require 'fileutils'

###############################################################################
# 環境変数
###############################################################################

### GNU screen 上で起動しているかチェック ###
if ENV["TERM"].index("screen")
    ENV["IN_SCREEN"]="1"
else
    ENV["IN_SCREEN"]="0"
end

ENV["MFILER3_DATADIR"]=ENV["DATADIR"]         # /usr/local/share


ENV["OPTION_MOVE_PARENT"]="0"              # 左右で親ディレクトリに上がるか
ENV["OPTION_SCROLL_TYPE"]="FDClone"        # スクロールタイプ
#ENV["OPTION_SCROLL_TYPE"]="afu"           # 端末の描写スピードを相当要求します

ENV["VIEW_PERMISSION"]="0"                 # パーミッションを表示するかどうか
ENV["VIEW_NLINK"]="0"                      # リンクを表示するかどうか
ENV["VIEW_OWNER"]="0"                      # オーナーを表示するかどうか
ENV["VIEW_GROUP"]="0"                      # グループを表示するかどうか
ENV["VIEW_SIZE"]="0"                       # サイズを表示するかどうか
ENV["VIEW_MTIME"]="0"                      # 修正時間を表示するかどうか
ENV["VIEW_FOCUSBACK"]="0"                  # ファイル名がはみ出るとき後ろにフォーカスするかどうか
ENV["VIEW_PAGE"]="0"                       # ページの描写方法
ENV["VIEW_DIVIDE_EXTENSION"]="0"           # 拡張子を別に表示するかどうか
ENV["VIEW_OPTION"]="all"

ENV["VIEW_FILE_SIZE"]="Normal"             # ファイルサイズの描写方法
#ENV["VIEW_FILE_SIZE"]="Human"
#ENV["VIEW_FILE_SIZE"]="Plane

ENV["OPTION_MENU_CYCLE"]="1"               # メニューで上下キーでサイクルするか
ENV["VIEW_ADD_STAR_EXE"]="1"               # 実行ファイルに*をつけるかどうか

ENV["TRASH_BOX_DIR"]=ENV["HOME"] + "/mtrashbox/"   # ゴミ箱のディレクトリ

if ENV["TRASH_BOX_DIR"][-1] != "/"[0]
    ENV["TRASH_BOX_DIR"] = ENV["TRASH_BOX_DIR"] + "/"
end

if File.directory? ENV["TRASH_BOX_DIR"]
    FileUtils.mkdir_p ENV["TRASH_BOX_DIR"]
end

ENV["INFO_FNAME"]=ENV["HOME"] + "/.mf3info"

# 利用するページャ
if ENV['PAGER'] == nil || ENV['PAGER'] == ""
    if `which lv 2> /dev/null` != ""
        if `uname -s`.index("CYGWIN")
            ENV['PAGER'] = "lv -As"
        else
            ENV['PAGER'] = "lv"
        end
    elsif `which less 2> /dev/null` != ""
        ENV['PAGER'] = "less"
    else
        ENV['PAGER'] = "more"
    end
end

# 利用するエディッタ
if ENV['EDITOR'] == nil || ENV['EDITOR'] == ""
    if `which emacs 2> /dev/null` != ""
        ENV['EDITOR'] = "emacs"
    elsif `which vim 2> /dev/null` != ""
        ENV['EDITOR'] = "vim"
    else
        ENV['EDITOR'] = "vi"
    end
end

# 利用するシェル
if ENV['SHELL'] == nil || ENV['SHELL'] == "" 
    if `which zsh 2> /dev/null` != ""
        ENV['SHELL'] = "zsh"
    elsif `which bash 2> /dev/null` != ""
        ENV['SHELL'] = "bash"
    elsif `which tcsh 2> /dev/null` != ""
        ENV['SHELL'] = "tcsh"
     else
        ENV['SHELL'] = "sh"
    end
end

### 他端末実行機能で使用するX端末の設定 ###
# set_xterm X端末のプログラム名, タイトルをつける引数, コマンドを実行する引数, その他の引数, Gnome Terminalなら1(Gnome Terminalは引数の処理が特殊なので１が必要)
if `uname -s`.index("CYGWIN")
    ENV["XTERM_PROG"]="ck"
    ENV["XTERM_OPT_TITLE"]="-title"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which gnome-terminal 2> /dev/null` != ""
    ENV["XTERM_PROG"]="gnome-terminal"
    ENV["XTERM_OPT_TITLE"]="-t"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="1"
elsif `which konsole 2> /dev/null` != ""
    ENV["XTERM_PROG"]="konsole"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which mlterm 2> /dev/null` != ""
    ENV["XTERM_PROG"]="mlterm"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which rxvt 2> /dev/null` != ""
    ENV["XTERM_PROG"]="rxvt"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which Eterm 2> /dev/null` != ""
    ENV["XTERM_PROG"]="Eterm"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which aterm 2> /dev/null` != ""
    ENV["XTERM_PROG"]="aterm"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
elsif `which kterm 2> /dev/null` != ""
    ENV["XTERM_PROG"]="kterm"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
else
    ENV["XTERM_PROG"]="xterm"
    ENV["XTERM_OPT_TITLE"]="-T"
    ENV["XTERM_OPT_EVAL"]="-e"
    ENV["XTERM_OPT_EXTRA"]=""
    ENV["XTERM_TYPE"]="0"
end

############################################################################
# キーバインド
############################################################################
def cursor_left
    if ENV["OPTION_MOVE_PARENT"] == "1" && shell3("row | chop") == "0" && shell3("adir | chomp") == "0"
        shell("cd ..");
    else
        if ENV["VIEW_OPTION"] == "all"
            shell("activate 0")
        else
            if shell3("row | chomp") != "0"
                shell("cursor_move -#{shell3("line_max | chomp")}")
            end
        end
    end
end

def cursor_right
    n = (shell3("row_max | chomp").to_i - 1).to_s

    if ENV["OPTION_MOVE_PARENT"] == "1" && shell3("row|chomp") == n && shell3("adir | chomp") == "1"
        shell("cd ..")
    else
        if ENV["VIEW_OPTION"] == "all"
            shell("activate 1")
        else
            if shell3("row|chomp") != n
                shell("cursor_move +#{shell3("line_max|chomp")}")
            end
        end
    end
end

def cursor_pageup
    if ENV["OPTION_SCROLL_TYPE"] == "FDClone"
        shell("cursor_move -10")
    else
        if ENV["VIEW_OPTION"] == "all"
            shell("cursor_move -`expr $(line_max|chomp) - 2`")
        else
            shell("cursor_move -10")
        end
    end
end

def cursor_pagedown
    if ENV["OPTION_SCROLL_TYPE"] == "FDClone"
        shell("cursor_move +10")
    else 
        if ENV["VIEW_OPTION"] == "all"
            shell("cursor_move +`expr $(line_max|chomp) - 2`")
        else
            shell("cursor_move +10")
        end
    end
end

$tab_view_option_before=""

def key_tab
    if ENV["VIEW_OPTION"] == "all"
        shell("activate -s")
    else
        $tab_view_option_before = ENV["VIEW_OPTION"]
        ENV["VIEW_OPTION"] = "all"

        shell("cd 1 `path 0|chomp`")
        shell("activate 1")
    end
end

def key_q
    if ENV["VIEW_OPTION"] == "all"
        if shell3("adir|chomp") == "1"
            shell("activate 0")
        end

        if $tab_view_option_before == ""
            ENV["VIEW_OPTION"] = "one_dir2"
        else
            ENV["VIEW_OPTION"] = $tab_view_option_before
            $tab_view_option_before = ""
        end
    else
        shell("if [ $(choice 'exit?' yes no) = 0 ]; then exit; fi")
    end
end

def key_r
    if shell3("adir | chomp") == "0" && ENV['FTP_SITE'] != ""
    then
        n = shell3("length \"%x\"")

        if n.to_i == 0
        then
            cmdline2('%Q rename %f %f', -1)
        else
            m = n.to_i + 2
            cmdline2('%Q rename %f %f', -m)
        end
    else
        n = shell3("length \"%x\"")

        if n.to_i == 0
        then
            cmdline2('%Q rename %F %F', -1)
        else
            m = n.to_i + 2
            cmdline2('%Q rename %F %F', -m)
        end
    end
end

def key_enter_single
    if shell3("archive_title | chomp") == ""
    then
        if history_number2("%F") == 0
            ext = shell3("%h file_ext $(cursor|chomp)|chomp")
            related_prog = shell3("%h related_prog \"#{ext}\" | chomp")

            if related_prog != ""
                add_history2("#{related_prog} %F")
            end
        end
    else
        shell("tar xfz \"$(archive_title | chomp)\" %f")
    end

    cmdline2(" %F", 0)
end

def key_enter_single_screen
    if history_number2("%F") == 0
        ext = shell3("%h file_ext $(cursor|chomp)|chomp")
        related_prog = shell3("%h related_prog \"#{ext}\" | chomp")

        if related_prog != ""
            add_history2("%s #{related_prog} %F")
        end
    end

    cmdline2("%s  %F", 3)
end

keycommand 0, KEY_UP,            '*',             '%Q%h cursor_move -1'
keycommand 0, KEY_CTRL_P,        '*',             '%Q%h cursor_move -1'
keycommand 0, KEY_DOWN,          '*',             '%Q%h cursor_move +1'
keycommand 0, KEY_CTRL_N,        '*',             '%Q%h cursor_move +1'
keycommand 0, KEY_LEFT,          '*',             '%Q%h%r cursor_left'
keycommand 0, KEY_CTRL_B,        '*',             '%Q%h%r cursor_left'
keycommand 0, KEY_RIGHT,         '*',             '%Q%h%r cursor_right'
keycommand 0, KEY_CTRL_F,        '*',             '%Q%h%r cursor_right'
keycommand 0, KEY_CTRL_A,        '*',             '%Q%h cursor_move 0'
keycommand 0, KEY_CTRL_E,        '*',             '%Q%h cursor_move $(file_num|chomp)'
keycommand 0, KEY_PAGEUP,        '*',             '%Q%h%r cursor_pageup'
keycommand 0, KEY_CTRL_U,        '*',             '%Q%h%r cursor_pageup'
keycommand 1, KEY_v,             '*',             '%Q%h%r cursor_pageup'
keycommand 0, KEY_PAGEDOWN,      '*',             '%Q%h%r cursor_pagedown'
keycommand 0, KEY_CTRL_D,        '*',             '%Q%h%r cursor_pagedown'
keycommand 0, KEY_CTRL_V,        '*',             '%Q%h%r cursor_pagedown'
keycommand 0, KEY_BACKSPACE,     '*',             '%Q if [ -n "$SSH_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vssh_cd ..\'; elif [ -n "$FTP_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vftp_cd ..\'; else cd ..; fi'
keycommand 0, KEY_CTRL_H,        '*',             '%Q if [ -n "$SSH_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vssh_cd ..\'; elif [ -n "$FTP_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vftp_cd ..\'; else cd ..; fi'
keycommand 1, KEY_LEFT,          '*',             '%Q cd -'
keycommand 0, KEY_META_LEFT,     '*',             '%Q cd -'
keycommand 1, KEY_RIGHT,         '*',             '%Q cd +'
keycommand 0, KEY_META_RIGHT,    '*',             '%Q cd +'
keycommand 0, KEY_LBRACK,        '*',             '%Q mark_range_start'
keycommand 0, KEY_RBRACK,        '*',             '%Q%o mark_range_end'
keycommand 0, KEY_HOME,          '*',             '%o%Q mark_all_files_and_directory'
keycommand 0, KEY_END,           '*',             '%o%Q mark_all_files'
keycommand 0, KEY_CTRL_L,        '*',             '%Q if [ -n "$SSH_SITE" ] && [ $(adir|chomp) = 0 ]; then mclear_immediately; eval vssh_reread; elif [ -n "$FTP_SITE" ] && [ $(adir|chomp) = 0 ]; then mclear_immediately; eval vftp_reread; else mclear_immediately; reread; fi'
keycommand 0, KEY_BACKSLASH,     '*',             '%Q cd /'
keycommand 0, KEY_TILDA,         '*',             '%Q cd ~'
keycommand 0, KEY_SPACE,         '*',             '%Q%h set_toggle_mark -a $(cursor|chomp); cursor_move +1'
keycommandline 0, KEY_PLUS,      '*',             '%Q%o set_mask \'\'', -2
keycommand 0, KEY_TAB,           '*',             '%Q%h%r key_tab'
keycommand 0, KEY_STAR,       '*',          '%Q%h cmdline \'%Q%r mark //, "*", "*", "*" # regex(/\\.c$/ for all c source files), user, group, permission \' 11'
keycommand 0, KEY_CTRL_C,        '*',             '%Q if [ $(choice "exit?" yes no) = 0 ]; then exit; fi'
keycommand 0, KEY_ENTER,         '.directory',    '%Q if [ -n "$SSH_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vssh_cd %f\'; elif [ -n "$FTP_SITE" ] && [ $(adir|chomp) = 0 ]; then eval \'vftp_cd %f\'; else cd %f; fi'
keycommand 0, KEY_ENTER,         '.tgz',          '%q set_archive_title %f; mtar %F | vd2'
keycommand 0, KEY_ENTER,         '.gz',           '%q set_archive_title %f; mtar %F | vd2'
keycommand 0, KEY_ENTER,         '.link',         '%Q if [ -d %f ]; then cd %f; else cmdline \' %F\' 0 1; fi'
keycommand 0, KEY_ATMARK,        '*',             '%Q%h mdnd %F &'
keycommand 0, KEY_EXCLAM,        '*',             '%Q run_file_manager'
keycommand 0, KEY_f,             '*',             '%Q%h isearch'
keycommand 0, KEY_SLASH,         '*',             '%Q%h isearch'
keycommand 0, KEY_QMARK,         '*',             '%Q%h help'
keycommand 0, KEY_CTRL_T,        '*',             '%Q new_dir %D'
keycommand 0, KEY_CTRL_W,        '*',             '%Q if [ $(dir_num|chomp) -gt 2 ]; then del_dir $(adir|chomp); activate 0; fi'


keycommand 0, KEY_DOT,           '*',             '%Q toggle_dotfile'
keycommand 0, KEY_SHARP,         '*',             '%Q menu sudo-menu'
keycommand 0, KEY_DOLLAR,        '*',             '%Q menu system'
keycommand 0, KEY_o,             '*',             '%Q if [ -z "$FTP_SITE" ]; then cd "`path -s|chomp`"; fi'
keycommand 0, KEY_O,             '*',             '%Q if [ -z "$FTP_SITE" ]; then cd -s "`path|chomp`"; fi'
keycommand 0, KEY_w,             '*',             '%Q if [ -z "$FTP_SITE" ]; then export ADIR=`path|chomp`; export SDIR=`path -s|chomp`; cd "$SDIR"; cd -s "$ADIR"; fi'
keycommand 0, KEY_q,             '*',             '%Q%h%r key_q'
keycommand 0, KEY_Q,             '*',             '%Q if [ $(choice "exit?" yes no) = 0 ]; then exit; fi'
keycommand 0, KEY_c,             '*',             '%Q mcp_check %m %D2'
keycommand 0, KEY_m,             '*',             '%Q mmv_check %m %D2'
keycommand 0, KEY_D,             '*',             '%Q mrm_check %m'
keycommand 0, KEY_d,             '*',             '%Q trash_box %m'
keycommand 0, KEY_l,              '*',            '%Q mln %m'
keycommand 0, KEY_r,             '*',             '%Q%h%r key_r'
keycommand 0, KEY_p,             '*',             '%Q%h tar_compress'
keycommand 0, KEY_P,             '*',             '%Q%h tar_compress2'
keycommand 0, KEY_u,             '.tgz',          '%Q%h tar_expand'
keycommand 0, KEY_a,             '*',             '%Q menu attribute'
keycommandline 0, KEY_n,         '*',             '%Q new_file ""', -2
keycommandline 0, KEY_k,         '*',             '%Q make_dir ""', -2
keycommandline2 0, KEY_b,        '*',             '%Q backup %F %F.bak', -5

keycommandline 0, KEY_g,         '*',     '%q mgrep -n \'\' %a', 13
keycommandline 0, KEY_g,     '.mark',     '%q mgrep -R -n \'\' %m', 16
keycommandline 0, KEY_G,         '*',     '%q vgrep -c --binary-files=without-match \'\' %a', -5
keycommandline 0, KEY_G,     '.mark',     '%q vgrep -c --binary-files=without-match -R \'\' %m', -5
keycommand 0, KEY_K,             '*',             '%q mmake'
keycommandline 0, KEY_F,         '*',             '%q find . | tee ~/.mfiler3_tmp/find_out; cat ~/.mfiler3_tmp/find_out | perl -ne \'print substr($_, 2);\' | vd', 10
keycommandline 0, KEY_F,         '.mark',         '%q find %m | tee ~/.mfiler3_tmp/find_out; cat ~/.mfiler3_tmp/find_out | vd', 11
keycommandline 1, KEY_f,         '*',             '%q locate \'\'| tee ~/.mfiler3_tmp/locate_out; cat ~/.mfiler3_tmp/locate_out | vd', 11
keycommand 0, KEY_s,             '*',             '%Q menu sort'
keycommand 0, KEY_V,             '*',             '%Q menu view'
keycommand 0, KEY_U,             '.tgz',          '%Q%h tar_expand2'
keycommand 0, KEY_j,             '*',             '%Q%r jump_menu'
keycommand 0, KEY_1,             '*',             '%Q fg 1'
keycommand 0, KEY_2,             '*',             '%Q fg 2'
keycommand 0, KEY_3,             '*',             '%Q fg 3'
keycommand 0, KEY_4,             '*',             '%Q fg 4'
keycommand 0, KEY_5,             '*',             '%Q fg 5'
keycommand 0, KEY_6,             '*',             '%Q fg 6'
keycommand 0, KEY_7,             '*',             '%Q fg 7'
keycommand 0, KEY_8,             '*',             '%Q fg 8'
keycommand 0, KEY_9,             '*',             '%Q fg 9'
keycommand 1, KEY_0,             '*',             '%Q%h activate 0'
keycommand 1, KEY_1,             '*',             '%Q%h activate 1'
keycommand 1, KEY_2,             '*',             '%Q%h activate 2'
keycommand 1, KEY_3,             '*',             '%Q%h activate 3'
keycommand 1, KEY_4,             '*',             '%Q%h activate 4'
keycommand 1, KEY_5,             '*',             '%Q%h activate 5'
keycommand 1, KEY_6,             '*',             '%Q%h activate 6'
keycommand 1, KEY_7,             '*',             '%Q%h activate 7'
keycommand 1, KEY_8,             '*',             '%Q%h activate 8'
keycommand 1, KEY_9,             '*',             '%Q%h activate 9'
keycommandline 0, KEY_H,         '*',             '%t ', -1
keycommand2 0, KEY_E,            '*',             "%t%Q #{ENV['EDITOR']} %F", '%f'
keycommand 0, KEY_r,          '.mark',      '%Q%h cmdline "%r%Q regex_rename_markfiles //, \"\" # when rename all c soruce to all cpp source, use regex_rename_markfiles /(.+)\\.c$/ \"\\\\1.cpp\"" 29'

keycommand 0, KEY_F2,           "*",     "%Q%h%r key_r"
keycommand 0, KEY_F3,           "*",     "%Q menu attribute"
keycommand 0, KEY_F4,           "*",     "%q editor %F"
keycommand 0, KEY_F5,           "*",     "%Q mcp_check %m %D2"
keycommand 0, KEY_F6,           "*",     "%Q mmv_check %m %D2"
keycommand 0, KEY_F7,           "*",     "%Q mln %m"
keycommand 0, KEY_F8,           "*",     "%Q trash_box %m"
keycommandline 0, KEY_F9,       '*',     '%Q make_dir ""', -2
keycommandline 0, KEY_F10,      '*',     '%Q new_file ""', -2


if ENV["IN_SCREEN"] == "0"
    keycommand2 0, KEY_v,           '*',             '%q pager %F', '%f'
    keycommand2 0, KEY_e,           '*',             '%q editor %F', '%f'
    keycommandline2 0, KEY_x,       '*',             './%f ', -1
    keycommandline 0, KEY_h,        '*',             '', 0
    keycommandline 0, KEY_F12,      '*',             '', 0
    keycommandline 0, KEY_ENTER,    ".mark",         ' %M', 0
    keycommand  0, KEY_ENTER,       '*',             '%Q%r%h key_enter_single'

    keycommand2 0, KEY_COLON,        '*',             '%q%h if [ -n "$SSH_SITE" ] && [ $(adir|chomp) = 0 ]; then ssh ${SSH_USER}@$SSH_SITE; else $SHELL; fi', '$SHELL'
    keycommand 0, KEY_C,             '*',             '%Q%h if [ $VIEW_OPTION = all ]; then cmdline "cp -a "\'%m\'" \\\'%D2\\\'" -2; else cmdline "cp -a "\'%m\'" \\\'%D\\\'" -2; fi'
    keycommand 0, KEY_M,             '*',             '%Q%h if [ $VIEW_OPTION = all ]; then cmdline "mv "\'%m\'" \\\'%D2\\\'" -2; else cmdline "mv "\'%m\'" \\\'%D\\\'" -2; fi'
else
    keycommand2 0, KEY_v,            '*',             "%Q%s #{ENV['PAGER']} %F", '%f'
    keycommand2 0, KEY_e,            '*',             "%Q%s #{ENV['EDITOR']} %F", '%f'
    keycommand2 0, KEY_COLON,        '*',             "%q%h if [ -n \"$SSH_SITE\" ] && [ $(adir|chomp) = 0 ]; then ssh ${SSH_USER}@$SSH_SITE; else eval \"%Q%s #{ENV['SHELL']}\"; fi", '$SHELL'
    keycommandline2 0, KEY_x,        '*',             '%s./%f ', -1
    keycommandline 0, KEY_h,         '*',             '%s ',  -1
    keycommandline 0, KEY_F12,       '*',             '%s ',  -1
    keycommandline 0, KEY_ENTER,     ".mark",         '%s  %M', 3
    keycommand 0, KEY_ENTER,         '*',             '%Q%r%h key_enter_single_screen'

    keycommand 0, KEY_C,             '*',             '%Q%h if [ $VIEW_OPTION = all ]; then cmdline "%s cp -a "\'%m\'" \\\'%D2\\\'" -2; else cmdline "%s cp -a "\'%m\'" \\\'%D\\\'" -2; fi'
    keycommand 0, KEY_M,             '*',             '%Q%h if [ $VIEW_OPTION = all ]; then cmdline "%s mv "\'%m\'" \\\'%D2\\\'" -2; else cmdline "%s mv "\'%m\'" \\\'%D\\\'" -2; fi'
end


###############################################################################
# キーマップ
###############################################################################
keymap   KEY_UP,        27,   91,   65,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_UP,        27,   79,   65,   -1,       -1,    -1, -1,-1,-1,-1
#keymap   KEY_UP,        56,   -1,   -1,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_DOWN,      27,   91,   66,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_DOWN,      27,   79,   66,   -1,       -1,    -1, -1,-1,-1,-1
#keymap   KEY_DOWN,      50,   -1,   -1,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_RIGHT,     27,   91,   67,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_RIGHT,     27,   79,   67,   -1,       -1,    -1, -1,-1,-1,-1
#keymap   KEY_RIGHT,     54,   -1,   -1,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_LEFT,      27,   91,   68,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_LEFT,      27,   79,   68,   -1,       -1,    -1, -1,-1,-1,-1
#keymap   KEY_LEFT,      52,   -1,   -1,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_INSERT,    27,   91,   50,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_DELETE,    27,   91,   51,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_BACKSPACE, 127,  -1,   -1,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   79,   72,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   72,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   55,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   0,    -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   49,   126,      -1,    -1, -1,-1,-1,-1
keymap   KEY_END,       27,   79,   70,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   70,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   56,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   101,  -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   52,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_PAGEUP,    27,   91,   53,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_PAGEUP,    27,   91,   73,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_PAGEDOWN,  27,   91,   54,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_PAGEDOWN,  27,   91,   71,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F1,        27,   91,   49,   49,      126,    -1, -1,-1,-1,-1
keymap   KEY_F1,        27,   79,   80,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F1,        27,   91,   91,   65,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F2,        27,   91,   49,   50,      126,    -1, -1,-1,-1,-1
keymap   KEY_F2,        27,   79,   81,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F2,        27,   91,   91,   66,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F3,        27,   91,   49,   51,      126,    -1, -1,-1,-1,-1
keymap   KEY_F3,        27,   79,   82,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F3,        27,   91,   91,   67,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F4,        27,   91,   49,   52,      126,    -1, -1,-1,-1,-1
keymap   KEY_F4,        27,   79,   83,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F4,        27,   91,   91,   68,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F5,        27,   91,   49,   53,      126,    -1, -1,-1,-1,-1
keymap   KEY_F5,        27,   91,   91,   69,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F6,        27,   91,   49,   55,      126,    -1, -1,-1,-1,-1
keymap   KEY_F7,        27,   91,   49,   56,      126,    -1, -1,-1,-1,-1
keymap   KEY_F8,        27,   91,   49,   57,      126,    -1, -1,-1,-1,-1
keymap   KEY_F9,        27,   91,   50,   48,      126,    -1, -1,-1,-1,-1
keymap   KEY_F10,       27,   91,   50,   49,      126,    -1, -1,-1,-1,-1
keymap   KEY_F11,       27,   91,   50,   51,      126,    -1, -1,-1,-1,-1
keymap   KEY_F12,       27,   91,   50,   52,      126,    -1, -1,-1,-1,-1

keymap   KEY_META_LEFT, 27,   91,   51,    68,      -1,    -1, -1,-1,-1,-1 # gnome-terminal
keymap   KEY_META_LEFT, 27,   91,   49,    59,      51,    68, -1,-1,-1,-1 # xterm
keymap   KEY_META_LEFT, 27,   91,   49,    59,      57,    68, -1,-1,-1,-1 # mlterm
keymap   KEY_META_LEFT, 27,   79,   49,    59,      51,    68, -1,-1,-1,-1 # screen
#keymap   KEY_META_LEFT, 27,   79,   68,    -1,      -1,    -1, -1,-1,-1,-1 # iTerm

keymap   KEY_META_RIGHT,27,   91,   51,    67,      -1,    -1, -1,-1,-1,-1 # gnome-terminal
keymap   KEY_META_RIGHT,27,   91,   49,    59,      51,    67, -1,-1,-1,-1 # xterm
keymap   KEY_META_RIGHT,27,   91,   49,    59,      57,    67, -1,-1,-1,-1 # mlterm
keymap   KEY_META_RIGHT,27,   79,   49,    59,      51,    67, -1,-1,-1,-1 # screen
#keymap   KEY_META_RIGHT,27,   79,   67,    -1,      -1,    -1, -1,-1,-1,-1 # iTerm

keymap   KEY_META_UP,   27,   91,   51,    65,      -1,    -1, -1,-1,-1,-1 # gnome-terminal
keymap   KEY_META_UP,   27,   91,   49,    59,      51,    65, -1,-1,-1,-1 # xterm
keymap   KEY_META_UP,   27,   91,   49,    59,      57,    65, -1,-1,-1,-1 # mlterm
keymap   KEY_META_UP,   27,   79,   49,    59,      51,    65, -1,-1,-1,-1 # screen
#keymap   KEY_META_UP,   27,   79,   65,    -1,      -1,    -1, -1,-1,-1,-1 # iTerm

keymap   KEY_META_DOWN, 27,   91,   51,    66,      -1,    -1, -1,-1,-1,-1 # gnome-terminal
keymap   KEY_META_DOWN, 27,   91,   49,    59,      51,    66, -1,-1,-1,-1 # xterm
keymap   KEY_META_DOWN, 27,   91,   49,    59,      57,    66, -1,-1,-1,-1 # mlterm
keymap   KEY_META_DOWN, 27,   79,   49,    59,      51,    66, -1,-1,-1,-1 # screen
#keymap   KEY_META_DOWN, 27,   79,   66,    -1,      -1,    -1, -1,-1,-1,-1 # iTerm

keymap   KEY_CTRL_UP,     27,   91,   49,    59,      53,    65, -1, -1, -1, -1 #gnome-terminal
keymap   KEY_CTRL_DOWN,   27,   91,   49,    59,      53,    66, -1, -1, -1, -1 #gnome-terminal
keymap   KEY_CTRL_LEFT,   27,   91,   49,    59,      53,    68, -1, -1, -1, -1 #gnome-terminal
keymap   KEY_CTRL_RIGHT,  27,   91,   49,    59,      53,    67, -1, -1, -1, -1 #gnome-terminal

keymap   KEY_CTRL_DELETE, 27,   91,   51,    59,      53,    126, -1, -1, -1, -1 #gnome-terminal

###############################################################################
# メニュー定義
###############################################################################
$view_nameonly_mode=false

def toggle_nameonly_mode
    if !$view_nameonly_mode
        $view_nameonly_mode=true

        $vnm_permission=ENV["VIEW_PERMISSION"]
        $vnm_nlink=ENV["VIEW_NLINK"]
        $vnm_owner=ENV["VIEW_OWNER"]
        $vnm_group=ENV["VIEW_GROUP"]
        $vnm_size=ENV["VIEW_SIZE"]
        $vnm_mtime=ENV["VIEW_MTIME"]
        $vnm_option=ENV["VIEW_OPTION"]

        ENV["VIEW_PERMISSION"]="0"
        ENV["VIEW_NLINK"]="0"
        ENV["VIEW_OWNER"]="0"
        ENV["VIEW_GROUP"]="0"
        ENV["VIEW_SIZE"]="0"
        ENV["VIEW_MTIME"]="0"
        ENV["VIEW_OPTION"]="one_dir"
    else
        $view_nameonly_mode=false

        ENV["VIEW_PERMISSION"]=$vnm_permission
        ENV["VIEW_NLINK"]=$vnm_nlink
        ENV["VIEW_OWNER"]=$vnm_owner
        ENV["VIEW_GROUP"]=$vnm_group
        ENV["VIEW_SIZE"]=$vnm_size
        ENV["VIEW_MTIME"]=$vnm_mtime
        ENV["VIEW_OPTION"]=$vnm_option
    end
end

ENV["COLOR"]="0"                           # カラー表示

def toggle_color
    if ENV["COLOR"] == "0"
        ENV["COLOR"] = "1"

        ENV["COLOR_DIR"]=MA_CYAN.to_s
        ENV["COLOR_EXE"]=MA_RED.to_s
        ENV["COLOR_LINK"]=MA_MAGENTA.to_s
        ENV["COLOR_MARK"]=MA_YELLOW.to_s
    else
        ENV["COLOR"] = "0"

        ENV["COLOR_DIR"]=MA_BOLD.to_s
        ENV["COLOR_EXE"]=MA_BOLD.to_s
        ENV["COLOR_LINK"]="0"
        ENV["COLOR_MARK"]=MA_BOLD.to_s
    end
end

ENV["COLOR256"]="0"

def toggle_256color
    if ENV["COLOR256"] == "0"
        ENV["COLOR256"]="1"
        shell("%Q%h init256; mclear_immediately; redraw")
    else
        ENV["COLOR256"]="0"
        shell("%Q%h final256; mclear_immediately redraw")
    end
end

$view_list_mode=false

def toggle_list_mode
    if ! $view_list_mode
        $view_list_mode=true

        $vlm_permission=ENV["VIEW_PERMISSION"]
        $vlm_nlink=ENV["VIEW_NLINK"]
        $vlm_owner=ENV["VIEW_OWNER"]
        $vlm_group=ENV["VIEW_GROUP"]
        $vlm_size=ENV["VIEW_SIZE"]
        $vlm_mtime=ENV["VIEW_MTIME"]
        $vlm_option=ENV["VIEW_OPTION"]

        ENV["VIEW_PERMISSION"]="1"
        ENV["VIEW_NLINK"]="1"
        ENV["VIEW_OWNER"]="1"
        ENV["VIEW_GROUP"]="1"
        ENV["VIEW_SIZE"]="1"
        ENV["VIEW_MTIME"]="1"
        ENV["VIEW_OPTION"]="one_dir"
    else
        $view_list_mode=false

        ENV["VIEW_PERMISSION"]=$vlm_permission
        ENV["VIEW_NLINK"]=$vlm_nlink
        ENV["VIEW_OWNER"]=$vlm_owner
        ENV["VIEW_GROUP"]=$vlm_group
        ENV["VIEW_SIZE"]=$vlm_size
        ENV["VIEW_MTIME"]=$vlm_mtime
        ENV["VIEW_OPTION"]=$vlm_option
    end
end




defmenu "system", "v(f)tp", KEY_f, "%Q%h cmdline \"vftp  # vftp site user password\" 5", "vftp_(q)uit", KEY_q, "vftp_quit", "v(s)sh", KEY_s, "%Q%h cmdline \"vssh  # vssh site user\" 5", "vssh_(Q)uit", KEY_Q, "vssh_quit"

defmenu "view", '2dir (a)ll', KEY_a, '%Q export VIEW_OPTION=all', '1dir(1)', KEY_1, '%Q export VIEW_OPTION=one_dir', '1dir(2)', KEY_2, '%Q export VIEW_OPTION=one_dir2', '1dir(3)', KEY_3, '%Q export VIEW_OPTION=one_dir3', '1dir(5)', KEY_5, '%Q export VIEW_OPTION=one_dir5', 'toggle (s)ize', KEY_s, '%Q export VIEW_SIZE=`toggle $VIEW_SIZE|chomp`', 'toggle m(t)ime', KEY_t,'%Q export VIEW_MTIME=`toggle $VIEW_MTIME|chomp`', 'toggle (u)ser', KEY_u, '%Q export VIEW_OWNER=`toggle $VIEW_OWNER|chomp`', 'toggle (g)roup', KEY_g, '%Q export VIEW_GROUP=`toggle $VIEW_GROUP|chomp`', 'toggle nl(i)nk', KEY_i, '%Q export VIEW_NLINK=`toggle $VIEW_NLINK|chomp`', 'toggle (p)ermission', KEY_p, '%Q export VIEW_PERMISSION=`toggle $VIEW_PERMISSION|chomp`', 'toggle fname (d)vide extension', KEY_d, '%Q export VIEW_DIVIDE_EXTENSION=`toggle $VIEW_DIVIDE_EXTENSION|chomp`', 'toggle fname (f)ocus back', KEY_f, '%Q export VIEW_FOCUSBACK=`toggle $VIEW_FOCUSBACK|chomp`', 'toggle (l)ist mode', KEY_l, '%Q%r%h toggle_list_mode', 'toggle (n)ameonly mode', KEY_n, '%Q%r%h toggle_nameonly_mode', 'toggle (c)olor', KEY_c, '%Q%r%h toggle_color', 'toggle 256 (C)olor', KEY_C, '%Q%r%h toggle_256color', 'toggle page view (w)ay', KEY_w, '%Q export VIEW_PAGE=`toggle $VIEW_PAGE|chomp`', 'file size view way (N)ormal', KEY_N, '%Q export VIEW_FILE_SIZE=Normal', 'file size view way (H)uman', KEY_H, '%Q export VIEW_FILE_SIZE=Human', 'file size view way (P)lane', KEY_P, '%Q export VIEW_FILE_SIZE=Plane'


defmenu "sort", '(n)ame', KEY_n, '%Q set_sort_kind name; reread -a', '(N)ame reverse', KEY_N, '%Q set_sort_kind name_rev; reread -a', '(e)xtension', KEY_e, '%Q set_sort_kind extension; reread', '(E)xtension reverse', KEY_E, '%Q set_sort_kind extension_rev; reread -a', '(s)ize', KEY_s, '%Q set_sort_kind size; reread -a', '(S)ize reverse', KEY_S, '%Q set_sort_kind size_rev; reread -a', '(t)ime', KEY_t, '%Q set_sort_kind time; reread -a', '(T)ime reverse', KEY_T, '%Q set_sort_kind time_rev; reread -a', '(u)ser', KEY_u, '%Q set_sort_kind user; reread -a', '(U)ser reverse', KEY_U, '%Q set_sort_kind user_rev; reread -a', '(g)roup', KEY_g, '%Q set_sort_kind group; reread -a', '(G)roup reverse', KEY_G, '%Q set_sort_kind group_rev; reread -a', '(p)ermission', KEY_p, '%Q set_sort_kind permission; reread -a', '(P)ermission reverse', KEY_P, '%Q set_sort_kind permission_rev; reread -a', '(r)andom', KEY_r, '%Q set_sort_kind random; reread -a', 'none (0)', KEY_0, '%Q set_sort_kind none; reread -a', 'toggle (d)ir up', KEY_d, '%Q toggle_sort_dirup; reread -a', 'toggle (m)ark up', KEY_m, '%Q toggle_sort_markup; reread -a'

defmenu "attribute", 'ch(m)od (permission)', KEY_m, '%Q cmdline \'chmod  %m\' 6', 'ch(o)wn (owner)', KEY_o, '%Q cmdline \'chown  %m\' 6', 'ch(g)rp (group)', KEY_g, '%Q cmdline \'chgrp  %m\' 6', 'ch(M)od -R (permission recursive)', KEY_M, '%Q cmdline \'chmod -R  %m\' 9', 'ch(O)wn -R (owner recursive)', KEY_O, '%Q cmdline \'chown -R  %m\' 9', 'ch(G)rp -R (group recursive)', KEY_G, '%Q cmdline \'chgrp -R  %m\' 9', 'm(a)ttr (permission and date)', KEY_a, '%q mattr %m'

###############################################################################
# ファイルの色
###############################################################################

# 256色端末のみ有効
# fcolor 正規表現 赤 緑 青
fcolor '^[\\.]+|\\.conf$|\\.config$', 3, 0, 3
fcolor '\\.tgz$|\\.tar$|\\.gz$|\\.tar\\.bz2$|\\.lzh$|\\.zip$', 0, 3, 0
fcolor '\\.bak$\\.old$', 0, 3, 0
fcolor '\\.c$|\\.cpp$|\\.cc$', 3, 3, 0
fcolor '\\.o$|\\.lo$', 0, 2, 3
fcolor '\\.a$|\\.la$|\\.lib$', 0, 0, 5
fcolor '\\.so$|\\.so\\.', 4, 3, 5
fcolor 'configure.in|\\.in$', 3, 2, 0
fcolor 'Makefile|makefile', 3, 0, 0
fcolor '\\.h$|\\.hpp$', 4, 2, 0
fcolor '\\.sh$|\\.pl$|\\.rb$|\\.py$|\\.el|\\.php$', 3, 2, 1
fcolor '\\.mp3$|\\.ogg$|\\.wav$', 3, 2, 0
fcolor '\\.mp4$|\\.wmv$', 5, 2, 0
fcolor '\\.jpg$|\\.gif$|\\.bmp$|\\.png', 2, 2, 4
fcolor '\\.html$|\\.htm$|\\.tex$|\\.info$|\\.doc$|\\.txt$', 3, 3, 0
fcolor '\\.log$', 1, 3, 0

###############################################################################
# ジャンプメニュー
###############################################################################
$jmenu = []

def jump_menu()
    menu_array = []

    $jmenu.each() {|item|
        menu_array.push(item[0])
        menu_array.push(item[1])
        menu_array.push("%h%Q cd #{item[2]}")
    }

    menu_array.push("----------------------------------------")
    menu_array.push(KEY_CTRL_Z)
    menu_array.push("print dummy")

    menu_array.push("(A)dd jump menu")
    menu_array.push(KEY_A)
    menu_array.push("%Q%h cmdline \"%r%Q add_jmenu '#{path "-a"}', KEY_a, '#{path "-a"}' # title, key, directory\" -26")

    menu_array.push("(D)elete jump menu")
    menu_array.push(KEY_D)
    menu_array.push("%r%Q del_jmenu()")

    defmenu('jump', *menu_array)
    shell("%Q%h menu jump")
end

def add_jmenu(title, key, path)
    $jmenu.push([title, key, path])
end

def del_jmenu()
    menu_array = []
    n = 0
    $jmenu.each() {|item|
        menu_array.push(item[0])
        menu_array.push(item[1])
        menu_array.push("%r%Q $jmenu.delete_at #{n}")
        n += 1
    }
    defmenu( 'delete_jmenu', *menu_array )
    shell("%Q%h menu delete_jmenu")
end

##############################################################################
# 状態の保存・復帰
##############################################################################
def atexit_hook
    f = open ENV['INFO_FNAME'], "w"

    f.puts ENV['VIEW_PERMISSION']
    f.puts ENV['VIEW_NLINK']
    f.puts ENV['VIEW_OWNER']
    f.puts ENV['VIEW_GROUP']
    f.puts ENV['VIEW_SIZE']
    f.puts ENV['VIEW_MTIME']
    f.puts ENV['VIEW_FOCUSBACK']
    f.puts ENV['VIEW_PAGE']
    f.puts ENV['VIEW_DIVIDE_EXTENSION']
    f.puts ENV['VIEW_OPTION']
    f.puts ENV['VIEW_FILE_SIZE']
    f.puts ENV['COLOR']
    f.puts ENV['COLOR256']

    f.puts $jmenu.size

    $jmenu.each { |item|
        f.puts item[0]
        f.puts item[1]
        f.puts item[2]
    }

    num = shell3("related_prog_num|chomp").to_i

    f.puts num.to_s
    i = 0
    while i < num
        prog = shell3("related_prog_prog #{i}|chomp")
        ext = shell3("related_prog_ext #{i}|chomp")

        f.puts prog
        f.puts ext

        i += 1
    end

    f.puts shell3("mask 0|chomp")
    f.puts shell3("mask 1|chomp")

    f.puts shell3("dotdir_mask 0|chomp")
    f.puts shell3("dotdir_mask 1|chomp")

    f.puts shell3("sort_kind 0|chomp")
    f.puts shell3("sort_kind 1|chomp")

    f.puts shell3("sort_dirup 0|chomp")
    f.puts shell3("sort_dirup 1|chomp")

    f.puts shell3("sort_markup 0|chomp")
    f.puts shell3("sort_markup 1|chomp")

    f.close
end

def upgrade_mf3info
    needed_line = 40
    num_line = 0
    f = open ENV['INFO_FNAME'], "r+"

    while num_line < needed_line
        str = f.gets
        if ! str
            f.puts ""
        end

        num_line += 1
    end

    f.close
end

if File.exist?(ENV['INFO_FNAME'])
    upgrade_mf3info

    f = open ENV['INFO_FNAME'], "r"

    ENV['VIEW_PERMISSION'] = f.gets.chomp!
    ENV['VIEW_NLINK'] = f.gets.chomp!
    ENV['VIEW_OWNER'] = f.gets.chomp!
    ENV['VIEW_GROUP'] = f.gets.chomp!
    ENV['VIEW_SIZE'] = f.gets.chomp!
    ENV['VIEW_MTIME'] = f.gets.chomp!
    ENV['VIEW_FOCUSBACK'] = f.gets.chomp!
    ENV['VIEW_PAGE'] = f.gets.chomp!
    ENV['VIEW_DIVIDE_EXTENSION'] = f.gets.chomp!
    ENV['VIEW_OPTION'] = f.gets.chomp!
    ENV['VIEW_FILE_SIZE'] = f.gets.chomp!
    ENV['COLOR'] = f.gets.chomp!

    if ENV['COLOR'] == '1'
    then
        ENV["COLOR_DIR"]=MA_CYAN.to_s
        ENV["COLOR_EXE"]=MA_RED.to_s
        ENV["COLOR_LINK"]=MA_MAGENTA.to_s
        ENV["COLOR_MARK"]=MA_YELLOW.to_s
    else
        ENV["COLOR_DIR"]=MA_BOLD.to_s
        ENV["COLOR_EXE"]=MA_BOLD.to_s
        ENV["COLOR_LINK"]="0"
        ENV["COLOR_MARK"]=MA_BOLD.to_s
    end

    ENV['COLOR256'] = f.gets.chomp!

    if ENV['COLOR256'] == "1"
        shell("%Q%h init256")
    end

    n = f.gets.chomp!.to_i

    i=0
    while i < n
        array = []
        array.push f.gets.chomp!
        array.push f.gets.chomp!.to_i
        array.push f.gets.chomp!

        $jmenu.push array
        
        i += 1
    end

    n2 = f.gets.chomp!.to_i

    i=0
    while i<n2
        prog = f.gets.chomp!
        ext = f.gets.chomp!

        shell("set_related_prog \"#{ext}\" \"#{prog}\"")

        i += 1
    end

    line = f.gets.chomp!
    if line == ""
        shell("set_mask 0 \"\"")
    else
        shell("set_mask 0 #{line}")
    end

    line = f.gets.chomp!
    if line == ""
        shell("set_mask 1 \"\"")
    else
        shell("set_mask 1 #{line}")
    end

    shell("set_dotdir_mask 0 #{f.gets.chomp!}")
    shell("set_dotdir_mask 1 #{f.gets.chomp!}")

    shell("set_sort_kind 0 #{f.gets.chomp!}")
    shell("set_sort_kind 1 #{f.gets.chomp!}")

    shell("set_sort_dirup 0 #{f.gets.chomp!}")
    shell("set_sort_dirup 1 #{f.gets.chomp!}")

    shell("set_sort_markup 0 #{f.gets.chomp!}")
    shell("set_sort_markup 1 #{f.gets.chomp!}")

    f.close
end

###############################################################################
# 正規表現リネーム
###############################################################################
def regex_rename_markfiles(regex, result)
    f = open ENV["HOME"] + "/.mfiler3_tmp/regex_rename", "w"

    mfiles(adir).each { |file|
        if file =~ regex
            f.puts("#{file}\n--> #{file.gsub(regex, result)}")
        end
    }
    f.close

    shell("$PAGER ~/.mfiler3_tmp/regex_rename")

    path = shell3("path|chomp")
    if shell3("choice \"rename ok?\" yes no") == "0"
        mfiles(adir).each { |file|
            if file =~ regex
                file2 = file.gsub(regex, result)

                if file[0] == "/"[0]
                    if !File.exist?(file2) || shell3("choice \"#{file2} overwride ok?\" yes no") == "0"
                        File.rename(file, file2)
                    end
                else
                    if !File.exist?(path + file2) || shell3("choice \"#{path + file2} overwride ok?\" yes no") == "0"
                        File.rename(path + file, path + file2)
                    end
                end
            end
        }

        shell("mark_clear")
        shell("reread -a")
    end
end



###############################################################################
# 正規表現マーク
###############################################################################
def mark(regex, user, group, permission)
    toggle_mark = shell3("choice 'toggle mark?' yes no") == "0"

    i = 0
    max = shell3("file_num|chomp").to_i
    while i < max
        if user == "*" || user == shell3("file_user #{i}|chomp")
            if group == "*" || group == shell3("file_group #{i}|chomp")
                if permission == "*" || permission.to_i == shell3("file_perm #{i} | chomp").to_i
                    if shell3("file_name #{i}|chomp") =~ regex
                        if toggle_mark
                            shell("set_toggle_mark #{i}")
                        else
                            shell("set_mark #{i} 1")
                        end
                    end
                end
            end
        end

        i += 1
    end
end


def msystem(cmd)
    mendwin()
    result = `#{cmd}`
    minitscr()
    return result
end

###############################################################################
# sudo メニュー
###############################################################################

def is_one_dir()
    if ENV["VIEW_OPTION"] == "all"
        return false
    else
        return true
    end
end

defmenu("file_attr_sudo",
   "sudo ch(m)od (permission)", KEY_m, "%r%Q%h cmdline('sudo chmod  %m', 11)",
   "sudo ch(o)wn (owner)", KEY_o, "%r%Q%h cmdline('sudo chown  %m', 11)",
   "sudo ch(g)rp (group)", KEY_g, "%r%Q%h cmdline('sudo chgrp  %m', 11)",
   "sudo ch(M)od -R (permission recursive)", KEY_M, "%r%Q%h cmdline('sudo chmod -R  %m', 14)",
   "sudo ch(O)wn -R (owner recursive)", KEY_O, "%r%Q%h cmdline('sudo chown -R  %m', 14)",
   "sudo ch(G)rp -R (group recursive)", KEY_G, "%r%Q%h cmdline('sudo chgrp -R  %m', 14)",
   "sudo m(a)ttr (permission and date)", KEY_a, "sudo mattr %m");

def key_sudo_unpack()
    ext = shell3("%Q%h file_ext $(cursor|chomp)|chomp")
    if ext == "gz" 
        if shell3("%Q%h file_name $(cursor|chomp) |chomp").rindex(".tar.gz")
            if is_one_dir()
                cmdline2('sudo tar xvfz %f -C %D', -1)
            else
                cmdline2('sudo tar xvfz %f -C %D2', -1)
            end
        else
            cmdline2('sudo gzip -d %F', -1)
        end
    elsif ext == "bz2"
        if shell3("%Q%h file_name $(cursor|chomp) |chomp").rindex(".tar.bz2")
            if is_one_dir()
                cmdline2('sudo tar xvfj %f -C %D', -1)
            else
                cmdline2('sudo tar xvfj %f -C %D2', -1)
            end
        else
            cmdline2('sudo bzip2 -d %f', -1)
        end
    elsif ext == "tar"
        if is_one_dir()
            cmdline2('sudo tar xvf %f -C %D', -1) 
        else 
            cmdline2('sudo tar xvf %f -C %D2', -1)
        end
    elsif ext == "tgz"
        if is_one_dir()
            cmdline2('sudo tar xvfz %f -C %D', -1)
        else
            cmdline2('sudo tar xvfz %f -C %D2', -1)
        end
    elsif ext == "lzh"
        if is_one_dir()
            cmdline2('cd %D; sudo lha x %F', shell3("path $(adir|chomp)|chomp").size() + 3)
        else 
            cmdline2('cd %D2; sudo lha x %F', shell3("path $(sdir|chomp)|chomp").size() + 3)
        end
    elsif ext == "zip" || ext == "ZIP"
        if is_one_dir()
            cmdline2('sudo unzip %f -d %D', -1)
        else
            cmdline2('sudo unzip %f -d %D2', -1)
        end
    end
end

def key_sudo_Unpack()
    ext = shell3("file_ext $(cursor|chomp)|chomp")
    cursor_name = shell3("file_name $(cursor|chomp) |chomp")
    
    if ext == "gz"
        if cursor_name.rindex(".tar.gz")
            cmdline2('sudo tar xvfz %f -C %D', -1)
        else
            cmdline2('sudo gzip -d %F', -1)
        end
    elsif ext == "bz2"
        if cursor_name.rindex(".tar.bz2")
            cmdline2('sudo tar xvfj %f -C %D', -1)
        else
            cmdline2('sudo bzip2 -d %f', -1)
        end
    elsif ext == "tar"
        cmdline2('sudo tar xvf %f -C %D', -1)
    elsif ext == "tgz"
        cmdline2('sudo tar xvfz %f -C %D', -1)
    elsif ext == "zip" || ext == "ZIP"
        cmdline2('sudo unzip %f -d %D', -1)
    elsif ext == "lzh"
        cmdline2('cd %D; sudo lha x %F', shell3("path $(adir|chomp)|chomp").size() + 3)
    end
end

def key_sudo_excute()
    cursor_name = shell3("path $(adir|chomp)|chomp") + shell3("file_name $(cursor|chomp)| chomp")
    if File.stat(cursor_name).executable? && !File.directory?(cursor_name)
        cmdline('sudo ./%f ', -1)
    elsif cursor_name.rindex(".pl")
        cmdline('sudo perl %f ', -1)
    elsif cursor_name.rindex(".py")
        cmdline('sudo python %f ', -1)
    elsif cursor_name.rindex(".rb")
        cmdline('sudo ruby %f ', -1)
    else
        cmdline('sudo  ./%f', 5)
    end
end

def key_sudo_backup()
    cmdline("sudo cp -a %f '" + shell3("file_name $(cursor|chomp) | chomp") + '.bak\'', -2)
end

defmenu("sudo-menu",
   "sudo (c)opy", KEY_c,   "%r%Q%h if is_one_dir() then cmdline2('sudo cp -a %m %D', -1) else cmdline2('sudo cp -a %m %D2', -1) end",
   "sudo (m)v", KEY_m,      "%r%Q%h if is_one_dir() then cmdline2('sudo mv %m %D', -1) else cmdline2('sudo mv %m %D2', -1) end",
   "sudo (d)elete",  KEY_d, "%r%Q%h cmdline2('sudo rm -R %m', -1)",
   "sudo (r)ename", KEY_r, "%r%Q%h cmdline2('sudo mv %f %f', -1)",
   "sudo (a)ttr menu",  KEY_a, "%h%Q menu file_attr_sudo",
   "sudo (e)dit", KEY_e,   "%q sudo $EDITOR %f",
   "sudo (v)iewer", KEY_v,     "%q sudo $PAGER %f",
   "sudo (p)ack", KEY_p, "%r%Q%h if is_one_dir() then cmdline2('sudo tar cvfz %X.tgz %m', 14 + shell3(\"echo %X|chomp\").size()) else cmdline2('sudo tar cvfz %D2%X.tgz %m', 14 + shell3(\"echo %D2%X|chomp\").size()) end", 
   "sudo (P)ack", KEY_P,     "%r%Q%h cmdline2('sudo tar cvfz %X.tgz %m', 14 + shell3(\"echo %X|chomp\").size()+ 14)",
   "sudo (u)npack", KEY_u,     "%r%Q%h key_sudo_unpack()",
   "sudo (U)npack", KEY_U,     "%r%Q%h key_sudo_Unpack()",
   "sudo ma(k)e dir", KEY_k,   "%r%Q%h cmdline(\"sudo mkdir -p ''\", -2)", 
   "sudo (n)ew file", KEY_n,   "%r%Q%h cmdline(\"sudo touch ''\", -2)",
   "sudo make (l)ink", KEY_l,  "%r%Q%h if is_one_dir() then cmdline2('sudo ln -s %M %D', -1) else cmdline('sudo ln -s %M %D2', -1) end",
   "sudo make (L)ink", KEY_L,  "%r%Q%h cmdline2('sudo ln -s %F %D', -1)",
   "sudo (g)rep", KEY_g,       "%r%Q%h cmdline(\"%q sudo grep '' * -n 2> /dev/null | $PAGER\", 14)",
   "sudo (G)rep", KEY_G,       "%r%Q%h cmdline(\"%q sudo grep -R '' * -n 2> /dev/null | $PAGER\", 17)",
   "sudo e(x)ecute", KEY_x, "%r%Q%h key_sudo_excute()",
   "sudo (b)ackup", KEY_b, "%r%Q%h key_sudo_backup()",
   "sudo run shell(:)", KEY_COLON, "%q echo \"-+- \"%D\" -+-\"; ls -aFG; sudo $SHELL", 
   "sudo s(h)ell", KEY_h,   "%r%Q%h cmdline('sudo ', -1)"
   );

ENV['FKEY_SPACE']="1"

def view_fkey()
    function_string = ["NONE", "Renam", "Attr", "Edit", "Copy", "Move", "Link", "Del", "mKdir", "New", "NONE", "sHell"]

    maxx = mgetmaxx()
    maxy = mgetmaxy()

    i = 0
    x = 1
    while i < 12
        mattron(MA_REVERSE)
        mmvprintw(maxy-3, x, function_string[i].center((maxx-3)/12-1))
        mattroff()

        x += maxx/12 + if i == 3 || i == 7 then 1 else 0 end
        i += 1
    end

    return 1        # この返り値分ファイラが面画縦に縮む
end

