#include "filer.h"
#include <dirent.h>
#include <libgen.h>
#include <termios.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <termios.h>
#include <stdarg.h>
#include <time.h>
#include <ctype.h>
#include <locale.h>
#include <sys/types.h>
#include <pwd.h>
#include <dirent.h>
#include <stdlib.h>
#include <fcntl.h>

static const int kMaxYMinus = 4;

BOOL gExecutiveFileBold = TRUE;
static void filer_sort2(sDir* self);

char* kSortName[kSortMax] = {
    "name", "name_rev", "extension", "extension_rev", "size", "size_rev",
    "time", "time_rev", "user", "user_rev", "group", "group_rev", "permission", "permission_rev", "random", "none"
};
sDir* gSelf;

typedef struct {
    char* mRegex[BUFSIZ];
    int mRed;
    int mGreen;
    int mBlue;
} sFColor;

vector_obj* gFColors;

///////////////////////////////////////////////////////////////////////////////
// sFile -- ファイルオブジェクト
///////////////////////////////////////////////////////////////////////////////
sFile* sFile_new(char* name, char* name_view, char* linkto, struct stat* stat_, struct stat* lstat_, BOOL mark, char* user, char* group, int uid, int gid)
{
    sFile* self = (sFile*)GC_malloc(sizeof(sFile));
    
    strcpy(self->mName, name);
    strcpy(self->mNameView, name_view);
    strcpy(self->mLinkTo, linkto);
    self->mStat = *stat_;
    self->mLStat = *lstat_;
    self->mMark = mark;
    if(user == NULL) {
        sprintf(self->mUser, "%d", uid);
    }
    else {
        strcpy(self->mUser, user);
    }
    if(group == NULL) {
        sprintf(self->mGroup, "%d", gid);
    }
    else {
        strcpy(self->mGroup, group);
    }

    self->mSortRandom = 0;

    return self;
}

///////////////////////////////////////////////////////////////////////////////
// sDir -- ディレクトリオブジェクト
///////////////////////////////////////////////////////////////////////////////
static void sDir_mask(sDir* self)
{
    if(strcmp(self->mMask, "") != 0) {
        int i;
        for(i=0; i<vector_size(self->mFiles); i++) {
            sFile* file = vector_item(self->mFiles, i);

            if(!S_ISDIR(file->mStat.st_mode) 
                && strcmp(file->mName, ".index") != 0) 
            {
                OnigUChar* regex = (OnigUChar*)self->mMask;
                regex_t* reg;
                int err_info;
        
                int r = onig_new(&reg, regex
                    , regex + strlen((char*)regex)
                    , ONIG_OPTION_IGNORECASE
                    , ONIG_ENCODING_UTF8
                    , ONIG_SYNTAX_DEFAULT
                    ,  &err_info);

                if(r == ONIG_NORMAL) {
                    OnigRegion* region = onig_region_new();

                    int r2 = onig_search(reg, file->mName
                       , file->mName + strlen((char*)file->mName)
                       , file->mName, file->mName + strlen((char*)file->mName)
                       , region, ONIG_OPTION_IGNORECASE);

                    if(r2 < 0) {
                        vector_erase(self->mFiles, i);
                        i--;
                    }

                    onig_region_free(region, 1);
                }
            } 
            else if(S_ISDIR(file->mStat.st_mode)) {
                if(strcmp(file->mName, "..") != 0 && file->mName[0] == '.' && self->mDotDirMask != 0) {
                    vector_erase(self->mFiles, i);
                    i--;
                }
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// sFColor -- 色
///////////////////////////////////////////////////////////////////////////////

void add_fcolor(char* regex, int red, int green, int blue)
{
    sFColor* self = GC_malloc(sizeof(sFColor));

    strcpy(self->mRegex, regex);
    self->mRed = red;
    self->mGreen = green;
    self->mBlue = blue;

    vector_add(gFColors, self);
}

static int convert_fname(char* src, char* des, int des_size) 
{
#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H) 
    if(is_all_ascii(src)) {
        strcpy(des, src);
    }
    else {
        /// コンバート ///
        if(kanji_convert(src, des, des_size, gKanjiCodeFileName, gKanjiCode) == -1) {
            return -1;
        }
    }
    return 0;
#else
    strcpy(des, src);
    return 0;
#endif
}

void filer_vd_start(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    sDir* self = (sDir*)vector_item(gDirs, dir);

    self->mVD = TRUE;
    vector_clear(self->mFiles);
}

void filer_vd2_start(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    sDir* self = (sDir*)vector_item(gDirs, dir);

    self->mVD2 = TRUE;
    vector_clear(self->mFiles);
}

void filer_vd_end(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }

    sDir* self = (sDir*)vector_item(gDirs, dir);

    self->mVD = FALSE;
    self->mVD2 = FALSE;
    filer_reread(dir);

    strcpy(self->mATitle, "");
}

void filer_archive_title(int dir, char* title)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }

    sDir* self = (sDir*)vector_item(gDirs, dir);
    strcpy(self->mATitle, title);
}

void filer_vd_add(int dir, char* fname)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    sDir* self = (sDir*)vector_item(gDirs, dir);

    char fname2[PATH_MAX];
    if(convert_fname(fname, fname2, 4089) == -1) {
        return;
    }

    char path[PATH_MAX];
    if(fname[0] == '/') {
        strcpy(path, fname);
    }
    else {
        strcpy(path, self->mPath);
        strcat(path, fname);
    }
    
    struct stat lstat_;
    memset(&lstat_, 0, sizeof(struct stat));
    if(lstat(path, &lstat_) < 0) {
        return;
    }

    struct stat stat_;
    memset(&stat_, 0, sizeof(struct stat));
    if(stat(path, &stat_) < 0) {
        if(S_ISLNK(lstat_.st_mode)) {
            stat_ = lstat_;
        }
        else {
            return;
        }
    }
    
    char linkto[PATH_MAX];

    if(S_ISLNK(lstat_.st_mode)) {
        int bytes = readlink(path, linkto, PATH_MAX);
        if(bytes == -1) {
            linkto[0] = 0;
        }
        else {
            linkto[bytes] = 0;
        }
    }
    else {
        linkto[0] = 0;
    }

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
    char tmp[PATH_MAX + 1];
    if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
        strcpy(linkto, tmp);
    }
#endif

    char* user = mygetpwuid(&lstat_);
    char* group = mygetgrgid(&lstat_);

    if(strcmp(fname, ".") != 0) {
        BOOL mark = FALSE;
        
        /// add ///
        vector_add(self->mFiles, sFile_new(fname, fname2, linkto, &stat_, &lstat_, mark, user, group, lstat_.st_uid, lstat_.st_gid));
    }
}

void filer_vd_add2(int dir, char* line)
{
    char permission[128];
    char user[128];
    char group[128];
    char size[128];
    char month[128];
    char day[128];
    char hour_min[128];
    char year[128];
    char fname[PATH_MAX];

    char* p = line;
    char* p2 = permission;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = user;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = group;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = size;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = month;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = day;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = hour_min;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = year;
    while(*p && *p != ' ') {
        *p2++ = *p++;
    }
    *p2 = 0;

    while(*p == ' ') {
        p++;
    }

    p2 = fname;
    while(*p) {
        *p2++ = *p++;
    }
    *p2 = 0;

    if(fname[strlen(fname)-1] == '/') {
        fname[strlen(fname)-1] = 0;
    }

    char hour[128];
    char min[128];

    p = hour_min;
    while(*p != ':' && *p) {
        p++;
    }

    memcpy(hour, hour_min, p - hour_min);
    hour[p - hour_min] = 0;
    memcpy(min, p+1, strlen(hour_min) - (p - hour_min));
    min[strlen(hour_min) - (p - hour_min)] = 0;

    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    sDir* self = (sDir*)vector_item(gDirs, dir);

    char fname2[PATH_MAX];
    strcpy(fname2, fname);
    
    struct stat stat_;
    memset(&stat_, 0, sizeof(struct stat));
    
    if(permission[0] == '-') {
        stat_.st_mode = S_IFREG;
    }
    else if(permission[0] == 'd') {
        stat_.st_mode = S_IFDIR;
    }
    else if(permission[0] == 'l') {
        stat_.st_mode = S_IFLNK;
    }
    else if(permission[0] == 's') {
        stat_.st_mode = S_IFSOCK;
    }

    if(permission[1] == 'r') {
        stat_.st_mode |= S_IRUSR;
    }
    if(permission[2] == 'w') {
        stat_.st_mode |= S_IWUSR;
    }
    if(permission[3] == 'x') {
        stat_.st_mode |= S_IXUSR;
    }

    if(permission[4] == 'r') {
        stat_.st_mode |= S_IRGRP;
    }
    if(permission[5] == 'w') {
        stat_.st_mode |= S_IWGRP;
    }
    if(permission[6] == 'x') {
        stat_.st_mode |= S_IXGRP;
    }

    if(permission[7] == 'r') {
        stat_.st_mode |= S_IROTH;
    }
    if(permission[8] == 'w') {
        stat_.st_mode |= S_IWOTH;
    }
    if(permission[9] == 'x') {
        stat_.st_mode |= S_IXOTH;
    }

    stat_.st_size = atoi(size);
    
    struct stat lstat_;
    memset(&lstat_, 0, sizeof(struct stat));

    struct tm tm_;
    memset(&tm_, 0, sizeof(struct tm));
    tm_.tm_min = atoi(min);
    tm_.tm_hour = atoi(hour);
    tm_.tm_mday = atoi(day);
    tm_.tm_year = atoi(year) - 1900;
    if(strcmp(month, "Jan") == 0) {
        tm_.tm_mon = 0;
    }
    else if(strcmp(month, "Feb") == 0) {
        tm_.tm_mon = 1;
    }
    else if(strcmp(month, "Mar") == 0) {
        tm_.tm_mon = 2;
    }
    else if(strcmp(month, "Apr") == 0) {
        tm_.tm_mon = 3;
    }
    else if(strcmp(month, "May") == 0) {
        tm_.tm_mon = 4;
    }
    else if(strcmp(month, "Jun") == 0) {
        tm_.tm_mon = 5;
    }
    else if(strcmp(month, "Jul") == 0) {
        tm_.tm_mon = 6;
    }
    else if(strcmp(month, "Aug") == 0) {
        tm_.tm_mon = 7;
    }
    else if(strcmp(month, "Sep") == 0) {
        tm_.tm_mon = 8;
    }
    else if(strcmp(month, "Oct") == 0) {
        tm_.tm_mon = 9;
    }
    else if(strcmp(month, "Nov") == 0) {
        tm_.tm_mon = 10;
    }
    else if(strcmp(month, "Dec") == 0) {
        tm_.tm_mon = 11;
    }
    stat_.st_mtime = mktime(&tm_);
    
    lstat_ = stat_;

    char linkto[PATH_MAX];
    strcpy(linkto, "");

    if(strcmp(fname, ".") != 0) {
        BOOL mark = FALSE;
        
        /// add ///
        vector_add(self->mFiles, sFile_new(fname, fname2, linkto, &stat_, &lstat_, mark, user, group, atoi(user), atoi(group)));
    }
}

int sDir_read(sDir* self)
{
    if(self->mVD2) {
        int i;
        for(i=0; i<vector_size(self->mFiles); i++) {
            sFile* file = vector_item(self->mFiles, i);
            file->mSortRandom = 0;
        }
    }
    else if(self->mVD) {
        int i;
        for(i=0; i<vector_size(self->mFiles); i++) {
            sFile* file = vector_item(self->mFiles, i);

            char fname[4089];
            if(convert_fname(file->mName, fname, 4089) == -1) {
                vector_erase(self->mFiles, i);
                i--;
                continue;
            }

            char path[PATH_MAX];
            if(file->mName[0] == '/') {
                strcpy(path, file->mName);
            }
            else {
                strcpy(path, self->mPath);
                strcat(path, file->mName);
            }
            
            struct stat lstat_;
            memset(&lstat_, 0, sizeof(struct stat));
            if(lstat(path, &lstat_) < 0) {
                vector_erase(self->mFiles, i);
                i--;
                continue;
            }

            struct stat stat_;
            memset(&stat_, 0, sizeof(struct stat));
            if(stat(path, &stat_) < 0) {
                if(S_ISLNK(lstat_.st_mode)) {
                    stat_ = lstat_;
                }
                else {
                    vector_erase(self->mFiles, i);
                    i--;
                    continue;
                }
            }
            
            char linkto[PATH_MAX];

            if(S_ISLNK(lstat_.st_mode)) {
                int bytes = readlink(path, linkto, PATH_MAX);
                if(bytes == -1) {
                    linkto[0] = 0;
                }
                else {
                    linkto[bytes] = 0;
                }
            }
            else {
                linkto[0] = 0;
            }

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX + 1];
            if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(linkto, tmp);
            }
#endif

            char* user = mygetpwuid(&lstat_);
            char* group = mygetgrgid(&lstat_);

            /// refresh ///
            strcpy(file->mLinkTo, linkto);
            file->mStat = stat_;
            file->mLStat = lstat_;
            if(user == NULL) {
                sprintf(file->mUser, "%d", lstat_.st_uid);
            }
            else {
                strcpy(file->mUser, user);
            }
            if(group == NULL) {
                sprintf(file->mGroup, "%d", lstat_.st_gid);
            }
            else {
                strcpy(file->mGroup, group);
            }

            file->mSortRandom = 0;
        }
    }
    else {
        if(access(self->mPath, F_OK) != 0) {
            strcpy(self->mPath, "/");
            return sDir_read(self);
        }

        hash_obj* mark_files = hash_new(10);
        int i;
        for(i=0; i<vector_size(self->mFiles); i++) {
            sFile* file = vector_item(self->mFiles, i);

            if(file->mMark) {
                hash_put(mark_files, file->mName, 1);
            }
        }

        vector_clear(self->mFiles);

        DIR* dir = opendir(self->mPath);
        if(dir == NULL) {
            strcpy(self->mPath, "/");
            return sDir_read(self);
        }
        
        struct dirent* entry;
        while(entry = readdir(dir)) {
            char fname[4089];
            if(convert_fname(entry->d_name, fname, 4089) == -1) {
                continue;
            }

            char path[PATH_MAX];
            strcpy(path, self->mPath);
            strcat(path, entry->d_name);
            
            struct stat lstat_;
            memset(&lstat_, 0, sizeof(struct stat));
            if(lstat(path, &lstat_) < 0) {
                continue;
            }

            struct stat stat_;
            memset(&stat_, 0, sizeof(struct stat));
            if(stat(path, &stat_) < 0) {
                if(S_ISLNK(lstat_.st_mode)) {
                    stat_ = lstat_;
                }
                else {
                    continue;
                }
            }
            
            char linkto[PATH_MAX];

            if(S_ISLNK(lstat_.st_mode)) {
                int bytes = readlink(path, linkto, PATH_MAX);
                if(bytes == -1) {
                    linkto[0] = 0;
                }
                else {
                    linkto[bytes] = 0;
                }
            }
            else {
                linkto[0] = 0;
            }

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX + 1];
            if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(linkto, tmp);
            }
#endif

            char* user = mygetpwuid(&lstat_);
            char* group = mygetgrgid(&lstat_);

            if(strcmp(entry->d_name, ".") != 0) {
                BOOL mark = FALSE;

                if(hash_item(mark_files, entry->d_name) != NULL) {
                    mark = TRUE;
                }
                
                /// add ///
                vector_add(self->mFiles, sFile_new(entry->d_name, fname, linkto, &stat_, &lstat_, mark, user, group, lstat_.st_uid, lstat_.st_gid));
            }
        }
        
        closedir(dir);
    }

    return 0;
}

sDir* sDir_new(char* path)      // 普通のディレクトリ読み込み
{
    sDir* self = (sDir*)GC_malloc(sizeof(sDir));

    char path2[PATH_MAX];
    strcpy(path2, path);
    if(path[strlen(path)-1] != '/') {
        strcat(path2, "/");
    }
    strcpy(self->mPath, path2);
    strcpy(self->mMask, "");
    self->mActive = FALSE;

    self->mFiles = vector_new(50);

    strcpy(self->mATitle, "");

    self->mScrollTop = 0;
    self->mCursor = 0;
    self->mSortKind = kName;
    self->mSortKindBefore = -1;
    self->mSortKindMarkUp = FALSE;
    self->mSortKindDirUp = TRUE;
    strcpy(self->mMask, "");

    self->mHistory = vector_new(10);
    vector_add(self->mHistory, string_new(self->mPath));
    self->mHistoryCursor = 0;

    sDir_read(self);
    sDir_mask(self);
    filer_sort2(self);

    self->mVD = FALSE;
    self->mVD2 = FALSE;

    return self;
}

///////////////////////////////////////////////////////////////////////////////
// ファイラー
///////////////////////////////////////////////////////////////////////////////
vector_obj* gDirs;
enum eKanjiCode gKanjiCodeFileName = kUtf8;
hash_obj* gKeyCommand[2][KEY_MAX];      // キーとコマンドのマップ[0][キーコード] metaなし [1][キーコード] meta
hash_obj* gKeyCommandTitle[2][KEY_MAX]; // gKeyCommandのコマンドタイトル

hash_obj* gKeyCommandLine[2][KEY_MAX];
hash_obj* gKeyCommandLineCurPos[2][KEY_MAX];
hash_obj* gKeyCommandLineExpandMacro[2][KEY_MAX];

BOOL gExtensionICase = TRUE;            // マークファイルの拡張子別実行で大文字小文字を区別するかどうか

void filer_init()
{
    gDirs = vector_new(10);
    gKanjiCodeFileName = gKanjiCode;

    int i;
    for(i=0; i<2; i++) {
        int j;
        for(j=0; j<KEY_MAX; j++) {
            gKeyCommand[i][j] = hash_new(10);
            gKeyCommandTitle[i][j] = hash_new(10);
            gKeyCommandLine[i][j] = hash_new(10);
            gKeyCommandLineCurPos[i][j] = hash_new(10);
            gKeyCommandLineExpandMacro[i][j] = hash_new(10);
         }
    }

    gFColors = vector_new(10);
}

int filer_new_dir(char* path)
{
    vector_add(gDirs, sDir_new(path));

    filer_cd(vector_size(gDirs)-1, path);
}

void filer_del_dir(int dir)
{
    vector_erase(gDirs, dir);
}

///////////////////////////////////////////////////////////////////////////////
// パスを絶対パスにする
///////////////////////////////////////////////////////////////////////////////
static int correct_path(char* current_path, char* path, char* path2)
{
    char tmp[PATH_MAX];
    char tmp2[PATH_MAX];
    char tmp3[PATH_MAX];
    char tmp4[PATH_MAX];

    /// 先頭にカレントパスを加える ///
    {
        if(path[0] == '/' || path[0] == '~' || path[0] == '$') {
            strcpy(tmp, path);
        }
        else {
            if(current_path == NULL) {
                char* cwd = mygetcwd();
                
                strcpy(tmp, cwd);
                strcat(tmp, "/");
                strcat(tmp, path);
            }
            else {
                strcpy(tmp, current_path);
                strcat(tmp, path);
            }
        }

    }

    /// ~と環境変数を展開する ///
    {
        char* home = getenv("HOME");

        if(home == NULL) {
            fprintf(stderr, "$HOME is not setted");
            exit(1);
        }
        
        if(tmp[0] == '~' && strlen(tmp) == 1) {
            strcpy(tmp2, home);
        }
        else if(tmp[0] == '~' && tmp[1] == '/') {
            strcpy(tmp2, home);
            strcat(tmp2, "/");
            strcat(tmp2, tmp + 2);
        }
        else if(tmp[0] == '$') {
            char* p;
            char* p2;
            char env[256];
            char* env_value;

            p = tmp + 1;
            p2 = env;
            while(*p != '/' && *p) {
                *p2++ = *p++;
            }
            *p2 = 0;

            env_value = getenv(env);
            if(env_value == NULL) {
                strcpy(tmp2, p);
            }
            else {
                if(*p == '/') {
                    strcpy(tmp2, env_value);
                    strcat(tmp2, p);
                }
                else {
                    strcpy(tmp2, env_value);
                }
            }
        }
        else {
            strcpy(tmp2, tmp);
        }

    }

   
    /// .を削除する ///
    {
        char* p;
        char* p2;
        int i;

        p = tmp3;
        p2 = tmp2;
        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) != '.' && ((*p2+3)=='/' || *(p2+3)==0)) {
                p2+=2;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;

        if(*tmp3 == 0) {
            *tmp3 = '/';
            *(tmp3+1) = 0;
        }

    }

    /// ..を削除する ///
    {
        char* p;
        char* p2;

        p = tmp4;
        p2 = tmp3;

        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == '/')
            {
                p2 += 3;

                do {
                    p--;

                    if(p < tmp4) {
                        strcpy(path2, "/");
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
            }
            else if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == 0) 
            {
                do {
                    p--;

                    if(p < tmp4) {
                        strcpy(path2, "/");
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
                break;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;
    }

    if(*tmp4 == 0) {
        strcpy(path2, "/");
    }
    else {
        strcpy(path2, tmp4);
    }

    return TRUE;
}

int sDir_cd(sDir* self, char* path)
{
    if(self->mVD) {
        self->mVD = FALSE;
    }
    if(self->mVD2) {
        self->mVD2 = FALSE;
        strcpy(self->mATitle, "");
    }

    int dir;
    int i;
    for(i=0; i<vector_size(gDirs); i++) {
        if(self == vector_item(gDirs, i)) {
            dir = i;
            break;
        }
    }

    if(self->mSortKindBefore != -1) {
        self->mSortKind = self->mSortKindBefore;
        self->mSortKindBefore = -1;
    }

    char* fname = GC_strdup(basename(GC_strdup(self->mPath)));
    char path2[PATH_MAX];
    if(correct_path(self->mPath, path, path2) && access(path2, F_OK) == 0) {
        strcpy(self->mPath, path2);
        if(self->mPath[strlen(self->mPath)-1] != '/') {
            strcat(self->mPath, "/");
        }
        
        char index_path[PATH_MAX];
        sprintf(index_path, "%s.index", self->mPath);

        if(access(index_path, F_OK) == 0) {
            filer_reset_marks(dir);

            filer_vd_start(dir);
            self->mSortKindBefore = self->mSortKind;
            self->mSortKind = kSortNone;

            filer_vd_add(dir, "..");
            filer_vd_add(dir, ".index");

            string_obj* str = string_new("");
            int f = open(index_path, O_RDONLY);
            while(1) {
                char buf[BUFSIZ];
                int r = read(f, buf, BUFSIZ);

                if(r < 0) {
                    perror("read");
                    exit(1);
                }
                if(r == 0) {
                    break;
                }

                buf[r] = 0;
                string_push_back(str, buf);
            }
            

            char* p = string_c_str(str);

            string_obj* str2 = string_new("");
            while(*p) {
                if(*p == '\n') {
                    p++;
                    if(strcmp(string_c_str(str2), "") != 0) {
                        filer_vd_add(dir, string_c_str(str2));
                    }
                    str2 = string_new("");
                }
                else {
                    string_push_back2(str2, *p++);
                }
            }

            if(strcmp(string_c_str(str2), "") != 0) {
                filer_vd_add(dir, string_c_str(str2));
            }

            sDir_mask(self);        // マスク
            filer_sort(dir);        // ソート

            if(strcmp(path, "..") == 0) {
                int i;
                for(i=0; i<vector_size(self->mFiles); i++) {
                    sFile* file = (sFile*)vector_item(self->mFiles, i);
                    if(strcmp(file->mName, fname) == 0) {
                        self->mScrollTop = 0;
                        filer_cursor_move(dir, i);
                        break;
                    }
                }
            }
            else {
                self->mScrollTop = 0;
                filer_cursor_move(dir, 0);
            }

            /// カレントディレクトリを変える ///
            if(dir == adir()) {
                chdir(self->mPath);
                setenv("PWD", self->mPath, 1);
            }
        }
        else {
            filer_reset_marks(dir);

            if(sDir_read(self) != 0) {
                return -1;
            }

            sDir_mask(self);
            filer_sort(dir);        // ソート

            if(strcmp(path, "..") == 0) {
                self->mScrollTop = 0;
                filer_cursor_move(dir, 0);

                int i;
                for(i=0; i<vector_size(self->mFiles); i++) {
                    sFile* file = (sFile*)vector_item(self->mFiles, i);
                    if(strcmp(file->mName, fname) == 0) {
                        self->mScrollTop = 0;
                        filer_cursor_move(dir, i);
                        break;
                    }
                }
            }
            else {
                self->mScrollTop = 0;
                filer_cursor_move(dir, 0);
            }

            /// カレントディレクトリを変える ///
            if(dir == adir()) {
                chdir(self->mPath);
                setenv("PWD", self->mPath, 1);
            }
        }

        return 0;
    }
    else {
        return -1;
    }
}

int filer_history_forward(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }

    sDir* dir2 = vector_item(gDirs, dir);

    if(dir2->mHistoryCursor < vector_size(dir2->mHistory)-1) {
        string_obj* path = vector_item(dir2->mHistory, ++dir2->mHistoryCursor);
        sDir_cd(dir2, string_c_str(path));
    }
}

int filer_history_back(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }

    sDir* dir2 = vector_item(gDirs, dir);

    if(dir2->mHistoryCursor > 0) {
        string_obj* path = vector_item(dir2->mHistory, --dir2->mHistoryCursor);
        sDir_cd(dir2, string_c_str(path));
    }
}

int filer_cd(int dir, char* path)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    if(sDir_cd(dir2, path) == 0) {
        int i;
        for(i=vector_size(dir2->mHistory)-1; i!=dir2->mHistoryCursor; i--) {
            vector_erase(dir2->mHistory, i);
        }
        vector_add(dir2->mHistory, string_new(dir2->mPath));
        dir2->mHistoryCursor++;
    }

    /// タイトルバー ///
    strcpy(gTitleBar, dir2->mPath);
    {
        DIR* dir = opendir(gTempDir);
        if(dir == NULL) {
            fprintf(stderr, "Tempolary directory doesn't exist");
            exit(1);
        }

        char send_cmd[BUFSIZ];
        strcpy(send_cmd, "E%Q%h unfocus");

        struct dirent* entry;
        while(entry = readdir(dir)) {
            if(strstr(entry->d_name, "socket")) {
                char soc_name[PATH_MAX];
                sprintf(soc_name, "%s/%s", gTempDir, entry->d_name);

                int pid = atoi(strstr(entry->d_name, "socket") + 6);

                if(pid != getpid()) {
                    char buf[BUFSIZ];
                    sprintf(buf, "%%Q%%h%%o%%i ps a | grep mfiler3 | grep %d | grep -v grep | gawk '{ print $3; }'", pid);
                    string_obj* ret = shell3(buf);

                    if(strstr(string_c_str(ret), "+")) {
                        int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
                        if(soc < 0) {
                            perror("socket");
                            return 1;
                        }

                        struct sockaddr_un addr;
                        addr.sun_family = AF_UNIX;
                        strcpy(addr.sun_path, soc_name);
                        if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == 0) {
                            write(soc, send_cmd, strlen(send_cmd)+1);
                        }

                        close(soc);
                    }
                }
            }
        }

        closedir(dir);
    }
    
    shell("%Q%h%i focus", "focus", -1, FALSE, FALSE, -1);

    return 0;
}

int filer_cd_back(int dir)
{
}

int filer_reread(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }

    sDir* dir2 = (sDir*)vector_item(gDirs, dir);
    sDir_read(dir2);
    sDir_mask(dir2);

    filer_sort(dir);
    filer_cursor_move(dir, dir2->mCursor);
}

BOOL filer_marking(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return FALSE;
    }
    
    if(filer_mark_file_num(dir) != 0) {
        return TRUE;
    }
    else {
        return FALSE;
    }
}


char* filer_mask(int dir)
{
    sDir* dir2 = filer_dir(dir);

    if(dir2) {
        return dir2->mMask;
    }
}

BOOL filer_dotdir_mask(int dir)
{
    sDir* dir2 = filer_dir(dir);

    if(dir2) {
        return dir2->mDotDirMask;
    }
}

void filer_cursor_move(int dir, int num)
{
    const int maxy = filer_line_max(dir);

    sDir* dir2 = filer_dir(dir);
    dir2->mCursor = num;
    
    if(dir2->mCursor < 0) dir2->mCursor = 0;
    if(dir2->mCursor >= vector_size(dir2->mFiles)) 
        dir2->mCursor = vector_size(dir2->mFiles)-1;

    char* env = getenv("OPTION_SCROLL_TYPE");
    char* env_view_option = getenv("VIEW_OPTION");
    if(env_view_option == NULL) {
        fprintf(stderr, "VIEW_OPTION is NULL\n");
        exit(1);
    }

    if(env && strcmp(env, "FDClone") == 0) {
        if(strcmp(env_view_option, "all") == 0 
            || strcmp(env_view_option, "one_dir") == 0) 
        {
             if(dir2->mCursor >= dir2->mScrollTop + maxy) {
                 dir2->mScrollTop = (dir2->mCursor/maxy)*maxy;
             }
             if(dir2->mCursor < dir2->mScrollTop) {
                 dir2->mScrollTop = (dir2->mCursor/maxy)*maxy;
             }
        }
        else if(strcmp(env_view_option, "one_dir2") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*2) {
                 dir2->mScrollTop = (dir2->mCursor/(maxy*2))*(maxy*2);
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop = (dir2->mCursor/(maxy*2))*(maxy*2);
            }
        }
        else if(strcmp(env_view_option, "one_dir3") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*3) {
                 dir2->mScrollTop = (dir2->mCursor/(maxy*3))*(maxy*3);
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop = (dir2->mCursor/(maxy*3))*(maxy*3);
            }
        }
        else if(strcmp(env_view_option, "one_dir5") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*5) {
                 dir2->mScrollTop = (dir2->mCursor/(maxy*5))*(maxy*5);
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop = (dir2->mCursor/(maxy*5))*(maxy*5);
            }
        }
    }
    else {
        if(strcmp(env_view_option, "all") == 0 
            || strcmp(env_view_option, "one_dir") == 0) 
        {
             if(dir2->mCursor >= dir2->mScrollTop + maxy-2) {
                 dir2->mScrollTop = dir2->mCursor -maxy+2;
             }
             if(dir2->mCursor < dir2->mScrollTop) {
                 dir2->mScrollTop = dir2->mCursor;
             }
        }
        else if(strcmp(env_view_option, "one_dir2") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*2) {
                 dir2->mScrollTop =  (dir2->mCursor/(maxy*2))*(maxy*2); 
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop =  (dir2->mCursor/(maxy*2))*(maxy*2);
            }
        }
        else if(strcmp(env_view_option, "one_dir3") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*3) {
                 dir2->mScrollTop =  (dir2->mCursor/(maxy*3))*(maxy*3);
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop =  (dir2->mCursor/(maxy*3))*(maxy*3);
            }
        }
        else if(strcmp(env_view_option, "one_dir5") == 0) {
            if(dir2->mCursor >= dir2->mScrollTop + maxy*5) {
                 dir2->mScrollTop =  (dir2->mCursor/(maxy*5))*(maxy*5);
            }
            if(dir2->mCursor < dir2->mScrollTop) {
                dir2->mScrollTop =  (dir2->mCursor/(maxy*5))*(maxy*5);
            }
        }
    }
}

void filer_activate(int dir)
{
    if(dir == 0 || dir == 1) {
        sDir* ldir = filer_dir(0);
        sDir* rdir = filer_dir(1);

        if(dir == 0) {
            ldir->mActive = TRUE;
            rdir->mActive = FALSE;

            chdir(ldir->mPath);
            setenv("PWD", ldir->mPath, 1);
        }
        else {
            ldir->mActive = FALSE;
            rdir->mActive = TRUE;

            chdir(rdir->mPath);
            setenv("PWD", rdir->mPath, 1);
        }
    }
    else if(dir >= 2 && dir < vector_size(gDirs)) {
        sDir* adir_ = filer_dir(adir());
        sDir* dir_ = filer_dir(dir);

        vector_exchange(gDirs, adir(), dir_);
        vector_exchange(gDirs, dir, adir_);

        adir_->mActive = FALSE;
        dir_->mActive = TRUE;

        chdir(dir_->mPath);
        setenv("PWD", dir_->mPath, 1);
    }
}

static BOOL is_same_extension_marked(int dir, char* result)
{
    if(!filer_marking(dir)) return FALSE;

    sDir* self = filer_dir(dir);

    strcpy(result, "");
    int i;
    for(i=0; i<vector_size(self->mFiles); i++) {
        sFile* file = (sFile*)vector_item(self->mFiles, i);
        if(file->mMark) {
            char* tmp = extname(file->mName);
            
            if(strcmp(result, "") == 0) {
                strcpy(result, tmp);
            }
            else {
                if(gExtensionICase) {
                    if(strcasecmp(result, tmp) != 0) {
                        strcpy(result, "");
                        return FALSE;
                    }
                }
                else {
                    if(strcmp(result, tmp) != 0) {
                        strcpy(result, "");
                        return FALSE;
                    }
                }
            }
        }
    }

    return TRUE;
}

static BOOL is_directory_marked(int dir)
{
    if(!filer_marking(dir)) return FALSE;

    sDir* self = filer_dir(dir);

    int i;
    for(i=0; i<vector_size(self->mFiles); i++) {
        sFile* file = (sFile*)vector_item(self->mFiles, i);
        if(file->mMark) {
            if(!S_ISDIR(file->mStat.st_mode)) {
                return FALSE;
            }
        }
    }
    
    return TRUE;
}

static BOOL is_executive_file_marked(int dir)
{
    if(!filer_marking(dir)) return FALSE;

    sDir* self = filer_dir(dir);

    int i;
    for(i=0; i<vector_size(self->mFiles); i++) {
        sFile* file = (sFile*)vector_item(self->mFiles, i);
        if(file->mMark) {
            if(!(file->mStat.st_mode&S_IXUSR) && !(file->mStat.st_mode&S_IXGRP) && !(file->mStat.st_mode&S_IXOTH))
            {
                return FALSE;
            }
        }
    }
    
    return TRUE;
}

static BOOL is_link_marked(int dir)
{
    if(!filer_marking(dir)) return FALSE;

    sDir* self = filer_dir(dir);

    int i;
    for(i=0; i<vector_size(self->mFiles); i++) {
        sFile* file = (sFile*)vector_item(self->mFiles, i);
        if(file->mMark) {
            if(!S_ISLNK(file->mLStat.st_mode))
            {
                return FALSE;
            }
        }
    }
    
    return TRUE;
}

void filer_input(int meta, int key)
{
    sDir* dir = filer_dir(adir());
    sFile* cursor = (sFile*)vector_item(dir->mFiles, dir->mCursor);

    /// ファイル名を得る ///
    const char* name = cursor->mName;
    char fname[1024];
    
    strcpy(fname, name);
    if(gExtensionICase && is_all_ascii((char*)name)) {
        mystrtolower(fname);
    }
    /// 拡張子名を得る ///
    char extension[256];

    char* tmp = extname(cursor->mName);
    if(gExtensionICase) {
        mystrtolower(tmp);
    }

    sprintf(extension, ".%s", tmp);

    /// マーク中ならその状態を調べる ///
    BOOL is_extension_marked = FALSE;           // 同一拡張子のファイルをマーク中
    char marked_extension[1024];                // マーク中の拡張子
    BOOL is_directory_marked_ = FALSE;           // ディレクトリをマーク中
    BOOL is_executive_file_marked_ = FALSE;      // 実行ファイルをマーク中
    BOOL is_link_marked_ = FALSE;                // リンクをマーク中

    if(filer_marking(adir())) {
        char tmp[1024];
        is_extension_marked = is_same_extension_marked(adir(), tmp);
        if(is_extension_marked) {
            if(gExtensionICase) {   // 大文字小文字を区別しない場合
                mystrtolower(tmp);
            }
            sprintf(marked_extension, ".mark-%s", tmp);
        }
        
        is_directory_marked_ = is_directory_marked(adir());
        is_executive_file_marked_ = is_executive_file_marked(adir());
        is_link_marked_ = is_link_marked(adir());
    }

    /// 同一拡張子のファイルをマーク中 ///
    if(is_extension_marked
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommand[meta][key], marked_extension))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  marked_extension);
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  marked_extension);
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }

        ISearchClear();
    }
    else if(is_extension_marked
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommandLine[meta][key], marked_extension))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  marked_extension);
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  marked_extension);
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  marked_extension);

        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }

        ISearchClear();
    }

    /// リンクをマーク中 ///
    else if(is_link_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommand[meta][key], ".mark-link"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".mark-link");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".mark-link");
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(is_link_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommandLine[meta][key], ".mark-link"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".mark-link");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".mark-link");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".mark-link");

        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// ディレクトリをマーク中 ///
    else if(is_directory_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommand[meta][key], ".mark-directory"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".mark-directory");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".mark-directory");

        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(is_directory_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommandLine[meta][key], ".mark-directory"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".mark-directory");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".mark-directory");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".mark-directory");

        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// 実行ファイルをマーク中 ///
    else if(is_executive_file_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommand[meta][key], ".mark-execute"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".mark-execute");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".mark-execute");
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(is_executive_file_marked_
            && key >= 0 && key < KEY_MAX
            && hash_item(gKeyCommandLine[meta][key], ".mark-execute"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".mark-execute");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".mark-execute");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".mark-execute");
        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// マーク中 ///
    else if(filer_marking(adir())
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommand[meta][key], ".mark"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".mark");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".mark");

        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(filer_marking(adir())
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommandLine[meta][key], ".mark"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".mark");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".mark");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".mark");

        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// リンクを選択中 ///
    else if(S_ISLNK(cursor->mLStat.st_mode)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommand[meta][key], ".link"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".link");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".link");

        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(S_ISLNK(cursor->mLStat.st_mode)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommandLine[meta][key], ".link"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".link");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".link");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".link");

        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// ファイル名で指定されている場合 ///
    else if(key >= 0 && key < KEY_MAX  
          && hash_item(gKeyCommand[meta][key], fname))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  fname);
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  fname);

        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(key >= 0 && key < KEY_MAX  
          && hash_item(gKeyCommandLine[meta][key], fname))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  fname);
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  fname);
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  fname);
        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }

        cmdline_start(command, cur_pos);
        ISearchClear();
    }

    /// 拡張子名で指定されている場合 ///
    else if(key >= 0 && key < KEY_MAX 
           && hash_item(gKeyCommand[meta][key], extension))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  extension);
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  extension);
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(key >= 0 && key < KEY_MAX 
           && hash_item(gKeyCommandLine[meta][key], extension))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  extension);
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  extension);
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  extension);
        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// ディレクトリを選択中 ///
    else if(S_ISDIR(cursor->mLStat.st_mode)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommand[meta][key], ".directory"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".directory");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".directory");
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(S_ISDIR(cursor->mLStat.st_mode)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommandLine[meta][key], ".directory"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".directory");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".directory");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".directory");

        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }

        cmdline_start(command, cur_pos);
        ISearchClear();
    }

    /// 実行ファイルを選択中 ///
    else if((cursor->mStat.st_mode&S_IXUSR
         || cursor->mStat.st_mode&S_IXGRP || cursor->mStat.st_mode&S_IXOTH)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommand[meta][key], ".execute"))
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  ".execute");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  ".execute");
        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if((cursor->mStat.st_mode&S_IXUSR
         || cursor->mStat.st_mode&S_IXGRP || cursor->mStat.st_mode&S_IXOTH)
        && key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommandLine[meta][key], ".execute"))
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  ".execute");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  ".execute");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  ".execute");
        
        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }

    /// その他のファイル ///
    else if(key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommand[meta][key], "*")) 
    {
        char* command = (char*)hash_item(gKeyCommand[meta][key],  "*");
        char* title = (char*)hash_item(gKeyCommandTitle[meta][key],  "*");

        if(title) {
            BOOL isdigit = TRUE;
            int j;
            for(j=0; j<strlen(title); j++) {
                if((title[j] < '0' || title[j] > '9') && title[j] != '-') {
                    isdigit = FALSE;
                }
            }
            if(isdigit) {
                shell(command, command, -1, FALSE, FALSE, atoi(title));
            }
            else {
                shell(command, title, -1, FALSE, FALSE, -1);
            }
        }
        else {
            shell(command, title, -1, FALSE, FALSE, -1);
        }
        ISearchClear();
    }
    else if(key >= 0 && key < KEY_MAX 
        && hash_item(gKeyCommandLine[meta][key], "*")) 
    {
        char* command = (char*)hash_item(gKeyCommandLine[meta][key],  "*");
        int cur_pos = (int)hash_item(gKeyCommandLineCurPos[meta][key],  "*");
        int macro = (int)hash_item(gKeyCommandLineExpandMacro[meta][key],  "*");

        if(macro) {
            string_obj* command2 = string_new("");
            expand_macro(command, command2, FALSE);
            cmdline_start(string_c_str(command2), cur_pos);
        }
        else {
            cmdline_start(command, cur_pos);
        }
        ISearchClear();
    }
}

int adir()
{
    sDir* dir0 = (sDir*)vector_item(gDirs, 0);
    sDir* dir1 = (sDir*)vector_item(gDirs, 1);

    if(dir0->mActive)
        return 0;
    else
        return 1;
}

int sdir()
{
    sDir* dir0 = (sDir*)vector_item(gDirs, 0);
    sDir* dir1 = (sDir*)vector_item(gDirs, 1);

    if(!dir0->mActive)
        return 0;
    else
        return 1;
}

sDir* filer_dir(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return NULL;
    }
    
    return (sDir*)vector_item(gDirs, dir);
}

sFile* filer_cursor_file(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return NULL;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    return (sFile*)vector_item(dir2->mFiles, dir2->mCursor);
}

void filer_toggle_mark(int dir, int num)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    if(num < 0 || num >= vector_size(dir2->mFiles)) {
        return;
    }

    sFile* file = vector_item(dir2->mFiles, num);

    file->mMark = !file->mMark;
}

void filer_set_mark(int dir, int num, int mark)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    if(num < 0 || num >= vector_size(dir2->mFiles)) {
        return;
    }

    sFile* file = vector_item(dir2->mFiles, num);

    file->mMark = mark;
}

BOOL filer_mark(int dir, int num)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    if(num < 0 || num >= vector_size(dir2->mFiles)) {
        return;
    }

    sFile* file = vector_item(dir2->mFiles, num);

    return file->mMark;
}

int filer_mark_file_num(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    int result = 0;
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = (sFile*)vector_item(dir2->mFiles, i);

        if(file->mMark) {
            result++;
        }
    }

    return result;
}

double filer_mark_file_size(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);

    double size = 0;
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = (sFile*)vector_item(dir2->mFiles, i);

        if(file->mMark && !S_ISDIR(file->mStat.st_mode)) {
            size += file->mLStat.st_size;
        }
    }

    return size;
}

void filer_reset_marks(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    
    sDir* dir2 = (sDir*)vector_item(gDirs, dir);
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = (sFile*)vector_item(dir2->mFiles, i);
        file->mMark = FALSE;
    }
}

///////////////////////////////////////////////////////////////////////////////
// ファイラ描写
///////////////////////////////////////////////////////////////////////////////

int make_size_str(char* result, double size)
{
    char* file_size = getenv("VIEW_FILE_SIZE");
    if(strcmp(file_size, "Human") == 0) {
        char tmp[256];
        double size2;
        if(size < 1024) {
            size2 = size;
            sprintf(tmp, "%.0f", size2);

            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 7) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 4) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }

            *p2 = 0;
        }
        else if(size < 1024*1024) {
            size2 = size / 1024;
            sprintf(tmp, "%.1f", size2);

            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 9) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 6) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }

            *p2++ = 'k';
            *p2 = 0;
        }
        else if(size < 1024*1024*1024) {
            size2 = size / (1024*1024);
            sprintf(tmp, "%.1f", size2);

            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 9) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 6) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }

            *p2++ = 'M';
            *p2 = 0;
        }
        else {
            size2 = size / (1024*1024*1024);
            sprintf(tmp, "%.1f", size2);

            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 9) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 6) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }

            *p2++ = 'G';
            *p2 = 0;
        }

        return 7;
    }
    else if(strcmp(file_size, "Normal") == 0) {
        if(size < 1024*1024) {
            char tmp[256];
            sprintf(tmp, "%.0f", size);
            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 7) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 4) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }
            *p2 = 0;
        }
        else {
            size = size / (1024*1024);

            char tmp[256];
            sprintf(tmp, "%.1f", size);
            char* end = tmp + strlen(tmp);

            char* p = tmp;
            char* p2 = result;
            
            while(*p) {
                if(end - p == 9) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else if(end - p == 6) {
                    *p2++ = *p++;
                    *p2++ = ',';
                }
                else {
                    *p2++ = *p++;
                }
            }
            *p2++ = 'M';
            *p2 = 0;
        }

        return 9;
    }
    else if(strcmp(file_size, "Plane") == 0) {
        char tmp[256];
        sprintf(tmp, "%.0f", size);
        char* end = tmp + strlen(tmp);

        char* p = tmp;
        char* p2 = result;
        
        while(*p) {
            if(end - p == 10) {
                *p2++ = *p++;
                *p2++ = ',';
            }
            else if(end - p == 7) {
                *p2++ = *p++;
                *p2++ = ',';
            }
            else if(end - p == 4) {
                *p2++ = *p++;
                *p2++ = ',';
            }
            else {
                *p2++ = *p++;
            }
        }
        *p2 = 0;

        return 14;
    }
}

static void make_size_str2(char* result, double size)
{
    char tmp[256];
    sprintf(tmp, "%.0f", size);
    char* end = tmp + strlen(tmp);

    char* p = tmp;
    char* p2 = result;
    
    while(*p) {
        if(end - p == 13) {
            *p2++ = *p++;
            *p2++ = ',';
        }
        else if(end - p == 10) {
            *p2++ = *p++;
            *p2++ = ',';
        }
        else if(end - p == 7) {
            *p2++ = *p++;
            *p2++ = ',';
        }
        else if(end - p == 4) {
            *p2++ = *p++;
            *p2++ = ',';
        }
        else {
            *p2++ = *p++;
        }
    }
    *p2 = 0;
}

/// buf は充分なスペースが必要 ///
void make_file_stat(sFile* file, char* buf)
{
    strcpy(buf, "");

    char* env_permission = getenv("VIEW_PERMISSION");
    if(env_permission && strcmp(env_permission, "1") == 0) {
        char permission[12];
        strcpy(permission, "----------");
        if(S_ISDIR(file->mLStat.st_mode)) permission[0] = 'd';
        if(S_ISCHR(file->mLStat.st_mode)) permission[0] = 'c';
        if(S_ISBLK(file->mLStat.st_mode)) permission[0] = 'b';
        if(S_ISFIFO(file->mLStat.st_mode)) permission[0] = 'p';
        if(S_ISLNK(file->mLStat.st_mode)) permission[0] = 'l';
        if(S_ISSOCK(file->mLStat.st_mode)) permission[0] = 's';
    
        mode_t smode = file->mLStat.st_mode;
        if(smode & S_IRUSR) permission[1] = 'r';
        if(smode & S_IWUSR) permission[2] = 'w';
        if(smode & S_IXUSR) permission[3] = 'x';
        if(smode & S_IRGRP) permission[4] = 'r';
        if(smode & S_IWGRP) permission[5] = 'w';
        if(smode & S_IXGRP) permission[6] = 'x';
        if(smode & S_IROTH) permission[7] = 'r';
        if(smode & S_IWOTH) permission[8] = 'w';
        if(smode & S_IXOTH) permission[9] = 'x';
        if(smode & S_ISUID) permission[3] = 's';
        if(smode & S_ISGID) permission[6] = 's';
#if defined(S_ISTXT)
        if(smode & S_ISTXT) permission[9] = 't';
#endif
#if defined(S_ISVTX)
        if(smode & S_ISVTX) permission[9] = 't';
#endif

        sprintf(buf + strlen(buf), " %s", permission);
    }

    char* env_nlink = getenv("VIEW_NLINK");
    if(env_nlink && strcmp(env_nlink, "1") == 0) {
        sprintf(buf + strlen(buf), " %3d", file->mStat.st_nlink);
    }

    char* env_owner = getenv("VIEW_OWNER");
    if(env_owner && strcmp(env_owner, "1") == 0) {
        char owner[256];
        char* tmp = file->mUser;
        if(tmp) {
            str_cut2(tmp, 8, owner, 256);
        }
        else {
            sprintf(owner, "%d", file->mLStat.st_uid);
        }

        sprintf(buf + strlen(buf), " %-8s", owner);
    }

    char* env_group = getenv("VIEW_GROUP");
    if(env_group && strcmp(env_group, "1") == 0) {
        char group[256];
        char* tmp = file->mGroup;
        if(tmp) {
            str_cut2(tmp, 8, group, 256);
        }
        else {
            sprintf(group, "%d", file->mLStat.st_gid);
        }

        sprintf(buf + strlen(buf), " %-8s", group);
    }

    char* env_size = getenv("VIEW_SIZE");
    if(env_size && strcmp(env_size, "1") == 0) {
        char size[256];
        int width = make_size_str(size, file->mLStat.st_size);

        if(S_ISDIR(file->mStat.st_mode)) {
            strcpy(size, "<DIR>");
        }

        char format[128];
        strcpy(format, "%");
        sprintf(format + strlen(format), "%d", width);
        strcat(format, "s");

        sprintf(buf + strlen(buf) , format, size);
    }

    char* env_mtime = getenv("VIEW_MTIME");
    if(env_mtime && strcmp(env_mtime, "1") == 0) {
        time_t t = file->mLStat.st_mtime;
        struct tm* tm_ = (struct tm*)localtime(&t);

        int year = tm_->tm_year-100;
        if(year < 0) year+=100;
        while(year > 100) year-=100;

        sprintf(buf + strlen(buf), " %02d-%02d-%02d %02d:%02d"
               , year, tm_->tm_mon+1
               , tm_->tm_mday, tm_->tm_hour, tm_->tm_min);
    }

    sprintf(buf + strlen(buf), " ");
}

sFile* filer_file(int dir, int num)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return NULL;
    }
    
    sDir* dir2 = vector_item(gDirs, dir);

    if(num < 0 || num >= vector_size(dir2->mFiles)) {
        return NULL;
    }

    return vector_item(dir2->mFiles, num);
}

vector_obj* filer_mark_files(int dir) 
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return NULL;
    }
    
    sDir* dir2 = vector_item(gDirs, dir);
    vector_obj* result = vector_new(10);
    
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = vector_item(dir2->mFiles, i);

        if(file->mMark) {
            vector_add(result, file);
        }
    }

    return result;
}

int filer_file2(int dir, char* name)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return -1;
    }
    
    sDir* dir2 = vector_item(gDirs, dir);
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = vector_item(dir2->mFiles, i);
        if(strcmp(file->mName, name) == 0) {
            return i;
        }
    }

    return -1;
}

/// fnameは充分なスペースが必要
void make_file_name(sFile* file, char* fname, char** ext, char* dot, int name_len)
{
    char* env_divide_ext = getenv("VIEW_DIVIDE_EXTENSION");
    BOOL view_divide_ext = FALSE;
    if(env_divide_ext && strcmp(env_divide_ext, "1") == 0) {
        view_divide_ext = TRUE;
    }

    strcpy(fname, file->mNameView);

    char* env_add_star_exe = getenv("VIEW_ADD_STAR_EXE");

    if(S_ISDIR(file->mStat.st_mode)) {
         strcat(fname, "/");
    }
    else if(S_ISFIFO(file->mLStat.st_mode)) {
        strcat(fname, "|");
    }
    else if(S_ISSOCK(file->mLStat.st_mode)) {
        strcat(fname, "=");
    }
    else if(env_add_star_exe && strcmp(env_add_star_exe, "1") == 0
             &&(file->mStat.st_mode&S_IXUSR
                || file->mStat.st_mode&S_IXGRP
                || file->mStat.st_mode&S_IXGRP))
    {
         strcat(fname, "*");
    }
    else if(S_ISLNK(file->mLStat.st_mode)) {
        strcat(fname, "@");
    }

    if(S_ISLNK(file->mLStat.st_mode)) {
        sprintf(fname + strlen(fname), " -> %s", file->mLinkTo);
    }

    if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
        *ext = GC_strdup("");
        *dot = ' ';
    }
    else {
        *ext = GC_strdup(extname(GC_strdup(fname)));
        *dot = ' ';

        if(strcmp(*ext, "") != 0) {
            fname[strlen(fname) - strlen(*ext) -1] = 0;
            *dot = '.';
        }
        if(strlen(*ext) > 4) {
            (*ext)[4] = 0;
        }
    }

    if(name_len > 0) {
        char* env_focusback = getenv("VIEW_FOCUSBACK");
        if(env_focusback && strcmp(env_focusback, "1") == 0) {
            str_cut3(fname, name_len, fname, PATH_MAX);
        }
        else {
            str_cut2(fname, name_len, fname, PATH_MAX);
        }
    }
    else {
        strcpy(fname, "");
    }
}

void filer_view(int dir)
{
    sDir* self = (sDir*)vector_item(gDirs, dir);

    char* env_divide_ext = getenv("VIEW_DIVIDE_EXTENSION");
    BOOL view_divide_ext = FALSE;
    if(env_divide_ext && strcmp(env_divide_ext, "1") == 0) {
        view_divide_ext = TRUE;
    }

    char* env_color_dir = getenv("COLOR_DIR");
    int color_dir = 0;
    if(env_color_dir) {
        color_dir = atoi(env_color_dir);
    }

    char* env_color_exe = getenv("COLOR_EXE");
    int color_exe = 0;
    if(env_color_exe) {
        color_exe = atoi(env_color_exe);
    }

    char* env_color_link = getenv("COLOR_LINK");
    int color_link = 0;
    if(env_color_link) {
        color_link = atoi(env_color_link);
    }

    char* env_color_mark = getenv("COLOR_MARK");
    int color_mark = 0;
    if(env_color_mark) {
        color_mark = atoi(env_color_mark);
    }

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    const int jobs_exist = vector_size(gJobs) > 0 ? 1 : 0;
    const int dstack_exist = vector_size(gDirs) > 2 ? 1 : 0;

    char* fkey = getenv("FKEY_SPACE");
    int fkey_space = 0;
    if(fkey) {
        fkey_space = atoi(fkey);
    }

    char* env_page_view_way = getenv("VIEW_PAGE");
    BOOL page_view_way = FALSE;
    if(env_page_view_way && strcmp(env_page_view_way, "1") == 0) {
        page_view_way = TRUE;
    }

    char* env_view_option = getenv("VIEW_OPTION");
    if(env_view_option == NULL) {
        fprintf(stderr, "VIEW_OPTION is NULL\n");
        exit(1);
    }

    ////////////////////////////////////////////////////////////
    // １画面１行
    ////////////////////////////////////////////////////////////
    if(strcmp(env_view_option, "one_dir") == 0) {
        if(self->mActive) {
            mbox(dstack_exist, 0, maxx-1, maxy-2-dstack_exist-jobs_exist-fkey_space);

            char path[PATH_MAX];
            
            char* ftp_site = getenv("FTP_SITE");
            char* ssh_site = getenv("SSH_SITE");
            if(ftp_site && strcmp(ftp_site, "") != 0) {
                char* ftp_path = getenv("FTP_PATH");

                sprintf(path, "ftp://%s/%s", ftp_site, ftp_path);
            }
            else if(ssh_site && strcmp(ssh_site, "") != 0) {
                char* ssh_path = getenv("SSH_PATH");

                sprintf(path, "ssh://%s/%s", ssh_site, ssh_path);
            }
            else {
                strcpy(path, self->mPath);
                if(strcmp(self->mATitle, "") != 0) {
                    strcat(path, self->mATitle);
                    strcat(path, "/");
                }
            }

            strcat(path, self->mMask);

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX];
            if(kanji_convert(path, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(path, tmp);
            }
#endif

            const int len = strlen(path);
            if(len < maxx-4) {
                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", path);
                mattroff();
            }
            else {
                char buf[PATH_MAX];

                str_cut3(path, maxx-4, buf, PATH_MAX);

                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", buf);
                mattroff();
            }

            int i;
            for(i=self->mScrollTop; 
                i-self->mScrollTop 
                    < maxy-kMaxYMinus
                        -dstack_exist-jobs_exist-fkey_space&&i<vector_size(self->mFiles);
                i++)
            {
                int attr = 0;
                sFile* file = (sFile*)vector_item(self->mFiles, i);

                int red = -1;
                int green = -1;
                int blue = -1;

                if(!S_ISDIR(file->mStat.st_mode)
                    && !(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                    && !S_ISLNK(file->mLStat.st_mode)) 
                {
                    int k;
                    for(k=0; k<vector_size(gFColors); k++) {
                        sFColor* fc = vector_item(gFColors, k);
                        OnigUChar* regex2 = (OnigUChar*)fc->mRegex;

                        regex_t* reg;

                        int err_info;

                        int r = onig_new(&reg, regex2
                                    , regex2 + strlen((char*)regex2)
                                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_IGNORECASE
                                    , ONIG_ENCODING_UTF8
                                    , ONIG_SYNTAX_DEFAULT
                                    ,  &err_info);

                        if(r == ONIG_NORMAL) {
                            OnigRegion* region = onig_region_new();
                            int r2 = onig_search(reg, file->mName
                               , file->mName + strlen((char*)file->mName)
                               , file->mName, file->mName + strlen((char*)file->mName)
                               , region, ONIG_OPTION_IGNORECASE);

                            if(r2 >= 0) {
                                red = fc->mRed;
                                green = fc->mGreen;
                                blue = fc->mBlue;
                                break;
                            }

                            onig_region_free(region, 1);
                        }

                        onig_free(reg);
                    }
                }

                if(self->mCursor == i && self->mActive) {
                     attr |= kCAReverse;
                }
        
                if(S_ISDIR(file->mStat.st_mode)) {
                     if(!file->mMark) attr |= color_dir;
                }
                else if(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                {
                     if(!file->mMark) attr |= color_exe;
                }
                else if(S_ISLNK(file->mLStat.st_mode)) {
                    if(!file->mMark) attr |= color_link;
                }

                char buf[1024];
                make_file_stat(file, buf);

                int name_len;
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    name_len = maxx-2-2-strlen(buf);
                }
                else {
                    name_len = maxx-2-5-2-strlen(buf);
                }

                char fname[1024];
                char* ext;
                char dot;
                make_file_name(file, fname, &ext, &dot, name_len);

                if(file->mMark) {
                    attr |= color_mark;
                }
                
                mattron(attr);

                if(red != -1) {
                    mattron_256color(red, green, blue);
                }

                if(file->mMark) {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, 1, "*");
                }
                else {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, 1, " ");
                }

                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, 2, "%s%s", fname,buf);
                }
                else {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, 2, "%s%c%-4s%s", fname, dot, ext,buf);
                }
                
                mattroff();
            }

            char size[256];
            make_size_str2(size, filer_mark_file_size(dir));
            if(page_view_way) {
                const int p = (((float)self->mCursor+1)
                                    /((float)vector_size(self->mFiles)))*100;
                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%3d%%)", filer_mark_file_num(dir)
                        , vector_size(self->mFiles)-1, size, p);
            }
            else {
                const int cur_page = self->mCursor/filer_line_max(adir()) + 1;
                const int max_page = vector_size(self->mFiles)/filer_line_max(adir()) + 1;

                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%d/%d)", filer_mark_file_num(dir)
                        , vector_size(self->mFiles)-1, size, cur_page, max_page);
            }
       }
    }
    //////////////////////////////////////////////////////////// 
    // １画面２行
    //////////////////////////////////////////////////////////// 
    else if(strcmp(env_view_option, "one_dir2") == 0) {
        if(self->mActive) {
            mbox(dstack_exist, 0, maxx-1, maxy-2-dstack_exist-jobs_exist-fkey_space);

            char path[PATH_MAX];

            char* ftp_site = getenv("FTP_SITE");
            char* ssh_site = getenv("SSH_SITE");
            if(ftp_site && strcmp(ftp_site, "") != 0) {
                char* ftp_path = getenv("FTP_PATH");

                sprintf(path, "ftp://%s/%s", ftp_site, ftp_path);
            }
            else if(ssh_site && strcmp(ssh_site, "") != 0) {
                char* ssh_path = getenv("SSH_PATH");

                sprintf(path, "ssh://%s/%s", ssh_site, ssh_path);
            }
            else {
                strcpy(path, self->mPath);
                if(strcmp(self->mATitle, "") != 0) {
                    strcat(path, self->mATitle);
                    strcat(path, "/");
                }
            }
            strcat(path, self->mMask);

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX];
            if(kanji_convert(path, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(path, tmp);
            }
#endif

            const int len = strlen(path);
            if(len < maxx-4) {
                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", path);
                mattroff();
            }
            else {
                char buf[PATH_MAX];

                str_cut3(path, maxx-4, buf, PATH_MAX);

                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", buf);
                mattroff();
            }
            int i;
            for(i=self->mScrollTop;
                i-self->mScrollTop<(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)*2
                            && i<vector_size(self->mFiles);
                i++)
            {
                int attr = 0;
                sFile* file = (sFile*)vector_item(self->mFiles, i);


                int red = -1;
                int green = -1;
                int blue = -1;

                if(!S_ISDIR(file->mStat.st_mode)
                    && !(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                    && !S_ISLNK(file->mLStat.st_mode)) 
                {
                    int k;
                    for(k=0; k<vector_size(gFColors); k++) {
                        sFColor* fc = vector_item(gFColors, k);
                        OnigUChar* regex2 = (OnigUChar*)fc->mRegex;

                        regex_t* reg;

                        int err_info;

                        int r = onig_new(&reg, regex2
                                    , regex2 + strlen((char*)regex2)
                                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_IGNORECASE
                                    , ONIG_ENCODING_UTF8
                                    , ONIG_SYNTAX_DEFAULT
                                    ,  &err_info);

                        if(r == ONIG_NORMAL) {
                            OnigRegion* region = onig_region_new();
                            int r2 = onig_search(reg, file->mName
                               , file->mName + strlen((char*)file->mName)
                               , file->mName, file->mName + strlen((char*)file->mName)
                               , region, ONIG_OPTION_IGNORECASE);

                            if(r2 >= 0) {
                                red = fc->mRed;
                                green = fc->mGreen;
                                blue = fc->mBlue;
                                break;
                            }

                            onig_region_free(region, 1);
                        }

                        onig_free(reg);
                    }
                }
/*
 * 拡張子別カラー
                if(gColor) {
                    char tmp[PATH_MAX];

                    if(this == gLDir) {
                        sprintf(tmp, "color = 0; $file_color.each do |item| if item[0] =~ file_name(0, %d) then color = item[1]; break; end end; color", i);
                    }
                    else {
                        sprintf(tmp, "color = 0; $file_color.each do |item| if item[0] =~ file_name(1,%d) then color = item[1]; break; end end; color", i);
                    }
                    int error;
                    VALUE color = rb_eval_string_protect(tmp, &error);

                    attr = NUM2INT(color);
                }
*/

                if(self->mCursor == i && self->mActive) {
                     attr |= kCAReverse;
                }
        
                if(S_ISDIR(file->mStat.st_mode)) {
                     if(!file->mMark) attr |= color_dir;
                }
                else if(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                {
                     if(!file->mMark) attr |= color_exe;
                }
                else if(S_ISLNK(file->mLStat.st_mode)) {
                    if(!file->mMark) attr |= color_link;
                }

                char buf[1024];
                make_file_stat(file, buf);

                int name_len;
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    name_len = maxx/2-2-2-strlen(buf);
                }
                else {
                    name_len = maxx/2-2-5-2-strlen(buf);
                }

                char fname[1024];
                char* ext;
                char dot;
                make_file_name(file, fname, &ext, &dot, name_len);

                const int x = (i-self->mScrollTop)
                                /(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                *(maxx/2) + 1;
                const int y = (i-self->mScrollTop)
                                %(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                    + 1 + dstack_exist;

                if(file->mMark) {
                    attr |= color_mark;
                }
                
                mattron(attr);

                if(red != -1) {
                    mattron_256color(red, green, blue);
                }

                if(file->mMark) {
                    mmvprintw(y, x, "*");
                }
                else {
                    mmvprintw(y, x, " ");
                }

                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    mmvprintw(y, x+1, "%s%s", fname,buf);
                }
                else {
                    mmvprintw(y, x+1, "%s%c%-4s%s", fname, dot, ext,buf);
                }
                
                mattroff();
            }

            char size[256];
            make_size_str2(size, filer_mark_file_size(dir));

            if(page_view_way) {
                const int p = (((float)self->mCursor+1)/((float)vector_size(self->mFiles)))*100;
                
                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%3d%%)"
                        , filer_mark_file_num(dir), vector_size(self->mFiles)-1, size, p);
            }
            else {
                const int cur_page = self->mCursor/(filer_line_max(adir())*2) + 1;
                const int max_page = vector_size(self->mFiles)/(filer_line_max(adir())*2) + 1;

                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                      , "(%d/%d)-%sbytes-(%d/%d)", filer_mark_file_num(dir)
                      , vector_size(self->mFiles)-1, size, cur_page, max_page);
            }
        }
    }
    //////////////////////////////////////////////////////////////////////////
    // １画面３行
    //////////////////////////////////////////////////////////////////////////
    else if(strcmp(env_view_option, "one_dir3") == 0) {
        if(self->mActive) {
            mbox(dstack_exist, 0, maxx-1, maxy-2-dstack_exist-jobs_exist-fkey_space);

            char path[PATH_MAX];

            char* ftp_site = getenv("FTP_SITE");
            char* ssh_site = getenv("SSH_SITE");
            if(ftp_site && strcmp(ftp_site, "") != 0) {
                char* ftp_path = getenv("FTP_PATH");

                sprintf(path, "ftp://%s/%s", ftp_site, ftp_path);
            }
            else if(ssh_site && strcmp(ssh_site, "") != 0) {
                char* ssh_path = getenv("SSH_PATH");

                sprintf(path, "ssh://%s/%s", ssh_site, ssh_path);
            }
            else {
                strcpy(path, self->mPath);
                if(strcmp(self->mATitle, "") != 0) {
                    strcat(path, self->mATitle);
                    strcat(path, "/");
                }
            }
            strcat(path, self->mMask);

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX];
            if(kanji_convert(path, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(path, tmp);
            }
#endif

            const int len = strlen(path);
            if(len < maxx-4) {
                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", path);
                mattroff();
            }
            else {
                char buf[PATH_MAX];

                str_cut3(path, maxx-4, buf, PATH_MAX);

                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", buf);
                mattroff();
            }

            int i;
            for(i=self->mScrollTop;
                i-self->mScrollTop<(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)*3
                            && i<vector_size(self->mFiles);
                i++)
            {
                int attr = 0;
                sFile* file = (sFile*)vector_item(self->mFiles, i);

                int red = -1;
                int green = -1;
                int blue = -1;

                if(!S_ISDIR(file->mStat.st_mode)
                    && !(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                    && !S_ISLNK(file->mLStat.st_mode)) 
                {
                    int k;
                    for(k=0; k<vector_size(gFColors); k++) {
                        sFColor* fc = vector_item(gFColors, k);
                        OnigUChar* regex2 = (OnigUChar*)fc->mRegex;

                        regex_t* reg;

                        int err_info;

                        int r = onig_new(&reg, regex2
                                    , regex2 + strlen((char*)regex2)
                                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_IGNORECASE
                                    , ONIG_ENCODING_UTF8
                                    , ONIG_SYNTAX_DEFAULT
                                    ,  &err_info);

                        if(r == ONIG_NORMAL) {
                            OnigRegion* region = onig_region_new();
                            int r2 = onig_search(reg, file->mName
                               , file->mName + strlen((char*)file->mName)
                               , file->mName, file->mName + strlen((char*)file->mName)
                               , region, ONIG_OPTION_IGNORECASE);

                            if(r2 >= 0) {
                                red = fc->mRed;
                                green = fc->mGreen;
                                blue = fc->mBlue;
                                break;
                            }

                            onig_region_free(region, 1);
                        }

                        onig_free(reg);
                    }
                }

                if(self->mCursor == i && self->mActive) {
                     attr |= kCAReverse;
                }
        
                if(S_ISDIR(file->mStat.st_mode)) {
                     if(!file->mMark) attr |= color_dir;
                }
                else if(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                {
                     if(!file->mMark) attr |= color_exe;
                }
                else if(S_ISLNK(file->mLStat.st_mode)) {
                    if(!file->mMark) attr |= color_link;
                }

                char buf[1024];
                make_file_stat(file, buf);

                int name_len;
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    name_len = maxx/3-2-2-strlen(buf);
                }
                else {
                    name_len = maxx/3-2-5-2-strlen(buf);
                }

                char fname[1024];
                char* ext;
                char dot;
                make_file_name(file, fname, &ext, &dot, name_len);

                const int x = (i-self->mScrollTop)
                                /(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                *(maxx/3) + 1;
                const int y = (i-self->mScrollTop)
                                %(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                    + 1 + dstack_exist;

                if(file->mMark) {
                    attr != kCABold;
                }
                
                mattron(attr);

                if(red != -1) {
                    mattron_256color(red, green, blue);
                }

                if(file->mMark) {
                    mmvprintw(y, x, "*");
                }
                else {
                    mmvprintw(y, x, " ");
                }

                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    mmvprintw(y, x+1, "%s%s", fname,buf);
                }
                else {
                    mmvprintw(y, x+1, "%s%c%-4s%s", fname, dot, ext,buf);
                }
                
                mattroff();
            }
            
            char size[256];
            make_size_str2(size, filer_mark_file_size(dir));

            if(page_view_way) {
                const int p = (((float)self->mCursor+1)/((float)vector_size(self->mFiles)))*100;
                
                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%3d%%)", filer_mark_file_num(dir), vector_size(self->mFiles)-1, size, p);
            }
            else {
                const int cur_page = self->mCursor/(filer_line_max(adir())*3) + 1;
                const int max_page = vector_size(self->mFiles)/(filer_line_max(adir())*3) + 1;

                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%d/%d)", filer_mark_file_num(dir)
                        , vector_size(self->mFiles)-1, size, cur_page, max_page);
            }
        }
    }
    
    //////////////////////////////////////////////////////////////////////////
    // １画面５行
    //////////////////////////////////////////////////////////////////////////
    else if(strcmp(env_view_option, "one_dir5") == 0) {
        if(self->mActive) {
            mbox(dstack_exist, 0, maxx-1, maxy-2-dstack_exist-jobs_exist-fkey_space);

            char path[PATH_MAX];

            char* ftp_site = getenv("FTP_SITE");
            char* ssh_site = getenv("SSH_SITE");
            if(ftp_site && strcmp(ftp_site, "") != 0) {
                char* ftp_path = getenv("FTP_PATH");

                sprintf(path, "ftp://%s/%s", ftp_site, ftp_path);
            }
            else if(ssh_site && strcmp(ssh_site, "") != 0) {
                char* ssh_path = getenv("SSH_PATH");

                sprintf(path, "ssh://%s/%s", ssh_site, ssh_path);
            }
            else {
                strcpy(path, self->mPath);
                if(strcmp(self->mATitle, "") != 0) {
                    strcat(path, self->mATitle);
                    strcat(path, "/");
                }
            }
            strcat(path, self->mMask);

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX];
            if(kanji_convert(path, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(path, tmp);
            }
#endif

            const int len = strlen(path);
            if(len < maxx-4) {
                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", path);
                mattroff();
            }
            else {
                char buf[PATH_MAX];

                str_cut3(path, maxx-4, buf, PATH_MAX);

                mattron(kCABold);
                mmvprintw(0 + dstack_exist, 2, "%s", buf);
                mattroff();
            }

            int i;
            for(i=self->mScrollTop;
                i-self->mScrollTop<(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)*5
                            && i<vector_size(self->mFiles);
                i++)
            {
                int attr = 0;
                sFile* file = (sFile*)vector_item(self->mFiles, i);

                int red = -1;
                int green = -1;
                int blue = -1;

                if(!S_ISDIR(file->mStat.st_mode)
                    && !(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                    && !S_ISLNK(file->mLStat.st_mode)) 
                {
                    int k;
                    for(k=0; k<vector_size(gFColors); k++) {
                        sFColor* fc = vector_item(gFColors, k);
                        OnigUChar* regex2 = (OnigUChar*)fc->mRegex;

                        regex_t* reg;

                        int err_info;

                        int r = onig_new(&reg, regex2
                                    , regex2 + strlen((char*)regex2)
                                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_IGNORECASE
                                    , ONIG_ENCODING_UTF8
                                    , ONIG_SYNTAX_DEFAULT
                                    ,  &err_info);

                        if(r == ONIG_NORMAL) {
                            OnigRegion* region = onig_region_new();
                            int r2 = onig_search(reg, file->mName
                               , file->mName + strlen((char*)file->mName)
                               , file->mName, file->mName + strlen((char*)file->mName)
                               , region, ONIG_OPTION_IGNORECASE);

                            if(r2 >= 0) {
                                red = fc->mRed;
                                green = fc->mGreen;
                                blue = fc->mBlue;
                                break;
                            }

                            onig_region_free(region, 1);
                        }

                        onig_free(reg);
                    }
                }
                
                if(self->mCursor == i && self->mActive) {
                     attr |= kCAReverse;
                }
        
                if(S_ISDIR(file->mStat.st_mode)) {
                     if(!file->mMark) attr |= color_dir;
                }
                else if(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                {
                     if(!file->mMark) attr |= color_exe;
                }
                else if(S_ISLNK(file->mLStat.st_mode)) {
                    if(!file->mMark) attr |= color_link;
                }

                char buf[1024];
                make_file_stat(file, buf);

                int name_len;
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    name_len = maxx/5-2-2-strlen(buf);
                }
                else {
                    name_len = maxx/5-2-5-2-strlen(buf);
                }
                char fname[1024];
                char* ext;
                char dot;
                make_file_name(file, fname, &ext, &dot, name_len);

                if(file->mMark) {
                    attr != kCABold;
                }

                mattron(attr);

                if(red != -1) {
                    mattron_256color(red, green, blue);
                }

                const int x = (i-self->mScrollTop)
                                /(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                *(maxx/5) + 1;
                const int y = (i-self->mScrollTop)
                                %(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space)
                                    + 1 + dstack_exist;
                if(file->mMark) {
                    mmvprintw(y, x, "*");
                }
                else {
                    mmvprintw(y, x, " ");
                }
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    mmvprintw(y, x+1, "%s%s", fname, buf);
                }
                else {
                    mmvprintw(y, x+1, "%s%c%-4s%s", fname, dot, ext, buf);
                }
                
                mattroff();
            }

            char size[256];
            make_size_str2(size, filer_mark_file_size(dir));

            if(page_view_way) {
                const int p = (((float)self->mCursor+1)/((float)vector_size(self->mFiles)))*100;
                
                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%3d%%)", filer_mark_file_num(dir), vector_size(self->mFiles)-1, size, p);
            }
            else {
                const int cur_page = self->mCursor/(filer_line_max(adir())*5) + 1;
                const int max_page = vector_size(self->mFiles)/(filer_line_max(adir())*5) + 1;

                mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, 2
                        , "(%d/%d)-%sbytes-(%d/%d)", filer_mark_file_num(dir)
                        , vector_size(self->mFiles)-1, size, cur_page, max_page);
            }
        }
    }

    //////////////////////////////////////////////////////////////////////////
    // ２画面
    //////////////////////////////////////////////////////////////////////////
    else {
        int x;
        if(dir == 0)
            x = 0;
        else
            x = maxx / 2; 

        int line = 0;
        mbox(dstack_exist, x, maxx/2-1, maxy-2-dstack_exist-jobs_exist-fkey_space);

        char path[PATH_MAX];

        char* ftp_site = getenv("FTP_SITE");
        char* ssh_site = getenv("SSH_SITE");
        if(ftp_site && strcmp(ftp_site, "") != 0 && dir == 0) {
            char* ftp_path = getenv("FTP_PATH");

            sprintf(path, "ftp://%s/%s", ftp_site, ftp_path);
        }
        else if(ssh_site && strcmp(ssh_site, "") != 0 && dir == 0) {
            char* ssh_path = getenv("SSH_PATH");

            sprintf(path, "ssh://%s/%s", ssh_site, ssh_path);
        }
        else {
            strcpy(path, self->mPath);
            if(strcmp(self->mATitle, "") != 0) {
                strcat(path, self->mATitle);
                strcat(path, "/");
            }
        }
        strcat(path, self->mMask);

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
        char tmp[PATH_MAX];
        if(kanji_convert(path, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
            strcpy(path, tmp);
        }
#endif

        const int len = strlen(path);
        if(len < maxx/2-5) {
            if(self->mActive) mattron(kCABold);
            mmvprintw(0 + dstack_exist, x+2, "%s", path);
            if(self->mActive) mattroff();
        }
        else {
            char buf[PATH_MAX];

            str_cut3(path, maxx/2-5, buf, PATH_MAX);

            if(self->mActive) mattron(kCABold);
            mmvprintw(0 + dstack_exist, x+2, "%s", buf);
            if(self->mActive) mattroff();
        }


        int i;
        for(i=self->mScrollTop;
                i-self->mScrollTop<maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space
                        && i<vector_size(self->mFiles);
                i++)
            {
                int attr = 0;
                sFile* file = (sFile*)vector_item(self->mFiles, i);
                
                int red = -1;
                int green = -1;
                int blue = -1;

                if(!S_ISDIR(file->mStat.st_mode)
                    && !(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                    && !S_ISLNK(file->mLStat.st_mode)) 
                {
                    int k;
                    for(k=0; k<vector_size(gFColors); k++) {
                        sFColor* fc = vector_item(gFColors, k);
                        OnigUChar* regex2 = (OnigUChar*)fc->mRegex;

                        regex_t* reg;

                        int err_info;

                        int r = onig_new(&reg, regex2
                                    , regex2 + strlen((char*)regex2)
                                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_IGNORECASE
                                    , ONIG_ENCODING_UTF8
                                    , ONIG_SYNTAX_DEFAULT
                                    ,  &err_info);

                        if(r == ONIG_NORMAL) {
                            OnigRegion* region = onig_region_new();
                            int r2 = onig_search(reg, file->mName
                               , file->mName + strlen((char*)file->mName)
                               , file->mName, file->mName + strlen((char*)file->mName)
                               , region, ONIG_OPTION_IGNORECASE);

                            if(r2 >= 0) {
                                red = fc->mRed;
                                green = fc->mGreen;
                                blue = fc->mBlue;
                                break;
                            }

                            onig_region_free(region, 1);
                        }

                        onig_free(reg);
                    }
                }

                if(self->mCursor == i && self->mActive) {
                     attr |= kCAReverse;
                }
        
                if(S_ISDIR(file->mStat.st_mode)) {
                     if(!file->mMark) attr |= color_dir;
                }
                else if(file->mStat.st_mode&S_IXUSR
                            || file->mStat.st_mode&S_IXGRP
                            || file->mStat.st_mode&S_IXGRP)
                {
                     if(!file->mMark) attr |= color_exe;
                }
                else if(S_ISLNK(file->mLStat.st_mode)) {
                    if(!file->mMark) attr |= color_link;
                }

                char buf[1024];
                make_file_stat(file, buf);

                int name_len;
                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    name_len = maxx/2-2-2-strlen(buf);
                }
                else {
                    name_len = maxx/2-2-5-2-strlen(buf);
                }

                char fname[1024];
                char* ext;
                char dot;
                make_file_name(file, fname, &ext, &dot, name_len);

                if(file->mMark) {
                    attr |= color_mark;
                }
                
                mattron(attr);

                if(red != -1) {
                    mattron_256color(red, green, blue);
                }

                if(file->mMark) {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, x+1, "*");
                }
                else {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, x+1, " ");
                }

                if(S_ISDIR(file->mStat.st_mode) || !view_divide_ext) {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, x+2, "%s%s", fname,buf);
                }
                else {
                    mmvprintw(i-self->mScrollTop + 1 + dstack_exist, x+2, "%s%c%-4s%s", fname, dot, ext,buf);
                }
                
                mattroff();
        }

        char size[256];
        make_size_str2(size, filer_mark_file_size(dir));
        
        mmvprintw(maxy - kMaxYMinus+1-jobs_exist-fkey_space, x + 2
                    , "(%d/%d)-%sbytes", filer_mark_file_num(dir), vector_size(self->mFiles)-1, size);
        
        if(self->mActive) {
            if(page_view_way) {
                const int p = (((float)self->mCursor+1)/((float)vector_size(self->mFiles)))*100;
                mprintw("-(%3d%%)", p);
            }
            else {
                const int cur_page = self->mCursor/filer_line_max(adir()) + 1;
                const int max_page = vector_size(self->mFiles)/(filer_line_max(adir())) + 1;

                mprintw("-(%d/%d)", cur_page, max_page);
            }
        }
    }

    /// draw gDirStack ///
    if(dstack_exist) {
        const int width = maxx / (vector_size(gDirs)-2);
        int i;
        for(i=2; i<vector_size(gDirs); i++) {
            sDir* dir = vector_item(gDirs, i);
            char* item = dir->mPath;
            
            char item2[256];
            strcpy(item2, "");
            const int len2 = strlen(item);
            int k;
            for(k=len2-2; k>=0; k--) {
                if(item[k] == '/') {
                    int l;
                    for(l=k+1; l<len2-1; l++) {
                        item2[l-k-1] = item[l];
                    }
                    item2[l-k-1] = 0;
                    break;
                }
            }
            
            char buf2[256];
            
            str_cut2(item2, width-6, buf2, 256);
            
            char buf[256];
            sprintf(buf, "[%d.%s]", i, buf2);

            mmvprintw(0, width * (i-2), "%s", buf);
        }
    }
}

int filer_line(int dir)
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    const int dstack_exist = vector_size(gDirs) > 2 ? 1 : 0;
    const int jobs_exist = vector_size(gJobs) > 0 ? 1 : 0;

    char* fkey = getenv("FKEY_SPACE");
    int fkey_space = 0;
    if(fkey) {
        fkey_space = atoi(fkey);
    }

    sDir* dir2 = vector_item(gDirs, dir);

    char* env_view_option = getenv("VIEW_OPTION");
    if(env_view_option == NULL) {
        fprintf(stderr, "VIEW_OPTION is NULL\n");
        exit(1);
    }

    if(dir2) {
        if(strcmp(env_view_option, "all") == 0)
        {
            return dir2->mCursor - dir2->mScrollTop;
        }
        else {
             return (dir2->mCursor - dir2->mScrollTop)
                         % (maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space);
        }
    }

    return -1;
}

int filer_line_max(int dir)
{
    const int jobs_exist = vector_size(gJobs) > 0 ? 1 : 0;
    const int dstack_exist = vector_size(gDirs) > 2 ? 1 : 0;
        
    char* fkey = getenv("FKEY_SPACE");
    int fkey_space = 0;
    if(fkey) {
        fkey_space = atoi(fkey);
    }
    return mgetmaxy() - kMaxYMinus - jobs_exist - dstack_exist-fkey_space;
}

int filer_row(int dir)
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    const int dstack_exist = vector_size(gDirs) > 2 ? 1 : 0;
    const int jobs_exist = vector_size(gJobs) > 0 ? 1 : 0;

    char* fkey = getenv("FKEY_SPACE");
    int fkey_space = 0;
    if(fkey) {
        fkey_space = atoi(fkey);
    }

    sDir* dir2 = vector_item(gDirs, dir);

    char* env_view_option = getenv("VIEW_OPTION");
    if(env_view_option == NULL) {
        fprintf(stderr, "VIEW_OPTION is NULL\n");
        exit(1);
    }

    if(dir2) {
        if(strcmp(env_view_option, "all") == 0)
        {
            return 0;
        }
        else {
            return dir2->mCursor/(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space);
        }
    }

    return -1;
}

int filer_row_max(int dir)
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    const int jobs_exist = vector_size(gJobs) > 0 ? 1 : 0;
    const int dstack_exist = vector_size(gDirs) > 2 ? 1 : 0;

    char* fkey = getenv("FKEY_SPACE");
    int fkey_space = 0;
    if(fkey) {
        fkey_space = atoi(fkey);
    }

    sDir* dir2 = vector_item(gDirs, dir);

    char* env_view_option = getenv("VIEW_OPTION");
    if(env_view_option == NULL) {
        fprintf(stderr, "VIEW_OPTION is NULL\n");
        exit(1);
    }
    if(dir2) {
        if(strcmp(env_view_option, "all") == 0) {
            return 1;
        }
        else {
            return (vector_size(dir2->mFiles)-1)
                    /(maxy-kMaxYMinus-dstack_exist-jobs_exist-fkey_space) + 1;
        }
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////
// ソート
///////////////////////////////////////////////////////////////////////////////
BOOL sort_name(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    if(strcmp(l->mName, ".") == 0) return TRUE;
    if(strcmp(l->mName, "..") == 0) {
        if(strcmp(r->mName, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(r->mName, ".") == 0) return FALSE;
    if(strcmp(r->mName, "..") == 0) return FALSE;
    
    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }

    if(gSelf->mSortKindDirUp) {
        if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
            || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
        {
            return strcasecmp(l->mName, r->mName) < 0;
        }

    
        if(S_ISDIR(l->mStat.st_mode))
            return TRUE;
        else
            return FALSE;
    }
    else {
        return strcasecmp(l->mName, r->mName) < 0;
    }
}

BOOL sort_name_reverse(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    if(strcmp(l->mName, ".") == 0) return TRUE;
    if(strcmp(l->mName, "..") == 0) {
        if(strcmp(r->mName, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(r->mName, ".") == 0) return FALSE;
    if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
        if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
            || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
            {
            return strcasecmp(l->mName, r->mName) > 0;
            }

    
        if(S_ISDIR(r->mStat.st_mode)) return FALSE;
        return TRUE;
    }
    else {
        return strcasecmp(l->mName, r->mName) > 0;
    }
}
    
BOOL sort_ext(void* left, void* right)
{
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;          
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
     char* lext = extname(l->mName);
     char* rext = extname(r->mName);
    
     bool result;
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
              if(S_ISDIR(r->mStat.st_mode))
                    result = strcasecmp(l->mName, r->mName) < 0;
              else
                    result = TRUE;
         }
         else if(S_ISDIR(r->mStat.st_mode)) {
              result = FALSE;
         }
         else {
              const int cmp = strcasecmp(lext, rext);
              if(cmp == 0) {
                  result = strcasecmp(l->mName, r->mName) < 0;
              }
              else {
                  result = cmp < 0;
              }
         }
     }
     else {
         const int cmp = strcasecmp(lext, rext);
         if(cmp == 0) {
             result = strcasecmp(l->mName, r->mName) < 0;
         }
         else {
             result = cmp < 0;
         }
     }
    
     return result;
}
    
BOOL sort_ext_reverse(void* left, void* right)
{
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;          
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
     char* lext = extname(l->mName);
     char* rext = extname(r->mName);
    
     bool result;
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
            if(S_ISDIR(l->mStat.st_mode))
                result= strcasecmp(l->mName, r->mName) >0;
            else
                result = FALSE;
         }
         else if(S_ISDIR(l->mStat.st_mode)) {
              result = TRUE;
         }
         else {
              const int cmp = strcasecmp(lext, rext);
              if(cmp == 0) {
                  result = strcasecmp(l->mName, r->mName) > 0;
              }
              else {
                  result = cmp > 0;
              }
         }
     }
     else {
         const int cmp = strcmp(lext, rext);
         if(cmp == 0) {
             result = strcasecmp(l->mName, r->mName) > 0;
         }
         else {
             result = cmp > 0;
         }
     }
    
     return result;
}

BOOL sort_size(void* left, void* right)
{
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;          
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;
     
    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
             if(S_ISDIR(r->mStat.st_mode)) return strcasecmp(l->mName, r->mName) < 0;
             return TRUE;
         }
         if(S_ISDIR(r->mStat.st_mode)) return FALSE;
     }
     
     const int lsize = S_ISDIR(l->mStat.st_mode) ? 0 : l->mLStat.st_size; 
     const int rsize = S_ISDIR(r->mStat.st_mode) ? 0 : r->mLStat.st_size;
    
     if(lsize == rsize) {
         return strcasecmp(l->mName, r->mName) < 0;
     }
     else {
         return lsize < rsize;
     }
}
  
BOOL sort_size_reverse(void* left, void* right)
{
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;          
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
             if(S_ISDIR(l->mStat.st_mode)) return strcasecmp(l->mName, r->mName) > 0;
             return FALSE;
         }
         if(S_ISDIR(l->mStat.st_mode)) return TRUE;
     }
     
     const int lsize = S_ISDIR(l->mStat.st_mode) ? 0 : l->mLStat.st_size; 
     const int rsize = S_ISDIR(r->mStat.st_mode) ? 0 : r->mLStat.st_size;

     if(lsize == rsize) {
         return strcasecmp(l->mName, r->mName) > 0;
     }
     else {
         return lsize > rsize;
     }
}
    
BOOL sort_time(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
             if(S_ISDIR(r->mStat.st_mode)) {
                 double cmp = difftime(l->mLStat.st_mtime, r->mLStat.st_mtime);
                 if(cmp == 0) {
                     return strcasecmp(l->mName, r->mName) < 0;
                 }
                 else {
                    return cmp < 0;
                }
             }
             return TRUE;
         }
         if(S_ISDIR(r->mStat.st_mode)) return FALSE;
     }
     
     double cmp = difftime(l->mLStat.st_mtime, r->mLStat.st_mtime);
     if(cmp == 0) {
         return strcasecmp(l->mName, r->mName) < 0;
     }
     else {
        return cmp < 0;
     }
}
    
BOOL sort_time_reverse(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
             if(S_ISDIR(l->mStat.st_mode)) {
                 double cmp = difftime(l->mLStat.st_mtime, r->mLStat.st_mtime);
                 if(cmp == 0) {
                     return strcasecmp(l->mName, r->mName) > 0;
                 }
                 else {
                    return cmp > 0;
                 }
             }
             return FALSE;
         }
         if(S_ISDIR(l->mStat.st_mode)) return TRUE;
     }
     
     double cmp = difftime(l->mLStat.st_mtime, r->mLStat.st_mtime);
     if(cmp == 0) {
         return strcasecmp(l->mName, r->mName) > 0;
     }
     else {
        return cmp > 0;
    }
}

BOOL sort_user(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
             if(S_ISDIR(r->mStat.st_mode)) {
                 if(l->mLStat.st_uid == r->mLStat.st_uid) {
                     return strcasecmp(l->mName, r->mName) < 0;
                 }
                 else {
                     return l->mLStat.st_uid < r->mLStat.st_uid;
                 }
             }
             return TRUE;
         }
         if(S_ISDIR(r->mStat.st_mode)) return FALSE;
     }
     
     if(l->mLStat.st_uid == r->mLStat.st_uid) {
         return strcasecmp(l->mName, r->mName) < 0;
     }
     else {
         return l->mLStat.st_uid < r->mLStat.st_uid;
     }
}
    
BOOL sort_user_reverse(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
             if(S_ISDIR(l->mStat.st_mode)) {
                 if(l->mLStat.st_uid == r->mLStat.st_uid) {
                     return strcasecmp(l->mName, r->mName) > 0;
                 }
                 else {
                    return l->mLStat.st_uid > r->mLStat.st_uid;
                 }
             }
//             if(S_ISDIR(l->mLStat.st_mode)) return strcasecmp(r->mName, l->mName) < 0;
             return FALSE;
         }
         if(S_ISDIR(l->mStat.st_mode)) return TRUE;
     }
     
     if(l->mLStat.st_uid == r->mLStat.st_uid) {
         return strcasecmp(l->mName, r->mName) > 0;
     }
     else {
        return l->mLStat.st_uid > r->mLStat.st_uid;
     }
}

BOOL sort_group(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
             if(S_ISDIR(r->mStat.st_mode)) {
                 if(l->mLStat.st_gid == r->mLStat.st_gid) {
                     return strcasecmp(l->mName, r->mName) < 0;
                 }
                 else {
                    return l->mLStat.st_gid < r->mLStat.st_gid;
                 }
             }
//             if(S_ISDIR(r->mLStat.st_mode)) return strcasecmp(l->mName, r->mName) < 0;
             return TRUE;
         }
         if(S_ISDIR(r->mStat.st_mode)) return FALSE;
     }
     
     if(l->mLStat.st_gid == r->mLStat.st_gid) {
         return strcasecmp(l->mName, r->mName) < 0;
     }
     else {
        return l->mLStat.st_gid < r->mLStat.st_gid;
     }
}
    
BOOL sort_group_reverse(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
             if(S_ISDIR(l->mStat.st_mode)) {
                 if(l->mLStat.st_gid == r->mLStat.st_gid) {
                     return strcasecmp(l->mName, r->mName) > 0;
                 }
                 else {
                    return l->mLStat.st_gid > r->mLStat.st_gid;
                 }
             }
//             if(S_ISDIR(l->mLStat.st_mode)) return strcasecmp(r->mName, l->mName) < 0;
             return FALSE;
         }
         if(S_ISDIR(l->mStat.st_mode)) return TRUE;
     }
     
     if(l->mLStat.st_gid == r->mLStat.st_gid) {
         return strcasecmp(l->mName, r->mName) > 0;
     }
     else {
        return l->mLStat.st_gid > r->mLStat.st_gid;
     }
}

BOOL sort_permission(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(l->mStat.st_mode)) {
             if(S_ISDIR(r->mStat.st_mode)) {
                 if((l->mLStat.st_mode&S_ALLPERM) == (r->mLStat.st_mode&S_ALLPERM)) {
                     return strcasecmp(l->mName, r->mName) < 0;
                 }
                 else {
                     return (l->mLStat.st_mode&S_ALLPERM) < (r->mLStat.st_mode&S_ALLPERM);
                 }
             }
             return TRUE;
         }
         if(S_ISDIR(r->mStat.st_mode)) return FALSE;
     }
     
     if((l->mLStat.st_mode&S_ALLPERM) == (r->mLStat.st_mode&S_ALLPERM)) {
         return strcasecmp(l->mName, r->mName) < 0;
     }
     else {
         return (l->mLStat.st_mode&S_ALLPERM) < (r->mLStat.st_mode&S_ALLPERM);
     }
}
    
BOOL sort_permission_reverse(void* left, void* right)
{ 
     sFile* l = (sFile*) left;
     sFile* r = (sFile*) right;

     if(strcmp(l->mName, ".") == 0) return TRUE;
     if(strcmp(l->mName, "..") == 0) {
          if(strcmp(r->mName, ".") == 0) return FALSE;

          return TRUE;
     }
     if(strcmp(r->mName, ".") == 0) return FALSE;
     if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(!l->mMark && r->mMark) {
            return TRUE;
        }
        if(l->mMark && !r->mMark) {
            return FALSE;
        }
    }
    if(gSelf->mSortKindDirUp) {
         if(S_ISDIR(r->mStat.st_mode)) {
             if(S_ISDIR(l->mStat.st_mode)) {
                 if((l->mLStat.st_mode&S_ALLPERM) == (r->mLStat.st_mode&S_ALLPERM)) {
                     return strcasecmp(l->mName, r->mName) > 0;
                 }
                 else {
                     return (l->mLStat.st_mode&S_ALLPERM) > (r->mLStat.st_mode&S_ALLPERM);
                 }
             }
             return FALSE;
         }
         if(S_ISDIR(l->mStat.st_mode)) return TRUE;
     }
     
     if((l->mLStat.st_mode&S_ALLPERM) == (r->mLStat.st_mode&S_ALLPERM)) {
         return strcasecmp(l->mName, r->mName) > 0;
     }
     else {
         return (l->mLStat.st_mode&S_ALLPERM) > (r->mLStat.st_mode&S_ALLPERM);
     }
}

BOOL sort_random(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    if(strcmp(l->mName, ".") == 0) return TRUE;
    if(strcmp(l->mName, "..") == 0) {
        if(strcmp(r->mName, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(r->mName, ".") == 0) return FALSE;
    if(strcmp(r->mName, "..") == 0) return FALSE;

    if(gSelf->mSortKindMarkUp) {
        if(l->mMark && !r->mMark) {
            return TRUE;
        }
        if(!l->mMark && r->mMark) {
            return FALSE;
        }
    }

    if(gSelf->mSortKindDirUp) {
        if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
            || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
        {
            return l->mSortRandom < r->mSortRandom;
        }

    
        if(S_ISDIR(l->mStat.st_mode))
            return TRUE;
        else
            return FALSE;
    }
    else {
        return l->mSortRandom < r->mSortRandom;
    }
}

void filer_sort(int dir)
{
    if(dir < 0 || dir >= vector_size(gDirs)) {
        return;
    }
    sDir* self = (sDir*)vector_item(gDirs, dir);

    filer_sort2(self);
}


static void filer_sort2(sDir* self)
{
    gSelf = self;
    switch(self->mSortKind) {
    case kRandom: {
        int i;
        for(i=0; i<vector_size(self->mFiles); i++) {
            sFile* f = (sFile*)vector_item(self->mFiles, i);

            f->mSortRandom = random()%vector_size(self->mFiles);
        }

        vector_sort(self->mFiles, sort_random);
        }
        break;

    case kName:
        vector_sort(self->mFiles, sort_name);
        break;

    case kNameReverse:
        vector_sort(self->mFiles, sort_name_reverse);
        break;

    case kExt:
        vector_sort(self->mFiles, sort_ext);
        break;

    case kExtReverse:
        vector_sort(self->mFiles, sort_ext_reverse);
        break;

    case kSize:
        vector_sort(self->mFiles, sort_size);
        break;

    case kSizeReverse:
        vector_sort(self->mFiles, sort_size_reverse);
        break;

    case kTime:
        vector_sort(self->mFiles, sort_time);
        break;

    case kTimeReverse:
        vector_sort(self->mFiles, sort_time_reverse);
        break;

    case kUser:
        vector_sort(self->mFiles, sort_user);
        break;

    case kUserReverse:
        vector_sort(self->mFiles, sort_user_reverse);
        break;

    case kGroup:
        vector_sort(self->mFiles, sort_group);
        break;

    case kGroupReverse:
        vector_sort(self->mFiles, sort_group_reverse);
        break;

    case kPermission:
        vector_sort(self->mFiles, sort_permission);
        break;

    case kPermissionReverse:
        vector_sort(self->mFiles, sort_permission_reverse);
        break;
    }
}
