#ifndef MFILER3_FILER_H
#define MFILER3_FILER_H

#include "common.h"

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>


///////////////////////////////////////////////////////////////////////////////
// sFile -- ファイルオブジェクト
///////////////////////////////////////////////////////////////////////////////
typedef struct {
    char mName[PATH_MAX];           // ディスク内部の名前
    char mNameView[PATH_MAX];       // 表示する時の名前(iconvで変換後)
    char mLinkTo[PATH_MAX];         // リンク先
    struct stat mStat;              // stat()のキャッシュ
    struct stat mLStat;             // lstat()のキャッシュ
    BOOL mMark;                     // マークされているかどうか
    char mUser[256];                // ユーザー名
    char mGroup[256];               // グループ名

    char mMask[256];                // マスク

    int mSortRandom;                // ランダムソート時の数値
} sFile;

sFile* sFile_new(char* name, char* name_view, char* linkto, struct stat* stat_, struct stat* lstat_, BOOL mark, char* user, char* group, int uid, int gid);

void add_fcolor(char* regex, int red, int green, int blue);

///////////////////////////////////////////////////////////////////////////////
// sDir -- ディレクトリオブジェクト
///////////////////////////////////////////////////////////////////////////////
enum eSortKind { kName, kNameReverse, kExt, kExtReverse, kSize, kSizeReverse, kTime, kTimeReverse, kUser, kUserReverse, kGroup, kGroupReverse, kPermission, kPermissionReverse, kRandom, kSortNone, kSortMax };

char* kSortName[kSortMax];

typedef struct  {
    char mPath[PATH_MAX];       // 現在のディレクトリ最後は/
    char mMask[BUFSIZ];         // マスク
    BOOL mDotDirMask;           // ドットディレクトリのマスク
    int mScrollTop;             // スクロールトップ
    int mCursor;                // カーソル位置
    char mATitle[PATH_MAX];     // 圧縮ファイルの名前

    vector_obj* mFiles;
    BOOL mActive;

    BOOL mVD;                   // 仮想ディレクトリ開始
    BOOL mVD2;                  // 仮想ディレクトリ開始

    enum eSortKind mSortKind;
    BOOL mSortKindMarkUp;
    BOOL mSortKindDirUp;

    enum eSortKind mSortKindBefore;

    vector_obj* mHistory;
    int mHistoryCursor;

} sDir;

sDir* sDir_new(char* path);      // 普通のディレクトリ読み込み

///////////////////////////////////////////////////////////////////////////////
// ファイラー
///////////////////////////////////////////////////////////////////////////////
extern enum eKanjiCode gKanjiCodeFileName;
extern BOOL gExecutiveFileBold;
extern vector_obj* gDirs;
extern BOOL gExtensionICase;        // マークファイルの拡張子別実行で大文字小文字を区別するかどうか
extern hash_obj* gKeyCommand[2][KEY_MAX];      // キーとコマンドのマップ[0][キーコード] metaなし [1][キーコード] meta
extern hash_obj* gKeyCommandTitle[2][KEY_MAX]; // gKeyCommandのコマンドタイトル
extern hash_obj* gKeyCommandLine[2][KEY_MAX];
extern hash_obj* gKeyCommandLineCurPos[2][KEY_MAX];
extern hash_obj* gKeyCommandLineExpandMacro[2][KEY_MAX];

void filer_init();

int filer_new_dir(char* path);
void filer_del_dir(int dir);

void filer_sort(int dir);

sDir* filer_dir(int dir);
sFile* filer_file(int dir, int num);
int filer_file2(int dir, char* name);
vector_obj* filer_mark_files(int dir);
int filer_cd(int dir, char* path);
int filer_cd_back(int dir);
int filer_history_forward(int dir);
int filer_history_back(int dir);

char* filer_mask(int dir);
BOOL filer_dotdir_mask(int dir);

void filer_vd_start(int dir);
void filer_vd2_start(int dir);
void filer_vd_add(int dir, char* fname);
void filer_vd_add2(int dir, char* line);
void filer_vd_end(int dir);

void filer_archive_title(int dir, char* title);

int filer_reread(int dir);
int filer_mark_file_num(int dir);
BOOL filer_marking(int dir);
void filer_cursor_move(int dir, int num);
int filer_cursor(int dir);
void filer_activate(int dir);
void filer_reset_marks(int dir);
sFile* filer_cursor_file(int dir);

void filer_toggle_mark(int dir, int num);
BOOL filer_mark(int dir, int num);
void filer_set_mark(int dir, int num, int mark);

int filer_line(int dir);
int filer_line_max(int dir);
int filer_row(int dir);
int filer_row_max(int dir);

void filer_view(int dir);
void filer_input(int meta, int key);

int adir();
int sdir();

void extend_macro(char* p, string_obj* title);
int make_size_str(char* result, double size);

#endif
