#include "common.h"
#include <unistd.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/shm.h>
#include <glob.h>
#include <string.h>
#include <libgen.h>

hash_obj* gArrays;        // 配列

enum eStatmentKind { kIf, kWhile, kFor, kBreak, kReturn, kFunction,
kExternCommand, kCd, kAdir };
enum eStatmentTerminated { kTNormal, kOrOr, kAndAnd };

enum eRedirect { kRedirectInput, kRedirectOverwrite, kRedirectAppend, kRedirectErrAndOutput };

typedef struct {
    enum eRedirect mType;
    int mFd;
    char mFName[PATH_MAX];
} sRedirect;

sRedirect* sRedirect_new()
{
    sRedirect* self = (sRedirect*)GC_malloc_atomic(sizeof(sRedirect));
    return self;
}

typedef struct
{
    enum eStatmentKind mKind;
    char* mExternCommand;       // GCで管理されるchar*
    vector_obj* mArgs;      // コンパイル済みの文 vector of GCで管理されるchar*

    vector_obj* mRedirects;     // vector of sRedirect
} sStatment;

sStatment* sStatment_new()
{
    sStatment* self = GC_malloc(sizeof(sStatment)));

    self->mKind = 0;
    self->mExternCommand = NULL;
    self->mArgs = vector_new(10);

    self->mRedirects = vector_new(5);

    return self;
}

typedef struct
{
    vector_obj* mStatments;

    char* mFName;
    int mLine;

    char* mHereDocument;

    enum eStatmentTerminated mTerminated;

    char* mRemain;          // 未コンパイル文 GCで管理されるchar*
    void* mExtra;
} sStatments;

sStatments* sStatments_new()
{
    sStatments* self = GC_malloc(sizeof(sStatments)));

    self->mStatments = vector_new(10);
    self->mTerminated = kTNormal;
    self->mHereDocument = NULL;
    self->mExtra = NULL;
    self->mFName = NULL;
    self->mLine = 0;
    self->mRemain = NULL;

    return self;
}

void fumiko_init()
{
    gJobs = vector_new(10);
    gArrays = hash_new(10);
}

BOOL is_space(char c)
{
    if(c == ' ' || c == '\n' || c == ';' || c == '\t' || c == 0) {
        return TRUE;
    }
    else {
        return FALSE;
    }
}

void err_msg(char* fname, int line, char* msg)
{
    if(mis_curses()) {
    }
    else {
        fprintf(stderr, "%s %d: %s", fname, line, msg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// コンパイル
///////////////////////////////////////////////////////////////////////////////
static int compile(char* p, char* fname, vector_obj* statments_list)
{
    int line = 0;
    while(1) {
        if(*p == ' ') p++
        else if(*p =='\t') p++;
        else if(*p =='\n') {
            line++;
            p++;
        }
    }

    if(*p == 0) return TRUE;

    string_obj* buf = string_new("");
    sStatment* statment = sStatment_new();

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(*p) {
        // クォート
        if(*p == '\\') {
            if(squote && *(p+1)=='\'' || dquote && *(p+1)=='"') {
                p++;
                string_push_back2(buf, *p++);
            }
            else {
                string_push_back2(buf, *p++);
                string_push_back2(buf, *p++);
            }
        }
        // 空文字列
        else if(!dquote && *p == '\'' && *(p+1) == '\'' 
                || (!squote && *p == '"' && *(p+1) == '"')) 
        {
            p+=2;

            if(strcmp(string_c_str(buf), "") != 0) {
                err_msg(fname, line, "parser error before \"\" or ''");
                return FALSE;
            }
            else {
                vector_add(statment->mArgs, GC_strdup(""));
                buf = string_new("");
            }
        }
        // シングルクォート
        else if(!dquote && *p == '\'') {
            p++;
            squote = !squote;
        }
        // ダブルクォート
        else if(!squote && *p == '"') {
            p++;
            dquote = !dquote;
        }
        // 環境変数
        else if(!squote && *p == '$') {
            while(1) {
                if(*p == 0 || *p == '\n') {
                    p++;

                    sStatments statments = sStatments_new();
                    statments->mTerminated = kTNormal;

                    statments->mFname = GC_strdup(fname);
                    statments->mLine = line;
                    statments->mRemain = GC_strdup(string_c_str(buf));

                    vector_add(statments_list, statments);

                    line++;
                    break;
                }
                else if(*p == ';') {
                    p++;

                    sStatments statments = sStatments_new();
                    statments->mTerminated = kTNormal;

                    statments->mFname = GC_strdup(fname);
                    statments->mLine = line;
                    statments->mRemain = GC_strdup(string_c_str(buf));

                    vector_add(statments_list, statments);
                    break;
                }
                else if(*p == '&' && *(p+1) == '&') {
                    p+=2;

                    sStatments statments = sStatments_new();
                    statments->mTerminated = kTAndAnd;

                    statments->mFname = GC_strdup(fname);
                    statments->mLine = line;
                    statments->mRemain = GC_strdup(string_c_str(buf));

                    vector_add(statments_list, statments);

                    break;
                }
                else if(*p == '|' && *(p+1) == '|') {
                    p += 2;
                    sStatments statments = sStatments_new();
                    statments->mTerminated = kTOrOr;

                    statments->mFname = GC_strdup(fname);
                    statments->mLine = line;
                    statments->mRemain = GC_strdup(string_c_str(buf));

                    vector_add(statments_list, statments);
                    break;
                }
                else {
                    string_push_back2(buf, *p++);
                }
            }
        }
        // マクロ
        else if(!squote && *p == '%') {
            while(1) {
                if(*p == 0 || *p == '\n') {
                    p++;

                    statment->mTerminated = kTNormal;

                    statment->mFname = GC_strdup(fname);
                    statment->mLine = line;
                    statment->mRemain = GC_strdup(string_c_str(buf));

                    line++;
                    break;
                }
                else if(*p == ';') {
                    p++;

                    statment->mTerminated = kTNormal;

                    statment->mFname = GC_strdup(fname);
                    statment->mLine = line;
                    statment->mRemain = GC_strdup(string_c_str(buf));
                    break;
                }
                else if(*p == '&' && *(p+1) == '&') {
                    p+=2;

                    statment->mTerminated = kTAndAnd;

                    statment->mFname = GC_strdup(fname);
                    statment->mLine = line;
                    statment->mRemain = GC_strdup(string_c_str(buf));

                    break;
                }
                else if(*p == '|' && *(p+1) == '|') {
                    p += 2;
                    statment->mTerminated = kTOrOr;

                    statment->mFname = GC_strdup(fname);
                    statment->mLine = line;
                    statment->mRemain = GC_strdup(string_c_str(buf));

                    break;
                }
                else {
                    string_push_back2(buf, *p++);
                }
            }
        }
        // シングルクォート、ダブルクォート中
        else if(squote || dquote) {
            string_push_back2(buf, *p++);
        }
        // パイプ
        else if(*p == '|') {
        }
        // アンドアンド
        else if(*p == '&' && *(p+1) == '&') {
            p+=2;

            vector_add(statment->mArgs, GC_strdup(string_c_str(buf)));
            buf = string_new("");

            statment->mFname = GC_strdup(fname);
            statment->mLine = line;
            statment->mTerminated = kAndAnd;

            vector_add(statments, statment);
        }
        // オアオア
        else if(*p == '|' && *(p+1) == '|') {
            p+=2;

            vector_add(statment->mArgs, GC_strdup(string_c_str(buf)));
            buf = string_new("");

            statment->mFname = GC_strdup(fname);
            statment->mLine = line;
            statment->mTerminated = kOrOr;

            vector_add(statments, statment);
        }
        // 改行
        else if(*p == ';') {
            p++;

            vector_add(statment->mArgs, GC_strdup(string_c_str(buf)));
            buf = string_new("");

            statment->mFname = GC_strdup(fname);
            statment->mLine = line;
            statment->mTerminated = kTNormal;

            vector_add(statments, statment);
        }
        // 改行
        else if(*p == '\n') {
            p++;
            line++;

            vector_add(statment->mArgs, GC_strdup(string_c_str(buf)));
            buf = string_new("");

            statment->mFname = GC_strdup(fname);
            statment->mLine = line;
            statment->mTerminated = kTNormal;

            vector_add(statments, statment);
        }
        // 空白
        else if(*p == ' ' || *p == '\t') {
            while(*p == ' ' || *p == '\t') {
                p++;
            }

            if(strcmp(string_c_str(buf), "") != 0) {
                vector_add(statment->mArgs, GC_strdup(string_c_str(buf)));
                buf = string_new("");
            }
            else {
                vector_add(statment->mArgs, GC_strdup(""));
                buf = string_new("");
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// フォアグランドジョブの終了を待つ
///////////////////////////////////////////////////////////////////////////////
static int wait_forground_job(BOOL quick)
{
    int return_code = 0;

    if(vector_size(gForgroundJob->mChildPrograms) > 0) {
        if(gChangeTerminalTitle) {
            printf("%c]2;mfiler3 %s%c", 033
                        , string_c_str(gForgroundJob->mName), 007);
            fflush(stdout);
        }

        while(gForgroundJob && vector_size(gForgroundJob->mChildPrograms) > 0) {
            sChildProgram* prog 
               = (sChildProgram*)vector_item(gForgroundJob->mChildPrograms, 0);
            int status = 0;
            pid_t pid = waitpid(prog->mPid, &status, WUNTRACED);
            
            if(pid) {
                /// 終了した場合 ///
                if(WIFEXITED(status) || WIFSIGNALED(status)) {
                    gForgroundJob->mRunningProgs--;
                    vector_erase(gForgroundJob->mChildPrograms, 0);

                    if(gForgroundJob->mRunningProgs == 0) {
                        int i;
                        for(i=0; i<vector_size(gJobs); i++) {
                            if(vector_item(gJobs, i) == gForgroundJob) {
                                vector_erase(gJobs, i);
                                break;
                            }
                        }
                        gForgroundJob = NULL;

                        if(!quick) {
                            filer_reread(0);
                            filer_reread(1);
                        }

                        if(tcsetpgrp(0, getpid())) {
                            perror("tcsetpgrp");
                            exit(1);
                        }

                        return_code = WEXITSTATUS(status);
                        char buf[256];
                        sprintf(buf, "%d", return_code);
                        setenv("?", buf, 1);
                    }
                }
                /// シグナルの配送によりフォワグランドジョブが停止した場合 ///
                else if(WIFSTOPPED(status)) {
                    gForgroundJob = NULL;

                    if(tcsetpgrp(0, getpid())) {
                        perror("tcsetpgrp");
                        exit(1);
                    }
                }
            }
        }

        if(gChangeTerminalTitle) {
            if(gFocus) {
                printf("%c]2;[mfiler3] %s%c", 033, gTitleBar, 007);
                fflush(stdout);
            }
            else {
                printf("%c]2;mfiler3 %s%c", 033, gTitleBar, 007);
                fflush(stdout);
            }
        }
    }

    return return_code;
}


///////////////////////////////////////////////////////////////////////////////
// 実行
///////////////////////////////////////////////////////////////////////////////
typedef struct {
    pid_t pgrp;
    char first_process;
} sSharedMemory;

static void null_fun()
{
}

static int run(vector_obj* statments, char* title)
{
    /// 実行 ///
    int nextin = 0;
    int nextout = 1;
    BOOL last_command_is_inner;
    sJob* job = sJob_new(title);

    job->mPGroup = -1;

    /// 共有メモリ ///
    static int n = 0;
    if(n == 999) {
        n = 0;
    }
    int shared_memory_id = shmget(n++, sizeof(sSharedMemory), 0666|IPC_CREAT);
    if(shared_memory_id == -1) {
        fprintf(stderr, "%d\n", n);
        perror("shmget");
        exit(1);
    }

    sSharedMemory* shared_memory = shmat(shared_memory_id, (void*)0, 0);
    
    memset(shared_memory, 0, sizeof(sSharedMemory));

    int i;
    for(i=0; i<vector_size(statments); i++) {
        sStatment* statment = vector_item(statments, i);

        int pipefds[2];

        if(i == (vector_size(statments)-1)) {
            if(pipein != -1) {
                nextout = pipein;
            }
            else {
                nextout = 1;
            }
        }
        else {
            if(pipe(pipefds) < 0) {
                perror("pipe");
                exit(1);
            }
            nextout = pipefds[1];
        }

        if(statment->mKind
            char* cmd = string_c_str((string_obj*)vector_item(argv, 0));

            /// 内蔵コマンド ///
            if(strcmp(cmd, "keycommand") == 0 || strcmp(cmd, "mfiler3_keycommand") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 5) {
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);


                    hash_put(gKeyCommand[meta][keycode], argv3, argv4);
                }
                else if(vector_size(argv) == 6){
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));
                    char* argv5 = string_c_str(vector_item(argv, 5));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);

                    hash_put(gKeyCommand[meta][keycode], argv3, argv4);
                    hash_put(gKeyCommandTitle[meta][keycode], argv3
                                    , argv5);
                }

                /// 終了処理 ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else {
        if(statments->mKind == kExternCommand) {
                last_command_is_inner = FALSE;

                /// コマンドのファイル関連付 ///
                if(!in_fun) {
                    char* prog = string_c_str(vector_item(argv, 0));

                    int l;
                    for(l=1; l<vector_size(argv); l++) {
                        char* arg = string_c_str(vector_item(argv, l));
                        char* ext = extname(arg);

                        if(arg[0] != '-' && strcmp(ext, "") != 0) {
                            if(hash_item(gRelatedProg, ext)) {
                                int j;
                                for(j=0; j<vector_size(gRelatedProg2); j++) {
                                    sRelatedProg* rp = vector_item(gRelatedProg2, j);
                                    if(strcmp(string_c_str(rp->mExt), ext) == 0) {
                                        rp->mProg = string_new(prog);
                                        break;
                                    }
                                }
                            }
                            else {
                                vector_add(gRelatedProg2, sRelatedProg_new(ext, prog));
                            }
                            hash_put(gRelatedProg, ext, string_new(prog));
                        }
                    }
                }

                /// fork ///
                pid_t pid = fork();
                if(pid < 0) {
                    perror("fork");
                    exit(1);
                }

                /// 子プロセスの処理 ///
                if(pid == 0) {
                    // シグナル //
                    set_signal_subshell();

                    /// プロセスグループ ///
                    if(job->mPGroup == -1) {
                        job->mPGroup = getpid();

                        /// 独自のプロセスグループにいれる ///
                        if(setpgid(0, job->mPGroup) < 0) {
                            perror("setpgid(child)");
                            exit(1);
                        }

                        /// 前に出す ///
                        if(!statment->background) {
                            if(tcsetpgrp(0, job->mPGroup) < 0) {
                                perror("tcsetpgrp(child)");
                                exit(1);
                            }
                        }

                        shared_memory->first_process = 1;
                    }
                    else {
                        while(shared_memory->first_process == 0) {
                        }

                        /// 独自のプロセスグループにいれる ///
                        if(setpgid(0, job->mPGroup) < 0) {
                            perror("setpgid2(child)");
                            exit(1);
                        }

                        /// 端末を前に出す ///
                        if(!statment->background) {
                            if(tcsetpgrp(0, job->mPGroup) < 0) {
                                perror("tcsetpgrp2(child)");
                                exit(1);
                            }
                        }
                    }

                    set_signal_clear();

char buf[BUFSIZ];
strcpy(buf, "");
int l;
for(l=0; l<vector_size(argv); l++) {
    strcat(buf, string_c_str(vector_item(argv, l)));
}

                    /// リダイレクト ///
                    int j;
                    for(j=0; j<vector_size(redirections); j++) {
                        sRedirect* redirect = (sRedirect*)
                                vector_item(redirections, j);
                        if(redirect->mType == kRedirectErrAndOutput) {
                            if(dup2(nextout, 2) < 0) {
                                perror("dup2 3-1");
                                exit(1);
                            }
                        }
                        else {
                            mode_t mode;
                            switch(redirect->mType) {
                                case kRedirectInput:
                                    mode = O_RDONLY;
                                    break;
                                
                                case kRedirectOverwrite:
                                    mode = O_RDWR | O_CREAT | O_TRUNC;
                                    break;
                                    
                                case kRedirectAppend:
                                    mode = O_RDWR | O_CREAT | O_APPEND;
                                    break;
                            }
                            
                            int openfd = open(redirect->mFName, mode, 0666);
                            if(openfd < 0) {
                                fprintf(stderr, "open %s is err", redirect->mFName);
                                exit(1);
                            }
                            
                            if(openfd != redirect->mFd) {
                                if(dup2(openfd, redirect->mFd) < 0) {
                                    perror("dup2 3");
                                    exit(1);
                                }
                                close(openfd);
                            }
                        }
                    }

                    /// パイプ ///
                    if(nextin != 0) {
                        if(dup2(nextin, 0) < 0) {
                            perror("dup2 1");
                            exit(1);
                        }
                        close(nextin);
                    }
                    
                    if(nextout != 1) {
                        if(dup2(nextout, 1) < 0) {
                            perror("dup2 2");
                            exit(1);
                        }
                        if(!flg_function
                            || flg_function && nextout != pipein)
                        {
                            close(nextout);
                        }
                    }

                    /// char** に変換 ///
                    char** argv2 = (char**)malloc(sizeof(char*)*(vector_size(argv)+1));

                    for(i=0; i<vector_size(argv); i++) {
                        string_obj* item = (string_obj*)vector_item(argv, i);
                        argv2[i] = string_c_str(item);
                    }
                    argv2[i] = NULL;

                    /// exec ///
                    execvp(argv2[0], argv2);
                    fprintf(stderr, "exec('%s') error", argv2[0]);
                    exit(1);
                }
                /// 親プロセスの処理 ///
                else {
                    if(job->mPGroup == -1) {
                        job->mPGroup = pid;

                        // 子を独自プロセスグループに入れる
                        if(setpgid(pid, job->mPGroup) < 0
                            && !errno == EACCES) 
                        {
                            perror("setpgid1(parent)");
                            exit(1);
                        }
                    }
                    else {
                        // 子を独自のプロセスグループに入れる
                        if(setpgid(pid, job->mPGroup) < 0 
                            && !errno == EACCES) 
                        {
                            perror("setpgid2(parent)");
                            exit(1);
                        }
                    }

                    sJob_AddChildProgram(job, pid, argv, 0);

                    if(nextin != 0) {
                        close(nextin);
                    }
                    if(nextout != 1 && nextout != 0 &&
                        (!flg_function
                            || flg_function && nextout != pipein) )
                        close(nextout);
                    
                    nextin = pipefds[0];
                }
            }
        }
    }
run_command_end:

    /// 共有メモリ解放 ///
    if(shmdt(shared_memory) == -1) {
        fprintf(stderr, "shmdt failed\n");
        exit(1);
    }

    if(shmctl(shared_memory_id, IPC_RMID, 0) == -1) {
        if(sub_shell) fprintf(stderr, "subshell\n");
        //perror("shmctl(IPC_RMID)");
    }

    vector_add(gJobs, job);

    /// フォアグランドジョブの処理 ///
    if(!statment->background || job->mRunningProgs == 0) {
        gForgroundJob = job;

        if(gForgroundJob->mRunningProgs == 0) {
            int i;
            for(i = 0; i<vector_size(gJobs); i++) {
                if(vector_item(gJobs, i) == gForgroundJob) {
                    vector_erase(gJobs, i);
                    break;
                }
            }
            gForgroundJob = NULL;

            if(last_command_is_inner == FALSE) {
                rcode = 0;
            }
        }
        else {
            if(vector_size(gForgroundJob->mChildPrograms) > 0) {
                if(change_title && gChangeTerminalTitle) {
                    printf("%c]2;mfiler3 %s%c", 033
                                , string_c_str(gForgroundJob->mName), 007);
                    fflush(stdout);
                }

                while(gForgroundJob 
                    && vector_size(gForgroundJob->mChildPrograms) > 0)
                {
                    sChildProgram* prog = (sChildProgram*)
                            vector_item(gForgroundJob->mChildPrograms, 0);
                    int status = 0;
                    pid_t pid = waitpid(prog->mPid, &status, WUNTRACED);
    
                    if(pid) {
                        /// シグナルの配送により終了した場合 ///
                        if(WIFSIGNALED(status)) {
                            gForgroundJob->mRunningProgs--;
                            vector_erase(gForgroundJob->mChildPrograms, 0);

                            if(gForgroundJob->mRunningProgs == 0) {
                                int i;
                                for(i=0; i<vector_size(gJobs); i++) {
                                    if(vector_item(gJobs, i) == gForgroundJob) {
                                        vector_erase(gJobs, i);
                                        break;
                                    }
                                }
                                gForgroundJob = NULL;

                                if(!quick && !sub_shell) {
                                    filer_reread(0);
                                    filer_reread(1);
                                }

                                if(tcsetpgrp(0, getpid())) {
                                    perror("tcsetpgrp(mfiler3)");
                                    exit(1);
                                }

                                if(last_command_is_inner == FALSE) {
                                    rcode = WEXITSTATUS(status);
                                    char buf[256];
                                    sprintf(buf, "%d", rcode);
                                    setenv("?", buf, 1);
                                }
                            }

                            *break_ = TRUE;
                        }
                        /// 終了した場合 ///
                        else if(WIFEXITED(status)) {
                            gForgroundJob->mRunningProgs--;
                            vector_erase(gForgroundJob->mChildPrograms, 0);

                            if(gForgroundJob->mRunningProgs == 0) {
                                int i;
                                for(i=0; i<vector_size(gJobs); i++) {
                                    if(vector_item(gJobs, i) == gForgroundJob) {
                                        vector_erase(gJobs, i);
                                        break;
                                    }
                                }
                                gForgroundJob = NULL;

                                if(!quick && !sub_shell) {
                                    filer_reread(0);
                                    filer_reread(1);
                                }

                                if(tcsetpgrp(0, getpid())) {
                                    perror("tcsetpgrp(mfiler3)");
                                    exit(1);
                                }

                                if(last_command_is_inner == FALSE) {
                                    rcode = WEXITSTATUS(status);
                                    char buf[256];
                                    sprintf(buf, "%d", rcode);
                                    setenv("?", buf, 1);
                                }
                            }
                        }
                        /// シグナルの配送により停止した場合 ///
                        else if(WIFSTOPPED(status)) {
                            gForgroundJob = NULL;

                            if(tcsetpgrp(0, getpid())) {
                                perror("tcsetpgrp(mfiler3) WIFSTOPPED");
                                exit(1);
                            }
                        }
                    }
                }

                if(change_title && gChangeTerminalTitle) {
                    if(gFocus) {
                        printf("%c]2;[mfiler3] %s%c", 033, gTitleBar, 007);
                        fflush(stdout);
                    }
                    else {
                        printf("%c]2;mfiler3 %s%c", 033, gTitleBar, 007);
                        fflush(stdout);
                    }
                }
            }
        }
    }
    else {
        if(last_command_is_inner == FALSE) {
            rcode = 1;
        }
    }
    return rcode;
}

///////////////////////////////////////////////////////////////////////////////
// シェル
///////////////////////////////////////////////////////////////////////////////
string_obj* shell3(char* cmd)
{
    int pipefds[2];

    if(pipe(pipefds) < 0) {
        perror("pipe");
        exit(1);
    }

    shell(cmd, NULL, pipefds[1], FALSE, FALSE, -1);
    string_obj* result = string_new("");

    char buf[BUFSIZ];
    while(1) {
        int size = read(pipefds[0], buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            fprintf(stderr, "expand command err(read)");
            close(pipefds[0]);
            close(pipefds[1]);
            return Qnil;
        }

        buf[size] = 0;

        string_push_back(result, buf);
    }
    close(pipefds[0]);
    close(pipefds[1]);

    return result;
}
}

///////////////////////////////////////////////////////////////////////////////
// ファイル読み込み
///////////////////////////////////////////////////////////////////////////////
int fumiko_load(char* fname)
{
    string_obj* str = string_new("");

    int f = open(fname, O_RDONLY);
    if(f < 0) {
        return -1;
    }

    char buf[BUFSIZ];
    while(1) {
        int size = read(f, buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            close(f);
            return -1;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(f);

    vector_obj* statments = vector_new(10);
    compile(string_c_str(str), fname, statments);
    run(statments);
}

///////////////////////////////////////////////////////////////////////////////
// 文字列読み込み
///////////////////////////////////////////////////////////////////////////////
void fumiko_shell(char* command)
{
    vector_obj* statments = vector_new(10);
    compile(command, command, statments);
    run(statments);
}

///////////////////////////////////////////////////////////////////////////////
// 描写
///////////////////////////////////////////////////////////////////////////////
void fumiko_view()
{
    const int maxy = mgetmaxy();
    const int maxx = mgetmaxx();

    const int size = vector_size(gJobs);
    int i;
    for(i=0; i<size; i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);

        const int x = (maxx/size)*i;
        char buf[BUFSIZ];
        sprintf(buf, "[%d]%s", i+1, string_c_str(job->mName));
        char buf2[BUFSIZ];
        
        str_cut(buf, maxx/size, buf2, BUFSIZ);

        int fkey_space = atoi(getenv("FKEY_SPACE"));
        mmvprintw(maxy-3-fkey_space, x, "%s", buf2);
    }
}

///////////////////////////////////////////////////////////////////////////////
// バックグラウンドジョブが終了していれば後処理をする
///////////////////////////////////////////////////////////////////////////////
void fumiko_wait_backgroud_job()
{
    int i = 0;
while_start:
    for(i=0; i<vector_size(gJobs); i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);
        int j;
        for(j=0; j<vector_size(job->mChildPrograms); j++) {
            sChildProgram* prg 
                = (sChildProgram*)vector_item(job->mChildPrograms, j);

            int status;
            pid_t pid = waitpid(prg->mPid, &status, WNOHANG);

            if(pid == prg->mPid || pid < 0 && errno == ECHILD) {
                vector_erase(job->mChildPrograms, j);

                job->mRunningProgs--;

                if(job->mRunningProgs == 0) {
                    vector_erase(gJobs, i);
   
                    filer_reread(0);
                    filer_reread(1);
                }

                goto while_start;
            }
        }
    }
}
///////////////////////////////////////////////////////////////////////////////
// ファイルの読み込み
///////////////////////////////////////////////////////////////////////////////
int fumiko_load(char* fname)
{
    string_obj* str = string_new("");

    int f = open(fname, O_RDONLY);
    if(f < 0) {
        return -1;
    }

    char buf[BUFSIZ];
    while(1) {
        int size = read(f, buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            close(f);
            return -1;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(f);

    shell(string_c_str(str), fname, -1, FALSE, sub_shell, -1);
}


///////////////////////////////////////////////////////////////////////////////
// 全てのジョブをkillする
///////////////////////////////////////////////////////////////////////////////
void fumiko_kill_all_jobs()
{
    int i;
    for(i=0; i<vector_size(gJobs); i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);
        
        int j;
        for(j=0; j<vector_size(job->mChildPrograms); j++) {
            sChildProgram* prog = (sChildProgram*)vector_item(job->mChildPrograms, j);
            kill(prog->mPid, SIGKILL);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// ジョブを前面に出す
///////////////////////////////////////////////////////////////////////////////
void fumiko_forground_job(int num)
{
    if(num>=0 && num < vector_size(gJobs)) {
        sJob* job = (sJob*)vector_item(gJobs, num);
        if(job->mRunningProgs == 0) {   // 内部コマンドだった
            return;
        }

        BOOL flg_curses = FALSE;
        if(mis_curses()) {
            flg_curses = TRUE;
            mendwin();
        }

        struct termios tty;
        tcgetattr(STDIN_FILENO, &tty);

        mclear_immediately();
        mmove_immediately(0, 0);
        fflush(stdout);

        gForgroundJob = job;
        
        if(tcsetpgrp(0, gForgroundJob->mPGroup)) {
            perror("tcsetpgrp forground job");
            exit(1);
        }
        
        if(killpg(gForgroundJob->mPGroup, SIGCONT) < 0) {
            sChildProgram* prog = 
                (sChildProgram*)vector_item(job->mChildPrograms, 0);
            kill(prog->mPid, SIGCONT);
        }
        
        wait_forground_job(TRUE);
        
        tcsetattr(STDIN_FILENO, TCSANOW, &tty);

        if(flg_curses) {
            minitscr();
            set_signal_sigint_clear();
            mclear();
        }

        mclear_immediately();
    }
}

