#include "common.h"
#include <ctype.h>

///////////////////////////////////////////////////////////////////////////////
// メッセージ表示
///////////////////////////////////////////////////////////////////////////////
static char gMsgBuf[BUFSIZ];

static void msg_view()
{
    int maxx = mgetmaxx();
    int maxy = mgetmaxy();

    mclear_online(maxy-2);
    mclear_online(maxy-1);
    mmvprintw(maxy-2, 0, "%s", gMsgBuf);

    mmove(maxy-1, maxx-2);
}

int msg(char* msg, ...)
{
    va_list args;
    va_start(args, msg);
    int ret = vsprintf(gMsgBuf, msg, args);
    va_end(args);
    
    int run_curses = FALSE;
    if(mis_curses() == 0) {
        run_curses = TRUE;
        minitscr();
    }

    gView = msg_view;
    
    while(true) {
        filer_view(0);
        filer_view(1);

        shell_view();

        msg_view();
        mrefresh();

        int meta;
        int key = 0;

        key = mgetch(&meta);
        
        if(key == 12) {            // CTRL-L
            mclear_immediately();
        }
        else {
            break;
        }
    }
    
    gView = NULL;

    if(run_curses) {
        mendwin();
    }
    
    return ret;
}

void msg_nonstop(char* msg, ...)
{
    char buf[BUFSIZ];

    va_list args;
    va_start(args, msg);
    int ret = vsprintf(buf, msg, args);
    va_end(args);
    
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mclear_online(maxy-2);
    mclear_online(maxy-1);
    mmvprintw(maxy-2, 0, "%s", buf);
    mrefresh();

    mmove(maxy-1, maxx-2);
}

//////////////////////////////////////////////////////////////////////////////
// 文字列選択コマンドライン版
//////////////////////////////////////////////////////////////////////////////

char* gSelectStrMsg;
char** gSelectStrStr;
int gSelectStrCursor;
int gSelectStrLen;

void select_str_view()
{
    int maxx = mgetmaxx();
    int maxy = mgetmaxy();
    
    /// view ///
    mclear_online(maxy-2);
    mclear_online(maxy-1);

    mmove(maxy-2, 0);
    mprintw("%s", gSelectStrMsg);
    
//        mmove(maxy-1, 0);
    mprintw(" ");
    int i;
    for(i=0; i< gSelectStrLen; i++) {
        if(gSelectStrCursor == i) {
            mattron(kCAReverse);
            mprintw("%s", gSelectStrStr[i]);
            mattroff();
            mprintw(" ");
        }
        else {
            mprintw("%s ", gSelectStrStr[i]);
        }
    }

    mmove(maxy-1, maxx-2);
}

int select_str(char* msg, char* str[], int len, int cancel)
{
    gSelectStrMsg = msg;
    gSelectStrStr = str;
    gSelectStrLen = len;
    
    gSelectStrCursor = 0;
    
    gView2 = select_str_view;
    
    while(1) {
        filer_view(0);
        filer_view(1);
        shell_view();
        select_str_view();
        mrefresh();

        /// input ///
        int meta;
        int key = mgetch(&meta);
        if(key == 10 || key == 13) {
            break;
        }
        else if(key == 6 || key == KEY_RIGHT) {
            gSelectStrCursor++;

            if(gSelectStrCursor >= len) gSelectStrCursor = len-1;
        }
        else if(key == 2 || key == KEY_LEFT) {
            gSelectStrCursor--;

            if(gSelectStrCursor < 0) gSelectStrCursor= 0;
        }
        else if(key == 12) {            // CTRL-L
            mclear_immediately();
        }
        else if(key == 3 || key == 7 || key == 27) {    // CTRL-C -G Escape
            gSelectStrCursor = cancel;
            break;
        }
        else {
            int i;
            for(i=0; i< len; i++) {
                if(toupper(key) == toupper(str[i][0])) {
                    gSelectStrCursor = i;
                    goto finished;
                }
            }
        }
    }
finished:
    
    gView2 = NULL;

    return gSelectStrCursor;
}

int select_str2(char* msg, char* str[], int len, int cancel)
{
    gSelectStrMsg = msg;
    gSelectStrStr = str;
    gSelectStrLen = len;
    
    gSelectStrCursor = 0;
    
    gView2 = select_str_view;
    
    while(1) {
        select_str_view();
        mrefresh();

        /// input ///
        int meta;
        int key = mgetch(&meta);
        if(key == 10 || key == 13) {
            break;
        }
        else if(key == 6 || key == KEY_RIGHT) {
            gSelectStrCursor++;

            if(gSelectStrCursor >= len) gSelectStrCursor = len-1;
        }
        else if(key == 2 || key == KEY_LEFT) {
            gSelectStrCursor--;

            if(gSelectStrCursor < 0) gSelectStrCursor= 0;
        }
        else if(key == 12) {            // CTRL-L
            mclear_immediately();
        }
        else if(key == 3 || key == 7 || key == 27) {    // CTRL-C -G Escape
            gSelectStrCursor = cancel;
            break;
        }
        else {
            int i;
            for(i=0; i< len; i++) {
                if(toupper(key) == toupper(str[i][0])) {
                    gSelectStrCursor = i;
                    goto finished;
                }
            }
        }
    }
finished:
    
    gView2 = NULL;

    return gSelectStrCursor;
}

//////////////////////////////////////////////////////////////////////////////
// インプットボックス
//////////////////////////////////////////////////////////////////////////////
// result 0: ok 1: cancel
static void input_box_cursor_move(string_obj* input, int* cursor, int v)
{
    if(gKanjiCode == kUtf8) {
        char* str = string_c_str(input);
        int utfpos = str_pointer2utfpos(str, str + *cursor);
        utfpos+=v;
        *cursor = str_utfpos2pointer(str, utfpos) - str;
    }
    else {
        *cursor += v;

        if(*cursor < 0) *cursor = 0;
        if(*cursor > string_length(input)) *cursor = string_length(input);
    }
}

char* gInputBoxMsg;
string_obj* gInputBoxInput;
int gInputBoxCursor;
    
void input_box_view()
{
    int maxx = mgetmaxx();
    int maxy = mgetmaxy();

    /// view ///
    mclear_online(maxy-2);
    mclear_online(maxy-1);
    
    mmvprintw(maxy-2, 0, "%s", gInputBoxMsg);
    
    mmove(maxy-1, 0);
    
    const int len = string_length(gInputBoxInput);
    int i;
    for(i=0; i< len && i<maxx-1; i++) {
        mprintw("%c", string_c_str(gInputBoxInput)[i]);
    }

    //mmove_immediately(maxy -1, gInputBoxCursor);
    mmove(maxy -1, gInputBoxCursor);
}

int input_box(char* msg, char* result, char* def_input, int def_cursor)
{
    gInputBoxMsg = msg;
    
    int result2 = 0;
    gInputBoxCursor = def_cursor;

    gInputBoxInput = string_new(def_input);
    
    gView2 = input_box_view;
    
    while(1) {
        input_box_view();
        mrefresh();

        /// input ///
        int meta;
        int key = mgetch(&meta);
        if(key == 10 || key == 13) {
            result2 = 0;
            break;
        }
        else if(key == 6 || key == KEY_RIGHT) {
            if(gKanjiCode == kUtf8) {
                input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, 1);
            }
            else {
                if(is_kanji(string_c_str(gInputBoxInput)[gInputBoxCursor]))
                    input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, 2);
                else
                    input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, 1);
            }
        }
        else if(key == 2 || key == KEY_LEFT) {
            if(gKanjiCode == kUtf8) {
                input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -1);
            }
            else {
                if(gInputBoxCursor > 0) {
                    if(gInputBoxCursor== 1) {
                        input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -1);
                    }
                    else {
                        if(is_kanji(string_c_str(gInputBoxInput)[gInputBoxCursor-2]))
                            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -2);
                        else 
                            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -1);
                    }
                }
            }
        }
        else if(key == 8 || key == KEY_BACKSPACE) {    // CTRL-H
            if(gInputBoxCursor > 0) {
                char* str2 = string_c_str(gInputBoxInput);

                if(gKanjiCode == kUtf8) {
                    int utfpos = str_pointer2utfpos(str2, str2 + gInputBoxCursor);
                    char* before_point = str_utfpos2pointer(str2, utfpos-1);
                    int new_cursor = before_point-str2;

                    string_erase(gInputBoxInput, before_point - str2, (str2 + gInputBoxCursor) - before_point);
                    gInputBoxCursor = new_cursor;
                }
                else {
                    if(gInputBoxCursor == 1) {
                        string_erase(gInputBoxInput, gInputBoxCursor-1, 1);
                        input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -1);
                    }
                    else {
                        if(is_kanji(string_c_str(gInputBoxInput)[gInputBoxCursor-2])) {
                            string_erase(gInputBoxInput, gInputBoxCursor-2, 2);

                            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -2);
                        } else {
                            string_erase(gInputBoxInput, gInputBoxCursor-1, 1);

                            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -1);
                        }
                    }
                }
            }
        }
        else if(key == 4 || key == KEY_DC) {    // CTRL-D DELETE
            char* str2 = string_c_str(gInputBoxInput);
            if(string_length(gInputBoxInput) > 0) {
                if(gInputBoxCursor < string_length(gInputBoxInput)) {
                    if(gKanjiCode == kUtf8) {
                        int utfpos = str_pointer2utfpos(str2, str2 + gInputBoxCursor);
                        char* next_point = str_utfpos2pointer(str2, utfpos+1);

                        string_erase(gInputBoxInput, gInputBoxCursor, next_point - (str2 + gInputBoxCursor));
                    }
                    else {
                        if(is_kanji(string_c_str(gInputBoxInput)[gInputBoxCursor])) {
                            string_erase(gInputBoxInput, gInputBoxCursor, 2);
                        }
                        else {
                            string_erase(gInputBoxInput, gInputBoxCursor, 1);
                        }
                    }
                }
            }
        }
        else if(key == 1 || key == KEY_HOME) {    // CTRL-A
            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, -999);
        }
        else if(key == 5 || key == KEY_END) {    // CTRL-E
            input_box_cursor_move(gInputBoxInput, &gInputBoxCursor, 999);
        }
        else if(key == 11) {    // CTRL-K
            string_erase(gInputBoxInput, gInputBoxCursor, string_length(gInputBoxInput)-gInputBoxCursor);
        }
        
        else if(key == 21) {    // CTRL-U
            string_put(gInputBoxInput, "");

            gInputBoxCursor = 0;
        }
        else if(key == 23) {     // CTRL-W
            if(gInputBoxCursor > 0) {
                const char* s = string_c_str(gInputBoxInput);
                int pos = gInputBoxCursor-1;
                if(s[pos]==' ' || s[pos]=='/' || s[pos]=='\'' || s[pos]=='"') {
                    while(pos>=0 && (s[pos]==' ' || s[pos]=='/' || s[pos]=='\'' || s[pos]=='"'))
                    {
                        pos--;
                    }
                }
                while(pos>=0 && s[pos]!=' ' && s[pos]!='/' && s[pos]!='\'' && s[pos]!='"')
                {
                    pos--;
                }

                string_erase(gInputBoxInput, pos+1, gInputBoxCursor-pos-1);

                gInputBoxCursor = pos+1;
            }
        }
        else if(meta==1 && key == 'd') {     // Meta-d
            const char* s = string_c_str(gInputBoxInput);

            if(s[gInputBoxCursor] != 0) {
                int pos = gInputBoxCursor;
                pos++;
                while(s[pos]!=0 && (s[pos] == ' ' || s[pos] == '/' || s[pos] == '\'' || s[pos] == '"')) {
                    pos++;
                }
                while(s[pos]!=0 && s[pos] != ' ' && s[pos] != '/' && s[pos] != '\'' && s[pos] != '"') {
                    pos++;
                }

                string_erase(gInputBoxInput, gInputBoxCursor, pos-gInputBoxCursor);
            }
        }
        else if(meta==1 && key == 'b') {     // META-b
            if(gInputBoxCursor > 0) {
                const char* s = string_c_str(gInputBoxInput);
                int pos = gInputBoxCursor;
                pos--;
                while(pos>=0 && (s[pos] == ' ' || s[pos] == '/' || s[pos] == '\'' || s[pos] == '"')) {
                    pos--;
                }
                while(pos>=0 && s[pos] != ' ' && s[pos] != '/' && s[pos] != '\'' && s[pos] != '"') {
                    pos--;
                }

                gInputBoxCursor = pos+1;
            }
        }
        else if(meta==1 && key == 'f') {     // META-f
            const char* s = string_c_str(gInputBoxInput);

            if(s[gInputBoxCursor] != 0) {
                int pos = gInputBoxCursor;
                pos++;
                while(s[pos]!=0 && (s[pos] == ' ' || s[pos] == '/' || s[pos] == '\'' || s[pos] == '"')) {
                    pos++;
                }
                while(s[pos]!=0 && s[pos] != ' ' && s[pos] != '/' && s[pos] != '\'' && s[pos] != '"') {
                    pos++;
                }

                gInputBoxCursor = pos;
            }
        }
        else if(key == 3 || key == 7 || key == 27) {    // CTRL-C -G Escape
            result2 = 1;
            break;
        }
        else if(key == 12) {            // CTRL-L
            mclear_immediately();
        }
        else {
            if(gKanjiCode == kUtf8) {
                if(meta == 0 && !(key >= 0 && key <= 27)) {
                    char tmp[128];

                    sprintf(tmp, "%c", key);
                    string_insert(gInputBoxInput, gInputBoxCursor, tmp);
                    gInputBoxCursor++;
                }
            }
            else {
                if(is_kanji(key)) {
                    int meta;
                    int key2 = mgetch(&meta);

                    char tmp[128];
                    sprintf(tmp, "%c%c", (char)key, (char)key2);
                    string_insert(gInputBoxInput, gInputBoxCursor, tmp);
                    gInputBoxCursor+=2;
                }
                else if(meta == 0 && ' ' <= key && key <= '~') {
                    char tmp[128];
                    sprintf(tmp, "%c", key);
                    string_insert(gInputBoxInput, gInputBoxCursor, tmp);
                    gInputBoxCursor++;
                }
            }
        }
    }
    
    gView2 = NULL;
    
    int maxx = mgetmaxx();
    int maxy = mgetmaxy();
    
    strcpy(result, string_c_str(gInputBoxInput));

    mmove_immediately(maxy -2, 0);
    
    return result2;
}

