/*
 * index
 * みなと だいすけ(c) 2008
 */

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include "minato_string.h"

int main(int argc, char* argv[])
{
    if(argc == 1) {
        fprintf(stderr, "index: invalid argument\n");
        exit(1);
    }

    string_obj* str = string_new("");
    while(1) {
        char buf[BUFSIZ];
        int r = read(0, buf, BUFSIZ);
        if(r < 0) {
            perror("read");
            return 1;
        }
        if(r == 0) {
            break;
        }
        buf[r] = 0;

        string_push_back(str, buf);
    }

    char* str2 = string_c_str(str);

    int argv2 = 0;
    if(argc == 3) {
        argv2 = atoi(argv[2]);

        if(argv2 < 0) {
            argv2 = strlen(str2) + argv2;
        }
    }

    char* p = strstr(str2 + argv2, argv[1]);

    if(p) {
        printf("%d\n", p - str2);
    }
    else {
        printf("-1\n");
    }

    return 0;
}

