#include "common.h"

#if defined(HAVE_MIGEMO_H)
migemo* gMigemo;
static regex_t* gReg;
#endif

static string_obj* gInputFileName;      // ͂ꂽ

///////////////////////////////////////////////////////////////////////////////
// Oɂ炷`
///////////////////////////////////////////////////////////////////////////////
BOOL gISearch = FALSE;                  // ݃CN^T[`ǂ
BOOL gISearchPartMatch = FALSE;         // ݃CN^T[`p[g}b`ǂ
BOOL gISearchExplore = FALSE;           // GLXv[[CN^T[`
BOOL gNoPartMatchClear = FALSE;         // ISearchClargISearchPartMatchNA邩ǂ
BOOL gISearchOption1 = TRUE;            // 擪CN^T[`s畔vCN^T[`IvV

// ̕GNXv[[CN^T[`Ŏĝǂ
BOOL IsISearchExploreChar(int meta, int key)
{
    return meta == 0 && (
                    
                 (key >= 'A' && key <= 'Z') 
                || (key >= '0' && key <= '9')
                || (key >= 'a' && key <='z')
                || key == '_'
                || key == '-'
                || key == '.'
                );
}

BOOL IsISearchNULL()
{
    return string_length(gInputFileName) == 0;
}

void ISearchClear()
{
    string_put(gInputFileName, "");
    if(!gNoPartMatchClear) {
        gISearchPartMatch = FALSE;
    }
    else {
        gNoPartMatchClear = FALSE;
    }
}

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////

/// ͂ꂽ񂪃CN^T[`ǂ ///
static inline BOOL is_isearch_char(int key)
{
    return key == 9 || (key >= ' ' && key <= '~')
                && key != '\\';
//                && key != '/'
//                && key != '~'
//                && key != ' '
//                && key != '?';
}

/// Ƀ}b`t@CɃJ[\ړ ///
static BOOL match_back(int start)
{
#if !defined(HAVE_MIGEMO_H)
    int i;
    for(i=start; i>=0; i--) {
        sFile* file = (sFile*)vector_item(filer_dir(adir())->mFiles, i);

        char* result = mystrcasestr(file->mNameView, string_c_str(gInputFileName));
        if(!gISearchPartMatch &&  result == file->mNameView
            || gISearchPartMatch && result != NULL)
        {
            filer_cursor_move(adir(), i);
            return TRUE;
        }
    }

    return FALSE;

#else

    /// get reg ///
    if(gReg == NULL) {
        const OnigUChar* p = migemo_query(gMigemo, (unsigned char*)string_c_str(gInputFileName));
        if(p == NULL) {
            return FALSE;
        }

        int r;
        OnigErrorInfo err_info;

        if(gKanjiCode == kUtf8) {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);
        }
        else if(gKanjiCode == kEucjp) {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_EUC_JP, ONIG_SYNTAX_DEFAULT, &err_info);
        }
        else if(gKanjiCode == kSjis) {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_SJIS, ONIG_SYNTAX_DEFAULT, &err_info);
        }

        migemo_release(gMigemo, (unsigned char*) p);

        if(r != ONIG_NORMAL) {
            return FALSE;
        }
    }

    /// start ///
    int i;
    for(i=start; i>=0; i--) {
        sFile* file = (sFile*)vector_item(filer_dir(adir())->mFiles, i);

        BOOL all_english = TRUE;
        const int len = strlen(file->mNameView);
        char* str = file->mNameView;
        int j;
        for(j=0; j<len; j++) {
            if(!(str[j]>=' ' && str[j]<='~')) {
                all_english = FALSE;
            }
        }

        if(all_english) {
            char* result = mystrcasestr(file->mNameView, string_c_str(gInputFileName));
            if(!gISearchPartMatch && result == file->mNameView
                || gISearchPartMatch && result != NULL)
            {
                filer_cursor_move(adir(), i);
                //if(gReg) onig_free(gReg);
                //gReg = NULL;
                
                return TRUE;
            }
            
        }
        else {
            OnigRegion* region = onig_region_new();
            
            OnigUChar* str2 = (OnigUChar*)file->mNameView;

            int r2 = onig_search(gReg, str2, str2 + strlen((char*)str2), str2, str2 + strlen((char*)str2), region, ONIG_OPTION_NONE);

            onig_region_free(region, 1);

            if(!gISearchPartMatch && r2 == 0
                || gISearchPartMatch && r2 >= 0)
            {
                filer_cursor_move(adir(), i);
                //if(gReg) onig_free(gReg);
                //gReg = NULL;
                return TRUE;
            }
        }
    }

    //if(gReg) onig_free(gReg);
    //gReg = NULL;

    return FALSE;
#endif
}

/// OɃ}b`t@CɃJ[\ړ ///
static BOOL match_next(int start)
{
#if !defined(HAVE_MIGEMO_H)
    int i;
    for(i=start; i<vector_size(filer_dir(adir())->mFiles); i++) {
        sFile* file = (sFile*)vector_item(filer_dir(adir())->mFiles, i);

        char* result = mystrcasestr(file->mNameView, string_c_str(gInputFileName));
        if(!gISearchPartMatch &&  result == file->mNameView
            || gISearchPartMatch && result != NULL)
        {
            filer_cursor_move(adir(), i);
            return TRUE;
        }
    }

    return FALSE;

#else

    /// get reg ///
    if(gReg == NULL) {
        const OnigUChar* p = migemo_query(gMigemo, (unsigned char*)string_c_str(gInputFileName));
        if(p == NULL) {
            return FALSE;
        }

        int r;
        OnigErrorInfo err_info;

        if(gKanjiCode == kUtf8) {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);
        }
        else if(gKanjiCode == kEucjp) {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_EUC_JP, ONIG_SYNTAX_DEFAULT, &err_info);
        }
        else {
            r = onig_new(&gReg, p, p + strlen((char*)p), ONIG_OPTION_DEFAULT, ONIG_ENCODING_SJIS, ONIG_SYNTAX_DEFAULT, &err_info);
        }
        migemo_release(gMigemo, (unsigned char*) p);

        if(r != ONIG_NORMAL) {
            return FALSE;
        }
    }

    /// start ///
    int i;
    vector_obj* v = filer_dir(adir())->mFiles;
    for(i=start; i<vector_size(v); i++) {
        sFile* file = (sFile*)vector_item(filer_dir(adir())->mFiles, i);

        BOOL all_english = TRUE;
        char* p = file->mNameView;
        while(*p) {
            if(!(*p>=' ' && *p<='~')) {
                all_english = FALSE;
                break;
            }
            p++;
        }

        if(all_english) {
            char* result = mystrcasestr(file->mNameView, string_c_str(gInputFileName));
            if(!gISearchPartMatch && result == file->mNameView
                || gISearchPartMatch && result != NULL)
            {
                filer_cursor_move(adir(), i);
                //if(gReg) onig_free(gReg);
                //gReg = NULL;
                
                return TRUE;
            }
            
        }
        else {
            OnigRegion* region = onig_region_new();
            
            OnigUChar* str2 = (OnigUChar*)file->mNameView;

            int r2 = onig_search(gReg, str2, str2 + strlen((char*)str2), str2, str2 + strlen((char*)str2), region, ONIG_OPTION_NONE);

            onig_region_free(region, 1);

            if(!gISearchPartMatch && r2 == 0
                || gISearchPartMatch && r2 >= 0)
            {
                filer_cursor_move(adir(), i);
                //if(gReg) onig_free(gReg);
                //gReg = NULL;
                return TRUE;
            }
        }
    }

    //if(gReg) onig_free(gReg);
    //gReg = NULL;

    return FALSE;
#endif
}

///////////////////////////////////////////////////////////////////////////////
// CN^T[`
///////////////////////////////////////////////////////////////////////////////
void migemo_init()
{
#if defined(HAVE_MIGEMO_H)
    char buf[PATH_MAX];
    char migemodir[PATH_MAX];
    gMigemo = migemo_open(NULL);

    char* datadir = getenv("MFILER3_DATADIR");

#ifdef SYSTEM_MIGEMODIR
    sprintf(migemodir,"%s", SYSTEM_MIGEMODIR);
#else
    sprintf(migemodir, "%s/%s", datadir, "mfiler");
#endif

    if(gKanjiCode == kUtf8) {
        sprintf(buf, "%s/utf-8/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/utf-8/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/utf-8/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/utf-8/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else if(gKanjiCode == kEucjp) {
        sprintf(buf, "%s/euc-jp/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/euc-jp/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/euc-jp/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/euc-jp/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else {
        sprintf(buf, "%s/cp932/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/cp932/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/cp932/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        sprintf(buf, "%s/cp932/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    
#endif
}

void isearch_init()
{
    gInputFileName = string_new("");
#if defined(HAVE_MIGEMO_H)
    gReg = NULL;
#endif

    migemo_init();
}

void isearch_reload_migemo_dict()
{
#if defined(HAVE_MIGEMO_H)
    onig_end();
    migemo_close(gMigemo);
#endif
    
#if defined(HAVE_MIGEMO_H)
    if(gReg) onig_free(gReg);
    gReg = NULL;
#endif

    migemo_init();
}

///////////////////////////////////////////////////////////////////////////////
// CN^T[`
///////////////////////////////////////////////////////////////////////////////
void isearch_final()
{
#if defined(HAVE_MIGEMO_H)
    onig_end();
    migemo_close(gMigemo);
#endif
    
#if defined(HAVE_MIGEMO_H)
    if(gReg) onig_free(gReg);
    gReg = NULL;
#endif
}

///////////////////////////////////////////////////////////////////////////////
// CN^T[`L[
///////////////////////////////////////////////////////////////////////////////
void isearch_input(int meta, int key)
{
    if(key == 8 || key == KEY_BACKSPACE || key == KEY_DC) {
        string_erase(gInputFileName, string_length(gInputFileName)-1, 1);

#if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
#endif
    }
    else if(key == 14 || key == KEY_DOWN) {
        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_next(filer_dir(adir())->mCursor+1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_next(filer_dir(adir())->mCursor+1);
        }
    }
    else if(key == 16 || key == KEY_UP) {
        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_back(filer_dir(adir())->mCursor-1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_back(filer_dir(adir())->mCursor-1);
        }
    }
    else if(key == ' ') {
        filer_toggle_mark(adir(), filer_dir(adir())->mCursor);

        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_next(filer_dir(adir())->mCursor+1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_next(filer_dir(adir())->mCursor+1);
        }
    }
    else if(!is_isearch_char(key)) {
        gISearch = FALSE;
        gISearchPartMatch = FALSE;
        string_put(gInputFileName, "");

#if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
#endif
    }
    else {
        if(key == 9)
            string_push_back2(gInputFileName, ' ');
        else
            string_push_back2(gInputFileName, (char)key);

#if defined(HAVE_MIGEMO_H)
                if(gReg) onig_free(gReg);
                gReg = NULL;
#endif

        if(gISearchOption1 && !gISearchPartMatch) {
            if(!match_next(0)) {
                gISearchPartMatch = TRUE;

                if(!match_next(0)) {
                    string_erase(gInputFileName, string_length(gInputFileName)-1, 1);

#if defined(HAVE_MIGEMO_H)
                    if(gReg) onig_free(gReg);
                    gReg = NULL;
#endif
                }

                gISearchPartMatch = FALSE;
            }
        }
        else {
            if(!match_next(0)) {
                string_erase(gInputFileName, string_length(gInputFileName)-1, 1);

    #if defined(HAVE_MIGEMO_H)
                    if(gReg) onig_free(gReg);
                    gReg = NULL;
    #endif
            }
        }
    }
}

void isearch_explore_input(int meta, int key)
{
    if(meta == 1 && key == KEY_UP || key == KEY_F(15) || meta == 1 && key == 16) {
        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_back(filer_dir(adir())->mCursor-1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_back(filer_dir(adir())->mCursor-1);
        }
    }
    else if(meta == 1 && key == KEY_DOWN || key == KEY_F(16) || meta == 1 && key == 14) {
        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_next(filer_dir(adir())->mCursor+1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_next(filer_dir(adir())->mCursor+1);
        }
    }
    else if(key == ' ') {
        filer_toggle_mark(adir(), filer_dir(adir())->mCursor);
        if(gISearchOption1 && !gISearchPartMatch) {
            gISearchPartMatch = TRUE;
            match_next(filer_dir(adir())->mCursor+1);
            gISearchPartMatch = FALSE;
        }
        else {
            match_next(filer_dir(adir())->mCursor+1);
        }
    }
    else {
        string_push_back2(gInputFileName, (char)key);

    #if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
    #endif

        if(gISearchOption1 && !gISearchPartMatch) {
            if(!match_next(0)) {
                gISearchPartMatch = TRUE;

                if(!match_next(0)) {
                    string_put(gInputFileName, "");
                    string_push_back2(gInputFileName, (char)key);

#if defined(HAVE_MIGEMO_H)
                    if(gReg) onig_free(gReg);
                    gReg = NULL;
#endif
                    if(!match_next(0)) {
                        string_put(gInputFileName, "");
                    }
                }

                gISearchPartMatch = FALSE;
            }
        }
        else {
            if(!match_next(0)) {
                string_put(gInputFileName, "");
                string_push_back2(gInputFileName, (char)key);

#if defined(HAVE_MIGEMO_H)
                if(gReg) onig_free(gReg);
                gReg = NULL;
#endif
                if(!match_next(0)) {
                    string_put(gInputFileName, "");
                }
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// CN^T[``
///////////////////////////////////////////////////////////////////////////////
void isearch_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    if(gISearchPartMatch) 
        mmvprintw(maxy -2, 0, "//");
    else
        mmvprintw(maxy -2, 0, "/");

    char buf[1024];
    char* str = string_c_str(gInputFileName);
    const int len = strlen(str);
    int i;
    for(i=0; i<maxx-35; i++) {
        if(i<len) {
            buf[i] = str[i];
        }
        else {
            buf[i] = ' ';
        }
    }
    buf[i] = 0;
    mprintw(buf);
}

void isearch_explore_view()
{
    const int maxx = mgetmaxx();

    if(gISearchPartMatch) 
        mprintw(" //");
    else
        mprintw(" /");

    char buf[1024];
    char* str = string_c_str(gInputFileName);
    const int len = strlen(str);
    int i;
    for(i=0; i<maxx-35; i++) {
        if(i<len) {
            buf[i] = str[i];
        }
        else {
            buf[i] = ' ';
        }
    }
    buf[i] = 0;
    mprintw(buf);
}

