#include "common.h"
#include <dirent.h>
#include <libgen.h>

BOOL gSISearch = false;

const int kCacheMax = 200;
const int kCacheNumberMax = 256;

static string_obj* gInputFileName;
static int gSIScrollTop = 0;
static int gSICursor = 0;

int gCandiateMaxAscii=17;
int gCandidateMaxMigemo=1;

BOOL gSISearchMigemo = false;
static vector_obj* gCandidate;

char gCacheDir[PATH_MAX];

#if defined(HAVE_MIGEMO_H)
hash_obj* gRegs;
vector_obj* gRegs2;

void regs_new()
{
    gRegs = hash_new(4096);
    gRegs2 = vector_new(4096);

    char tmp[256];
    char c;
    for(c='a'; c<='z'; c++) {
        tmp[0] = c;
        tmp[1] = 0;

        const OnigUChar* p
            = migemo_query(gMigemo, (unsigned char*)tmp);
        if(p == NULL) {
            continue;
        }

        regex_t* reg;
        int r;
        OnigErrorInfo err_info;

        if(gKanjiCode == kUtf8) {
            r = onig_new(&reg, p, p + strlen((char*)p)
                , ONIG_OPTION_DEFAULT
                , ONIG_ENCODING_UTF8
                , ONIG_SYNTAX_DEFAULT, &err_info);
        }
        else if(gKanjiCode == kEucjp) {
            r = onig_new(&reg, p, p + strlen((char*)p)
                , ONIG_OPTION_DEFAULT
                , ONIG_ENCODING_EUC_JP
                , ONIG_SYNTAX_DEFAULT
                , &err_info);
        }
        else if(gKanjiCode == kSjis) {
            r = onig_new(&reg, p, p + strlen((char*)p)
                , ONIG_OPTION_DEFAULT
                , ONIG_ENCODING_SJIS
                , ONIG_SYNTAX_DEFAULT
                , &err_info);
        }

        if(r == ONIG_NORMAL) {
            hash_put(gRegs, tmp, reg);
            vector_add(gRegs2, reg);
        }

        migemo_release(gMigemo, (unsigned char*) p);
    }
}

void regs_release()
{
    int i;
    for(i=0; i<vector_size(gRegs2); i++) {
        onig_free((regex_t*)vector_item(gRegs2, i));
    }
}

#endif

BOOL sisearch_cache_exist()
{
    return access(gCacheDir, X_OK) == 0;
}

static inline BOOL is_isearch_char(int key)
{
    return key == 9 || (key >= ' ' && key <= '~')
                && key != '\\';
//                && key != '/'
//                && key != '~'
//                && key != ' '
//                && key != '?';
}

void sisearch_init()
{
    gInputFileName = string_new("");
    char* p = getenv("HOME");
    if(p == NULL) {
        fprintf(stderr, "Your system is crazy. set $HOME\n");
        exit(1);
    }
    sprintf(gCacheDir, "%s/.mfiler3_tmp/sisearch_cache", p);
    gCandidate = vector_new(10);
}

void sisearch_final()
{
}

void sisearch_start()
{
    gSIScrollTop = 0;
    gSICursor = 0;
}

static BOOL get_cache(char* root)
{
    VALUE array = rb_eval_string("$sisearch_except_dir");

    Check_Type(array, T_ARRAY);

    int i;
    for(i=0; i<RARRAY(array)->len; i++) {
        if(strcmp(root, RSTRING(rb_ary_entry(array, i))->ptr) == 0) {
            return true;
        }
    }

    DIR* dir = opendir(root);

    if(dir) {
        struct dirent* dirent_;
        
        while(dirent_ = readdir(dir)) {
            if(strcmp(dirent_->d_name, ".") != 0 
                && strcmp(dirent_->d_name, "..") != 0)
            {
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    int meta;
                    int key = mgetch(&meta);

                    if(key == 3 || key == 7 || key == 27) {
                                        // CTRL-G and CTRL-C
                        err_msg("sisearch_get_cache: canceled");
                        return false;
                    }
                }
                struct stat stat_;

                char path[PATH_MAX];
                sprintf(path, "%s%s", root, dirent_->d_name);
                lstat(path, &stat_);

                if(S_ISDIR(stat_.st_mode)) {
                    if(is_all_ascii(dirent_->d_name)) {
                        int l = strlen(dirent_->d_name);
                        
                        if(l < 4) {
                            int i;
                            for(i= 1; i<l+1; i++) {
                                char tmp[PATH_MAX];
                                memcpy(tmp, dirent_->d_name, i);
                                tmp[i] = 0;

                                char fpath[PATH_MAX];
                                sprintf(fpath
                                     , "%s/mfiler3_sisearch_cache_%s"
                                                , gCacheDir, tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                        else {
                            int i;
                            for(i= 1; i<4; i++) {
                                char tmp[PATH_MAX];
                                memcpy(tmp, dirent_->d_name, i);
                                tmp[i] = 0;

                                char fpath[PATH_MAX];
                                sprintf(fpath, "%s/mfiler3_sisearch_cache_%s"
                                              , gCacheDir
                                              , tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                    }
#if defined(HAVE_MIGEMO_H)
                    else {
                        char fname[PATH_MAX];
                        convert_fname(dirent_->d_name, fname, PATH_MAX);

                        OnigUChar* str = (OnigUChar*)fname;

                        char tmp[256];
                        char c;
                        for(c='a'; c<='z'; c++) {
                            tmp[0] = c;
                            tmp[1] = 0;

                            OnigRegion* region = onig_region_new();
                            regex_t* reg = (regex_t*)hash_item(gRegs, tmp);

                            int r = onig_search(reg
                                        , str, str + strlen((char*)str)
                                        , str, str + strlen((char*)str)
                                        , region, ONIG_OPTION_NONE);
                            
                            onig_region_free(region, 1);

                            if(r == 0) {
                                char fpath[PATH_MAX];
                        sprintf(fpath, "%s/mfiler3_sisearch_cache_migemo_%s"
                                             , gCacheDir
                                             , tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                    }
#endif

                    char path2[PATH_MAX];
                    sprintf(path2, "%s/", path);
                    msg_nonstop("entering %s", path2);

                    if(!get_cache(path2)) {
                        return false;
                    }
                }
                else {
                    if(is_all_ascii(dirent_->d_name)) {
                        int l = strlen(dirent_->d_name);
                        
                        if(l < 4) {
                            int i;
                            for(i= 1; i<l+1; i++) {
                                char tmp[PATH_MAX];
                                memcpy(tmp, dirent_->d_name, i);
                                tmp[i] = 0;

                                char fpath[PATH_MAX];
                                sprintf(fpath, "%s/mfiler3_sisearch_cache_%s"
                                             , gCacheDir
                                             , tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                        else {
                            int i;
                            for(i= 1; i<4; i++) {
                                char tmp[PATH_MAX];
                                memcpy(tmp, dirent_->d_name, i);
                                tmp[i] = 0;

                                char fpath[PATH_MAX];
                                sprintf(fpath, "%s/mfiler3_sisearch_cache_%s"
                                             , gCacheDir
                                             , tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                    }
#if defined(HAVE_MIGEMO_H)
                    else {
                        char fname[PATH_MAX];
                        convert_fname(dirent_->d_name, fname, PATH_MAX);

                        OnigUChar* str = (OnigUChar*)fname;

                        char tmp[256];
                        char c;
                        for(c='a'; c<='z'; c++) {
                            tmp[0] = c;
                            tmp[1] = 0;

                            OnigRegion* region = onig_region_new();
                            regex_t* reg = (regex_t*)hash_item(gRegs, tmp);

                            int r = onig_search(reg
                                        , str, str + strlen((char*)str)
                                        , str, str + strlen((char*)str)
                                        , region, ONIG_OPTION_NONE);
                            
                            onig_region_free(region, 1);

                            if(r == 0) {
                                char fpath[PATH_MAX];
                        sprintf(fpath, "%s/mfiler3_sisearch_cache_migemo_%s"
                                             , gCacheDir
                                             , tmp);

                                FILE* f = fopen(fpath, "a");
                                char tmp2[PATH_MAX];
                                sprintf(tmp2, "%s\n", path);
                                fprintf(f, tmp2);
                                fclose(f);
                            }
                        }
                    }
#endif
                }
            }
        }

        closedir(dir);
    }
    return true;

//cache_check();

}

BOOL sort_path(void* left, void* right)
{ 
    char* l = (char*) left;
    char* r = (char*) right;

    char* tmp = strdup(l);
    char* l2 = basename(tmp);

    char* tmp2 = strdup(r);
    char* r2 = basename(tmp2);

    if(strcmp(l2, r2) == 0) {
        if(strlen(l) < strlen(r)) {
            free(tmp);
            free(tmp2);
            return TRUE;
        }
        else {
            free(tmp);
            free(tmp2);
            return FALSE;
        }
    }
    else if(strcmp(l2, r2) < 0) {
        free(tmp);
        free(tmp2);
        return TRUE;
    }
    else {
        free(tmp);
        free(tmp2);
        return FALSE;
    }
}

BOOL sort_cache()
{
    msg_nonstop("sorting cache...");
    DIR* dir = opendir(gCacheDir);

    if(dir) {
        struct dirent* dirent_;

        while(dirent_ = readdir(dir)) {
            if(strcmp(dirent_->d_name, ".") != 0 
                && strcmp(dirent_->d_name, "..") != 0)
            {
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    int meta;
                    int key = mgetch(&meta);

                    if(key == 3 || key == 7 || key == 27) {
                                        // CTRL-G and CTRL-C
                        err_msg("sisearch: canceled");
                        return false;
                    }
                }

                char tmp[PATH_MAX];
                sprintf(tmp, "%s/%s" , gCacheDir , dirent_->d_name);

                vector_obj* v = vector_new(10);

                FILE* f = fopen(tmp, "r");
                if(f == NULL) {
                    fprintf(stderr, "\nfopen\n");
                    exit(1);
                }

                char path[PATH_MAX];
                while(fgets(path, PATH_MAX, f)) {
                    path[strlen(path)-1] = 0;
                    vector_add(v, GC_strdup(path));
                }

                fclose(f);

                vector_sort(v, sort_path);
                FILE* f2 = fopen(tmp, "w");
                if(f2 == NULL) {
                    fprintf(stderr, "\nfopen\n");
                    exit(1);
                }

                int i;
                for(i=0; i<vector_size(v); i++) {
                    char* path = (char*)vector_item(v, i);
                    fprintf(f2, "%s\n", path);
                }

                fclose(f2);
            }
        }

        closedir(dir);
    }

    return true;
}

void sisearch_get_cache()
{
#if defined(HAVE_MIGEMO_H)
    msg_nonstop("preparing for migemo dictionary...");
    regs_new();
#endif

    char tmp[PATH_MAX];
    sprintf(tmp, "rm -Rf %s", gCacheDir);
    system(tmp);
    sprintf(tmp, "mkdir -p %s", gCacheDir);
    system(tmp);
    system("chmod 700 ~/.mfiler3_tmp");

    if(get_cache("/")) {
        if(!sort_cache()) {
            sprintf(tmp, "rm -Rf %s", gCacheDir);
            system(tmp);
        }
    }
    else {
        sprintf(tmp, "rm -Rf %s", gCacheDir);
        system(tmp);
    }

#if defined(HAVE_MIGEMO_H)
    regs_release();
#endif
}

void cache_append_head(char* fpath, char* path)
{
    vector_obj* v = vector_new(10);
    vector_add(v, strdup(path));

    FILE* f = fopen(fpath, "r");
    if(f == NULL) {
        perror("fopen");
    }
    char path2[PATH_MAX];
    while(fgets(path2, PATH_MAX, f)) {
        path2[strlen(path2)-1] = 0;
        if(strcmp(path, path2) != 0) {
            vector_add(v, GC_strdup(path2));
        }
    }
    fclose(f);

    FILE* f2 = fopen(fpath, "w");
    if(f2 == NULL) {
        perror("fopen2");
    }
    int i;
    for(i=0; i<vector_size(v); i++) {
        fprintf(f2, "%s\n", vector_item(v, i));
    }
    fclose(f2);
}

void candidate_refresh()
{
    char* p = string_c_str(gInputFileName);
    char tmp[256];

    gCandidate = vector_new(10);

    if(strlen(p) < 4) {
        strcpy(tmp, p);

        char path[PATH_MAX];
        sprintf(path, "%s/mfiler3_sisearch_cache_%s", gCacheDir, tmp);
        FILE* f = fopen(path, "r");
        if(f) {
            while(fgets(path, PATH_MAX, f)) {
/*
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    int meta;
                    int key = mgetch(&meta);

                    if(key == 3 || key == 7 || key == 27) {
                                        // CTRL-G and CTRL-C
                        break;
                    }
                }
*/
                path[strlen(path)-1] = 0;

                char* fname = GC_strdup(basename(path));
                if(vector_size(gCandidate) <= gCandiateMaxAscii
                    || strlen(fname) == strlen(p)) 
                {
                    vector_add(gCandidate, GC_strdup(path));
                }
            }
            fclose(f);
        }
    }
    else {
        memcpy(tmp, p, 3);
        tmp[3] = 0;

        char path[PATH_MAX];
        sprintf(path, "%s/mfiler3_sisearch_cache_%s", gCacheDir, tmp);
        FILE* f = fopen(path, "r");
        if(f) {
            while(fgets(path, PATH_MAX, f)) {
/*
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    int meta;
                    int key = mgetch(&meta);

                    if(key == 3 || key == 7 || key == 27) {
                                        // CTRL-G and CTRL-C
                        break;
                    }
                }
*/
                path[strlen(path)-1] = 0;
                char* fname = GC_strdup(basename(path));

                if(mystrcasestr(fname, p) == fname) {
                    if(vector_size(gCandidate) < gCandiateMaxAscii
                        || strlen(fname) == strlen(p)) 
                    {
                        vector_add(gCandidate, GC_strdup(path));
                    }
                }
            }
            fclose(f);
        }
    }

#if defined(HAVE_MIGEMO_H)
    if(gSISearchMigemo) {
        // {t@C
        tmp[0] = p[0];
        tmp[1] = 0;

        const int v_size = vector_size(gCandidate);

        char path[PATH_MAX];
        sprintf(path, "%s/mfiler3_sisearch_cache_migemo_%s", gCacheDir, tmp);
        FILE* f = fopen(path, "r");
        if(f) {
            while(fgets(path, PATH_MAX, f)) {
/*
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                if(FD_ISSET(0, &mask)) {
                    int meta;
                    int key = mgetch(&meta);

                    if(key == 3 || key == 7 || key == 27) {
                                        // CTRL-G and CTRL-C
                        break;
                    }
                }
*/                

                path[strlen(path)-1] = 0;

                char* fname = GC_strdup(basename(path));
                const OnigUChar* p2
                    = migemo_query(gMigemo, (unsigned char*)p);
                if(p2) {
                    regex_t* reg;
                    int r;
                    OnigErrorInfo err_info;

                    if(gKanjiCode == kUtf8) {
                        r = onig_new(&reg, p2, p2 + strlen((char*)p2)
                            , ONIG_OPTION_DEFAULT
                            , ONIG_ENCODING_UTF8
                            , ONIG_SYNTAX_DEFAULT, &err_info);
                    }
                    else if(gKanjiCode == kEucjp) {
                        r = onig_new(&reg, p2, p2 + strlen((char*)p2)
                            , ONIG_OPTION_DEFAULT
                            , ONIG_ENCODING_EUC_JP
                            , ONIG_SYNTAX_DEFAULT
                            , &err_info);
                    }
                    else if(gKanjiCode == kSjis) {
                        r = onig_new(&reg, p2, p2 + strlen((char*)p2)
                            , ONIG_OPTION_DEFAULT
                            , ONIG_ENCODING_SJIS
                            , ONIG_SYNTAX_DEFAULT
                            , &err_info);
                    }

                    migemo_release(gMigemo, (unsigned char*) p2);

                    if(r == ONIG_NORMAL) {
                        OnigRegion* region = onig_region_new();
                        char fname2[PATH_MAX];
                        convert_fname(fname, fname2, PATH_MAX);
                        OnigUChar* str = (OnigUChar*)fname2;

                        int r = onig_search(reg
                                            , str, str + strlen((char*)str)
                                            , str, str + strlen((char*)str)
                                            , region
                                            , ONIG_OPTION_NONE);

                        if(r == 0) {
                            vector_add(gCandidate, GC_strdup(path));
                            if(vector_size(gCandidate) 
                                >= v_size+gCandidateMaxMigemo) 
                            {
                                onig_region_free(region, 1);
                                onig_free(reg);
                                break;
                            }
                        }

                        onig_region_free(region, 1);

                        onig_free(reg);
                    }
                }
            }
            fclose(f);
        }
    }
#endif

}

void sisearch_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    int i;
    for(i=gSIScrollTop;
        i<vector_size(gCandidate) && i-gSIScrollTop < maxy-3;
        i++) 
    {
        char* item = (char*)vector_item(gCandidate, i);
        char item2[PATH_MAX];
        convert_fname(item, item2, PATH_MAX);

        char item3[PATH_MAX];
        str_cut3(item2, maxx, item3, PATH_MAX);

        if(gSICursor == i) {
            mattron(kCAReverse);
            mmvprintw(i-gSIScrollTop, 0, item3);
            mattroff();
        }
        else {
            mmvprintw(i-gSIScrollTop, 0, item3);
        }
    }

    mmvprintw(maxy -2, 0, "//");

    char buf[1024];
    char* str = string_c_str(gInputFileName);
    const int len = strlen(str);
    int i;
    for(i=0; i<maxx-35; i++) {
        if(i<len) {
            buf[i] = str[i];
        }
        else {
            buf[i] = ' ';
        }
    }
    buf[i] = 0;
    mprintw(buf);
}

void sisearch_input(int meta, int key)
{
    if(key == 8 || key == KEY_BACKSPACE || key == KEY_DC) {
        string_erase(gInputFileName, string_length(gInputFileName)-1, 1);
        candidate_refresh();
/*
#if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
#endif
*/
    }
    else if(key == 14 || key == KEY_DOWN) {
        gSICursor++;
    }
    else if(key == 16 || key == KEY_UP) {
        gSICursor--;
    }
    else if(key == 4 || key == KEY_NPAGE) {    // CTRL-D
        gSICursor+=10;
    }
    else if(key == 21 || key == KEY_PPAGE) {    // CTRL-U
        gSICursor-=10;
    }
    else if(key == 10 || key == 13) {   // CTRL-M, CTRL-J
        char* path = (char*)vector_item(gCandidate, gSICursor);
        if(path) {
            char* tmp = GC_strdup(path);
            char dir[PATH_MAX];
            sprintf(dir, "%s/", dirname(tmp));
            BOOL result = true;
            if(strcmp(ActiveDir()->Path(), dir) != 0) {
                result = ActiveDir()->Move(dir);
            }

            if(result) {
                char* str = string_c_str(gInputFileName);

                char* tmp3 = GC_strdup(path);
                char* fname = basename(tmp3);

#if !defined(HAVE_MIGEMO_H)
                const int max = strlen(str) < 3 ? strlen(str) : 3;
                int i;
                for(i=0; i < max; i++) {
                    char tmp[256];
                    memcpy(tmp, str, i+1);
                    tmp[i+1] = 0;
                    char fpath[PATH_MAX];
                    sprintf(fpath, "%s/mfiler3_sisearch_cache_%s"
                       , gCacheDir
                       , tmp);
                    cache_append_head(fpath, path);
                }
#else
                if(is_all_ascii(fname)) {
                    const int max = strlen(str) < 3 ? strlen(str) : 3;
                    int i;
                    for(i=0; i < max; i++) {
                        char tmp[256];
                        memcpy(tmp, str, i+1);
                        tmp[i+1] = 0;
                        char fpath[PATH_MAX];
                        sprintf(fpath, "%s/mfiler3_sisearch_cache_%s"
                                   , gCacheDir
                                   , tmp);
                        cache_append_head(fpath, path);
                    }
                }
                else {
                    char tmp[256];
                    tmp[0] = str[0];
                    tmp[1] = 0;

                    char fpath[PATH_MAX];
                    sprintf(fpath, "%s/mfiler3_sisearch_cache_migemo_%s"
                                    , gCacheDir
                                    , tmp);
                    cache_append_head(fpath, path);
                }
#endif

                int n = ActiveDir()->FileNum(fname);
                if(n >= 0) {
                    ActiveDir()->MoveCursor(n);
                }
            }
        }

        gSISearch = false;
        string_put(gInputFileName, "");
        vector_clear(gCandidate);
    }
    else if(!is_isearch_char(key)) {
        gSISearch = false;
        string_put(gInputFileName, "");
        vector_clear(gCandidate);

/*
#if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
#endif
*/
    }
    else {
        if(key == 9)
            string_push_back2(gInputFileName, ' ');
        else
            string_push_back2(gInputFileName, (char)key);

        candidate_refresh();
/*
#if defined(HAVE_MIGEMO_H)
        if(gReg) onig_free(gReg);
        gReg = NULL;
#endif
*/
    }

    while(gSICursor < 0) {
        gSICursor += vector_size(gCandidate);
    }
    while(vector_size(gCandidate) != 0 && gSICursor >= vector_size(gCandidate)) {
        gSICursor -= vector_size(gCandidate);
    }

    const int maxy = mgetmaxy();

    if(gSICursor >= (gSIScrollTop+maxy-3)) {
        gSIScrollTop += gSICursor - (gSIScrollTop+maxy-3) + 1;
    }
    if(gSICursor < gSIScrollTop) {
        gSIScrollTop = gSICursor;
    }

}

