#include "common.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <termios.h>
#include <stdarg.h>
#include <time.h>
#include <ctype.h>
#include <locale.h>
#include <sys/types.h>
#include <pwd.h>
#include <dirent.h>
#include <stdlib.h>
#include <fcntl.h>

void P(char* msg, ...);

BOOL gMainLoop = FALSE;
void (*gView)() = NULL;          // 登録描写関数
void (*gView2)() = NULL;          // 登録描写関数

BOOL gFocus = FALSE;
char gTitleBar[BUFSIZ];
BOOL gChangeTerminalTitle = TRUE;

///////////////////////////////////////////////////////////////////////////////
// キーボード入力処理
///////////////////////////////////////////////////////////////////////////////
static void input(int meta, int key)
{
    if(key == 26) {
        mendwin();
        kill(getpid(), SIGSTOP);
        minitscr();
    }
    else if(gCmdLineActive) {
        /// 補完候補選択 ///
        if(vector_size(gCCandidate) > 0)
            cmdline_completion_input(meta, key);

        /// 普通のコマンドライン ///
        else
            cmdline_input(meta, key);
    }
    else if(gActiveMenu) {
        /// メニュー ///
        menu_input(gActiveMenu, meta, key);
    }
    /// インクリメンタルサーチ ///
    else if(gISearch) {
        isearch_input(meta, key);
    }
    /// エキスプローラー風インクリメンタルサーチ ///
    else if(gISearchExplore && IsISearchExploreChar(meta, key)) {
        isearch_explore_input(meta, key);
    }
    /// エキスプローラー風インクリメンタルサーチ 上下キーとスペースキー ///
    else if(gISearchExplore && !IsISearchNULL() 
        && (meta == 0 && key == ' '
            || meta == 1 && (key == 14 || key == 16)
            || meta == 1 && (key == KEY_UP || key == KEY_DOWN)
            || meta == 0 && (key == KEY_F(15) || key == KEY_F(16))
            ))
    {
        isearch_explore_input(meta, key);
    }
    /*
    /// スーパーインクリメンタルサーチ ///
    else if(gSISearch) {
        sisearch_input(meta, key);
    }
    */
    else {
        /// ファイラー ///
        filer_input(meta, key);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 描写
///////////////////////////////////////////////////////////////////////////////
void view()
{
    if(gCmdLineActive) {
        /// 補完候補選択画面 ///
        if(vector_size(gCCandidate)) {
            cmdline_completion_view();
            cmdline_view();
        }
        /// ヒストリー選択画面 ///
        else if(vector_size(gHCandidate)) {
            cmdline_history_view();
            cmdline_view();
        }

        /// ファイラ画面 ///
        else {
            filer_view(0);
            filer_view(1);

            shell_view();

            cmdline_view();
        }
    }
    else if(gISearch) {
        filer_view(0);
        filer_view(1);

        shell_view();

        isearch_view();
    }
    /*
    /// スーパーインクリメンタルサーチ描写 ///
    else if(gSISearch) {
        sisearch_view();
    }
    */
    else if(gActiveMenu) {
        filer_view(0);
        filer_view(1);

        shell_view();

        cmdline_view();
        menu_view(gActiveMenu);

        rb_funcall(rb_cObject, rb_intern("view_fkey"), 0);
    }
    else {
        filer_view(0);
        filer_view(1);

        shell_view();
        cmdline_view();

        rb_funcall(rb_cObject, rb_intern("view_fkey"), 0);
    }

    if(gView) gView();
    if(gView2) gView2();
}

///////////////////////////////////////////////////////////////////////////////
// ランタイムスクリプト実行
///////////////////////////////////////////////////////////////////////////////
static void read_rc_file()
{
    setenv("DATADIR", DATADIR, 1);

    char rc_fname[256];
    sprintf(rc_fname,"%s/.mfiler3", SYSCONFDIR);

    if(access(rc_fname, R_OK) == 0) {
        shell_load(rc_fname, TRUE);
    }
    else {
        fprintf(stderr, "can't find $HOME/.mfiler3 or %s/.mfiler3 file\n", SYSCONFDIR);
        exit(1);
    }

    sprintf(rc_fname, "%s/.mfiler3", gHomeDir);
    
    if(access(rc_fname, R_OK) == 0) {
        shell_load(rc_fname, TRUE);
    }
}

///////////////////////////////////////////////////////////////////////////////
// ランタイムスクリプトファイル読み込み
///////////////////////////////////////////////////////////////////////////////
static void read_rc_file_ruby()
{
    char ms_fname[PATH_MAX];
    sprintf(ms_fname, "%s/.mfiler3.rb", SYSCONFDIR);

    if(access(ms_fname, R_OK) == 0) {
        rb_load(rb_str_new2(ms_fname), 0);
    }
    else {
        fprintf(stderr, "can't find %s/.mfiler3.rb", SYSCONFDIR);
        exit(1);
    }

    char completion_fname[PATH_MAX];
    sprintf(completion_fname, "%s/completion.rb", SYSCONFDIR);
    if(access(completion_fname, R_OK) == 0) {
        rb_load(rb_str_new2(completion_fname), 0);
    }
    else {
        fprintf(stderr, "can't find %s/completion.rb", SYSCONFDIR);
        exit(1);
    }

    char rc_fname[PATH_MAX];
    sprintf(rc_fname, "%s/.mfiler3.rb", gHomeDir);
    
    if(access(rc_fname, R_OK) == 0) {
        rb_load(rb_str_new2(rc_fname), 0);
    }
}

///////////////////////////////////////////////////////////////////////////////
// exit時に実行される関数
///////////////////////////////////////////////////////////////////////////////
static void atexit_fun()
{
    if(mis_curses()) {
        mendwin();
    }
}

///////////////////////////////////////////////////////////////////////////////
// シグナル処理
///////////////////////////////////////////////////////////////////////////////
static void sig_winch(int signal)
{
    if(gMainLoop) {
        mclear_immediately();       // 画面の再描写
        view();
        mrefresh();
    }
}


void sig_SIGQUIT() { P("SIGQUIT"); }
void sig_SIGCHLD() { P("SIGCHLD"); }
void sig_SIGABRT() { P("SIGABRT"); }
void sig_SIGALRM() { P("SIGALRM"); }
void sig_SIGBUS() { P("SIGBUS"); }
void sig_SIGCONT() { P("SIGCONT"); }
void sig_SIGHUP() { P("SIGHUP"); }
void sig_SIGFPE() { P("SIGFPE"); }
void sig_SIGILL() { P("SIGILL"); }
void sig_SIGIO() { P("SIGIO"); }
void sig_SIGKILL() { P("SIGKILL"); }
void sig_SIGPIPE() { P("SIGPIPE"); }
void sig_SIGPROF() { P("SIGPROF"); }
void sig_SIGSEGV() { P("SIGSEGV"); }
void sig_SIGTERM() { P("SIGTERM"); }
void sig_SIGTRAP() { P("SIGTRAP"); }
void sig_SIGURG() { P("SIGURG"); }
void sig_SIGUSR1() { P("SIGUSR1"); }
void sig_SIGUSR2() { P("SIGUSR2"); }
void sig_SIGXCPU() { P("SIGXCPU"); }
void sig_SIGXFSZ() { P("SIGXFSZ"); }
void sig_SIGVTALRM() { P("SIGVTALRM"); }
void sig_SIGPOLL() { P("SIGPOLL"); }
void sig_SIGSYS() { P("SIGSYS"); }
void sig_SIGUNUSED() { P("SIGUNUSED"); }

void sig_SIGTTIN() { P("SIGTTIN"); }
void sig_SIGTTOU() { P("SIGTTOU"); }
void sig_SIGWINCH() { P("SIGWINCH"); }
void sig_SIGSTOP() { P("SIGSTOP"); }
void sig_SIGTSTP() { P("SIGTSTP"); }

int gBreak = FALSE;
void sig_SIGINT() { gBreak = TRUE; }

void set_signal_sigint()
{
    signal(SIGINT, sig_SIGINT);
}

void set_signal_sigint_clear()
{
    signal(SIGINT, SIG_IGN);
}

void set_signal_clear_all()
{
    signal(SIGABRT, SIG_DFL);
    signal(SIGALRM, SIG_DFL);
    signal(SIGBUS, SIG_DFL);
    signal(SIGCHLD, SIG_DFL);
    signal(SIGCONT, SIG_DFL);
    signal(SIGHUP, SIG_DFL);
    signal(SIGFPE, SIG_DFL);
    signal(SIGILL, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGIO, SIG_DFL);
    signal(SIGKILL, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGPIPE, SIG_DFL);
    signal(SIGPROF, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    signal(SIGTERM, SIG_DFL);
    signal(SIGTRAP, SIG_DFL);
    signal(SIGTTIN, SIG_DFL);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGWINCH, SIG_DFL);
    signal(SIGURG, SIG_DFL);
    signal(SIGUSR1, SIG_DFL);
    signal(SIGUSR2, SIG_DFL);
    signal(SIGXCPU, SIG_DFL);
    signal(SIGXFSZ, SIG_DFL);
    signal(SIGVTALRM, SIG_DFL);
    signal(SIGSYS, SIG_DFL);
#ifdef SIGUNUSED
    signal(SIGUNUSED, SIG_DFL);
#endif
}


void set_signal_clear()
{
    signal(SIGWINCH, SIG_DFL);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGTTIN, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGSTOP, SIG_DFL);
    signal(SIGTSTP, SIG_DFL);
}

void set_signal_subshell()
{
    signal(SIGTTIN, SIG_IGN);
    signal(SIGTTOU, SIG_IGN);
    signal(SIGWINCH, SIG_IGN);
    signal(SIGSTOP, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGINT, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
}

void set_signal_mfiler3()
{
    signal(SIGWINCH, sig_winch);
    signal(SIGTTOU, SIG_IGN);
    signal(SIGTTIN, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    signal(SIGSTOP, SIG_DFL);
    signal(SIGTSTP, SIG_IGN);
}

///////////////////////////////////////////////////////////////////////////////
// Ruby 初期化
///////////////////////////////////////////////////////////////////////////////
static void myruby_init()
{
    ruby_init();
    ruby_script("embedded");
    ruby_init_loadpath();

    char tmp[256];
    sprintf(tmp, "$:.push(\"%s\")", SYSCONFDIR);
    rb_eval_string(tmp);
    
    rb_define_global_const("KEY_UP", INT2NUM(KEY_UP));
    rb_define_global_const("KEY_RIGHT", INT2NUM(KEY_RIGHT));
    rb_define_global_const("KEY_DOWN", INT2NUM(KEY_DOWN));
    rb_define_global_const("KEY_LEFT", INT2NUM(KEY_LEFT));
    rb_define_global_const("KEY_INSERT", INT2NUM(KEY_IC));
    rb_define_global_const("KEY_DELETE", INT2NUM(KEY_DC));
    rb_define_global_const("KEY_HOME", INT2NUM(KEY_HOME));
    rb_define_global_const("KEY_END", INT2NUM(KEY_END));
    rb_define_global_const("KEY_PAGEUP", INT2NUM(KEY_PPAGE));
    rb_define_global_const("KEY_PAGEDOWN", INT2NUM(KEY_NPAGE));
    rb_define_global_const("KEY_META_LEFT", INT2NUM(KEY_F(13)));
    rb_define_global_const("KEY_META_RIGHT", INT2NUM(KEY_F(14)));
    rb_define_global_const("KEY_META_UP", INT2NUM(KEY_F(15)));
    rb_define_global_const("KEY_META_DOWN", INT2NUM(KEY_F(16)));
    rb_define_global_const("KEY_CTRL_LEFT", INT2NUM(KEY_F(17)));
    rb_define_global_const("KEY_CTRL_RIGHT", INT2NUM(KEY_F(18)));
    rb_define_global_const("KEY_CTRL_UP", INT2NUM(KEY_F(19)));
    rb_define_global_const("KEY_CTRL_DOWN", INT2NUM(KEY_F(20)));

    rb_define_global_const("KEY_CTRL_DELETE", INT2NUM(KEY_F(21)));
    
    rb_define_global_const("KEY_ENTER", INT2NUM(10));
    rb_define_global_const("KEY_BACKSPACE", INT2NUM(KEY_BACKSPACE));
    rb_define_global_const("KEY_SPACE", INT2NUM(32));
    
    rb_define_global_const("KEY_F1", INT2NUM(KEY_F(1)));
    rb_define_global_const("KEY_F2", INT2NUM(KEY_F(2)));
    rb_define_global_const("KEY_F3", INT2NUM(KEY_F(3)));
    rb_define_global_const("KEY_F4", INT2NUM(KEY_F(4)));
    rb_define_global_const("KEY_F5", INT2NUM(KEY_F(5)));
    rb_define_global_const("KEY_F6", INT2NUM(KEY_F(6)));
    rb_define_global_const("KEY_F7", INT2NUM(KEY_F(7)));
    rb_define_global_const("KEY_F8", INT2NUM(KEY_F(8)));
    rb_define_global_const("KEY_F9", INT2NUM(KEY_F(9)));
    rb_define_global_const("KEY_F10", INT2NUM(KEY_F(10)));
    rb_define_global_const("KEY_F11", INT2NUM(KEY_F(11)));
    rb_define_global_const("KEY_F12", INT2NUM(KEY_F(12)));
    
    rb_define_global_const("KEY_a", INT2NUM('a'));
    rb_define_global_const("KEY_b", INT2NUM('b'));
    rb_define_global_const("KEY_c", INT2NUM('c'));
    rb_define_global_const("KEY_d", INT2NUM('d'));
    rb_define_global_const("KEY_e", INT2NUM('e'));
    rb_define_global_const("KEY_f", INT2NUM('f'));
    rb_define_global_const("KEY_g", INT2NUM('g'));
    rb_define_global_const("KEY_h", INT2NUM('h'));
    rb_define_global_const("KEY_i", INT2NUM('i'));
    rb_define_global_const("KEY_j", INT2NUM('j'));
    rb_define_global_const("KEY_k", INT2NUM('k'));
    rb_define_global_const("KEY_l", INT2NUM('l'));
    rb_define_global_const("KEY_m", INT2NUM('m'));
    rb_define_global_const("KEY_n", INT2NUM('n'));
    rb_define_global_const("KEY_o", INT2NUM('o'));
    rb_define_global_const("KEY_p", INT2NUM('p'));
    rb_define_global_const("KEY_q", INT2NUM('q'));
    rb_define_global_const("KEY_r", INT2NUM('r'));
    rb_define_global_const("KEY_s", INT2NUM('s'));
    rb_define_global_const("KEY_t", INT2NUM('t'));
    rb_define_global_const("KEY_u", INT2NUM('u'));
    rb_define_global_const("KEY_v", INT2NUM('v'));
    rb_define_global_const("KEY_w", INT2NUM('w'));
    rb_define_global_const("KEY_x", INT2NUM('x'));
    rb_define_global_const("KEY_y", INT2NUM('y'));
    rb_define_global_const("KEY_z", INT2NUM('z'));
    
    rb_define_global_const("KEY_CTRL_SPACE", INT2NUM(0));
    rb_define_global_const("KEY_CTRL_A", INT2NUM(1));
    rb_define_global_const("KEY_CTRL_B", INT2NUM(2));
    rb_define_global_const("KEY_CTRL_C", INT2NUM(3));
    rb_define_global_const("KEY_CTRL_D", INT2NUM(4));
    rb_define_global_const("KEY_CTRL_E", INT2NUM(5));
    rb_define_global_const("KEY_CTRL_F", INT2NUM(6));
    rb_define_global_const("KEY_CTRL_G", INT2NUM(7));
    rb_define_global_const("KEY_CTRL_H", INT2NUM(8));
    rb_define_global_const("KEY_CTRL_I", INT2NUM(9));
    rb_define_global_const("KEY_TAB", INT2NUM(9));
    rb_define_global_const("KEY_CTRL_J", INT2NUM(10));
    rb_define_global_const("KEY_CTRL_K", INT2NUM(11));
    rb_define_global_const("KEY_CTRL_L", INT2NUM(12));
    rb_define_global_const("KEY_CTRL_M", INT2NUM(13));
    rb_define_global_const("KEY_CTRL_N", INT2NUM(14));
    rb_define_global_const("KEY_CTRL_O", INT2NUM(15));
    rb_define_global_const("KEY_CTRL_P", INT2NUM(16));
    rb_define_global_const("KEY_CTRL_Q", INT2NUM(17));
    rb_define_global_const("KEY_CTRL_R", INT2NUM(18));
    rb_define_global_const("KEY_CTRL_S", INT2NUM(19));
    rb_define_global_const("KEY_CTRL_T", INT2NUM(20));
    rb_define_global_const("KEY_CTRL_U", INT2NUM(21));
    rb_define_global_const("KEY_CTRL_V", INT2NUM(22));
    rb_define_global_const("KEY_CTRL_W", INT2NUM(23));
    rb_define_global_const("KEY_CTRL_X", INT2NUM(24));
    rb_define_global_const("KEY_CTRL_Y", INT2NUM(25));
    rb_define_global_const("KEY_CTRL_Z", INT2NUM(26));
    rb_define_global_const("KEY_ESCAPE", INT2NUM(27));
    
    rb_define_global_const("KEY_A", INT2NUM('A'));
    rb_define_global_const("KEY_B", INT2NUM('B'));
    rb_define_global_const("KEY_C", INT2NUM('C'));
    rb_define_global_const("KEY_D", INT2NUM('D'));
    rb_define_global_const("KEY_E", INT2NUM('E'));
    rb_define_global_const("KEY_F", INT2NUM('F'));
    rb_define_global_const("KEY_G", INT2NUM('G'));
    rb_define_global_const("KEY_H", INT2NUM('H'));
    rb_define_global_const("KEY_I", INT2NUM('I'));
    rb_define_global_const("KEY_J", INT2NUM('J'));
    rb_define_global_const("KEY_K", INT2NUM('K'));
    rb_define_global_const("KEY_L", INT2NUM('L'));
    rb_define_global_const("KEY_M", INT2NUM('M'));
    rb_define_global_const("KEY_N", INT2NUM('N'));
    rb_define_global_const("KEY_O", INT2NUM('O'));
    rb_define_global_const("KEY_P", INT2NUM('P'));
    rb_define_global_const("KEY_Q", INT2NUM('Q'));
    rb_define_global_const("KEY_R", INT2NUM('R'));
    rb_define_global_const("KEY_S", INT2NUM('S'));
    rb_define_global_const("KEY_T", INT2NUM('T'));
    rb_define_global_const("KEY_U", INT2NUM('U'));
    rb_define_global_const("KEY_V", INT2NUM('V'));
    rb_define_global_const("KEY_W", INT2NUM('W'));
    rb_define_global_const("KEY_X", INT2NUM('X'));
    rb_define_global_const("KEY_Y", INT2NUM('Y'));
    rb_define_global_const("KEY_Z", INT2NUM('Z'));

    rb_define_global_const("KEY_0", INT2NUM('0'));
    rb_define_global_const("KEY_1", INT2NUM('1'));
    rb_define_global_const("KEY_2", INT2NUM('2'));
    rb_define_global_const("KEY_3", INT2NUM('3'));
    rb_define_global_const("KEY_4", INT2NUM('4'));
    rb_define_global_const("KEY_5", INT2NUM('5'));
    rb_define_global_const("KEY_6", INT2NUM('6'));
    rb_define_global_const("KEY_7", INT2NUM('7'));
    rb_define_global_const("KEY_8", INT2NUM('8'));
    rb_define_global_const("KEY_9", INT2NUM('9'));
        
    rb_define_global_const("KEY_EXCLAM", INT2NUM('!'));
    rb_define_global_const("KEY_DQUOTE", INT2NUM('"'));
    rb_define_global_const("KEY_SHARP", INT2NUM('#'));
    rb_define_global_const("KEY_DOLLAR", INT2NUM('$'));
    rb_define_global_const("KEY_PERCENT", INT2NUM('%'));
    rb_define_global_const("KEY_AND", INT2NUM('&'));
    rb_define_global_const("KEY_SQUOTE", INT2NUM('\''));
    rb_define_global_const("KEY_LPAREN", INT2NUM('('));
    rb_define_global_const("KEY_RPAREN", INT2NUM(')'));
    rb_define_global_const("KEY_TILDA", INT2NUM('~'));
    rb_define_global_const("KEY_EQUAL", INT2NUM('='));
    rb_define_global_const("KEY_MINUS", INT2NUM('-'));
    rb_define_global_const("KEY_CUP", INT2NUM('^'));
    rb_define_global_const("KEY_VBAR", INT2NUM('|'));
    rb_define_global_const("KEY_BACKSLASH", INT2NUM('\\'));
    rb_define_global_const("KEY_ATMARK", INT2NUM('@'));
    rb_define_global_const("KEY_BAPOSTROPHE", INT2NUM('`'));
    rb_define_global_const("KEY_LCURLY", INT2NUM('{'));
    rb_define_global_const("KEY_LBRACK", INT2NUM('['));
    rb_define_global_const("KEY_PLUS", INT2NUM('+'));
    rb_define_global_const("KEY_SEMICOLON", INT2NUM(';'));
    rb_define_global_const("KEY_STAR", INT2NUM('*'));
    rb_define_global_const("KEY_COLON", INT2NUM(':'));
    rb_define_global_const("KEY_RCURLY", INT2NUM('}'));
    rb_define_global_const("KEY_RBRACK", INT2NUM(']'));
    rb_define_global_const("KEY_LSS", INT2NUM('<'));
    rb_define_global_const("KEY_COMMA", INT2NUM(','));
    rb_define_global_const("KEY_GTR", INT2NUM('>'));
    rb_define_global_const("KEY_DOT", INT2NUM('.'));
    rb_define_global_const("KEY_SLASH", INT2NUM('/'));
    rb_define_global_const("KEY_QMARK", INT2NUM('?'));
    rb_define_global_const("KEY_UNDERBAR", INT2NUM('_'));
    
    rb_define_global_const("NOMETA", INT2NUM(0));
    rb_define_global_const("META", INT2NUM(1));

    rb_define_global_const("MA_REVERSE", INT2NUM(kCAReverse));
    rb_define_global_const("MA_BOLD", INT2NUM(kCABold));
    rb_define_global_const("MA_UNDERLINE", INT2NUM(kCAUnderline));
    
    rb_define_global_const("MA_WHITE", INT2NUM(kCAWhite));
    rb_define_global_const("MA_BLUE", INT2NUM(kCABlue));
    rb_define_global_const("MA_CYAN", INT2NUM(kCACyan));
    rb_define_global_const("MA_GREEN", INT2NUM(kCAGreen));
    rb_define_global_const("MA_YELLOW", INT2NUM(kCAYellow));
    rb_define_global_const("MA_MAGENTA", INT2NUM(kCAMagenta));
    rb_define_global_const("MA_RED", INT2NUM(kCARed));
}

///////////////////////////////////////////////////////////////////////////////
// メイン関数
///////////////////////////////////////////////////////////////////////////////
char gTempDir[PATH_MAX];
char gHomeDir[PATH_MAX];

int main(int argc, char* argv[])
{
    /// ホームディレクトリを保存しておく ///
    char* home_dir = getenv("HOME");
    if(home_dir == NULL) {
        fprintf(stderr, "set $HOME");
        exit(1);
    }
    strcpy(gHomeDir, home_dir);

    /// 一時ファイルの置き場を保存しておく ///
    sprintf(gTempDir, "%s/.mfiler3_tmp", gHomeDir);
    if(access(gTempDir, F_OK) != 0) {
        if(mkdir(gTempDir, 0700) < 0) {
            fprintf(stderr, "can't mkdir %s", gTempDir);
            exit(1);
        }
    }

    if(chmod(gTempDir, S_IRUSR|S_IWUSR|S_IXUSR) < 0) {
        fprintf(stderr, "can't chmod %s", gTempDir);
        exit(1);
    }

    /// 乱数初期化 ///
    srandom(1000);

    /// シグナルを初期化 ///
    set_signal_clear_all();
    signal(SIGWINCH, SIG_IGN);

    /// 環境変数設定 ///
    setenv("SYSCONFDIR", SYSCONFDIR, 1);
    setenv("key_up", string_c_str(string_new_from_int(KEY_UP)), 1);
    setenv("key_right", string_c_str(string_new_from_int(KEY_RIGHT)), 1);
    setenv("key_down", string_c_str(string_new_from_int(KEY_DOWN)), 1);
    setenv("key_left", string_c_str(string_new_from_int(KEY_LEFT)), 1);
    setenv("key_insert", string_c_str(string_new_from_int(KEY_IC)), 1);
    setenv("key_delete", string_c_str(string_new_from_int(KEY_DC)), 1);
    setenv("key_home", string_c_str(string_new_from_int(KEY_HOME)), 1);
    setenv("key_end", string_c_str(string_new_from_int(KEY_END)), 1);
    setenv("key_pageup", string_c_str(string_new_from_int(KEY_PPAGE)), 1);
    setenv("key_pagedown", string_c_str(string_new_from_int(KEY_NPAGE)), 1);
    setenv("key_meta_left", string_c_str(string_new_from_int(KEY_F(13))), 1);
    setenv("key_meta_right", string_c_str(string_new_from_int(KEY_F(14))), 1);
    setenv("key_meta_up", string_c_str(string_new_from_int(KEY_F(15))), 1);
    setenv("key_meta_down", string_c_str(string_new_from_int(KEY_F(16))), 1);
    setenv("key_ctrl_left", string_c_str(string_new_from_int(KEY_F(17))), 1);
    setenv("key_ctrl_right", string_c_str(string_new_from_int(KEY_F(18))), 1);
    setenv("key_ctrl_up", string_c_str(string_new_from_int(KEY_F(19))), 1);
    setenv("key_ctrl_down", string_c_str(string_new_from_int(KEY_F(20))), 1);
    setenv("key_ctrl_delete", string_c_str(string_new_from_int(KEY_F(21))), 1);
    setenv("key_enter", string_c_str(string_new_from_int(10)), 1);
    setenv("key_backspace", string_c_str(string_new_from_int(KEY_BACKSPACE)), 1);
    setenv("key_f1", string_c_str(string_new_from_int(KEY_F(1))), 1);
    setenv("key_f2", string_c_str(string_new_from_int(KEY_F(2))), 1);
    setenv("key_f3", string_c_str(string_new_from_int(KEY_F(3))), 1);
    setenv("key_f4", string_c_str(string_new_from_int(KEY_F(4))), 1);
    setenv("key_f5", string_c_str(string_new_from_int(KEY_F(5))), 1);
    setenv("key_f6", string_c_str(string_new_from_int(KEY_F(6))), 1);
    setenv("key_f7", string_c_str(string_new_from_int(KEY_F(7))), 1);
    setenv("key_f8", string_c_str(string_new_from_int(KEY_F(8))), 1);
    setenv("key_f9", string_c_str(string_new_from_int(KEY_F(9))), 1);
    setenv("key_f10", string_c_str(string_new_from_int(KEY_F(10))), 1);
    setenv("key_f11", string_c_str(string_new_from_int(KEY_F(11))), 1);
    setenv("key_f12", string_c_str(string_new_from_int(KEY_F(12))), 1);
    
    setenv("key_a", string_c_str(string_new_from_int('a')), 1);
    setenv("key_b", string_c_str(string_new_from_int('b')), 1);
    setenv("key_c", string_c_str(string_new_from_int('c')), 1);
    setenv("key_d", string_c_str(string_new_from_int('d')), 1);
    setenv("key_e", string_c_str(string_new_from_int('e')), 1);
    setenv("key_f", string_c_str(string_new_from_int('f')), 1);
    setenv("key_g", string_c_str(string_new_from_int('g')), 1);
    setenv("key_h", string_c_str(string_new_from_int('h')), 1);
    setenv("key_i", string_c_str(string_new_from_int('i')), 1);
    setenv("key_j", string_c_str(string_new_from_int('j')), 1);
    setenv("key_k", string_c_str(string_new_from_int('k')), 1);
    setenv("key_l", string_c_str(string_new_from_int('l')), 1);
    setenv("key_m", string_c_str(string_new_from_int('m')), 1);
    setenv("key_n", string_c_str(string_new_from_int('n')), 1);
    setenv("key_o", string_c_str(string_new_from_int('o')), 1);
    setenv("key_p", string_c_str(string_new_from_int('p')), 1);
    setenv("key_q", string_c_str(string_new_from_int('q')), 1);
    setenv("key_r", string_c_str(string_new_from_int('r')), 1);
    setenv("key_s", string_c_str(string_new_from_int('s')), 1);
    setenv("key_t", string_c_str(string_new_from_int('t')), 1);
    setenv("key_u", string_c_str(string_new_from_int('u')), 1);
    setenv("key_v", string_c_str(string_new_from_int('v')), 1);
    setenv("key_w", string_c_str(string_new_from_int('w')), 1);
    setenv("key_x", string_c_str(string_new_from_int('x')), 1);
    setenv("key_y", string_c_str(string_new_from_int('y')), 1);
    setenv("key_z", string_c_str(string_new_from_int('z')), 1);

    setenv("key_A", string_c_str(string_new_from_int('A')), 1);
    setenv("key_B", string_c_str(string_new_from_int('B')), 1);
    setenv("key_C", string_c_str(string_new_from_int('C')), 1);
    setenv("key_D", string_c_str(string_new_from_int('D')), 1);
    setenv("key_E", string_c_str(string_new_from_int('E')), 1);
    setenv("key_F", string_c_str(string_new_from_int('F')), 1);
    setenv("key_G", string_c_str(string_new_from_int('G')), 1);
    setenv("key_H", string_c_str(string_new_from_int('H')), 1);
    setenv("key_I", string_c_str(string_new_from_int('I')), 1);
    setenv("key_J", string_c_str(string_new_from_int('J')), 1);
    setenv("key_K", string_c_str(string_new_from_int('K')), 1);
    setenv("key_L", string_c_str(string_new_from_int('L')), 1);
    setenv("key_M", string_c_str(string_new_from_int('M')), 1);
    setenv("key_N", string_c_str(string_new_from_int('N')), 1);
    setenv("key_O", string_c_str(string_new_from_int('O')), 1);
    setenv("key_P", string_c_str(string_new_from_int('P')), 1);
    setenv("key_Q", string_c_str(string_new_from_int('Q')), 1);
    setenv("key_R", string_c_str(string_new_from_int('R')), 1);
    setenv("key_S", string_c_str(string_new_from_int('S')), 1);
    setenv("key_T", string_c_str(string_new_from_int('T')), 1);
    setenv("key_U", string_c_str(string_new_from_int('U')), 1);
    setenv("key_V", string_c_str(string_new_from_int('V')), 1);
    setenv("key_W", string_c_str(string_new_from_int('W')), 1);
    setenv("key_X", string_c_str(string_new_from_int('X')), 1);
    setenv("key_Y", string_c_str(string_new_from_int('Y')), 1);
    setenv("key_Z", string_c_str(string_new_from_int('Z')), 1);

    setenv("key_space", string_c_str(string_new_from_int(32)), 1);
    
    setenv("key_ctrl_space", string_c_str(string_new_from_int(0)), 1);
    setenv("key_ctrl_a", string_c_str(string_new_from_int(1)), 1);
    setenv("key_ctrl_b", string_c_str(string_new_from_int(2)), 1);
    setenv("key_ctrl_c", string_c_str(string_new_from_int(3)), 1);
    setenv("key_ctrl_d", string_c_str(string_new_from_int(4)), 1);
    setenv("key_ctrl_e", string_c_str(string_new_from_int(5)), 1);
    setenv("key_ctrl_f", string_c_str(string_new_from_int(6)), 1);
    setenv("key_ctrl_g", string_c_str(string_new_from_int(7)), 1);
    setenv("key_ctrl_h", string_c_str(string_new_from_int(8)), 1);
    setenv("key_ctrl_i", string_c_str(string_new_from_int(9)), 1);
    setenv("key_ctrl_j", string_c_str(string_new_from_int(10)), 1);
    setenv("key_ctrl_k", string_c_str(string_new_from_int(11)), 1);
    setenv("key_ctrl_l", string_c_str(string_new_from_int(12)), 1);
    setenv("key_ctrl_m", string_c_str(string_new_from_int(13)), 1);
    setenv("key_ctrl_n", string_c_str(string_new_from_int(14)), 1);
    setenv("key_ctrl_o", string_c_str(string_new_from_int(15)), 1);
    setenv("key_ctrl_p", string_c_str(string_new_from_int(16)), 1);
    setenv("key_ctrl_q", string_c_str(string_new_from_int(17)), 1);
    setenv("key_ctrl_r", string_c_str(string_new_from_int(18)), 1);
    setenv("key_ctrl_s", string_c_str(string_new_from_int(19)), 1);
    setenv("key_ctrl_t", string_c_str(string_new_from_int(20)), 1);
    setenv("key_ctrl_u", string_c_str(string_new_from_int(21)), 1);
    setenv("key_ctrl_v", string_c_str(string_new_from_int(22)), 1);
    setenv("key_ctrl_w", string_c_str(string_new_from_int(23)), 1);
    setenv("key_ctrl_x", string_c_str(string_new_from_int(24)), 1);
    setenv("key_ctrl_y", string_c_str(string_new_from_int(25)), 1);
    setenv("key_ctrl_z", string_c_str(string_new_from_int(26)), 1);
    setenv("key_escape", string_c_str(string_new_from_int(27)), 1);
    setenv("key_tab", string_c_str(string_new_from_int(9)), 1);

    setenv("key_0", string_c_str(string_new_from_int('0')), 1);
    setenv("key_1", string_c_str(string_new_from_int('1')), 1);
    setenv("key_2", string_c_str(string_new_from_int('2')), 1);
    setenv("key_3", string_c_str(string_new_from_int('3')), 1);
    setenv("key_4", string_c_str(string_new_from_int('4')), 1);
    setenv("key_5", string_c_str(string_new_from_int('5')), 1);
    setenv("key_6", string_c_str(string_new_from_int('6')), 1);
    setenv("key_7", string_c_str(string_new_from_int('7')), 1);
    setenv("key_8", string_c_str(string_new_from_int('8')), 1);
    setenv("key_9", string_c_str(string_new_from_int('9')), 1);
        
    setenv("key_exclam", string_c_str(string_new_from_int('!')), 1);
    setenv("key_dquote", string_c_str(string_new_from_int('"')), 1);
    setenv("key_sharp", string_c_str(string_new_from_int('#')), 1);
    setenv("key_dollar", string_c_str(string_new_from_int('$')), 1);
    setenv("key_percent", string_c_str(string_new_from_int('%')), 1);
    setenv("key_and", string_c_str(string_new_from_int('&')), 1);
    setenv("key_squote", string_c_str(string_new_from_int('\'')), 1);
    setenv("key_lparen", string_c_str(string_new_from_int('(')), 1);
    setenv("key_rparen", string_c_str(string_new_from_int(')')), 1);
    setenv("key_tilda", string_c_str(string_new_from_int('~')), 1);
    setenv("key_equal", string_c_str(string_new_from_int('=')), 1);
    setenv("key_minus", string_c_str(string_new_from_int('-')), 1);
    setenv("key_cup", string_c_str(string_new_from_int('^')), 1);
    setenv("key_vbar", string_c_str(string_new_from_int('|')), 1);
    setenv("key_backslash", string_c_str(string_new_from_int('\\')), 1);
    setenv("key_atmark", string_c_str(string_new_from_int('@')), 1);
    setenv("key_bapostrophe", string_c_str(string_new_from_int('`')), 1);
    setenv("key_lcurly", string_c_str(string_new_from_int('{')), 1);
    setenv("key_lbrack", string_c_str(string_new_from_int('[')), 1);
    setenv("key_plus", string_c_str(string_new_from_int('+')), 1);
    setenv("key_semicolon", string_c_str(string_new_from_int(';')), 1);
    setenv("key_star", string_c_str(string_new_from_int('*')), 1);
    setenv("key_colon", string_c_str(string_new_from_int(':')), 1);
    setenv("key_rcurly", string_c_str(string_new_from_int('}')), 1);
    setenv("key_rbrack", string_c_str(string_new_from_int(']')), 1);
    setenv("key_lss", string_c_str(string_new_from_int('<')), 1);
    setenv("key_comma", string_c_str(string_new_from_int(',')), 1);
    setenv("key_gtr", string_c_str(string_new_from_int('>')), 1);
    setenv("key_dot", string_c_str(string_new_from_int('.')), 1);
    setenv("key_slash", string_c_str(string_new_from_int('/')), 1);
    setenv("key_qmark", string_c_str(string_new_from_int('?')), 1);
    setenv("key_underbar", string_c_str(string_new_from_int('_')), 1);
    
    setenv("nometa", string_c_str(string_new_from_int(0)), 1);
    setenv("meta", string_c_str(string_new_from_int(1)), 1);

    setenv("ma_reverse", string_c_str(string_new_from_int(kCAReverse)), 1);
    setenv("ma_bold", string_c_str(string_new_from_int(kCABold)), 1);
    setenv("ma_underline", string_c_str(string_new_from_int(kCAUnderline)), 1);
    setenv("ma_white", string_c_str(string_new_from_int(kCAWhite)), 1);
    setenv("ma_blue", string_c_str(string_new_from_int(kCABlue)), 1);
    setenv("ma_cyan", string_c_str(string_new_from_int(kCACyan)), 1);
    setenv("ma_green", string_c_str(string_new_from_int(kCAGreen)), 1);
    setenv("ma_yellow", string_c_str(string_new_from_int(kCAYellow)), 1);
    setenv("ma_magenta", string_c_str(string_new_from_int(kCAMagenta)), 1);
    setenv("ma_red", string_c_str(string_new_from_int(kCARed)), 1);

    /// ruby 初期化 ///
    myruby_init();

    /// オプション処理 ///
    char send_cmd[BUFSIZ];
    strcpy(send_cmd, "");

    char send_cmd2[BUFSIZ];
    strcpy(send_cmd2, "");

    int i;
    int pid = -1;
    for(i=1 ; i<argc; i++){
        if(argv[i][0] == '-') {
            switch (argv[i][1]){
                case 'e':
                    if(atoi(argv[i+1]) != 0) {
                        pid = atoi(argv[i+1]);
                        strcpy(send_cmd, "E");
                        strcat(send_cmd, argv[i+2]);
                        i+=2;
                    }
                    else {
                        strcpy(send_cmd, "e");
                        strcat(send_cmd, argv[i+1]);
                        i++;
                    }
                    break;

                case 'E':
                    strcpy(send_cmd, "E");
                    strcat(send_cmd, argv[i+1]);
                    i++;
                    break;

                case 'c':
                    strcpy(send_cmd2, argv[i+1]);
                    i++;
                    break;

                case 'h':
                case 'H':
                case '?':
                    printf("usage mfiler3 [-e [pid] command] [-E command] [-c command]\n\n");
                    printf("-e : send a command to running focused mfiler3\n");
                    printf("-e [pid] : send a command to running mfiler3 which has a argment pid\n");
                    printf("-E : send a command to running all mfiler3\n");
                    printf("-c : run a command on mfiler3\n");
                    exit(1);
                    break;
            }
        }
    }

    /// 環境変数初期化 ///
    setenv("#", "-1", 1);

    /// オプションで指定されているならシェルで実行する ///
    if(strcmp(send_cmd2, "") != 0) {
        if(gKanjiCode == kUtf8) setlocale(LC_CTYPE, "ja_JP.UTF-8");
        set_signal_subshell();
        //tcsetpgrp(0, getpid());
        //debug_init();
        shell_init_subshell();

        int rcode;
        if(!isatty(0) || !isatty(1)) {
            int pipefds[2];

            if(pipe(pipefds) < 0) {
                perror("pipe");
                exit(1);
            }

            rcode = shell(send_cmd2, NULL, pipefds[1], FALSE, TRUE, -1);
            
            string_obj* str = string_new("");
            char buf[BUFSIZ];
            while(1) {
                int size = read(pipefds[0], buf, BUFSIZ-1);
                if(size == 0) {
                    break;
                }
                if(size < 0) {
                    fprintf(stderr, "mfiler -c (%s) failed (read)", send_cmd2);
                    close(pipefds[0]);
                    return 1;
                }

                buf[size] = 0;

                string_push_back(str, buf);
            }
            close(pipefds[0]);

            printf("%s", string_c_str(str));
        }
        else {
            rcode = shell(send_cmd2, NULL, -1, FALSE, TRUE, -1);
        }

        //debug_final();

        return rcode;
    }

    /// オプションで指定されているなら動いているmfiler3にメッセージを送る  ///
    if(strcmp(send_cmd, "") != 0) {
        if(pid != -1) {
            char soc_name[PATH_MAX];
            sprintf(soc_name, "%s/socket%d", gTempDir, pid);

            int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
            if(soc < 0) {
                perror("socket");
                return 1;
            }

            struct sockaddr_un addr;
            addr.sun_family = AF_UNIX;
            strcpy(addr.sun_path, soc_name);
            if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == 0) {
                write(soc, send_cmd, strlen(send_cmd)+1);
            }

            close(soc);
            
            return 0;
        }
        else {
            DIR* dir = opendir(gTempDir);
            if(dir == NULL) {
                fprintf(stderr, "Tempolary directory doesn't exist");
                exit(1);
            }

            struct dirent* entry;
            while(entry = readdir(dir)) {
                if(strstr(entry->d_name, "socket")) {
                    char soc_name[PATH_MAX];
                    sprintf(soc_name, "%s/%s", gTempDir, entry->d_name);

                    int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
                    if(soc < 0) {
                        perror("socket");
                        return 1;
                    }

                    struct sockaddr_un addr;
                    addr.sun_family = AF_UNIX;
                    strcpy(addr.sun_path, soc_name);
                    if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == 0) {
                        write(soc, send_cmd, strlen(send_cmd)+1);
                    }

                    close(soc);
                }
            }
            
            return 0;
        }
    }

    /// 標準入力と出力が制御端末かどうか確認 ///
    if(!isatty(0) || !isatty(1)) {
        fprintf(stderr, "standard input is not a tty\n");
        return 1;
    }

    /// フォワグランドジョブになるまでループ ///
    int status;
    pid_t pgrp;
    while((status = tcgetpgrp(0)) >= 0) {
        if(status == (pgrp = getpgrp())) {
            break;
        }
        kill(- pgrp, SIGTTIN);
    }

    /// 新しいセッションを始めてプロセスグループリーダーになる ///
    setsid();
    pid_t shell_pgrp = getpid();
    setpgid(shell_pgrp, shell_pgrp);

    /// 端末の制御を握る ///
    tcsetpgrp(0, shell_pgrp);

    /// モジュールの初期化 ///
    cmdline_init();
    //sisearch_init();
    cmdline_completion_init();
    menu_init();
    //debug_init();
    filer_init();
    mcurses_init();
    kanji_init();
    shell_init();
    ruby_fun_init();

    /// ソケットの初期化 ///
    char soc_name[PATH_MAX];
    sprintf(soc_name, "%s/socket%d", gTempDir, getpid());
    
    if(access(soc_name, F_OK) == 0) {
        unlink(soc_name);
    }
    
    int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
    if(soc < 0) {
        perror("socket");
        return 1;
    }
    
    struct sockaddr_un addr;
    addr.sun_family = AF_UNIX;
    strcpy(addr.sun_path, soc_name);
    if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        perror("bind");
        return 1;
    }

    /// シグナルを設定 ///
    set_signal_mfiler3();

    /// localeの設定 ///
    if(gKanjiCode == kUtf8) setlocale(LC_CTYPE, "ja_JP.UTF-8");

    /// ディレクトリを作成 ///
    setenv("VIEW_OPTION", "all", 1);

    filer_new_dir(mygetcwd());
    filer_new_dir(mygetcwd());

    filer_activate(0);

    /// ランタイムスクリプト実行 ///
    read_rc_file();
    read_rc_file_ruby();
    cmdline_rehash();

    /// モジュールの初期化(ランタイムスクリプト以降の方が良い奴 ///
    isearch_init();
    
    /// カーシスの起動 ///
    minitscr();
    mclear_immediately();

    /// atexit登録 ///
    atexit(atexit_fun);

    /// ごみソケットの掃除 ///
    char buf[BUFSIZ];
    sprintf(buf, "%%Q%%h%%o%%i ps a | grep mfiler3 | grep -v grep | gawk '{ print $1; }'");
    string_obj* ret = shell3(buf);

    DIR* dir = opendir(gTempDir);
    if(dir == NULL) {
        fprintf(stderr, "Tempolary directory doesn't exist");
        exit(1);
    }

    struct dirent* entry;
    while(entry = readdir(dir)) {
        if(strstr(entry->d_name, "socket")) {
            int pid = atoi(strstr(entry->d_name, "socket") + 6);

            if(pid != getpid()) {
                char buf2[BUFSIZ];
                sprintf(buf2, "%d", pid);
                if(strstr(string_c_str(ret), buf2) == NULL) {
                    char path[PATH_MAX];
                    sprintf(path, "%s/%s", gTempDir, entry->d_name);
                    unlink(path);
                }
            }
        }
    }

    closedir(dir);
    
    /// メインループ ///
    gMainLoop = TRUE;

    fd_set mask;
    fd_set read_ok;

    FD_ZERO(&mask);
    FD_SET(0, &mask);
    FD_SET(soc, &mask);

    while(gMainLoop) {
        /// 描写 ///
        mclear();
        view();
        mrefresh();

        /// selectで入力待ち ///
        read_ok = mask;
        if(!mkbuf_exist()) {     // キーボードのバッファがないならselect
            if(vector_size(gJobs) > 0) {
                struct timeval tv;
                tv.tv_sec = 5;
                tv.tv_usec = 0;

                select(soc + 1, &read_ok, NULL, NULL, &tv);
            }
            else {
                select(soc + 1, &read_ok, NULL, NULL, NULL);
            }
        }

        /// キー処理 ///
        if(FD_ISSET(0, &read_ok) || mkbuf_exist()) {    // キー入力があったか、キーボードのバッファがあるなら

            /// コマンドライン入力中 ///
            if(gCmdLineActive) {
                while(1) {
                    /// 漢字入力のためselectで入力を見張る ///
                    struct timeval tv;
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;

                    read_ok = mask;

                    select(1, &read_ok, NULL, NULL, &tv);

                    /// キー入力中 ///
                    if(FD_ISSET(0, &read_ok) || mkbuf_exist()) {
                        int meta;
                        int key = mgetch(&meta);

                        if(key == -1) {
                        }
                        else if(meta) {
                            input(1, key);
                        }
                        /// normal key ///
                        else {
                           input(0, key);
                        }
                    }
                    /// キー入力が終わった ///
                    else {
                        break;
                    }
                }
            }

            /// その他 ///
            else {
                int meta;
                int key = mgetch_nonblock(&meta);

                /// ESCキー ///
                if(key == -1) {
                }
                else if(meta) {
                    input(1, key);
                }
                
                /// meta key ///
                else if(key >= kKeyMetaFirst && key <= kKeyMetaFirst+127) {
                    input(1, key - kKeyMetaFirst);
                }

                /// normal key ///
                else {
                   input(0, key);
                }
            }
        }

        /// UNIX Domainソケット処理 ///
        else if(FD_ISSET(soc, &read_ok)) {
            char buf[BUFSIZ];
            
            struct sockaddr_un caddr;
            socklen_t caddr_len;
            int len = recvfrom(soc, buf, BUFSIZ, 0, (struct sockaddr *)&caddr, &caddr_len);
            if(buf[0] == 'e') {
                if(gFocus) {
                    shell(buf + 1, NULL, -1, FALSE, FALSE, -1);
                }
            }
            else if(buf[0] == 'E') {
                shell(buf + 1, NULL, -1, FALSE, FALSE, -1);
            }
        }

        /// ジョブ処理 ///
        shell_wait_backgroud_job();
    }

    /// カーシス終わり ///
    mmove_immediately(0,0);
    mclear_immediately();
    mendwin();

    /// モジュール解放 ///
    isearch_final();
    //sisearch_final();
    mcurses_final();
    kanji_final();
    //debug_final();

    /// フック呼び出し ///
    rb_funcall(rb_cObject, rb_intern("atexit_hook"), 0);
    shell("%Q%h atexit_fun", "atexit_fun", -1, FALSE, TRUE, -1);

    /// シグナルを初期化 ///
    set_signal_clear_all();
    
    /// 全てのジョブをkill ///
    shell_kill_all_jobs();

    /// ソケット解放 ///
    unlink(soc_name);

    return 0;
}
