/* 
 * ʐ䃉Cu
 * ݂ȂƂ (c) 2008
 */

#ifndef MINATO_CURSES_H
#define MINATO_CURSES_H

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#endif

#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>

#include "config.h"
#include "minato_string.h"
#include "minato_kanji.h"

#define UTF_CHAR_SIZE_MAX MB_CUR_MAX   // UTF̈ꕶő剽oCg

///////////////////////////////////////////////////////////////////////////////
// ϐ`
///////////////////////////////////////////////////////////////////////////////
extern int gKeyEscapeWait;      // GXP[vL[̑҂

///////////////////////////////////////////////////////////////////////////////
// }N`
///////////////////////////////////////////////////////////////////////////////
#define kCAReverse 0x1          // ̑
#define kCABold 0x2
#define kCAUnderline 0x4
#define kCABlack 0x8
#define kCARed 0x10
#define kCAGreen 0x20
#define kCAYellow 0x40
#define kCABlue 0x80
#define kCAMagenta 0x100
#define kCACyan 0x200
#define kCAWhite 0x400
#define kCABackBlack 0x800
#define kCABackRed 0x1000
#define kCABackGreen 0x2000
#define kCABackYellow 0x4000
#define kCABackBlue 0x8000
#define kCABackMagenta 0x10000
#define kCABackCyan 0x20000
#define kCABackWhite 0x40000

#define kKeyMetaFirst 128      // MetaL[R[h̍ŏ

///////////////////////////////////////////////////////////////////////////////
// ֐`
///////////////////////////////////////////////////////////////////////////////
void mcurses_init();            // minato_cursesW[ vOJnɌĂ
void mcurses_final();           // minato_cursesW[ vOIɌĂ

void minitscr();                // minato_curses minato_cursesgOɌĂ
void mendwin();                 // minato_curses minato_cursesgIɌĂ

#define kKeyMapKeysMax 10
void madd_keymap(int key, char keyes[kKeyMapKeysMax]);      // L[}bvɃL[ǉ

void mclear();                          // ̉ʂ
void mclear_immediately();              // ډʂ
void mclear_online(int y);              // ̉ʂs

void mmove(int y, int x);                           // ̃J[\ړ
void mmove_immediately(int y, int x);               // ډʏ̃J[\ړ
int mmvprintw(int y, int x, char* str, ...);        // ̃J[\ړăɕ
int mprintw(char* str, ...);                        // ɕ

void mattron(int attrs);                // ޕ̑ݒ
void mattron_256color(int red, int green, int blue); // ޕ̑ݒ
void mattroff();                        // ޕ̑̐ݒ

void mbox(int y, int x, int width, int height);     // Ƀ{bNX`
void mrefresh();                                    // ̓eʂɔf

int mgetmaxx();                 // ʂ̃TCY(X)
int mgetmaxy();                 // ʂ̃TCY(Y)
int mis_curses();               // ݃J[VXNĂ邩ǂ 1ȏ: true 0:false
void minit256color();           // 256FL
void mfinal256color();          // 

int mgetch(int* meta);          // L[{[h
int mgetch_nonblock(int* meta); // L[{[h ͂Ȃ-1Ԃ

int mkbuf_exist(); // L[{[hobt@݂ΐ^Ԃ

#endif

