/* 
 * 漢字関連ライブラリ
 * みなとだいすけ (c) 2008
 */

#ifndef MINATO_KANJI_H
#define MINATO_KANJI_H

#include "minato_extra.h"
#include <wchar.h>

#include "config.h"

enum eKanjiCode { kEucjp, kSjis, kUtf8, kUtf8Mac, kAscii, kUnknown };
extern enum eKanjiCode gKanjiCode;       // 現在の漢字コード
extern char* gKanjiCodeString[6];
extern char gIconvKanjiCodeName[5][256];     // ICONVの漢字コードの名前


void kanji_init();     // 初期化
void kanji_final();    // 解放

extern int is_kanji(unsigned char c);
    // 引数が漢字一バイト目かどうか
extern int is_hankaku(unsigned char c);
    // 引数が半角文字一バイト目かどうか
int is_all_ascii(char* buf);
    // FALSE:漢字まじり TRUE:全部英数字

int str_termlen(char* mbs);            // 引数の文字列が画面で何文字か
int str_termlen2(char* mbs, int pos);  // 漢字でpos文字目までの端末で何文字か
int str_kanjilen(char* mbs);           // 引数の文字列が漢字で何文字か

void str_cut(char* mbs, int termsize, char* dest_mbs, int dest_byte);       
    // mbsから端末上の文字列分(termsize)のみ残して残りを捨てた文字列をdest_mbsに返す dest_byte: dest_mbsのサイズ
void str_cut2(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // mbsから端末上の文字列分(termsize)のみ残して残りを捨てた文字列をdest_mbsに返す dest_byte: dest_mbsのサイズ
    // 切り捨てた文字列をスペースで埋める
void str_cut3(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // mbsから端末上の文字列分(termsize)のみ残して残りを捨てた文字列をdest_mbsに返す dest_byte: dest_mbsのサイズ
    // 切り捨てた文字列をスペースで埋める
    // 切り捨てるのは文字列の前から

/// utf8限定 ///
char* str_utfpos2pointer(char* mbs, int pos);       // mbsをUTF文字列と見たときのpos文字目の位置を返す
int str_pointer2utfpos(char* mbs, char* point);     // mbsをUTF文字列と見たときのpointの場所は何文字目かを返す
int wcs_termlen(wchar_t* wcs);         // 引数の文字列が画面で何文字か

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)

enum eKanjiCode kanji_encode_type(char* buf);
    // 引数の文字列の漢字エンコードを返す

int kanji_convert(char* input_buf, char* output_buf, size_t output_buf_size, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type);
    // 漢字エンコードの変換。iconvのラッパー
    // output_bufは十分なスペースが割り当てられている必要がある
    // 返り値は-1はエラー 0は成功

#endif

#endif

