#include "minato_vector.h"
#include <string.h>

///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////
vector_obj* vector_new(int first_size)
{
   vector_obj* self = (vector_obj*)GC_malloc(sizeof(vector_obj));

   self->mTable = (void**)GC_malloc(sizeof(void*) * first_size);
   self->mTableSize = first_size;
   self->mCount = 0;

   return self;
}

///////////////////////////////////////////////////////////////////////////////
// N[
///////////////////////////////////////////////////////////////////////////////
vector_obj* vector_clone(vector_obj* v)
{
    int i;
    vector_obj* result;

    result = vector_new(vector_size(v)+1);
    for(i = 0; i<vector_size(v); i++) {
        vector_add(result, vector_item(v, i));
    }

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// ACeԂ
///////////////////////////////////////////////////////////////////////////////
void* vector_item(vector_obj* self, int index)
{
    if(index >= 0 && index < self->mCount) {
        return self->mTable[index];
    }
    else {
        return NULL;
    }
}

///////////////////////////////////////////////////////////////////////////////
// TCYԂ
///////////////////////////////////////////////////////////////////////////////
int vector_size(vector_obj* self)
{
   return self->mCount;
}

///////////////////////////////////////////////////////////////////////////////
// ACe
///////////////////////////////////////////////////////////////////////////////
void vector_exchange(vector_obj* self, int n, void* item)
{
   self->mTable[n] = item;
}

///////////////////////////////////////////////////////////////////////////////
// ACeŌɒǉ
///////////////////////////////////////////////////////////////////////////////
void vector_add(vector_obj* self, void* item)
{
   if(self->mCount == self->mTableSize) {
      self->mTableSize = self->mTableSize * 2;

      self->mTable = (void**)GC_realloc(self->mTable, sizeof(void*)*self->mTableSize);
   }

   self->mTable[self->mCount] = item;
   self->mCount++;
}

///////////////////////////////////////////////////////////////////////////////
// ACen̈ʒuɑ}
///////////////////////////////////////////////////////////////////////////////
void vector_insert(vector_obj* self, int n, void* item)
{
   if(self->mCount == self->mTableSize) {
      self->mTableSize = self->mTableSize * 2;

      self->mTable = (void**)GC_realloc(self->mTable
                              , sizeof(void*)*self->mTableSize);
   }

   memmove(self->mTable +n +1, self->mTable +n
                           , sizeof(void*)*(self->mCount - n));
   
   self->mTable[n] = item;
   self->mCount++;
}

///////////////////////////////////////////////////////////////////////////////
// ACẽCfbNXԂ
///////////////////////////////////////////////////////////////////////////////
int vector_index(vector_obj* self, void* item)
{
    int i;
    for(i=0; i<self->mCount; i++) {
        if(self->mTable[i] == item) {
            return i;
        }
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////
// n̈ʒũACe폜
///////////////////////////////////////////////////////////////////////////////
void* vector_erase(vector_obj* self, int n)
{
    void* item = NULL;

    if(n>=0 && n<self->mCount) {
        item = self->mTable[n];
        memmove(self->mTable + n, self->mTable + n + 1, sizeof(void*)*(self->mCount -n-1));

        self->mCount--;
    }

    return item;
}

///////////////////////////////////////////////////////////////////////////////
// Ō̃ACeo
///////////////////////////////////////////////////////////////////////////////
void* vector_pop_back(vector_obj* self)
{
    return vector_erase(self, self->mCount-1);
}

///////////////////////////////////////////////////////////////////////////////
// ŏ̃ACeo
///////////////////////////////////////////////////////////////////////////////
void* vector_pop_front(vector_obj* self)
{
    return vector_erase(self, 0);
}

///////////////////////////////////////////////////////////////////////////////
// ACe\[g
///////////////////////////////////////////////////////////////////////////////
static quick_sort(vector_obj* self, int left, int right, sort_if fun)
{
   int i;
   int j;
   void* center_item;

	if(left < right) {
		center_item = self->mTable[(left+right) / 2];

		i = left;
		j = right;

		do { 
			while(self->mTable[i]!=center_item
                     && fun(self->mTable[i], center_item))
         {
				i++;
			}
         
			while(center_item!=self->mTable[j]
                     && fun(center_item, self->mTable[j]))
         {
				j--;
			}

			if(i <= j) {
				void* tmp = self->mTable[i];					// swap
				self->mTable[i] = self->mTable[j];
				self->mTable[j] = tmp;

				i++;
				j--;
			}
		} while(i <= j);

		quick_sort(self, left, j, fun);
		quick_sort(self, i, right, fun);
	}
}

void vector_sort(vector_obj* self, sort_if fun)
{
    quick_sort(self, 0, self->mCount-1, fun);
}

///////////////////////////////////////////////////////////////////////////////
// ACeNA
///////////////////////////////////////////////////////////////////////////////
void vector_clear(vector_obj* self)
{
    self->mCount = 0;
}

