#include <libtar.h>
#include <zlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/param.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

int gzopen_frontend(char* pathname, int oflags, int mode)
{
    char* gzoflags;
    gzFile gzf;
    int fd;

    switch(oflags & O_ACCMODE)
    {
    case O_WRONLY:
        gzoflags = "wb";
        break;
    case O_RDONLY:
        gzoflags = "rb";
        break;
    default:
    case O_RDWR:
        errno = EINVAL;
        return -1;
    }

    fd = open(pathname, oflags, mode);
    if(fd == -1) return -1;

    if((oflags & O_CREAT) && fchmod(fd, mode)) return -1;

    gzf = gzdopen(fd, gzoflags);
    if(!gzf)
    {
        errno = ENOMEM;
        return -1;
    }

    return (int)gzf;
}

tartype_t gztype = { (openfunc_t) gzopen_frontend, (closefunc_t) gzclose
                     , (readfunc_t) gzread, (writefunc_t) gzwrite };

int main(int argc, char* argv[])
{
    if(argc == 2) {
        TAR* t;
        if(tar_open(&t, argv[1], &gztype, O_RDONLY, 0
                    , TAR_VERBOSE|TAR_GNU) == -1)
        {
            fprintf(stderr, "tar_open(): %s\n", strerror(errno));
            return -1;
        }

        int i;
        while((i = th_read(t)) == 0)
        {
            th_print_long_ls(t);

            if(TH_ISREG(t) && tar_skip_regfile(t) != 0)
            {
                fprintf(stderr, "tar_skip_regfile(): %s\n", strerror(errno));
                return -1;
            }
        }

        if(tar_close(t) != 0)
        {
            fprintf(stderr, "tar_close(): %s\n", strerror(errno));
            return -1;
        }
    }

    return 0;
}

