#include "common.h"

VALUE mf_keycommand(VALUE self, VALUE rmeta, VALUE rkeycode, VALUE rextension, VALUE rcommand)
{
    Check_Type(rmeta, T_FIXNUM);
    Check_Type(rkeycode, T_FIXNUM);
    Check_Type(rextension, T_STRING);
    Check_Type(rcommand, T_STRING);

    int meta = NUM2INT(rmeta);
    int keycode = NUM2INT(rkeycode);
    char* extension = RSTRING(rextension)->ptr;
    char* command = RSTRING(rcommand)->ptr;

    hash_put(gKeyCommand[meta][keycode], extension, GC_strdup(command));
                 
    return Qnil;
}

VALUE mf_keycommand2(VALUE self, VALUE rmeta, VALUE rkeycode, VALUE rextension, VALUE rcommand, VALUE rtitle)
{
    Check_Type(rmeta, T_FIXNUM);
    Check_Type(rkeycode, T_FIXNUM);
    Check_Type(rextension, T_STRING);
    Check_Type(rcommand, T_STRING);
    Check_Type(rtitle, T_STRING);

    int meta = NUM2INT(rmeta);
    int keycode = NUM2INT(rkeycode);
    char* extension = RSTRING(rextension)->ptr;
    char* command = RSTRING(rcommand)->ptr;
    char* title = RSTRING(rtitle)->ptr;

    hash_put(gKeyCommand[meta][keycode], extension, GC_strdup(command));
    hash_put(gKeyCommandTitle[meta][keycode], extension, GC_strdup(title));
                 
    return Qnil;
}

VALUE mf_keycommandline(VALUE self, VALUE rmeta, VALUE rkeycode, VALUE rextension, VALUE rcommand, VALUE cursor_pos)
{
    Check_Type(rmeta, T_FIXNUM);
    Check_Type(rkeycode, T_FIXNUM);
    Check_Type(rextension, T_STRING);
    Check_Type(rcommand, T_STRING);
    Check_Type(cursor_pos, T_FIXNUM);

    int meta = NUM2INT(rmeta);
    int keycode = NUM2INT(rkeycode);
    char* extension = RSTRING(rextension)->ptr;
    char* command = RSTRING(rcommand)->ptr;
    int cursor_pos2 = NUM2INT(cursor_pos);

    hash_put(gKeyCommandLine[meta][keycode], extension, GC_strdup(command));
    hash_put(gKeyCommandLineCurPos[meta][keycode], extension, cursor_pos2);
    hash_put(gKeyCommandLineExpandMacro[meta][keycode], extension, 0);
                 
    return Qnil;
}

VALUE mf_keycommandline2(VALUE self, VALUE rmeta, VALUE rkeycode, VALUE rextension, VALUE rcommand, VALUE cursor_pos)
{
    Check_Type(rmeta, T_FIXNUM);
    Check_Type(rkeycode, T_FIXNUM);
    Check_Type(rextension, T_STRING);
    Check_Type(rcommand, T_STRING);
    Check_Type(cursor_pos, T_FIXNUM);

    int meta = NUM2INT(rmeta);
    int keycode = NUM2INT(rkeycode);
    char* extension = RSTRING(rextension)->ptr;
    char* command = RSTRING(rcommand)->ptr;
    int cursor_pos2 = NUM2INT(cursor_pos);

    hash_put(gKeyCommandLine[meta][keycode], extension, GC_strdup(command));
    hash_put(gKeyCommandLineCurPos[meta][keycode], extension, cursor_pos2);
    hash_put(gKeyCommandLineExpandMacro[meta][keycode], extension, 1);
                 
    return Qnil;
}

VALUE mf_keymap(VALUE self, VALUE key, VALUE p1, VALUE p2, VALUE p3, VALUE p4, VALUE p5, VALUE p6, VALUE p7, VALUE p8, VALUE p9, VALUE p10)
{
    char keys[kKeyMapKeysMax];

    Check_Type(key, T_FIXNUM);
    Check_Type(p1, T_FIXNUM);
    Check_Type(p2, T_FIXNUM);
    Check_Type(p3, T_FIXNUM);
    Check_Type(p4, T_FIXNUM);
    Check_Type(p5, T_FIXNUM);
    Check_Type(p6, T_FIXNUM);
    Check_Type(p7, T_FIXNUM);
    Check_Type(p8, T_FIXNUM);
    Check_Type(p9, T_FIXNUM);
    Check_Type(p10, T_FIXNUM);
   

    keys[0] = NUM2INT(p1);
    keys[1] = NUM2INT(p2);
    keys[2] = NUM2INT(p3);
    keys[3] = NUM2INT(p4);
    keys[4] = NUM2INT(p5);
    keys[5] = NUM2INT(p6);
    keys[6] = NUM2INT(p7);
    keys[7] = NUM2INT(p8);
    keys[8] = NUM2INT(p9);
    keys[9] = NUM2INT(p10);
    madd_keymap(NUM2INT(key), keys);
    
    return Qnil;
}

VALUE mf_fcolor(VALUE self, VALUE regex, VALUE red, VALUE green, VALUE blue)
{
    Check_Type(regex, T_STRING);
    Check_Type(red, T_FIXNUM);
    Check_Type(green, T_FIXNUM);
    Check_Type(blue, T_FIXNUM);

    add_fcolor(RSTRING(regex)->ptr, NUM2INT(red), NUM2INT(green), NUM2INT(blue));
    
    return Qnil;
}

VALUE mf_shell(VALUE self, VALUE command)
{
    Check_Type(command, T_STRING);

    string_obj* str = string_new("%Q%h%o");
    string_push_back(str, RSTRING(command)->ptr);
    shell(string_c_str(str), NULL, -1, FALSE, FALSE, -1);
    
    return command;
}

VALUE mf_shell2(VALUE self, VALUE command, VALUE title)
{
    Check_Type(command, T_STRING);
    Check_Type(title, T_STRING);

    string_obj* str = string_new("%Q%h%o");
    string_push_back(str, RSTRING(command)->ptr);
    shell(string_c_str(str), RSTRING(title)->ptr, -1, FALSE, FALSE, -1);
    
    return command;
}

VALUE mf_shell3(VALUE self, VALUE command)
{
    Check_Type(command, T_STRING);

    int pipefds[2];

    if(pipe(pipefds) < 0) {
        perror("pipe");
        exit(1);
    }

    string_obj* command2 = string_new("%Q%h%o");
    string_push_back(command2, RSTRING(command)->ptr);
    shell(string_c_str(command2), NULL, pipefds[1], FALSE, FALSE, -1);
    string_obj* str = string_new("");

    char buf[BUFSIZ];
    while(1) {
        int size = read(pipefds[0], buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            fprintf(stderr, "expand command err(read)");
            close(pipefds[0]);
            close(pipefds[1]);
            return Qnil;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(pipefds[0]);
    close(pipefds[1]);

    return rb_str_new2(string_c_str(str));
}

VALUE mf_adir(VALUE self)
{
    return INT2NUM(adir());
}

VALUE mf_sdir(VALUE self)
{
    return INT2NUM(sdir());
}

VALUE mf_mfiles(VALUE self, VALUE dir)
{
    Check_Type(dir, T_FIXNUM);

    vector_obj* files = filer_mark_files(NUM2INT(dir));

    if(files == NULL) return Qnil;

    VALUE result = rb_ary_new();
    
    int i;
    for(i=0; i<vector_size(files); i++) {
        sFile* file = vector_item(files, i);
        rb_ary_push(result, rb_str_new2(file->mName));
    }

    return result;
}

VALUE mf_files(VALUE self, VALUE dir)
{
    Check_Type(dir, T_FIXNUM);

    sDir* dir2 = filer_dir(NUM2INT(dir));

    if(dir2 == NULL) return Qnil;

    VALUE result = rb_ary_new();
    
    int i;
    for(i=0; i<vector_size(dir2->mFiles); i++) {
        sFile* file = vector_item(dir2->mFiles, i);
        rb_ary_push(result, rb_str_new2(file->mName));
    }

    return result;
}

VALUE mf_shell4(VALUE self, VALUE command, VALUE title)
{
    Check_Type(command, T_STRING);
    Check_Type(title, T_STRING);

    int pipefds[2];

    if(pipe(pipefds) < 0) {
        perror("pipe");
        exit(1);
    }

    string_obj* command2 = string_new("%Q%h%o");
    string_push_back(command2, RSTRING(command)->ptr);
    shell(string_c_str(command2), RSTRING(title)->ptr, pipefds[1], FALSE, FALSE, -1);
    string_obj* str = string_new("");

    char buf[BUFSIZ];
    while(1) {
        int size = read(pipefds[0], buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            fprintf(stderr, "expand command err(read)");
            close(pipefds[0]);
            close(pipefds[1]);
            return Qnil;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(pipefds[0]);
    close(pipefds[1]);

    return rb_str_new2(string_c_str(str));
}

VALUE mf_cmdline(VALUE self, VALUE command, VALUE cursor)
{
    Check_Type(command, T_STRING);
    Check_Type(cursor, T_FIXNUM);

    cmdline_start(RSTRING(command)->ptr, NUM2INT(cursor));
    
    return command;
}

VALUE mf_cmdline2(VALUE self, VALUE command, VALUE cursor)
{
    Check_Type(command, T_STRING);
    Check_Type(cursor, T_FIXNUM);

    string_obj* init_str2 = string_new("");
    expand_macro(RSTRING(command)->ptr, init_str2, FALSE);
    cmdline_start(string_c_str(init_str2), NUM2INT(cursor));
    
    return command;
}

VALUE mf_defmenu(int argc, VALUE* argv, VALUE self)
{
    /// check arguments ///
    if(argc%3 != 1) {
        rb_raise(rb_eArgError, "wrong argument in defmenu");
    }

    /// entry menu ///
    char* menu_name = RSTRING(argv[0])->ptr;

    sMenu* new_menu = sMenu_new(menu_name);

    int i;
    for(i=1; i<argc; i+=3) {
        Check_Type(argv[i], T_STRING);
        Check_Type(argv[i+1], T_FIXNUM);
        Check_Type(argv[i+2], T_STRING);

        menu_append(new_menu, RSTRING(argv[i])->ptr, NUM2INT(argv[i+1]), RSTRING(argv[i+2])->ptr);
    }

    return Qnil;
}

VALUE mf_path(VALUE self, VALUE num)
{
    Check_Type(num, T_STRING);

    char* n = RSTRING(num)->ptr;

    if(strcmp(n, "-a") == 0) {
        sDir* dir = filer_dir(adir());
        return rb_str_new2(dir->mPath);
    }
    else if(strcmp(n, "-s") == 0) {
        sDir* dir = filer_dir(sdir());
        return rb_str_new2(dir->mPath);
    }
    else {
        int num = atoi(n);

        sDir* dir = filer_dir(num);
        if(dir) {
            return rb_str_new2(dir->mPath);
        }
    }
}

VALUE mf_completion_program(VALUE self, VALUE editing_dir, VALUE editing_file, VALUE editing, VALUE editing_position)
{
    Check_Type(editing_dir, T_STRING);
    Check_Type(editing_file, T_STRING);
    Check_Type(editing, T_STRING);
    Check_Type(editing_position, T_FIXNUM);

    cmdline_completion_program(RSTRING(editing_dir)->ptr, RSTRING(editing_file)->ptr, RSTRING(editing)->ptr, NUM2INT(editing_position));

    return Qnil;
}

VALUE mf_completion_file(VALUE self, VALUE editing_dir, VALUE editing_file, VALUE editing, VALUE editing_position)
{
    Check_Type(editing_dir, T_STRING);
    Check_Type(editing_file, T_STRING);
    Check_Type(editing, T_STRING);
    Check_Type(editing_position, T_FIXNUM);

    cmdline_completion_file(RSTRING(editing_dir)->ptr, RSTRING(editing_file)->ptr, RSTRING(editing)->ptr, NUM2INT(editing_position));

    return Qnil;
}

VALUE mf_completion(VALUE self, VALUE all_candidate, VALUE editing, VALUE add_space)
{
    Check_Type(all_candidate, T_ARRAY);
    Check_Type(editing, T_STRING);

    bool add_space2 = (add_space == Qtrue) ? TRUE: FALSE;

    vector_obj* all_candidate2 = vector_new(10);
    int i;
    for(i = 0; i<RARRAY(all_candidate)->len; i++) {
        VALUE str = rb_ary_entry(all_candidate, i);

        vector_add(all_candidate2, string_new((RSTRING(str)->ptr)));
    }

    cmdline_completion(all_candidate2, RSTRING(editing)->ptr, add_space2);

    return Qnil;
}

VALUE mf_completion2(VALUE self, VALUE all_candidate, VALUE editing, VALUE add_space, VALUE candidate_len)
{
    Check_Type(all_candidate, T_ARRAY);
    Check_Type(editing, T_STRING);
    Check_Type(candidate_len, T_FIXNUM);

    bool add_space2 = (add_space == Qtrue) ? TRUE: FALSE;

    vector_obj* all_candidate2 = vector_new(10);
    int i;
    for(i = 0; i<RARRAY(all_candidate)->len; i++) {
        VALUE array = rb_ary_entry(all_candidate, i);
        
        vector_obj* array2 = vector_new(2);
        vector_add(array2, string_new(RSTRING(rb_ary_entry(array, 0))->ptr));
        vector_add(array2, string_new(RSTRING(rb_ary_entry(array, 1))->ptr));

        vector_add(all_candidate2, array2);
    }

    cmdline_completion2(all_candidate2, RSTRING(editing)->ptr, add_space2, NUM2INT(candidate_len));

    return Qnil;
}
VALUE mf_completion_clear(VALUE self)
{
    cmdline_completion_clear();

    return Qnil;
}

VALUE mf_add_history(VALUE self, VALUE history)
{
    Check_Type(history, T_STRING);

    add_history(RSTRING(history)->ptr);

    return history;
}

VALUE mf_add_history2(VALUE self, VALUE history)
{
    Check_Type(history, T_STRING);

    string_obj* cmdline = string_new("");
    expand_macro(RSTRING(history)->ptr, cmdline, FALSE);
    add_history(string_c_str(cmdline));

    return history;
}

VALUE mf_history_number(VALUE self, VALUE cmdline)
{
    Check_Type(cmdline, T_STRING);

    int result = 0;

    char* search = RSTRING(cmdline)->ptr;

    char path[PATH_MAX];
    sprintf(path, "%s/.mhistory3", gHomeDir);

    if(access(path, R_OK) == 0) {
        char line[kCmdLineMax];

        FILE* f = fopen(path, "r+");
        while(fgets(line, kCmdLineMax, f) != NULL) {
            line[strlen(line)-1] = 0; // chomp
            if(strstr(line, search)) {
                result++;
            }
        }
        fclose(f);
    }

    return INT2NUM(result);
}

VALUE mf_history_number2(VALUE self, VALUE cmdline)
{
    Check_Type(cmdline, T_STRING);

    int result = 0;

    string_obj* cmdline2 = string_new("");
    expand_macro(RSTRING(cmdline)->ptr, cmdline2, FALSE);
    char* search = string_c_str(cmdline2);

    char path[PATH_MAX];
    sprintf(path, "%s/.mhistory3", gHomeDir);

    if(access(path, R_OK) == 0) {
        char line[kCmdLineMax];

        FILE* f = fopen(path, "r+");
        while(fgets(line, kCmdLineMax, f) != NULL) {
            line[strlen(line)-1] = 0; // chomp
            if(strstr(line, search)) {
                result++;
            }
        }
        fclose(f);
    }

    return INT2NUM(result);
}

VALUE mf_enable_explore_isearch(VALUE self)
{
    gISearchExplore = TRUE;

    return Qtrue;
}

VALUE mf_minitscr(VALUE self)
{
    if(!mis_curses()) {
        set_signal_mfiler3();
        minitscr();
    }

    return Qnil;
}

VALUE mf_mendwin(VALUE self)
{
    if(mis_curses()) {
        mendwin();
        set_signal_clear_all();
    }

    return Qnil;
}

VALUE mf_mmove(VALUE self, VALUE y, VALUE x)
{
    Check_Type(y, T_FIXNUM);
    Check_Type(x, T_FIXNUM);

    mmove(NUM2INT(y), NUM2INT(x));

    return Qnil;
}

VALUE mf_mmove_immediately(VALUE self, VALUE y, VALUE x)
{
    Check_Type(y, T_FIXNUM);
    Check_Type(x, T_FIXNUM);

    mmove_immediately(NUM2INT(y), NUM2INT(x));

    return Qnil;
}

VALUE mf_mprintw(int argc, VALUE* argv, VALUE self)
{
    if(argc < 1) {
        fprintf(stderr, "invalid arguments in mprintw(%d)", argc);
        exit(1);
    }

    /// get str ///
    VALUE str = rb_f_sprintf(argc, argv);
    int ret = mprintw("%s", RSTRING(str)->ptr);

    return INT2NUM(ret);
}

VALUE mf_mmvprintw(int argc, VALUE* argv, VALUE self)
{
    if(argc < 3) {
        fprintf(stderr, "invalid arguments in mmvprintw(%d)", argc);
        exit(1);
    }
        
    /// get x, y ///
    Check_Type(argv[0], T_FIXNUM);
    Check_Type(argv[1], T_FIXNUM);

    int x = NUM2INT(argv[0]);
    int y = NUM2INT(argv[1]);

    /// get str ///
    int new_argc = argc-2;
    VALUE* new_argv = argv + 2;
    
    VALUE str = rb_f_sprintf(new_argc, new_argv);
    int ret = mmvprintw(x, y, "%s", RSTRING(str)->ptr);

    return INT2NUM(ret);
}

VALUE mf_mattron(VALUE self, VALUE attrs)
{
    Check_Type(attrs, T_FIXNUM);

    mattron(NUM2INT(attrs));

    return Qnil;
}

VALUE mf_mattroff(VALUE self)
{
    mattroff();

    return Qnil;
}

VALUE mf_mgetmaxx(VALUE self)
{
    int ret = mgetmaxx();

    return INT2NUM(ret);
}

VALUE mf_mgetmaxy(VALUE self)
{
    int ret = mgetmaxy();

    return INT2NUM(ret);
}

VALUE mf_mclear_immediately(VALUE self)
{
    mclear_immediately();

    return Qnil;
}

VALUE mf_mclear(VALUE self)
{
    mclear();

    return Qnil;
}

VALUE mf_mclear_online(VALUE self, VALUE y)
{
    Check_Type(y, T_FIXNUM);

    mclear_online(NUM2INT(y));

    return Qnil;
}

VALUE mf_mbox(VALUE self, VALUE y, VALUE x, VALUE width, VALUE height)
{
    Check_Type(y, T_FIXNUM);
    Check_Type(x, T_FIXNUM);
    Check_Type(width, T_FIXNUM);
    Check_Type(height, T_FIXNUM);

    mbox(NUM2INT(y), NUM2INT(x), NUM2INT(width), NUM2INT(height));

    return Qnil;
}

VALUE mf_mrefresh(VALUE self)
{
    mrefresh();

    return Qnil;
}

VALUE mf_mgetch(VALUE self)
{
    int meta;
    int key = mgetch(&meta);
    
    VALUE result = rb_ary_new();
    rb_ary_push(result, INT2NUM(meta));
    rb_ary_push(result, INT2NUM(key));

    return result;
}

VALUE mf_mgetch_nonblock(VALUE self)
{
    int meta;
    int key = mgetch_nonblock(&meta);
    
    VALUE result = rb_ary_new();
    rb_ary_push(result, INT2NUM(meta));
    rb_ary_push(result, INT2NUM(key));
    
    return result;
}

VALUE mf_mis_curses(VALUE self)
{
    int result = mis_curses();

    return result ? Qtrue:Qfalse;
}


void ruby_fun_init()
{
    rb_define_global_function("mmove", RUBY_METHOD_FUNC(mf_mmove), 2);
    rb_define_global_function("mmove_immediately", RUBY_METHOD_FUNC(mf_mmove_immediately), 2);
    rb_define_global_function("mmvprintw", RUBY_METHOD_FUNC(mf_mmvprintw), -1);
    rb_define_global_function("mprintw", RUBY_METHOD_FUNC(mf_mprintw), -1);
    rb_define_global_function("mattron", RUBY_METHOD_FUNC(mf_mattron), 1);
    rb_define_global_function("mattroff", RUBY_METHOD_FUNC(mf_mattroff), 0);
    rb_define_global_function("mgetmaxx", RUBY_METHOD_FUNC(mf_mgetmaxx), 0);
    rb_define_global_function("mgetmaxy", RUBY_METHOD_FUNC(mf_mgetmaxy), 0);
    rb_define_global_function("mclear_immediately", RUBY_METHOD_FUNC(mf_mclear_immediately), 0);
    rb_define_global_function("mclear", RUBY_METHOD_FUNC(mf_mclear), 0);
    rb_define_global_function("mclear_online", RUBY_METHOD_FUNC(mf_mclear_online), 1);
    rb_define_global_function("mbox", RUBY_METHOD_FUNC(mf_mbox), 4);
    rb_define_global_function("mrefresh", RUBY_METHOD_FUNC(mf_mrefresh), 0);
    rb_define_global_function("mgetch", RUBY_METHOD_FUNC(mf_mgetch), 0);
    rb_define_global_function("mgetch_nonblock", RUBY_METHOD_FUNC(mf_mgetch_nonblock), 0);
    rb_define_global_function("mis_curses", RUBY_METHOD_FUNC(mf_mis_curses), 0);
    rb_define_global_function("keycommand", RUBY_METHOD_FUNC(mf_keycommand), 4);
    rb_define_global_function("keycommand2", RUBY_METHOD_FUNC(mf_keycommand2), 5);
    rb_define_global_function("keycommandline", RUBY_METHOD_FUNC(mf_keycommandline), 5);
    rb_define_global_function("keycommandline2", RUBY_METHOD_FUNC(mf_keycommandline2), 5);
    rb_define_global_function("keymap", RUBY_METHOD_FUNC(mf_keymap), 11);
    rb_define_global_function("fcolor", RUBY_METHOD_FUNC(mf_fcolor), 4);
    rb_define_global_function("shell", RUBY_METHOD_FUNC(mf_shell), 1);
    rb_define_global_function("shell2", RUBY_METHOD_FUNC(mf_shell2), 2);
    rb_define_global_function("shell3", RUBY_METHOD_FUNC(mf_shell3), 1);
    rb_define_global_function("shell4", RUBY_METHOD_FUNC(mf_shell4), 2);
    rb_define_global_function("cmdline", RUBY_METHOD_FUNC(mf_cmdline), 2);
    rb_define_global_function("cmdline2", RUBY_METHOD_FUNC(mf_cmdline2), 2);
    rb_define_global_function("defmenu", RUBY_METHOD_FUNC(mf_defmenu), -1);
    rb_define_global_function("path", RUBY_METHOD_FUNC(mf_path), 1);
    rb_define_global_function("mfiles", RUBY_METHOD_FUNC(mf_mfiles), 1);
    rb_define_global_function("files", RUBY_METHOD_FUNC(mf_files), 1);
    rb_define_global_function("adir", RUBY_METHOD_FUNC(mf_adir), 0);
    rb_define_global_function("sdir", RUBY_METHOD_FUNC(mf_sdir), 0);
    rb_define_global_function("completion_program", RUBY_METHOD_FUNC(mf_completion_program), 4);
    rb_define_global_function("completion_file", RUBY_METHOD_FUNC(mf_completion_file), 4);
    rb_define_global_function("completion", RUBY_METHOD_FUNC(mf_completion), 3);
    rb_define_global_function("completion2", RUBY_METHOD_FUNC(mf_completion2), 4);
    rb_define_global_function("completion_clear", RUBY_METHOD_FUNC(mf_completion_clear), 0);
    rb_define_global_function("minitscr", RUBY_METHOD_FUNC(mf_minitscr), 0);
    rb_define_global_function("mendwin", RUBY_METHOD_FUNC(mf_mendwin), 0);
    rb_define_global_function("mis_curses", RUBY_METHOD_FUNC(mf_mis_curses), 0);
    rb_define_global_function("add_history", RUBY_METHOD_FUNC(mf_add_history), 1);
    rb_define_global_function("add_history2", RUBY_METHOD_FUNC(mf_add_history2), 1);
    rb_define_global_function("history_number", RUBY_METHOD_FUNC(mf_history_number), 1);
    rb_define_global_function("history_number2", RUBY_METHOD_FUNC(mf_history_number2), 1);
    rb_define_global_function("enable_explore_isearch", RUBY_METHOD_FUNC(mf_enable_explore_isearch), 0);
}

