#include "common.h"
#include <unistd.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/shm.h>
#include <glob.h>
#include <string.h>
#include <libgen.h>

vector_obj* gJobs;                    // vector of sJob
sJob* gForgroundJob = NULL;           // tHAOhWu

static int wait_forground_job(BOOL quick); // tHAOhWȕI҂
static void shell_background_job(int num);

typedef struct {
    string_obj* func_name;
    vector_obj* statments;
} sFunction;

hash_obj* gFuncs;         // sFunction*̔z
vector_obj* gFuncs2;      // ⊮p
hash_obj* gFDs;           // openꂽt@CfBXNv^Ă
hash_obj* gBuffers;       // openꂽt@C̃obt@


typedef struct
{
    string_obj* mExt;
    string_obj* mProg;
} sRelatedProg;

sRelatedProg* sRelatedProg_new(char* ext, char* prog)
{
    sRelatedProg* result = GC_malloc(sizeof(sRelatedProg));

    result->mExt = string_new(ext);
    result->mProg = string_new(prog);

    return result;
}

hash_obj* gRelatedProg;   // gq֘At
vector_obj* gRelatedProg2;   // gq֘At

hash_obj* gArrays;        // z

///////////////////////////////////////////////////////////////////////////////
// shell
///////////////////////////////////////////////////////////////////////////////
void shell_init()
{
    gJobs = vector_new(10);
    gFuncs = hash_new(10);
    gFuncs2 = vector_new(100);
    gFDs = hash_new(10);
    gBuffers = hash_new(10);

    gArrays = hash_new(10);

    gRelatedProg = hash_new(100);
    gRelatedProg2 = vector_new(100);

    hash_put(gFDs, "<STDIN>", 1);
    hash_put(gFDs, "<STDOUT>", 2);
    hash_put(gFDs, "<STDERR>", 3);
}

void shell_init_subshell()
{
    gJobs = vector_new(10);
    gFuncs = hash_new(10);
    gFDs = hash_new(10);

    gArrays = hash_new(10);
}

void add_history(char* str)
{
    char path[PATH_MAX];
    sprintf(path, "%s/.mhistory3", gHomeDir);
    if(access(path, W_OK) != 0) {
        creat(path, 0600);
    }

    FILE* f = fopen(path, "a");
    fprintf(f, "%s\n", str);
    fclose(f);
}

///////////////////////////////////////////////////////////////////////////////
// }NWJ
///////////////////////////////////////////////////////////////////////////////
void get_quoted_fname(char* fname, string_obj* quoted_fname)
{
    char* p = fname;
    while(*p) {
        if(*p==' ' || *p=='!' || *p=='*' || *p=='>' || *p=='&' || *p=='~' || *p=='#' || *p =='$' || *p=='(' || *p==')' || *p=='\\' || *p=='|' || *p=='[' || *p==']' || *p=='{' || *p=='}' || *p==';' || *p=='\'' || *p=='"' || *p=='<' || *p=='>' || *p=='?') 
        {
            string_push_back2(quoted_fname, '\\');
            string_push_back2(quoted_fname, *p++);
        }
        else {
            string_push_back2(quoted_fname, *p++);
        }
    }
}

int expand_macro(char* p, string_obj* cmdline, int sub_shell)
{
    while(*p == ' ' || *p == '\n' || *p == ';' || *p == '\t') {
        string_push_back2(cmdline, *p);
        p++;
    }

    if(*p == 'i' && *(p+1) == 'f') {
        string_push_back(cmdline, p);
        return TRUE;
    }
    else if(*p == 'w' && *(p+1) == 'h' && *(p+2) == 'i' && *(p+3) == 'l' && 
            *(p+4) == 'e')
    {
        string_push_back(cmdline, p);
        return TRUE;
    }
    else if(*p == 'f' && *(p+1) == 'o' && *(p+2) == 'r') {
        string_push_back(cmdline, p);
        return TRUE;
    }
    else if(*p == 'f' && *(p+1) == 'u' && *(p+2) == 'n' && *(p+3) == 'c' && 
            *(p+4) == 't' && *(p+5) == 'i' && *(p+6) == 'o' && *(p+7) == 'n')
    {
        string_push_back(cmdline, p);
        return TRUE;
    }

    BOOL squote = FALSE;
    BOOL dquote = FALSE;

    while(*p) {
        if(*p == '\\') {
            string_push_back2(cmdline, *p++);

            if(*p) string_push_back2(cmdline, *p++);
        }
        else if(!dquote && *p == '\'') {
            string_push_back2(cmdline, *p++);
            squote = !squote;
        }
        else if(!squote && *p == '"') {
            string_push_back2(cmdline, *p++);
            dquote = !dquote;
        }
        else if(!squote && *p == '%') {
            p++;

            if(*p == 'q') {
                p++;

                string_push_back(cmdline, "%q");
            }
            else if(*p == 'Q') {
                p++;

                string_push_back(cmdline, "%Q");
            }
            else if(*p == 'o') {
                p++;

                string_push_back(cmdline, "%o");
            }
            else if(*p == 'h') {
                p++;

                string_push_back(cmdline, "%h");
            }
            else if(*p == 'r') {
                p++;

                string_push_back(cmdline, "%r");
            }
            else if(*p == 't') {
                p++;

                string_push_back(cmdline, "%t");
            }
            else if(*p == 'c') {
                p++;

                string_push_back(cmdline, "%c");
            }
            else if(*p == 'f') {
                p++;

                sDir* dir = filer_dir(adir());
                sFile* file = filer_file(adir(), dir->mCursor);

                string_obj* quoted_fname = string_new("");
                get_quoted_fname(file->mName, quoted_fname);
                string_push_back(cmdline, string_c_str(quoted_fname));
            }
            else if(*p == 'F') {
                p++;

                sDir* dir = filer_dir(adir());
                sFile* file = filer_file(adir(), dir->mCursor);

                string_obj* path = string_new(dir->mPath);
                string_push_back(path, file->mName);

                string_obj* quoted_fname = string_new("");
                get_quoted_fname(string_c_str(path), quoted_fname);
                string_push_back(cmdline, string_c_str(quoted_fname));
            }
            else if(*p == 'x') {
                p++;

                sDir* dir = filer_dir(adir());
                sFile* file = filer_file(adir(), dir->mCursor);

                char* extension = extname(file->mName);

                string_obj* quoted_fname = string_new("");
                get_quoted_fname(extension, quoted_fname);
                string_push_back(cmdline, string_c_str(quoted_fname));
            }
            else if(*p == 'X') {
                p++;

                sDir* dir = filer_dir(adir());
                sFile* file = filer_file(adir(), dir->mCursor);

                char* noextension = noextname(file->mName);

                string_obj* quoted_fname = string_new("");
                get_quoted_fname(noextension, quoted_fname);
                string_push_back(cmdline, string_c_str(quoted_fname));
            }
            else if(*p == 'm') {
                p++;

                vector_obj* marks = filer_mark_files(adir());
                if(vector_size(marks) > 0) {
                    int i;
                    for(i=0; i<vector_size(marks); i++) {
                        sFile* file = vector_item(marks, i);

                        string_obj* quoted_fname = string_new("");
                        get_quoted_fname(file->mName, quoted_fname);
                        string_push_back(cmdline, string_c_str(quoted_fname));
                        string_push_back(cmdline, " ");
                    }
                }
                else {
                    sDir* dir = filer_dir(adir());
                    sFile* file = filer_file(adir(), dir->mCursor);

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(file->mName, quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
            }
            else if(*p == 'M') {
                p++;

                vector_obj* marks = filer_mark_files(adir());
                if(vector_size(marks) > 0) {
                    int i;
                    for(i=0; i<vector_size(marks); i++) {
                        sFile* file = vector_item(marks, i);
                        sDir* dir = filer_dir(adir());

                        string_obj* path = string_new(dir->mPath);
                        string_push_back(path, file->mName);

                        string_obj* quoted_fname = string_new("");
                        get_quoted_fname(string_c_str(path), quoted_fname);
                        string_push_back(cmdline, string_c_str(quoted_fname));
                        string_push_back(cmdline, " ");
                    }
                }
                else {
                    sDir* dir = filer_dir(adir());
                    sFile* file = filer_file(adir(), dir->mCursor);

                    string_obj* path = string_new(dir->mPath);
                    string_push_back(path, file->mName);

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(string_c_str(path), quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
            }
            else if(*p == 'a') {
                p++;

                sDir* dir = filer_dir(adir());

                int i;
                for(i=0; i<vector_size(dir->mFiles); i++) {
                    sFile* file = vector_item(dir->mFiles, i);

                    if(strcmp(file->mName, "..") != 0) {
                        string_obj* quoted_fname = string_new("");
                        get_quoted_fname(file->mName, quoted_fname);
                        string_push_back(cmdline, string_c_str(quoted_fname));
                        string_push_back(cmdline, " ");
                    }
                }
            }
            else if(*p == 'A') {
                p++;

                sDir* dir = filer_dir(adir());

                int i;
                for(i=0; i<vector_size(dir->mFiles); i++) {
                    sFile* file = vector_item(dir->mFiles, i);

                    if(strcmp(file->mName, "..") != 0) {
                        string_obj* path = string_new(dir->mPath);
                        string_push_back(path, file->mName);

                        string_obj* quoted_fname = string_new("");
                        get_quoted_fname(string_c_str(path), quoted_fname);
                        string_push_back(cmdline, string_c_str(quoted_fname));
                        string_push_back(cmdline, " ");
                    }
                }
            }
            else if(*p == 'd') {
                p++;

                if(*p == '2') {
                    p++;

                    sDir* dir = filer_dir(sdir());

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(basename(dir->mPath), quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
                else {
                    sDir* dir = filer_dir(adir());

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(basename(dir->mPath), quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
            }
            else if(*p == 'D') {
                p++;

                if(*p == '2') {
                    p++;

                    sDir* dir = filer_dir(sdir());

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(dir->mPath, quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
                else {
                    sDir* dir = filer_dir(adir());

                    string_obj* quoted_fname = string_new("");
                    get_quoted_fname(dir->mPath, quoted_fname);
                    string_push_back(cmdline, string_c_str(quoted_fname));
                }
            }
            else if(*p == '%') {
                p++;

                string_push_back(cmdline, "%");
            }
            else {
                string_push_back(cmdline, "%");
            }
        }
        else if(squote || dquote) {
            string_push_back2(cmdline, *p++);
        }
        else {
            string_push_back2(cmdline, *p++);
        }
    }
    
    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
// qvZX
///////////////////////////////////////////////////////////////////////////////
sChildProgram* sChildProgram_new(pid_t pid, vector_obj* argv, int return_code)
{
    sChildProgram* self = (sChildProgram*)GC_malloc(sizeof(sChildProgram));

    self->mPid = pid;
    self->mArgv = vector_new(10);
    int i;
    for(i=0; i<vector_size(argv); i++) {
        string_obj* item = (string_obj*)vector_item(argv, i);
        vector_add(self->mArgv, string_new(string_c_str(item)));
    }

    self->mReturnCode = return_code;

    return self;
}

///////////////////////////////////////////////////////////////////////////////
// Wu
///////////////////////////////////////////////////////////////////////////////
sJob* sJob_new(char* name) 
{
    sJob* self = (sJob*)GC_malloc(sizeof(sJob));

    char buf[BUFSIZ];
    char* p2 = buf;
    char* p = name;
    while(*p) {
        if(*p == '\n') {
            break;
        }
        if((p2-buf) >= (BUFSIZ-1)) {
            break;
        }
        else {
            *p2++ = *p++;
        }
    }
    *p2 = 0;
    char buf2[BUFSIZ];
    str_cut(buf, 128, buf2, BUFSIZ);
    self->mName = string_new(buf2);
    int id = 0;
    while(1) {
        bool id_exist = false;
        int i;
        for(i=0; i<vector_size(gJobs); i++) {
            sJob* job = (sJob*)vector_item(gJobs, i);
            if(job->mJobId == id) {
                id_exist = true;
                break;
            }
        }

        if(!id_exist) {
            break;
        }

        id++;
    }
    self->mJobId = id;
    self->mNumProgs = 0;

    self->mChildPrograms = vector_new(10);
    
    self->mRunningProgs = 0;
    self->mPGroup = 0;

    return self;
}

void sJob_AddChildProgram(sJob* self, pid_t pid, vector_obj* argv, int return_code) 
{
    vector_add(self->mChildPrograms, sChildProgram_new(pid, argv, return_code));
    self->mNumProgs++;
    self->mRunningProgs++;
}

//////////////////////////////////////////////////////////////////////////////
// p[T[
//////////////////////////////////////////////////////////////////////////////
enum eRedirect { kRedirectInput, kRedirectOverwrite, kRedirectAppend, kRedirectErrAndOutput };

typedef struct _sRedirect {
    enum eRedirect mType;
    int mFd;
    char mFName[1024];
} sRedirect;

sRedirect* sRedirect_new()
{
    sRedirect* self = (sRedirect*)GC_malloc_atomic(sizeof(sRedirect));
    return self;
}

enum eStatment { kNormal, kIf, kWhile, kFor, kBreak, kReturn, kFunction };
enum eStatmentTerminated { kTNormal, kOrOr, kAndAnd };

typedef struct _sStatment {
    vector_obj* kinds;
    enum eStatmentTerminated terminated;
    vector_obj* argvs;
    vector_obj* redirections_list;
    vector_obj* extras;
    string_obj* here_document;
    BOOL background;
} sStatment;

sStatment* sStatment_new() {
    sStatment* self = (sStatment*)GC_malloc(sizeof(sStatment));

    self->kinds = vector_new(10);
    self->argvs = vector_new(10);
    self->terminated = kTNormal;
    self->redirections_list = vector_new(10);
    self->background = FALSE;
    self->extras = vector_new(10);
    self->here_document = string_new("");

    return self;
}

typedef struct {
    vector_obj* conditionals_list;
    vector_obj* statments_list;
} sIf;

sIf* sIf_new() {
    sIf* self = (sIf*)GC_malloc(sizeof(sIf));

    self->conditionals_list = vector_new(5);
    self->statments_list = vector_new(5);

    return self;
}

typedef struct {
    vector_obj* conditionals;
    vector_obj* statments;
} sWhile;

sWhile* sWhile_new() {
    sWhile* self = (sWhile*)GC_malloc(sizeof(sWhile));

    self->conditionals = vector_new(5);
    self->statments = vector_new(10);

    return self;
}

typedef struct {
    string_obj* var_name;
    vector_obj* strings;
    vector_obj* statments;
} sFor;

sFor* sFor_new() {
    sFor* self = (sFor*)GC_malloc(sizeof(sFor));

    self->var_name = string_new("");
    self->strings = vector_new(10);
    self->statments = vector_new(10);

    return self;
}

sFunction* sFunction_new() {
    sFunction* self = (sFunction*)GC_malloc(sizeof(sFor));

    self->func_name = string_new("");
    self->statments = vector_new(10);

    return self;
}

static int gExpandCommandNum = 0;

int err_msg(char* str, int sub_shell) {
    if(sub_shell || mis_curses() == 0) {
        fprintf(stderr, "%s\n", str);

        minitscr();
        int meta;
        mgetch(&meta);
        mendwin();
    }
    else {
        msg("%s", str);
    }
}

static BOOL expand_env(string_obj* cmdline, string_obj* cmdline2
                        , BOOL sub_shell)
{
    BOOL squote = FALSE;
    BOOL dquote = FALSE;

    char* p = string_c_str(cmdline);

    while(*p == ' ' || *p == '\n' || *p == ';' || *p == '\t') {
        string_push_back2(cmdline2, *p);
        p++;
    }

    if(*p == 'i' && *(p+1) == 'f') {
        string_push_back(cmdline2, string_c_str(cmdline));
        return TRUE;
    }
    else if(*p == 'w' && *(p+1) == 'h' && *(p+2) == 'i' && *(p+3) == 'l' && 
            *(p+4) == 'e')
    {
        string_push_back(cmdline2, string_c_str(cmdline));
        return TRUE;
    }
    else if(*p == 'f' && *(p+1) == 'o' && *(p+2) == 'r') {
        string_push_back(cmdline2, string_c_str(cmdline));
        return TRUE;
    }
    else if(*p == 'f' && *(p+1) == 'u' && *(p+2) == 'n' && *(p+3) == 'c' && 
            *(p+4) == 't' && *(p+5) == 'i' && *(p+6) == 'o' && *(p+7) == 'n')
    {
        string_push_back(cmdline2, string_c_str(cmdline));
        return TRUE;
    }

    while(*p) {
        if(*p == '\\') {
            string_push_back2(cmdline2, *p++);

            if(*p) string_push_back2(cmdline2, *p++);
        }
        else if(!dquote && *p == '\'') {
            string_push_back2(cmdline2, *p++);
            squote = !squote;
        }
        else if(!squote && *p == '"') {
            string_push_back2(cmdline2, *p++);
            dquote = !dquote;
        }
        else if(!squote && *p == '$' && *(p+1) == '{') {
            p+=2;
            
            char name[1024];
            char* p3 = name;
            while(*p != '}' && *p != 0) {
                *p3++ = *p++;
            }
            *p3 = 0;
            p++;

            string_obj* name2 = string_new("");
            expand_env(string_new(name), name2, sub_shell);

            string_obj* name3 = string_new("");
            expand_macro(string_c_str(name2), name3, sub_shell);
            
            vector_obj* array = hash_item(gArrays, string_c_str(name3));
            if(array) {
                int k;
                for(k=0; k<vector_size(array); k++) {
                    string_obj* str = vector_item(array, k);
                    string_obj* str2 = string_new("");
                    get_quoted_fname(string_c_str(str), str2);
                    string_push_back(cmdline2, string_c_str(str2));
                    string_push_back2(cmdline2, ' ');
                }
            }
            else {
                char* env = getenv(string_c_str(name3));
                
                if(env) {
                    string_obj* env2 = string_new("");
                    get_quoted_fname(env, env2);
                    string_push_back(cmdline2, string_c_str(env2));
                }
            }
        }
        else if(!squote && *p == '$' && *(p+1) != '(') {
            p++;
            
            char name[1024];
            char* p3 = name;
//            while(*p>='a' && *p<='z' || *p>='A' && *p<='Z' || *p>='0' && *p<='9'
//                 || *p == '@' || *p == '#' || *p == '?' || *p == '_')
            while(*p != '\\' && *p != ' ' && *p != '\'' && *p != '"' 
                    && *p != 0 && *p != ';' && *p != '\n' 
                    && *p!='[' && *p!='|' && *p!='/' && *p!=':'
                    && *p !='>' && *p != '<' && *p != '.' && *p !='=' 
                    && *p !='(' && *p !=')' && *p != ',' && *p !='+' && *p != '-'
                    && *p != '~') 
            {
                *p3++ = *p++;
            }
            *p3 = 0;

            /// [ Zq ///
            char number1[1024];
            strcpy(number1, "");
            char number2[1024];
            strcpy(number2, "");

            if(*p == '[') {
                p++;

                char buf[BUFSIZ];
                char* p2 = buf;
                while(1) {
                    if(*p == 0) {
                        err_msg("require ]", sub_shell);
                        return FALSE;
                    }
                    else if(*p == ']') {
                        p++;
                        break;
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;

                string_obj* str = string_new("");
                expand_env(string_new(buf), str, sub_shell);

                string_obj* str2 = string_new("");
                expand_macro(string_c_str(str), str2, sub_shell);

                char* p5 = string_c_str(str2);

                char* p4 = number1;
                while(*p5 >= '0' && *p5 <='9' || *p5 == '-') {
                    *p4++ = *p5++;
                }
                *p4 = 0;

                if(*p5 == '.' && *(p5+1) == '.') {
                    p5+=2;

                    char* p4 = number2;
                    while(*p5 >= '0' && *p5 <='9' || *p5 == '-') {
                        *p4++ = *p5++;
                    }
                    *p4 = 0;
                }
            }
            
            vector_obj* array = hash_item(gArrays, name);
            if(array) {
                int k;
                for(k=0; k<vector_size(array); k++) {
                    string_obj* str = vector_item(array, k);
                    string_obj* str2 = string_new("");
                    get_quoted_fname(string_c_str(str), str2);
                    string_push_back(cmdline2, string_c_str(str2));
                    string_push_back2(cmdline2, ' ');
                }
            }
            else {
                char* env = getenv(name);
                if(env) {
                    if(strcmp(number1, "") == 0 && strcmp(number2, "") == 0) {
                        string_obj* env2 = string_new("");
                        get_quoted_fname(env, env2);
                        string_push_back(cmdline2, string_c_str(env2));
                    }
                    else if(strcmp(number1, "") != 0 && strcmp(number2, "") == 0) {
                        int n = atoi(number1);

                        if(n < 0) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%c", env[strlen(env) + n]);
                            
                            string_obj* env2 = string_new("");
                            get_quoted_fname(buf, env2);
                            string_push_back(cmdline2, string_c_str(env2));
                        }
                        else if(n < strlen(env)) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%c", env[n]);
                            
                            string_obj* env2 = string_new("");
                            get_quoted_fname(buf, env2);
                            string_push_back(cmdline2, string_c_str(env2));
                        }
                    }
                    else {
                        int n = atoi(number1);
                        int n2 = atoi(number2);

                        int m;
                        if(n < 0) {
                            m = strlen(env) + n;
                        }
                        else {
                            m = n;
                        }

                        int m2;
                        if(n2 < 0) {
                            m2 = strlen(env) + n2;
                        }
                        else {
                            m2 = n2;
                        }

                        if(m < m2 && (m >= 0 && m < strlen(env))
                            && (m2 >= 0 && m2 < strlen(env)))
                        {
                            int i;
                            for(i=m; i<=m2; i++) {
                                char buf[BUFSIZ];
                                sprintf(buf, "%c", env[i]);
                                
                                string_obj* env2 = string_new("");
                                get_quoted_fname(buf, env2);
                                string_push_back(cmdline2, string_c_str(env2));
                            }
                        }
                    }
                }
            }
        }
        else if(!squote && *p == '$' && *(p+1) == '(') {
            p++;
            p++;

            char buf[BUFSIZ];
            char* p2 = buf;
            int n = sprintf(buf, "%%Q%%h");
            p2 += n;
            int nest = 0;
            while(1) {
                if(*p == '$' && *(p+1) == '(') {
                    nest++;
                    *p2++ = *p++;
                    *p2++ = *p++;
                }
                else if(*p == '(') {
                    nest++;
                    *p2++ = *p++;
                }
                else if(*p == ')') {
                    if(nest == 0) {
                        p++;
                        break;
                    }
                    nest--;
                    *p2++ = *p++;
                }
                else if(*p == 0) {
                    err_msg("need )", sub_shell);
                    return FALSE;
                }
                else {
                    *p2++ = *p++;
                }
            }
            *p2 = 0;

            int pipefds[2];

            if(pipe(pipefds) < 0) {
                perror("pipe");
                exit(1);
            }

            shell(buf, "expand command", pipefds[1], FALSE, sub_shell, -1);
            string_obj* str = string_new("");

            while(1) {
                int size = read(pipefds[0], buf, BUFSIZ-1);
                if(size == 0) {
                    break;
                }
                if(size < 0) {
                    err_msg("expand command err(read)", sub_shell);
                    close(pipefds[0]);
                    close(pipefds[1]);
                    return FALSE;
                }

                buf[size] = 0;

                string_push_back(str, buf);
            }
            close(pipefds[0]);
            close(pipefds[1]);

            if(string_c_str(str)[string_length(str)-1] == '\n') {
                string_erase(str, string_length(str)-1, 1);
            }

            string_obj* str2 = string_new("");
            if(!expand_env(str, str2, sub_shell)) {
                err_msg("expand env err", sub_shell);
                return FALSE;
            }

            string_obj* env2 = string_new("");
            get_quoted_fname(string_c_str(str2), env2);
            string_push_back(cmdline2, string_c_str(env2));
        }
        else if(!squote && *p == '`') {
            p++;

            char buf[BUFSIZ];
            char* p2 = buf;
            int n = sprintf(buf, "%%Q%%h");
            p2 += n;
            int nest = 0;
            while(1) {
                if(*p == '\\' && *(p+1) == '`') {
                    p+=2;
                    if(nest == 0) {
                        nest++;
                        *p2++ = '`';
                    }
                    else if(nest > 0) {
                        nest--;
                        *p2++ = '`';
                    }
                }
                else if(*p == '`') {
                    p++;
                    break;
                }
                else if(*p == 0) {
                    err_msg("need `", sub_shell);
                    return FALSE;
                }
                else {
                    *p2++ = *p++;
                }
            }
            *p2 = 0;

            int pipefds[2];

            if(pipe(pipefds) < 0) {
                perror("pipe");
                exit(1);
            }

            shell(buf, "expand command"
                , pipefds[1], FALSE, sub_shell, -1);

            string_obj* str = string_new("");

            while(1) {
                int size = read(pipefds[0], buf, BUFSIZ-1);
                if(size == 0) {
                    break;
                }
                if(size < 0) {
                    err_msg("expand command err(read)", sub_shell);
                    close(pipefds[0]);
                    close(pipefds[1]);
                    return FALSE;
                }

                buf[size] = 0;

                string_push_back(str, buf);
            }
            close(pipefds[0]);
            close(pipefds[1]);

            if(string_c_str(str)[string_length(str)-1] == '\n') {
                string_erase(str, string_length(str)-1, 1);
            }

            string_obj* str2 = string_new("");
            if(!expand_env(str, str2, sub_shell)) {
                err_msg("expand env err", sub_shell);
                return FALSE;
            }

            string_obj* env2 = string_new("");
            get_quoted_fname(string_c_str(str2), env2);
            string_push_back(cmdline2, string_c_str(env2));
        }
        else if(squote || dquote) {
            string_push_back2(cmdline2, *p++);
        }
        else {
            string_push_back2(cmdline2, *p++);
        }
    }

    return TRUE;
}

static BOOL expand_special_macro(string_obj* src, string_obj* out, BOOL* hitanykey, BOOL* quick, BOOL* reset_marks, BOOL* append_history, BOOL* change_title, BOOL* screen_mode
    , BOOL* ruby_mode, BOOL* xterm)
{
    char* p = string_c_str(src);

    bool squote = FALSE;
    bool dquote = FALSE;
    while(*p) {
        if(*p == '\\') {
            string_push_back2(out, *p++);

            if(*p) string_push_back2(out, *p++);
        }
        else if(*p == '\'') {
            p++;

            if(!dquote) squote = !squote;

            string_push_back(out, "\'");
        }
        else if(*p == '"') {
            p++;

            if(!squote) dquote = !dquote;

            string_push_back(out, "\"");
        }
        else if(!squote && !dquote && *p == '%') {
            p++;

            if(*p == 'q') {
                p++;
                *hitanykey = FALSE;
            }
            else if(*p == 'Q') {
                p++;
                *quick = TRUE;
                *hitanykey = FALSE;
            }
            else if(*p == 'o') {
                p++;
                *reset_marks = FALSE;
            }
            else if(*p == 'h') {
                p++;
                *append_history = FALSE;
            }
            else if(*p == 'i') {
                p++;
                *change_title = FALSE;
            }
            else if(*p == 's') {
                p++;
                *screen_mode = TRUE;
            }
            else if(*p == 'r') {
                p++;
                *ruby_mode = TRUE;
            }
            else if(*p == 't') {
                p++;
                *xterm = TRUE;
            }
            else {
                string_push_back(out, "%");
            }
        }
        else {
            string_push_back2(out, *p++);
        }
    }

    return TRUE;
}

BOOL is_space(char c)
{
    if(c == ' ' || c == '\n' || c == ';' || c == '\t' || c == 0) {
        return TRUE;
    }
    else {
        return FALSE;
    }
}

static BOOL get_one_line(char** p, string_obj* line, BOOL sub_shell) 
{
    BOOL squote = FALSE;
    BOOL dquote = FALSE;

    while(**p == ' ' || **p == '\n' || **p == ';' || **p == '\t') {
        string_push_back2(line, **p);
        (*p)++;
    }

    if(**p == 'f' && *(*p+1) == 'o' && *(*p+2) == 'r'
        && is_space(*(*p+3))) 
    {
        (*p)+=3;
        string_push_back2(line, 'f');
        string_push_back2(line, 'o');
        string_push_back2(line, 'r');

        int nest = 0;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(1) {
            if(**p == '\\') {
                (*p)++;
                string_push_back2(line, '\\');

                if(**p) {
                    string_push_back2(line, **p);
                    (*p)++;
                }
            }
            else if(!dquote && **p == '\'') {
                (*p)++;
                squote = !squote;

                string_push_back(line, "'");
            }
            else if(!squote && **p == '"') {
                (*p)++;
                dquote = !dquote;

                string_push_back(line, "\"");
            }
            else if(squote || dquote) {
                string_push_back2(line, **p);
                (*p)++;
            }
            else if(is_space(**p) && *(*p+1) == 'w' && *(*p+2) == 'h' 
                && *(*p+3) == 'i' && *(*p+4) == 'l' && *(*p+5) == 'e'
                && is_space(*(*p+6))) 
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'w');
                string_push_back2(line, 'h');
                string_push_back2(line, 'i');
                string_push_back2(line, 'l');
                string_push_back2(line, 'e');

                (*p)+=6;

                nest++;
            }
            else if(is_space(**p) 
                    && *(*p+1) == 'f' && *(*p+2) == 'o' && *(*p+3) == 'r'
                    && is_space(*(*p+4)))
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'f');
                string_push_back2(line, 'o');
                string_push_back2(line, 'r');

                (*p)+=4;

                nest++;
            }
            else if(is_space(**p) && *(*p+1) == 'd' && *(*p+2) == 'o' 
                    && *(*p+3) == 'n' && *(*p+4) == 'e'
                    && is_space(*(*p+5)))
            {
                string_push_back2(line, **p);
                
                string_push_back2(line, 'd');
                string_push_back2(line, 'o');
                string_push_back2(line, 'n');
                string_push_back2(line, 'e');

                (*p)+=5;

                if(nest == 0) break;
                nest--;
            }
            else if(**p == 0) {
                err_msg("sytax err: for statment require done", sub_shell);
                return FALSE;
            }
            else {
                string_push_back2(line, **p);
                (*p)++;
            }
        }
    }
    else if(**p == 'i' && *(*p+1) == 'f' && is_space(*(*p+2))) 
    {
        (*p)+=2;
        string_push_back2(line, 'i');
        string_push_back2(line, 'f');

        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        int nest = 0;
        while(1) {
            if(**p == '\\') {
                (*p)++;
                string_push_back2(line, '\\');

                if(**p) {
                    string_push_back2(line, **p);
                    (*p)++;
                }
            }
            else if(!dquote && **p == '\'') {
                (*p)++;
                squote = !squote;

                string_push_back(line, "'");
            }
            else if(!squote && **p == '"') {
                (*p)++;
                dquote = !dquote;

                string_push_back(line, "\"");
            }
            else if(squote || dquote) {
                string_push_back2(line, **p);
                (*p)++;
            }
            else if(is_space(**p) 
                && *(*p+1) == 'i' && *(*p+2) == 'f' && is_space(*(*p+3))) 
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'i');
                string_push_back2(line, 'f');

                (*p)+=3;

                nest++;
            }
            else if(is_space(**p) 
                && *(*p+1) == 'f' && *(*p+2) == 'i' && is_space(*(*p+3)))
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'f');
                string_push_back2(line, 'i');

                (*p)+=3;

                if(nest == 0) break;
                nest--;
            }
            else if(**p == 0) {
                err_msg("sytax err: if statment require fi", sub_shell);
                return FALSE;
            }
            else {
                string_push_back2(line, **p);
                (*p)++;
            }
        }
    }
    else if(**p == 'f' && *(*p+1) == 'u' && *(*p+2) == 'n' 
            && *(*p+3) == 'c' && *(*p+4) == 't' && *(*p+5) == 'i'
            && *(*p+6) == 'o' && *(*p+7) == 'n'
            && is_space(*(*p+8))) 
    {
        (*p)+=8;
        string_push_back(line, "function");

        while(**p != '{') {
            if(**p == 0) {
                err_msg("syntax err: function require {", sub_shell);
                return FALSE;
            }

            string_push_back2(line, **p);
            (*p)++;
        }
        string_push_back(line, "{");
        (*p)++;

        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        int nest = 0;
        while(1) {
            if(**p == '\\') {
                (*p)++;
                string_push_back2(line, '\\');

                if(**p) {
                    string_push_back2(line, **p);
                    (*p)++;
                }
            }
            else if(!dquote && **p == '\'') {
                (*p)++;
                squote = !squote;

                string_push_back(line, "'");
            }
            else if(!squote && **p == '"') {
                (*p)++;
                dquote = !dquote;

                string_push_back(line, "\"");
            }
            else if(squote || dquote) {
                string_push_back2(line, **p);
                (*p)++;
            }
            else if(**p == '{') {
                (*p)++;

                string_push_back2(line, '{');

                nest++;
            }
            else if(**p == '}') {
                (*p)++;

                string_push_back2(line, '}');

                if(nest == 0) break;
                nest--;
            }
            else if(**p == 0) {
                err_msg("sytax err: function require }", sub_shell);
                return FALSE;
            }
            else {
                string_push_back2(line, **p);
                (*p)++;
            }
        }
    }
    else if(**p == 'w' && *(*p+1) == 'h' && *(*p+2) == 'i' 
            && *(*p+3) == 'l' && *(*p+4) == 'e' && is_space(*(*p+5)))
    {
        (*p)+=5;

        string_push_back2(line, 'w');
        string_push_back2(line, 'h');
        string_push_back2(line, 'i');
        string_push_back2(line, 'l');
        string_push_back2(line, 'e');

        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        int nest = 0;
        while(1) {
            if(**p == '\\') {
                (*p)++;
                string_push_back2(line, '\\');

                if(**p) {
                    string_push_back2(line, **p);
                    (*p)++;
                }
            }
            else if(!dquote && **p == '\'') {
                (*p)++;
                squote = !squote;

                string_push_back(line, "'");
            }
            else if(!squote && **p == '"') {
                (*p)++;
                dquote = !dquote;

                string_push_back(line, "\"");
            }
            else if(squote || dquote) {
                string_push_back2(line, **p);
                (*p)++;
            }
            else if(is_space(**p) && *(*p+1) == 'w' && *(*p+2) == 'h' 
                && *(*p+3) == 'i' && *(*p+4) == 'l' && *(*p+5) == 'e'
                && is_space(*(*p+6))) 
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'w');
                string_push_back2(line, 'h');
                string_push_back2(line, 'i');
                string_push_back2(line, 'l');
                string_push_back2(line, 'e');

                (*p)+=6;

                nest++;
            }
            else if(is_space(**p) 
                    && *(*p+1) == 'f' && *(*p+2) == 'o' && *(*p+3) == 'r'
                    && is_space(*(*p+4)))
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'f');
                string_push_back2(line, 'o');
                string_push_back2(line, 'r');

                (*p)+=4;

                nest++;
            }
            else if(is_space(**p) && *(*p+1) == 'd' && *(*p+2) == 'o' 
                    && *(*p+3) == 'n' && *(*p+4) == 'e'
                    && is_space(*(*p+5)))
            {
                string_push_back2(line, **p);
                string_push_back2(line, 'd');
                string_push_back2(line, 'o');
                string_push_back2(line, 'n');
                string_push_back2(line, 'e');

                (*p)+=5;

                if(nest == 0) break;
                nest--;
            }
            else if(**p == 0) {
                err_msg("sytax err: if statment require done", sub_shell);
                return FALSE;
            }
            else {
                string_push_back2(line, **p);
                (*p)++;
            }
        }
    }
    else {
        while(**p) {
            if(**p == '\\') {
                (*p)++;
                string_push_back2(line, '\\');

                if(**p) {
                    string_push_back2(line, **p);
                    (*p)++;
                }
            }
            else if(!dquote && **p == '\'') {
                (*p)++;
                squote = !squote;

                string_push_back(line, "'");
            }
            else if(!squote && **p == '"') {
                (*p)++;
                dquote = !dquote;

                string_push_back(line, "\"");
            }
            else if(squote || dquote) {
                string_push_back2(line, **p);
                (*p)++;

            }
            else if(**p == '`') {
                string_push_back2(line, **p);
                (*p)++;
                
                BOOL squote2 = FALSE;
                BOOL dquote2 = FALSE;
                int nest = 0;
                while(**p) {
                    if(**p == '\\') {
                        (*p)++;
                        string_push_back2(line, '\\');

                        if(**p) {
                            string_push_back2(line, **p);
                            (*p)++;
                        }
                    }
                    else if(!dquote2 && **p == '\'') {
                        (*p)++;
                        squote2 = !squote2;

                        string_push_back(line, "'");
                    }
                    else if(!squote2 && **p == '"') {
                        (*p)++;
                        dquote2 = !dquote2;

                        string_push_back(line, "\"");
                    }
                    else if(squote2 || dquote2) {
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                    else if(**p == '`') {
                        string_push_back2(line, **p);
                        (*p)++;
                        if(nest == 0) {
                            break;
                        }
                        nest--;
                    }
                    else {
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                }
            }
            else if(**p == '(') {
                string_push_back2(line, **p);
                (*p)++;

                BOOL squote2 = FALSE;
                BOOL dquote2 = FALSE;
                int nest = 0;
                while(**p) {
                    if(**p == '\\') {
                        (*p)++;
                        string_push_back2(line, '\\');

                        if(**p) {
                            string_push_back2(line, **p);
                            (*p)++;
                        }
                    }
                    else if(!dquote2 && **p == '\'') {
                        (*p)++;
                        squote2 = !squote2;

                        string_push_back(line, "'");
                    }
                    else if(!squote2 && **p == '"') {
                        (*p)++;
                        dquote2 = !dquote2;

                        string_push_back(line, "\"");
                    }
                    else if(**p == '(') {
                        string_push_back2(line, **p);
                        (*p)++;
                        nest++;
                    }
                    else if(**p == ')') {
                        string_push_back2(line, **p);
                        (*p)++;
                        if(nest == 0) {
                            break;
                        }
                        nest--;
                    }
                    else {
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                }
            }
            else if(**p == '&' && *(*p+1) == '&') {
                (*p)+=2;
                string_push_back2(line, '&');
                string_push_back2(line, '&');
                break;
            }
            else if(**p == '|' && *(*p+1) == '|') {
                (*p)+=2;
                string_push_back2(line, '|');
                string_push_back2(line, '|');
                break;
            }
            else if(*(*p-1) != '$' && **p == '#') {
                while(**p) {
                    if(**p == '\n' || **p == 0) {
                        break;
                    }
                    else {
                        (*p)++;
                    }
                }
            }
            else if(**p == '<' && *(*p+1) == '<') {
                (*p)+=2;

                string_push_back2(line, '<');
                string_push_back2(line, '<');

                while(1) {
                    if(**p == ' ' || **p == '\t') {
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                    else {
                        break;
                    }
                }

                char str[BUFSIZ];
                char* p2 = str;
                while(1) {
                    if(**p == '\n') {
                        string_push_back2(line, **p);
                        (*p)++;
                        break;
                    }
                    else if(**p == 0) {
                        break;
                    }
                    else {
                        *p2++ = **p;
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                }
                *p2 = 0;

                char line2[BUFSIZ];
                p2 = line2;
                while(1) {
                    if(**p == 0) {
                        break;
                    }
                    else if(**p == '\n') {
                        string_push_back2(line, **p);
                        (*p)++;

                        *p2 = 0;
                        p2 = line2;

                        if(strcmp(line2, str) == 0) {
                            break;
                        }
                    }
                    else {
                        *p2++ = **p;
                        string_push_back2(line, **p);
                        (*p)++;
                    }
                }
                break;
            }
            else if(**p == ';' || **p == '\n') {
                string_push_back2(line, **p);
                (*p)++;
                break;
            }
            else {
                string_push_back2(line, **p);
                (*p)++;
            }
        }
    }


    return TRUE;
}

static BOOL parse(char* p, sStatment* statment, BOOL sub_shell)
{
    while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
        p++;
    }
    
    if(strcmp(p, "") == 0) {
        return TRUE;
    }

    vector_obj* argv = vector_new(10);
    vector_obj* redirections = vector_new(10);

    string_obj* buf = string_new("");
    BOOL next_is_rfname = FALSE;
    sRedirect* redirection;
    BOOL flg_subshell = FALSE;

    BOOL oror = FALSE;
    BOOL andand = FALSE;

    if(*p == 'b' && *(p+1) == 'r' && *(p+2) == 'e' && *(p+3) == 'a'
        && *(p+4) == 'k'
        && is_space(*(p+5))) 
    {
        p+=5;

        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before break", sub_shell);
            return FALSE;
        }

        vector_add(statment->argvs, NULL);
        vector_add(statment->redirections_list, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->kinds, (void*)kBreak);
        vector_add(statment->extras, NULL);
    }
    else if(*p == 'r' && *(p+1) == 'e' && *(p+2) == 't' && *(p+3) == 'u'
        && *(p+4) == 'r' && *(p+5) == 'n' && is_space(*(p+6))) 
    {
        p+=6;

        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before return", sub_shell);
            return FALSE;
        }

        vector_add(statment->argvs, NULL);
        vector_add(statment->redirections_list, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->kinds, (void*)kReturn);
        vector_add(statment->extras, NULL);
    }
    else if(*p == 'f' && *(p+1) == 'o' && *(p+2) == 'r' && is_space(*(p+3))) {
        p+=3;

        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before for", sub_shell);
            return FALSE;
        }

        while(*p == ' ' || *p == '\t') {
            p++;
        }

        sFor* extra = sFor_new();

        /// ϐ𓾂 ///
        while(*p && *p != ' ' && *p != '\t') {
            string_push_back2(extra->var_name, *p++);
        }

        while(*p == ' ' || *p == '\t') {
            p++;
        }

        /// in ///
        if(*p != 'i' || *(p+1) != 'n') {
            err_msg("syntax err: for require in", sub_shell);
            return FALSE;
        }

        p+=2;

        while(*p == ' ' || *p == '\t') {
            p++;
        }

        /// ̃Xg ///
        string_obj* str = string_new("%Q%h echo ");

        if(!get_one_line(&p, str, sub_shell)) {
            err_msg("for get_one_line: err", sub_shell);
            return FALSE;
        }
        

        static int gForCommandNum = 0;

        int pipefds[2];

        if(pipe(pipefds) < 0) {
            perror("pipe");
            exit(1);
        }

        shell(string_c_str(str), NULL, pipefds[1], FALSE
                            , sub_shell, -1);

        string_obj* result = string_new("");

        char  buf2[BUFSIZ];
        while(1) {
            int size = read(pipefds[0], buf2, BUFSIZ-1);
            if(size == 0) {
                break;
            }
            if(size < 0) {
                err_msg("expand command err(read)", sub_shell);
                close(pipefds[0]);
                close(pipefds[1]);
                return FALSE;
            }

            buf2[size] = 0;

            string_push_back(result, buf2);
        }
        close(pipefds[0]);
        close(pipefds[1]);
        
        char* p2 = string_c_str(result);
        string_obj* str2 = string_new("");
        while(*p2) {
            if(*p2 == ' ' || *p2 == '\t' || *p2 == '\n') {
                while(*p2 == ' ' || *p2 == '\t' || *p2 == '\n') {
                    p2++;
                }

                vector_add(extra->strings, str2);
                str2 = string_new("");
            }
            else {
                string_push_back2(str2, *p2++);
            }
        }

        if(strcmp(string_c_str(str2), "") != 0) {
            vector_add(extra->strings, str2);
        }

        while(*p == ' ' || *p == '\t' || *p == '\n') {
            p++;
        }

        if(*p != 'd' || *(p+1) != 'o' && is_space(*(p+2))) {
            err_msg("syntax err: for require do", sub_shell);
            return FALSE;
        }
        p+=2;
        
        /// s𓾂 ///
        while(1) {
            string_obj* statment = string_new("");

            if(!get_one_line(&p, statment, sub_shell)) {
                err_msg("for get_one_line: err", sub_shell);
                return FALSE;
            }

            vector_add(extra->statments, statment);

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }

            if(*p == 'd' && *(p+1) == 'o' && *(p+2) == 'n'
                    && *(p+3) == 'e' && is_space(*(p+4)))
            {
                p+=4;
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err for require done", sub_shell);
                return FALSE;
            }
        }

        vector_add(statment->argvs, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->redirections_list, NULL);
        vector_add(statment->kinds, (void*)kFor);
        vector_add(statment->extras, (void*)extra);
    }
    else if(*p == 'i' && *(p+1) == 'f' && is_space(*(p+2))) {
        p+=2;

        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before if", sub_shell);
            return FALSE;
        }

        sIf* extra = sIf_new();

        /// 𓾂 ///
        vector_obj* conditionals = vector_new(10);
        while(1) {
            string_obj* conditional = string_new("");

            if(!get_one_line(&p, conditional, sub_shell)) {
                err_msg("if conditional get_one_line err", sub_shell);
                return FALSE;
            }

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }

            vector_add(conditionals, conditional);

            if(*p == 't' && *(p+1) == 'h' 
                && *(p+2) == 'e' && *(p+3) == 'n' && is_space(*(p+4))) 
            {
                p+=4;
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err if(conditional1-2)", sub_shell);
                return FALSE;
            }
        }

        vector_add(extra->conditionals_list, conditionals);
        
        /// s𓾂 ///
        vector_obj* statments = vector_new(10);
        while(1) {
            string_obj* statment = string_new("");

            if(!get_one_line(&p, statment, sub_shell)) {
                err_msg("get_one_line: err", sub_shell);
                return FALSE;
            }

            vector_add(statments, statment);

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }

            if(*p == 'f' && *(p+1) == 'i' && is_space(*(p+2))) {
                break;
            }
            else if(*p == 'e' && *(p+1) == 'l' && *(p+2) == 's'
                    && *(p+3) == 'e' && is_space(*(p+4))) 
            {
                break;
            }
            else if(*p == 'e' && *(p+1) == 'l' && *(p+2) == 'i'
                    && *(p+3) == 'f' && is_space(*(p+4))) 
            {
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err if(statment1-2)", sub_shell);
                return FALSE;
            }
        }

        vector_add(extra->statments_list, statments);

        /// elif ///
        while(*p == 'e' && *(p+1) == 'l' 
                    && *(p+2) == 'i' && *(p+3) == 'f' && is_space(*(p+4))) 
        {
            p+=4;

            /// 𓾂 ///
            vector_obj* conditionals = vector_new(10);
            while(1) {
                string_obj* conditional = string_new("");
                if(!get_one_line(&p, conditional, sub_shell)) {
                    err_msg("get_one_line: err", sub_shell);
                    return FALSE;
                }
                vector_add(conditionals, conditional);

                while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                    p++;
                }
                
                if(*p == 't' && *(p+1) == 'h' 
                    && *(p+2) == 'e' && *(p+3) == 'n' && is_space(*(p+4))) 
                {
                    p+=4;
                    break;
                }
                else if(*p == 0) {
                    err_msg("syntax err elif(conditonal2)", sub_shell);
                    return FALSE;
                }
            }

            vector_add(extra->conditionals_list, conditionals);
            
            /// s𓾂 ///
            vector_obj* statments = vector_new(10);
            while(1) {
                string_obj* statment = string_new("");
                if(!get_one_line(&p, statment, sub_shell)) {
                    err_msg("get_one_line: err", sub_shell);
                    return FALSE;
                }

                vector_add(statments, statment);

                while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                    p++;
                }

                if(*p == 'f' && *(p+1) == 'i' && is_space(*(p+2))) {
                    break;
                }
                else if(*p == 'e' && *(p+1) == 'l' && *(p+2) == 's'
                        && *(p+3) == 'e' && is_space(*(p+4))) 
                {
                    break;
                }
                else if(*p == 'e' && *(p+1) == 'l' && *(p+2) == 'i'
                        && *(p+3) == 'f' && is_space(*(p+4))) 
                {
                    break;
                }
                else if(*p == 0) {
                    err_msg("syntax err elif(statmenent2)", sub_shell);
                    return FALSE;
                }
            }

            vector_add(extra->statments_list, statments);

            if(*p == 'f' && *(p+1) == 'i' && is_space(*(p+2))) {
                break;
            }
            else if(*p == 'e' && *(p+2) == 'l' && *(p+3) == 's'
                    && *(p+4) == 'e' && is_space(*(p+5))) 
            {
                break;
            }
        }

        /// else ///
        if(*p == 'f' && *(p+1) == 'i' && is_space(*(p+2))) {
            p+=2;
        }
        else if(*p == 'e' && *(p+1) == 'l' 
                && *(p+2) == 's' && *(p+3) == 'e' && is_space(*(p+4))) 
        {
            p+=4;

            vector_add(extra->conditionals_list, (void*)NULL);

            /// s𓾂 ///
            vector_obj* statments = vector_new(10);
            while(1) {
                string_obj* statment = string_new("");
                if(!get_one_line(&p, statment, sub_shell)) {
                    err_msg("get_one_line: err", sub_shell);
                    return FALSE;
                }

                vector_add(statments, statment);

                while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                    p++;
                }

                if(*p == 'f' && *(p+1) == 'i' && is_space(*(p+2))) {
                    p+=2;
                    break;
                }
                else if(*p == 0) {
                    err_msg("syntax err else(statment2) require fi"
                        , sub_shell);
                    return FALSE;
                }
            }

            vector_add(extra->statments_list, statments);
        }
        else {
            err_msg("syntax err require fi", sub_shell);
        }

        vector_add(statment->argvs, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->redirections_list, NULL);
        vector_add(statment->kinds, (void*)kIf);
        vector_add(statment->extras, (void*)extra);
    }
    else if(*p == 'f' && *(p+1) == 'u' && *(p+2) == 'n' && *(p+3) == 'c' && 
            *(p+4) == 't' && *(p+5) == 'i' && *(p+6) == 'o' && *(p+7) == 'n'
             && is_space(*(p+8)))
    {
        p+=8;
        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before function", sub_shell);
            return FALSE;
        }
        
        sFunction* extra = sFunction_new();

        while(*p == ' ' || *p == '\t' || *p == '\n') {
            p++;
        }

        while(*p != 0 && *p != ' ' && *p != '\t' && *p != '\n') {
            string_push_back2(extra->func_name, *p++);
        }

        while(*p == ' ' || *p == '\t' || *p == '\n') {
            p++;
        }

        if(*p != '{') {
            err_msg("function require {", sub_shell);
        }
        p++;

        while(TRUE) {
            string_obj* statment = string_new("");
            if(!get_one_line(&p, statment, sub_shell)) {
                err_msg("get_one_line: err", sub_shell);
                return FALSE;
            }
            vector_add(extra->statments, statment);

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }
            
            if(*p == '}') {
                p++;
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err: function require }", sub_shell);
                return FALSE;
            }
        }
        
        vector_add(statment->argvs, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->redirections_list, NULL);
        vector_add(statment->kinds, (void*)kFunction);
        vector_add(statment->extras, (void*)extra);
    }
    else if(*p == 'w' && *(p+1) == 'h'
        && *(p+2) == 'i' && *(p+3) == 'l'  && *(p+4) == 'e'
        && is_space(*(p+5)))
    {
        p+=5;

        if(strcmp(string_c_str(buf), "") != 0) {
            err_msg("syntax err: before while", sub_shell);
            return FALSE;
        }

        sWhile* extra = sWhile_new();

        /// 𓾂 ///
        while(1) {
            string_obj* conditional = string_new("");
            if(!get_one_line(&p, conditional, sub_shell)) {
                err_msg("get_one_line: err", sub_shell);
                return FALSE;
            }

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }

            vector_add(extra->conditionals, conditional);

            if(*p == 'd' && *(p+1) == 'o' && is_space(*(p+2)))
            {
                p+=2;
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err while(conditional1-2)", sub_shell);
                return FALSE;
            }
        }
        
        /// s𓾂 ///
        while(1) {
            string_obj* statment = string_new("");
            if(!get_one_line(&p, statment, sub_shell)) {
                err_msg("get_one_line: err", sub_shell);
                return FALSE;
            }

            vector_add(extra->statments, statment);

            while(*p == ' ' || *p == '\t' || *p == '\n' || *p == ';') {
                p++;
            }
            
            if(*p == 'd' && *(p+1) == 'o' && *(p+2) == 'n' && *(p+3) == 'e'
                && is_space(*(p+4))) 
            {
                break;
            }
            else if(*p == 0) {
                err_msg("syntax err while(statment1-2) require done"
                            , sub_shell);
                return FALSE;
            }
        }

        vector_add(statment->argvs, NULL);
        statment->terminated = kTNormal;
        vector_add(statment->redirections_list, NULL);
        vector_add(statment->kinds, (void*)kWhile);
        vector_add(statment->extras, (void*)extra);
    }
    else {
        //BOOL expand_cmd1 = FALSE;
        //int expand_cmd2 = FALSE;
        BOOL squote = FALSE;
        BOOL dquote = FALSE;
        while(*p) {
            if(*p == '\\' && (squote && *(p+1)!='\'' || dquote && *(p+1)!='"'))
            {
                string_push_back2(buf, *p++);
            }
            else if(*p == '\\') {
                p++;

                if(*p) string_push_back2(buf, *p++);
            }
            else if(!dquote && *p == '\'' && *(p+1) == '\'') {
                p+=2;

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else {
                        if(flg_subshell) {
                            err_msg("syntax err: after subshell", sub_shell);
                            return FALSE;
                        }

                        vector_add(argv, string_new(string_c_str(buf)));
                    }
                    buf = string_new("");
                }
                else {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, "");
                    }
                    else {
                        vector_add(argv, string_new(""));
                    }
                    buf = string_new("");
                }
            }
            else if(!squote && *p == '"' && *(p+1) == '"') {
                p+=2;

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else {
                        if(flg_subshell) {
                            err_msg("syntax err: after subshell", sub_shell);
                            return FALSE;
                        }

                        vector_add(argv, string_new(string_c_str(buf)));
                    }
                    buf = string_new("");
                }
                else {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, "");
                    }
                    else {
                        vector_add(argv, string_new(""));
                    }
                    buf = string_new("");
                }
            }
            else if(!dquote && *p == '\'') {
                p++;
                squote = !squote;
            }
            else if(!squote && *p == '"') {
                p++;
                dquote = !dquote;
            }
            else if(squote || dquote) {
            //else if(squote || dquote || expand_cmd1 || expand_cmd2 > 0) {
                string_push_back2(buf, *p++);
            }
            else if(*p == '=' && *(p+1) =='~') {
                p+=2;
                string_push_back(buf, "=~");
            }
            else if(*p == '~' && (*(p+1) == 0 || *(p+1) == ' ' || *(p+1) == '/')) {
                p++;
                
                char* home = getenv("HOME");
                if(home == NULL) {
                    fprintf(stderr, "$HOME is null");
                    exit(1);
                }
                
                char* p3 = home;
                while(*p3) {
                    string_push_back2(buf, *p3++);
                }
            }
            else if(*p == '*' || *p == '?' || *p == '[' || *p == '{') {
                char pattern[BUFSIZ];
                char* p2 = pattern;

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        err_msg("syntax err: after redirect", sub_shell);
                        return FALSE;
                    }
                    else {
                        char* p3 = string_c_str(buf);

                        while(*p3) {
                            *p2++ = *p3++;
                        }

                        buf = string_new("");
                    }
                }

                while(*p != 0 && *p != ' ' && *p != '\t') {
                    *p2++ = *p++;
                }
                *p2 = 0;

                glob_t result;
                int rc = glob(pattern, 0, NULL, &result);
                if(rc == GLOB_NOSPACE) {
                    err_msg("out of space during glob operation", sub_shell);
                    return FALSE;
                }
                else if(rc == GLOB_NOMATCH) {
                    vector_add(argv, string_new(pattern));
                }
                else {
                    int i;
                    for(i=0; i<result.gl_pathc; i++) {
                        vector_add(argv, string_new(result.gl_pathv[i]));
                    }
                }
            }
            else if(*p == '&' && *(p+1) == '&') {
                p+=2;
                andand = TRUE;
                break;
            }
            else if(*p == '|' && *(p+1) == '|') {
                p+=2;
                oror = TRUE;
                break;
            }
            else if(*p == ';' || *p == '\n') {
                p++;
                break;
            }
            else if(*p == ' ' || *p == '\t') {
                while(*p == ' ' || *p == '\t') {
                    p++;
                }

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else {
                        if(flg_subshell) {
                            err_msg("syntax err: after subshell", sub_shell);
                            return FALSE;
                        }

                        vector_add(argv, string_new(string_c_str(buf)));
                    }
                }
                buf = string_new("");
            }
            else if(*p == '(') {
                p++;

                if(strcmp(string_c_str(buf), "") != 0 || vector_size(argv) != 0) {
                    err_msg("syntax err near unexpected token '('", sub_shell);
                    int j;
                    for(j=0; j<vector_size(argv); j++) {
                        err_msg(string_c_str(vector_item(argv, j)), sub_shell);
                    }
                    return FALSE;
                }

                char buf[BUFSIZ];
                char* p2 = buf;
                int nest = 0;
                while(1) {
                    if(*p == '(') {
                        nest++;
                        *p2++ = *p++;
                    }
                    else if(*p == ')') {
                        if(nest == 0) {
                            p++;
                            break;
                        }
                        nest--;
                        *p2++ = *p++;
                    }
                    else if(*p == 0) {
                        err_msg("need )", sub_shell);
                        return FALSE;
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;

                vector_add(argv, string_new("mfiler3"));
                vector_add(argv, string_new("-c"));
                vector_add(argv, string_new(buf));

                flg_subshell = TRUE;
            }

            else if(*p == '&' && *(p+1) != '&') {
                p++;
                statment->background = TRUE;

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else
                        vector_add(argv, string_new(string_c_str(buf)));
                }
                buf = string_new("");
            }
            else if(*p == '|' && *(p+1) != '|') {
                p++;
                
                while(*p == ' ' || *p == '\t') {
                    p++;
                }

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else {
                        if(flg_subshell) {
                            err_msg("syntax err: after subshell", sub_shell);
                            return FALSE;
                        }

                        vector_add(argv, string_new(string_c_str(buf)));
                    }
                }
                buf = string_new("");
                
                if(vector_size(argv) == 0) return FALSE;
                vector_add(statment->argvs, argv);
                argv = vector_new(10);
                flg_subshell = FALSE;
                
                if(next_is_rfname) return FALSE;
                vector_add(statment->redirections_list, redirections);
                redirections = vector_new(10);

                vector_add(statment->kinds, (void*)kNormal);
                vector_add(statment->extras, (void*)NULL);
            }
            else if(*p == '2' && *(p+1) == '>' && *(p+2) == '1') {
                p+=3;
                redirection = sRedirect_new();
                
                redirection->mType = kRedirectErrAndOutput;

                vector_add(redirections, redirection);
            }
            else if(*p == '<' && *(p+1) == '<') {
                p+=2;

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else {
                        if(flg_subshell) {
                            err_msg("syntax err: after subshell", sub_shell);
                            return FALSE;
                        }

                        vector_add(argv, string_new(string_c_str(buf)));
                    }
                }
                buf = string_new("");
                
                if(vector_size(argv) == 0) return FALSE;
                vector_add(statment->argvs, argv);
                argv = vector_new(10);
                flg_subshell = FALSE;
                
                if(next_is_rfname) return FALSE;
                vector_add(statment->redirections_list, redirections);
                redirections = vector_new(10);

                vector_add(statment->kinds, (void*)kNormal);
                vector_add(statment->extras, (void*)NULL);

                while(1) {
                    if(*p == ' ' || *p == '\t') {
                        p++;
                    }
                    else if(*p == 0 || *p == '\n') {
                        p++;
                        err_msg("require string for <<", sub_shell);
                        return FALSE;
                    }
                    else {
                        break;
                    }
                }

                char str[BUFSIZ];
                char* p2 = str;
                while(1) {
                    if(*p == '\n') {
                        p++;
                        break;
                    }
                    else if(*p == 0) {
                        p++;
                        err_msg("require string2 for <<", sub_shell);
                        return FALSE;
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;

                string_obj* lines = string_new("");
                char line[BUFSIZ];
                p2 = line;
                while(1) {
                    if(*p == 0) {
                        *p2 = 0;

                        if(strcmp(line, str) != 0) {
                            char tmp[BUFSIZ];
                            sprintf(tmp, "require %s for <<", str);
                            err_msg(tmp, sub_shell);
                            return FALSE;
                        }
                        else {
                            break;
                        }
                    }
                    else if(*p == '\n') {
                        p++;

                        *p2 = 0;
                        p2 = line;

                        if(strcmp(line, str) == 0) {
                            break;
                        }
                        string_push_back(lines, line);
                        string_push_back2(lines, '\n');
                    }
                    else {
                        *p2++ = *p++;
                    }
                }

                string_put(statment->here_document, string_c_str(lines));
            }
            else if( (*p == '1' && *(p+1) == '>') 
                        || (*p == '1' && *(p+1) == '>' && *(p+2) == '>') 
                        || (*p == '2' && *(p+1) == '>') 
                        || (*p == '2' && *(p+1) == '>' && *(p+2) == '>') 
                        || (*p == '>' && *(p+1) == '>')
                        || *p =='>' 
                        || *p =='<'
                        ) 
           {
                if(strcmp(string_c_str(buf), "") != 0) {
                    if(next_is_rfname) {
                        next_is_rfname = FALSE;
                        strcpy(redirection->mFName, string_c_str(buf));
                    }
                    else
                        vector_add(argv, string_new(string_c_str(buf)));
                }
                buf = string_new("");
                
                int fd;
                enum eRedirect type;
                
                if(*p == '1' && *(p+1) == '>') {
                    p+=2;
                    
                    fd = 1;
                    type = kRedirectOverwrite;
                }
                else if(*p == '1' && *(p+1) == '>' && *(p+2) == '>') {
                    p+=3;
                    
                    fd = 1;
                    type = kRedirectAppend;
                }
                else if(*p == '2' && *(p+1) == '>') {
                    p+=2;
                    
                    fd = 2;
                    type = kRedirectOverwrite;
                }
                else if(*p == '2' && *(p+1) == '>' && *(p+2) == '>') {
                    p+=3;
                    
                    fd = 2;
                    type = kRedirectAppend;
                }
                else if(*p == '>' && *(p+1) == '>') {
                    p+=2;
                    
                    fd = 1;
                    type = kRedirectAppend;
                }
                else if(*p =='>') {
                    p++;
                    
                    fd = 1;
                    type = kRedirectOverwrite;
                }
                else {
                    p++;
                    
                    fd = 0;
                    type = kRedirectInput;
                }
                
                while(*p == ' ' || *p == '\t') {
                    p++;
                }
                
                redirection = sRedirect_new();
                
                redirection->mType = type;
                redirection->mFd = fd;
                
                next_is_rfname = TRUE;
                
                vector_add(redirections, redirection);
            }
            else {
                string_push_back2(buf, *p++);
            }
        }
    }
    
    if(strcmp(string_c_str(buf), "") != 0) {
        if(next_is_rfname) {
            next_is_rfname = FALSE;
            strcpy(redirection->mFName, string_c_str(buf));
        }
        else {
            if(flg_subshell) {
                err_msg("syntax err: after subshell", sub_shell);
                return FALSE;
            }
            vector_add(argv, string_new(string_c_str(buf)));
        }
    }
    
    if(vector_size(argv) > 0) {
        vector_add(statment->argvs, argv);
        
        if(next_is_rfname) {
            err_msg("require redirect file name", sub_shell);
            return FALSE;
        }
        vector_add(statment->redirections_list, redirections);
        if(andand) {
            statment->terminated = kAndAnd;
        }
        else if(oror) {
            statment->terminated = kOrOr;
        }
        else {
            statment->terminated = kTNormal;
        }
        vector_add(statment->kinds, (void*)kNormal);
        vector_add(statment->extras, (void*)NULL);
    }

    return TRUE;
}

int get_node(char** p) 
{
    int value = 0;
    while(**p == ' ' || **p == '\n' || **p == '\t') {
        (*p)++;
    }

    int keta = 1;
    char* tmp = *p;
    while(*tmp >= '0' && *tmp <= '9') {
        keta = keta * 10;
        tmp++;
    }

    keta = keta / 10;

    while(**p >= '0' && **p <= '9') {
        value = value + keta * (**p-'0');
        keta = keta / 10;
        (*p)++;
    }

    while(**p == ' ' || **p == '\n' || **p == '\t') {
        (*p)++;
    }

    return value;
}

int calculate(char* p, int sub_shell) 
{
    int value = 0;
    while(*p) {
        if(*p == ' ' || *p == '\t' || *p == '\n') {
            p++;
        }
        else if(*p >= '0' && *p <= '9') {
            value = get_node(&p);
        }
        else if(*p == '(') {
            p++;
            char buf[BUFSIZ];
            char* p2 = buf;
            while(*p != ')') {
                if(*p == 0) {
                    err_msg("need )", sub_shell);
                    return 0;
                }
                else {
                    *p2++ = *p++;
                }
            }
            p++;
            *p2 = 0;

            value = calculate(buf, sub_shell);
        }
        else if(*p == '+') {
            p++;
            int right = get_node(&p);

            value = value + right;
        }
        else if(*p == '-') {
            p++;
            int right = get_node(&p);

            value = value - right;
        }
        else if(*p == '*') {
            p++;
            int right = get_node(&p);

            value = value * right;
        }
        else if(*p == '/') {
            p++;
            int right = get_node(&p);

            value = value / right;
        }
    }

    return value;
}

///////////////////////////////////////////////////////////////////////////////
// R}hs
///////////////////////////////////////////////////////////////////////////////
typedef struct {
    pid_t pgrp;
    char first_process;
} sSharedMemory;

static void null_fun()
{
}

static int gProgressMark = 0;

static void draw_progress_box(int mark_num)
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    const int y = maxy/2;
    
    mbox(y, (maxx-22)/2, 22, 3);
    mmvprintw(y, (maxx-22)/2+2, "progress");
    mmvprintw(y+1, (maxx-22)/2+1, "(%d/%d) files", gProgressMark, mark_num);
}

static void inner_command_init(int i, int pipein
              , sStatment* statment, vector_obj* redirections, BOOL sub_shell
              , int* output_fd, int* input_fd, int nextin, int nextout)
{
    *output_fd = 1;
    *input_fd = 0;

    if(pipein != -1 && i == (vector_size(statment->argvs)-1)) {
        *output_fd = pipein;
    }

    int j;
    for(j=0; j<vector_size(redirections); j++) {
        sRedirect* redirect = (sRedirect*)
                vector_item(redirections, j);
        mode_t mode;
        switch(redirect->mType) {
            case kRedirectInput:
                mode = O_RDONLY;
                break;
            
            case kRedirectOverwrite:
                mode = O_RDWR | O_CREAT | O_TRUNC;
                break;
                
            case kRedirectAppend:
                mode = O_RDWR | O_CREAT | O_APPEND;
                break;
        }
        
        int openfd = open(redirect->mFName, mode, 0666);
        if(openfd < 0) {
            fprintf(stderr, "open %s is err", redirect->mFName);
            exit(1);
        }

        switch(redirect->mType) {
            case kRedirectInput:
                *input_fd = openfd;
                break;
            
            case kRedirectOverwrite:
                *output_fd = openfd;
                break;
                
            case kRedirectAppend:
                *output_fd = openfd;
                break;
        }
    }
}

static void inner_command_final(int i, sStatment* statment, int pipein, int* nextin, int* nextout, int* rcode, int pipefds0, int* input_fd, int* output_fd, int flg_function)
{
    char buf[256];
    sprintf(buf, "%d", *rcode);
    setenv("?", buf, 1);
    
    if(pipein != -1 && i == (vector_size(statment->argvs)-1)) {
        if(*nextin != 0) close(*nextin);
        if(*input_fd != 0) close(*input_fd);

        if(*nextout != 1 && *nextout != 0 && 
            (!flg_function
            || flg_function && *nextout != pipein))
            close(*nextout);
        if(*output_fd != 1 && *output_fd != 0 && *output_fd != pipein) 
            close(*output_fd);
    }
    else {
        if(*nextin != 0) close(*nextin);
        if(*nextout != 1 && *nextout != 0) close(*nextout);

        if(*input_fd != 0) close(*input_fd);
        if(*output_fd != 1 && *output_fd != 0) close(*output_fd);
    }

    *nextin = pipefds0;
}
void selector(string_obj* output, string_obj* result, int* scrolltop, int* cursor)
{
    int flg_curses = FALSE;
    if(mis_curses() == 0) {
        minitscr();
        flg_curses = TRUE;
    }

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* lines = vector_new(10);

    /// o͂ƂlinesɊi[ ///
    string_obj* tmp = string_new("");
    char* p = string_c_str(output);
    while(*p) {
        if(*p == '\n') {
            p++;
            vector_add(lines, tmp);
            tmp = string_new("");
        }
        else {
            string_push_back2(tmp, *p++);
        }
    }

    if(vector_size(lines) > 0) {
        while(1) {
            /// ` ///
            mclear();
            int n = *scrolltop;
            int y = 0;
            while(y < maxy && n < vector_size(lines)) {
                if(n == *cursor) {
                    mattron(kCAReverse);
                }

                char* line = string_c_str(vector_item(lines, n));

                if(str_termlen(line) <= maxx) {
                    mmvprintw(y, 0, "%s", line);
                    y++;
                }
                else {
                    char* p = line;
                    while(p < line + strlen(line)) {
                        char one_line[BUFSIZ];
                        str_cut2(p, maxx, one_line, BUFSIZ);

                        mmvprintw(y, 0, "%s", one_line);
                        y++;

                        p+=strlen(one_line);
                    }
                }

                if(n == *cursor) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// Cvbg ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                (*cursor)++;
            }
            else if(key == 16 || key == KEY_UP) {
                (*cursor)--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                (*cursor) += (maxy / 2);
            }
            else if(key == 21 || key == KEY_PPAGE) {
                (*cursor) -= (maxy /2);
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                break;
            }
            else if(key == 10 || key == 13) {
                string_push_back(result
                    , string_c_str(vector_item(lines, *cursor)));
                break;
            }

            /// C ///
            if(*cursor < 0) {
                *cursor = 0;
            }
            if(*cursor >= vector_size(lines)) {
                *cursor = vector_size(lines)-1;
            }
            if(*cursor >= n) {
                *scrolltop = n;
            }
            if(*cursor < *scrolltop) {
                int i = *cursor;
                int width_sum = 0;
                while(width_sum < maxy) {
                    char* line = string_c_str(vector_item(lines, i));
                    int width = str_termlen(line) / maxx + 1;
                    width_sum += width;
                    i--;
                    if(i < 0) {
                        i = -2;
                        break;
                    }
                }
                
                *scrolltop = i +2;
            }
        }
    }

    if(flg_curses) {
        mendwin();
    }
}

int run_command(int* break_, int* return_, sStatment* statment, int pipein
                    , BOOL flg_function, char* title
                    , BOOL quick, BOOL* hitanykey, BOOL change_title
                    , BOOL in_fun, BOOL sub_shell)
{
    *break_ = FALSE;
    *return_ = FALSE;
    int rcode = 0;

    /// s ///
    int nextin = 0;
    int nextout = 1;
    BOOL last_command_is_inner;
    sJob* job = sJob_new(title);

    job->mPGroup = -1;

    /// L ///
    static int n = 0;
    if(n == 999) {
        n = 0;
    }
    int shared_memory_id = shmget(n++, sizeof(sSharedMemory), 0666|IPC_CREAT);
    if(shared_memory_id == -1) {
        fprintf(stderr, "%d\n", n);
        perror("shmget");
        exit(1);
    }

    sSharedMemory* shared_memory = shmat(shared_memory_id, (void*)0, 0);
    
    memset(shared_memory, 0, sizeof(sSharedMemory));

    /// qAhLg ///
    char* hd = string_c_str(statment->here_document);
    if(strcmp(hd, "") != 0)
    {
        vector_obj* argv = vector_new(10);
        vector_add(argv, string_new("print"));
        vector_add(argv, string_new(hd));

        vector_insert(statment->argvs, 0, argv);
        vector_insert(statment->redirections_list, 0, vector_new(10));
        vector_insert(statment->kinds, 0, kNormal);
        vector_insert(statment->extras, 0, NULL);
    }

    int i;
    for(i=0; i<vector_size(statment->argvs); i++) {
        vector_obj* argv = (vector_obj*)vector_item(statment->argvs, i);
        vector_obj* redirections = (vector_obj*)vector_item(statment->redirections_list, i);
        enum eStatment kind = (enum eStatment)vector_item(statment->kinds, i);
        void* extra = vector_item(statment->extras, i);



        int pipefds[2];

        if(i == (vector_size(statment->argvs)-1)) {
            if(pipein != -1) {
                nextout = pipein;
            }
            else {
                nextout = 1;
            }
        }
        else {
            if(pipe(pipefds) < 0) {
                perror("pipe");
                exit(1);
            }
            nextout = pipefds[1];
        }

        if(kind == kBreak) {
            *break_ = TRUE;
            break;
        }
        else if(kind == kReturn) {
            *return_ = TRUE;
            break;
        }
        else if(kind == kFunction) {
            sFunction* function_statment = (sFunction*)extra;
            char* func_name = string_c_str(function_statment->func_name);

            if(hash_item(gFuncs, func_name)) {
                hash_replace(gFuncs, func_name, extra);
            }
            else {
                hash_put(gFuncs, func_name, extra);
                vector_add(gFuncs2, string_new(func_name));
            }
        }
        else if(kind == kFor) {
            sFor* for_statment = (sFor*)extra;
            int i;
            for(i=0; i<vector_size(for_statment->strings); i++) {
                string_obj* string 
                    = vector_item(for_statment->strings, i);

                (void)setenv(string_c_str(for_statment->var_name)
                                    , string_c_str(string), 1);
               
                BOOL terminated = TRUE;
                int j;
                for(j=0; j<vector_size(for_statment->statments); j++) {
                    string_obj* statment1
                            = vector_item(for_statment->statments,j);

                    string_obj* statment2 = string_new("");
                    if(!expand_env(statment1, statment2, sub_shell)) {
                        err_msg("for statment: expand env err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    string_obj* statment3 = string_new("");
                    if(!expand_macro(string_c_str(statment2), statment3 , sub_shell)) {
                        err_msg("for statment: expand macro err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    sStatment* statment = sStatment_new();
                    if(!parse(string_c_str(statment3), statment, sub_shell)) {
                        err_msg("for statment: parser err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    int break2;
                    int return2;
                    if(!terminated) {
                        if(statment->terminated == kTNormal) {
                            terminated = TRUE;
                        }
                    }
                    else {
                        rcode = run_command(&break2, &return2, statment
                                            , pipein, flg_function, title
                                            , quick, &hitanykey, change_title
                                            , FALSE, sub_shell);

                        if(statment->terminated == kOrOr) {
                            if(rcode == 0) {
                                terminated = FALSE;
                            }
                        }
                        else if(statment->terminated == kAndAnd) {
                            if(rcode != 0) {
                                terminated = FALSE;
                            }
                        }
                    }

                    if(break2) {
                        goto for_end;
                    }
                    if(return2) {
                        *return_ = return2;
                        goto for_end;
                    }
                }
            }
for_end:
        null_fun();
        }
        else if(kind == kIf) {
            sIf* if_statment = (sIf*)extra;

            int i;
            for(i=0; i<vector_size(if_statment->conditionals_list); i++) {
                vector_obj* conditionals 
                    = vector_item(if_statment->conditionals_list, i);
                vector_obj* statments 
                    = vector_item(if_statment->statments_list, i);

                int rcode = 0;

                if(conditionals) {
                    BOOL terminated = TRUE;
                    int j;
                    for(j=0; j<vector_size(conditionals); j++) {
                        string_obj* statment1 = vector_item(conditionals, j);

                        string_obj* statment2 = string_new("");
                        if(!expand_env(statment1, statment2, sub_shell)) {
                            err_msg("if conditional: expand env err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }

                        string_obj* statment3 = string_new("");
                        if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                            err_msg("if conditional: expand macro err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }

                        sStatment* statment = sStatment_new();
                        if(!parse(string_c_str(statment3), statment, sub_shell)) {
                            err_msg("if conditional: parser err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }

                        int break2;
                        int return2;
                        if(!terminated) {
                            if(statment->terminated == kTNormal) {
                                terminated = TRUE;
                            }
                        }
                        else {
                            rcode = run_command(&break2, &return2, statment
                                                , pipein, flg_function, title
                                                , quick, &hitanykey
                                                , change_title, FALSE
                                                , sub_shell);

                            if(statment->terminated == kOrOr) {
                                if(rcode == 0) {
                                    terminated = FALSE;
                                }
                            }
                            else if(statment->terminated == kAndAnd) {
                                if(rcode != 0) {
                                    terminated = FALSE;
                                }
                            }
                        }

                        if(break2) {
                            rcode = 1;
                            goto run_command_end;
                        }
                        if(return2) {
                            *return_ = return2;
                            goto run_command_end;
                        }
                    }
                }

                if(rcode == 0) {
                    int j;
                    BOOL terminated = TRUE;
                    for(j=0; j<vector_size(statments); j++) {
                        string_obj* statment1 = vector_item(statments, j);

                        string_obj* statment2 = string_new("");
                        if(!expand_env(statment1, statment2, sub_shell)) {
                            err_msg("if statment: expand env err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }

                        string_obj* statment3 = string_new("");
                        if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                            err_msg("if statment: expand macro err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }
                        sStatment* statment = sStatment_new();
                        if(!parse(string_c_str(statment3), statment, sub_shell)) {
                            err_msg("if statment: parser err", sub_shell);
                            rcode = 1;
                            goto run_command_end;
                        }


                        int break2;
                        int return2;
                        if(!terminated) {
                            if(statment->terminated == kTNormal) {
                                terminated = TRUE;
                            }
                        }
                        else {
                            rcode = run_command(&break2, &return2, statment
                                                , pipein, flg_function, title
                                                , quick, &hitanykey
                                                , change_title
                                                , FALSE, sub_shell);

                            if(statment->terminated == kOrOr) {
                                if(rcode == 0) {
                                    terminated = FALSE;
                                }
                            }
                            else if(statment->terminated == kAndAnd) {
                                if(rcode != 0) {
                                    terminated = FALSE;
                                }
                            }
                        }

                        if(break2) {
                            *break_ = TRUE;
                            break;
                        }
                        if(return2) {
                            *return_ = TRUE;
                            break;
                        }
                    }
                    break;
                }
            }
        }
        else if(kind == kWhile) {
            sWhile* while_statment = (sWhile*)extra;

            int i;
            BOOL terminated = TRUE;
            for(i=0; i<vector_size(while_statment->conditionals); i++) {
                string_obj* statment1
                    = vector_item(while_statment->conditionals, i);

                string_obj* statment2 = string_new("");
                if(!expand_env(statment1, statment2, sub_shell)) {
                    err_msg("while conditional: expand env err", sub_shell);
                    rcode = 1;
                    goto run_command_end;
                }

                string_obj* statment3 = string_new("");
                if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                    err_msg("while conditional: expand macro err", sub_shell);
                    rcode = 1;
                    goto run_command_end;
                }
                sStatment* statment = sStatment_new();
                if(!parse(string_c_str(statment3), statment, sub_shell)) {
                    err_msg("while conditional: parser err", sub_shell);
                    rcode = 1;
                    goto run_command_end;
                }

                int break2;
                int return2;
                if(!terminated) {
                    if(statment->terminated == kTNormal) {
                        terminated = TRUE;
                    }
                }
                else {
                    rcode = run_command(&break2, &return2, statment, pipein
                                        , flg_function, title
                                        , quick,&hitanykey, change_title
                                        , FALSE
                                        , sub_shell);

                    if(statment->terminated == kOrOr) {
                        if(rcode == 0) {
                            terminated = FALSE;
                        }
                    }
                    else if(statment->terminated == kAndAnd) {
                        if(rcode != 0) {
                            terminated = FALSE;
                        }
                    }
                }

                if(break2) {
                    rcode = 1;
                    goto run_command_end;
                }
                if(return2) {
                    *return_ = TRUE;
                    goto run_command_end;
                }
            }

            while(rcode == 0) {
                BOOL terminated = TRUE;
                int i;
                for(i=0; i<vector_size(while_statment->statments); i++) {
                    string_obj* statment1
                        = vector_item(while_statment->statments, i);

                    string_obj* statment2 = string_new("");
                    if(!expand_env(statment1, statment2, sub_shell)) {
                        err_msg("while statment: expand env err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    string_obj* statment3 = string_new("");
                    if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                        err_msg("while statment: expand macro err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    sStatment* statment = sStatment_new();
                    if(!parse(string_c_str(statment3), statment, sub_shell)) {
                        err_msg("while statment: parser err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    int break2;
                    int return2;
                    if(!terminated) {
                        if(statment->terminated == kTNormal) {
                            terminated = TRUE;
                        }
                    }
                    else {
                        rcode = run_command(&break2, &return2, statment
                                            , pipein, flg_function, title
                                            , quick, &hitanykey, change_title
                                            , FALSE, sub_shell);

                        if(statment->terminated == kOrOr) {
                            if(rcode == 0) {
                                terminated = FALSE;
                            }
                        }
                        else if(statment->terminated == kAndAnd) {
                            if(rcode != 0) {
                                terminated = FALSE;
                            }
                        }
                    }

                    if(break2) {
                        goto while_end;
                    }
                    if(return2) {
                        *return_ = return2;
                        goto while_end;
                    }
                }

                terminated = TRUE;
                for(i=0; i<vector_size(while_statment->conditionals); i++) {
                    string_obj* statment1
                        = vector_item(while_statment->conditionals, i);

                    string_obj* statment2 = string_new("");
                    if(!expand_env(statment1, statment2, sub_shell)) {
                        err_msg("while conditional: expand env err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    string_obj* statment3 = string_new("");
                    if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                        err_msg("while conditional: expand macro err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    sStatment* statment = sStatment_new();
                    if(!parse(string_c_str(statment3), statment, sub_shell)) {
                        err_msg("while conditional: parser err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    int break2;
                    int return2;
                    if(!terminated) {
                        if(statment->terminated == kTNormal) {
                            terminated = TRUE;
                        }
                    }
                    else {
                        rcode = run_command(&break2, &return2, statment
                                            , pipein, flg_function, title
                                            , quick, &hitanykey, change_title
                                            , FALSE, sub_shell);

                        if(statment->terminated == kOrOr) {
                            if(rcode == 0) {
                                terminated = FALSE;
                            }
                        }
                        else if(statment->terminated == kAndAnd) {
                            if(rcode != 0) {
                                terminated = FALSE;
                            }
                        }
                    }
                    if(break2) {
                        rcode = 1;
                        goto run_command_end;
                    }
                    if(return2) {
                        return_ = TRUE;
                        goto run_command_end;
                    }
                }
            }
while_end:
            null_fun();
        }
        else if(kind == kNormal) {
            char* cmd = string_c_str((string_obj*)vector_item(argv, 0));

            /// ֐ ///
            sFunction* func = hash_item(gFuncs, cmd);
            int fd = hash_item(gFDs, cmd);
            if(fd) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 0;
                setenv("_", "", 1);

fd_start:
                if(vector_size(argv) == 1) {
                    string_obj* buffer = hash_item(gBuffers, cmd);
                    if(buffer && strcmp(string_c_str(buffer), "") != 0) {
                        char* p = string_c_str(buffer);
                        char* p2 = strstr(p, "\n");
                        
                        if(p2) {
                            char buf[BUFSIZ];
                            memcpy(buf, p, p2-p+1);
                            buf[p2-p+1] = 0;

                            setenv("_", buf, 1);

                            char buf2[BUFSIZ];
                            memcpy(buf2, p2+1, p + strlen(p) - p2);

                            string_put(buffer, buf2);
                        }
                        else {
                            char buf[BUFSIZ];
                            int r = read(fd-1, buf, BUFSIZ);
                            if(r < 0) {
                                rcode = 1;
                                goto fd_end;
                            }
                            if(r == 0) {
                                setenv("_", string_c_str(buffer), 1);
                            }
                            else {
                                buf[r] = 0;
                                string_push_back(buffer, buf);
                                goto fd_start;
                            }
                        }
                    }
                    else {
                        char buf[BUFSIZ];
                        int r = read(fd-1, buf, BUFSIZ);
                        if(r <= 0) {
                            rcode = 1;
                            goto fd_end;
                        }

                        buf[r] = 0;

                        hash_put(gBuffers, cmd, string_new(buf));
                        goto fd_start;
                    }
                }

fd_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(func) {
                int input_fd;
                int output_fd;
                inner_command_init(i, pipein, statment, redirections, sub_shell, &output_fd, &input_fd, nextin, nextout);

                /// Öۑ ///
                char* n = getenv("#");
                string_obj* number;
                vector_obj* v;
                vector_obj* all;
                if(n && strcmp(n, "-1") != 0) {
                    number = string_new(n);

                    v = vector_new(10);

                    int m = atoi(n);
                    int j;
                    for(j=0; j<=m; j++) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%d", j);
                        vector_add(v, string_new(getenv(buf)));
                    }
                    all = hash_item(gArrays, "@");
                }

                /// n ///
                char name[BUFSIZ];
                int k;
                for(k=0; k<vector_size(argv); k++) {
                    string_obj* arg = vector_item(argv, k); 
                    sprintf(name, "%d", k);
                    (void)setenv(name, string_c_str(arg), 1);
                }

                char buf[BUFSIZ];
                sprintf(buf, "%d", vector_size(argv)-1);
                (void)setenv("#", buf, 1);

                vector_obj* atmark = vector_new(10);
                for(k=1; k<vector_size(argv); k++) {
                    vector_add(atmark, vector_item(argv, k));
                }

                hash_put(gArrays, "@", atmark);

                /// s ///
                BOOL terminated = TRUE;
                for(k=0; k<vector_size(func->statments); k++) {
                    string_obj* statment1 = vector_item(func->statments, k);

                    string_obj* statment2 = string_new("");
                    if(!expand_env(statment1, statment2, sub_shell)) {
                        err_msg("func statment: expand env err"
                                    , sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    string_obj* statment3 = string_new("");
                    if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                        err_msg("func statment: expand macro err"
                                    , sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    sStatment* statment = sStatment_new();
                    if(!parse(string_c_str(statment3)
                        , statment, sub_shell)) 
                    {
                        err_msg("func statment: parser err", sub_shell);
                        rcode = 1;
                        goto run_command_end;
                    }

                    int break2;
                    int return2;
                    if(!terminated) {
                        if(statment->terminated == kTNormal) {
                            terminated = TRUE;
                        }
                    }
                    else {
                        rcode = run_command(&break2, &return2, statment
                                    , pipein, TRUE
                                    , title
                                    //, string_c_str(statment1)
                                            , quick, &hitanykey, change_title
                                            , TRUE, sub_shell);

                        if(statment->terminated == kOrOr) {
                            if(rcode == 0) {
                                terminated = FALSE;
                            }
                        }
                        else if(statment->terminated == kAndAnd) {
                            if(rcode != 0) {
                                terminated = FALSE;
                            }
                        }
                    }
                    if(return2) {
                        break;
                    }
                }

                /// I ///
                rcode = 0;

                if(n && strcmp(n, "-1") != 0) {
                    setenv("#", string_c_str(number), 1);

                    hash_put(gArrays, "@", all);

                    int j;
                    for(j=0; j<vector_size(v); j++) {
                        string_obj* item = vector_item(v, j);
                        char buf[BUFSIZ];
                        sprintf(buf, "%d", j);
                        setenv(buf, string_c_str(item), 1);
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
                close(pipein);
            }

            /// R}h ///
            else if(strcmp(cmd, "keycommand") == 0 || strcmp(cmd, "mfiler3_keycommand") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 5) {
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);


                    hash_put(gKeyCommand[meta][keycode], argv3, argv4);
                }
                else if(vector_size(argv) == 6){
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));
                    char* argv5 = string_c_str(vector_item(argv, 5));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);

                    hash_put(gKeyCommand[meta][keycode], argv3, argv4);
                    hash_put(gKeyCommandTitle[meta][keycode], argv3
                                    , argv5);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }

            /// R}h ///
            else if(strcmp(cmd, "keycommandline") == 0 || strcmp(cmd, "mfiler3_keycommandline") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 6){
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));
                    char* argv5 = string_c_str(vector_item(argv, 5));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);

                    hash_put(gKeyCommandLine[meta][keycode], argv3, argv4);
                    hash_put(gKeyCommandLineCurPos[meta][keycode], argv3, atoi(argv5));
                    hash_put(gKeyCommandLineExpandMacro[meta][keycode], argv3, 0);
                }
                else if(vector_size(argv) == 7){
                    char* argv1 = string_c_str(vector_item(argv, 1));
                    char* argv2 = string_c_str(vector_item(argv, 2));
                    char* argv3 = string_c_str(vector_item(argv, 3));
                    char* argv4 = string_c_str(vector_item(argv, 4));
                    char* argv5 = string_c_str(vector_item(argv, 5));
                    char* argv6 = string_c_str(vector_item(argv, 6));

                    int meta = atoi(argv1);
                    int keycode = atoi(argv2);

                    hash_put(gKeyCommandLine[meta][keycode], argv3, argv4);
                    hash_put(gKeyCommandLineCurPos[meta][keycode], argv3, atoi(argv5));
                    hash_put(gKeyCommandLineExpandMacro[meta][keycode], argv3, 0);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }

            /// export ///
            else if(strcmp(cmd, "export") == 0 || strcmp(cmd, "mfiler3_export") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) != 2) {
                    err_msg("export syntax error", sub_shell);
                    goto run_command_end;
                }
                else {
                    char* p = string_c_str((string_obj*)vector_item(argv, 1));
                    char* p2 = strstr(p, "=");

                    if(p2) {
                        char var_name[BUFSIZ];
                        char value[BUFSIZ];

                        memcpy(var_name, p, p2 - p);
                        var_name[strstr(p, "=") - p] = 0;
                        strcpy(value, p2 + 1);

                        (void)setenv(var_name, value, 1);
                        rcode = 0;
                    }
                }
                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// [ ///
            else if(strcmp(cmd, "[") == 0 || strcmp(cmd, "mfiler3_[") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                char* arg_last = string_c_str(
                        vector_item(argv, vector_size(argv)-1));

                if(strcmp(arg_last, "]") != 0) {
                    err_msg("need ]", sub_shell);
                }
                else {
                    BOOL reverse = FALSE;

                    char* arg1;
                    char* arg2;
                    char* arg3;
                    char* arg4;
                    char* arg5;

                    if(vector_size(argv) > 1) {
                        arg1 = string_c_str(vector_item(argv, 1));
                        if(strcmp(arg1, "!") == 0) {
                            reverse = TRUE;
                        }
                    }

                    if(reverse) {
                        if(vector_size(argv) == 5) {
                            arg1 = string_c_str(vector_item(argv, 2));
                            arg2 = string_c_str(vector_item(argv, 3));
                        }
                        else if(vector_size(argv) == 6) {
                            arg1 = string_c_str(vector_item(argv, 2));
                            arg2 = string_c_str(vector_item(argv, 3));
                            arg3 = string_c_str(vector_item(argv, 4));
                        }
                    }
                    else {
                        if(vector_size(argv) == 4) {
                            arg2 = string_c_str(vector_item(argv, 2));
                        }
                        else if(vector_size(argv) == 5) {
                            arg2 = string_c_str(vector_item(argv, 2));
                            arg3 = string_c_str(vector_item(argv, 3));
                        }
                    }

                    if(!reverse && vector_size(argv) == 4 
                        || reverse && vector_size(argv) == 5) 
                    {
                        /// string ///
                        if(strcmp(arg1, "-n") == 0) {
                            if(!reverse && strcmp(arg2, "") != 0) {
                                rcode = 0;
                            }
                            else if(reverse && ! strcmp(arg2, "") != 0) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg1, "-z") == 0) {
                            if(!reverse && strcmp(arg2, "") == 0) {
                                rcode = 0;
                            }
                            else if(reverse && ! strcmp(arg2, "") == 0) {
                                rcode = 0;
                            }
                        }
                        
                        else {
                            /// file type ///
                            struct stat stat_;
                            if(stat(arg2, &stat_) == 0) {
                                if(strcmp(arg1, "-b") == 0) {
                                    if(!reverse && S_ISBLK(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISBLK(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-c") == 0) {
                                    if(!reverse && S_ISCHR(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISCHR(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-d") == 0) {
                                    if(!reverse && S_ISDIR(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISDIR(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-f") == 0) {
                                    if(!reverse && S_ISREG(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISREG(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-h") == 0 
                                         || strcmp(arg1, "-L") == 0) 
                                {
                                    if(!reverse && S_ISLNK(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISLNK(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-p") == 0) {
                                    if(!reverse && S_ISFIFO(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! S_ISFIFO(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-S") == 0) {
                                    if(!reverse && S_ISSOCK(stat_.st_mode)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && S_ISSOCK(stat_.st_mode)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-t") == 0) {
                                }
                                /// permission ///
                                else if(strcmp(arg1, "-g") == 0) {
                                    if(!reverse && (stat_.st_mode & S_ISGID)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && !(stat_.st_mode & S_ISGID)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-k") == 0) {
#if defined(S_ISTXT)
                                    if(!reverse && (stat_.st_mode & S_ISTXT)) {
#endif
#if defined(S_ISVTX)
                                    if(!reverse && (stat_.st_mode & S_ISVTX)) {
#endif
                                        rcode = 0;
                                    }
#if defined(S_ISTXT)
                                    else if(reverse 
                                        && !(stat_.st_mode & S_ISTXT)) 
                                    {
#endif
#if defined(S_ISVTX)
                                    else if(reverse 
                                        && !(stat_.st_mode & S_ISVTX)) 
                                    {
#endif
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-u") == 0) {
                                    if(!reverse && (stat_.st_mode & S_ISUID)) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! (stat_.st_mode & S_ISUID)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-r") == 0) {
                                    if(!reverse && access(arg2, R_OK) == 0) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && !(access(arg2, R_OK) == 0)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-w") == 0) {
                                    if(!reverse && access(arg2, W_OK) == 0) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! ( access(arg2, W_OK) == 0)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-x") == 0) {
                                    if(!reverse && access(arg2, X_OK) == 0) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && !(access(arg2, X_OK) == 0)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-O") == 0) {
                                    if(!reverse && stat_.st_uid == getuid()) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && !stat_.st_uid == getuid()) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-G") == 0) {
                                    if(!reverse && stat_.st_gid == getgid()) {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                        && ! stat_.st_gid == getgid()) 
                                    {
                                        rcode = 0;
                                    }
                                }
                                else if(strcmp(arg1, "-e") == 0) {
                                    if(!reverse) rcode = 0;
                                }
                                else if(strcmp(arg1, "-s") == 0) {
                                    if(!reverse && stat_.st_size > 0) {
                                        rcode = 0;
                                    }
                                    else if(reverse && !(stat_.st_size > 0)) {
                                        rcode = 0;
                                    }
                                }
                            }
                            else {
                                if(strcmp(arg1, "-e") == 0) {
                                    if(reverse) rcode = 0;
                                }
                            }
                        }
                    }
                    else if(!reverse && vector_size(argv) == 5 
                        || reverse && vector_size(argv) == 6) 
                    {
                        /// string ///
                        if(strcmp(arg2, "=") == 0) {
                            if(!reverse && strcmp(arg1, arg3) == 0) {
                                rcode = 0;
                            }
                            else if(reverse && !(strcmp(arg1, arg3) == 0)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "!=") == 0) {
                            if(!reverse && strcmp(arg1, arg3) != 0) {
                                rcode = 0;
                            }
                            else if(reverse && !(strcmp(arg1, arg3) != 0)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "=~") == 0) {
                            if(arg3[0] == '/' && arg3[strlen(arg3)-1] == '/') {
                                char regex[BUFSIZ];
                                memcpy(regex, arg3 + 1, strlen(arg3) -2);
                                regex[strlen(arg3) - 2 ] = 0;
                                
                                OnigUChar* regex2 = (OnigUChar*)regex;

                                regex_t* reg;

                                int err_info;
    
                                int r = onig_new(&reg, regex2
                                            , regex2 + strlen((char*)regex2)
                                            , ONIG_OPTION_DEFAULT
                                            , ONIG_ENCODING_UTF8
                                            , ONIG_SYNTAX_DEFAULT
                                            ,  &err_info);

                                if(r == ONIG_NORMAL) {
                                    OnigRegion* region = onig_region_new();
                                    int r2 = onig_search(reg, arg1
                                       , arg1 + strlen((char*)arg1)
                                       , arg1, arg1 + strlen((char*)arg1)
                                       , region, ONIG_OPTION_NONE);

                                    if(r2 >= 0) {
                                        rcode = 0;

                                        int i;
                                        for (i=1; i<region->num_regs; i++) {
                                            char tmp[BUFSIZ];

                                            memcpy(tmp, arg1 + region->beg[i]
                                             , region->end[i]-region->beg[i]);

                                            tmp[region->end[i]
                                                - region->beg[i]] = 0;

                                            char name[BUFSIZ];
                                            sprintf(name, "REG%d", i);

                                            setenv(name, tmp, 1);
                                        }
                                    }

                                    onig_region_free(region, 1);
                                }

                                onig_free(reg);
                            }
                        }

                        /// number ///
                        else if(strcmp(arg2, "-eq") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l == r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l == r)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "-ne") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l != r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l != r)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "-lt") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l < r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l < r)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "-le") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l <= r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l <= r)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "-gt") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l > r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l > r)) {
                                rcode = 0;
                            }
                        }
                        else if(strcmp(arg2, "-ge") == 0) {
                            int l = atoi(arg1);
                            int r = atoi(arg3);

                            if(!reverse && l >= r) {
                                rcode = 0;
                            }
                            else if(reverse && !(l >= r)) {
                                rcode = 0;
                            }
                        }

                        /// file ///
                        else if(strcmp(arg2, "-nt") == 0) {
                            struct stat lstat_;
                            struct stat rstat_;

                            if(lstat(arg1, &lstat_) == 0) {
                                if(lstat(arg3, &rstat_) == 0) {
                                    if(!reverse 
                                        && lstat_.st_mtime > rstat_.st_mtime) 
                                    {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                      && !(lstat_.st_mtime > rstat_.st_mtime)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                            }
                        }
                        else if(strcmp(arg2, "-ot") == 0) {
                            struct stat lstat_;
                            struct stat rstat_;

                            if(lstat(arg1, &lstat_) == 0) {
                                if(lstat(arg3, &rstat_) == 0) {
                                    if(!reverse 
                                        && lstat_.st_mtime < rstat_.st_mtime) 
                                    {
                                        rcode = 0;
                                    }
                                    else if(reverse 
                                      && !(lstat_.st_mtime < rstat_.st_mtime)) 
                                    {
                                        rcode = 0;
                                    }
                                }
                            }
                        }
                        else if(strcmp(arg2, "-ef") == 0) {
                        }
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
                
            }
            else if(strcmp(cmd, "defmenu") == 0 || strcmp(cmd, "mfiler3_defmenu") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                /// ̃`FbN ///
                if(vector_size(argv)%3 != 2) {
                    err_msg("defmenu arguments err", sub_shell);
                    int j;
                    for(j=0; j<vector_size(argv); j++) {
                        char tmp[BUFSIZ];
                        sprintf(tmp, "%s", string_c_str(vector_item(argv, j)));
                        err_msg(tmp, sub_shell);
                    }
                }
                else {
                    char* menu_name = string_c_str(vector_item(argv, 1));
                    
                    sMenu* new_menu = sMenu_new(menu_name);

                    int j;
                    for(j=2; j<vector_size(argv); j+=3) {
                        char* argv1 = string_c_str(vector_item(argv, j));
                        char* argv2 = string_c_str(vector_item(argv, j+1));
                        char* argv3 = string_c_str(vector_item(argv, j+2));
                        menu_append(new_menu, argv1, atoi(argv2), argv3);
                    }
                }

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "keymap") == 0 || strcmp(cmd, "mfiler3_keymap") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 12) {
                    char keys[kKeyMapKeysMax];

                    keys[0] = atoi(string_c_str(vector_item(argv, 2)));
                    keys[1] = atoi(string_c_str(vector_item(argv, 3)));
                    keys[2] = atoi(string_c_str(vector_item(argv, 4)));
                    keys[3] = atoi(string_c_str(vector_item(argv, 5)));
                    keys[4] = atoi(string_c_str(vector_item(argv, 6)));
                    keys[5] = atoi(string_c_str(vector_item(argv, 7)));
                    keys[6] = atoi(string_c_str(vector_item(argv, 8)));
                    keys[7] = atoi(string_c_str(vector_item(argv, 9)));
                    keys[8] = atoi(string_c_str(vector_item(argv, 10)));
                    keys[9] = atoi(string_c_str(vector_item(argv, 11)));

                    madd_keymap(atoi(string_c_str(vector_item(argv, 1)))
                                , keys);

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "cd") == 0 || strcmp(cmd, "mfiler3_cd") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                int dir = adir();

                if(vector_size(argv) > 1) {
                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        if(vector_size(argv) == 2) {
                            filer_cd(adir(), arg1);
                        }
                        else {
                            dir = arg1[0] - '0';

                            if(vector_size(argv) == 3) {
                                char* arg2 = string_c_str(vector_item(argv, 2));

                                if(strcmp(arg2, "+") == 0) {
                                    filer_history_forward(dir);
                                }
                                else if(strcmp(arg2, "-") == 0) {
                                    filer_history_back(dir);
                                }
                                else {
                                    filer_cd(dir, arg2);
                                }
                            }
                            else {
                                filer_cd(dir, "~");
                            }
                        }
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();

                        if(vector_size(argv) == 3) {
                            char* arg2 = string_c_str(vector_item(argv, 2));

                            if(strcmp(arg2, "+") == 0) {
                                filer_history_forward(dir);
                            }
                            else if(strcmp(arg2, "-") == 0) {
                                filer_history_back(dir);
                            }
                            else {
                                filer_cd(dir, arg2);
                            }
                        }
                        else {
                            filer_cd(dir, "~");
                        }
                    }
                    else if(strcmp(arg1, "-") == 0) {
                        filer_history_back(dir);
                    }
                    else if(strcmp(arg1, "+") == 0) {
                        filer_history_forward(dir);
                    }
                    else {
                        filer_cd(dir, arg1);
                    }
                }
                else {
                    filer_cd(dir, "~");
                }

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "rehash") == 0 || strcmp(cmd, "mfiler3_rehash") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                cmdline_rehash();
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "menu") == 0 || strcmp(cmd, "mfiler3_menu") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char* menu_name = string_c_str(vector_item(argv, 1));

                gActiveMenu = hash_item(gMenu, menu_name);
                if(gActiveMenu) {
                    gActiveMenu->mScrollTop = 0;
                    gActiveMenu->mCursor = 0;
                }

                rcode = 0;
                *hitanykey = FALSE;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "mfiler3_view") == 0 || strcmp(cmd, "mfiler3_mfiler3_view") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                BOOL init_curses = FALSE;
                if(mis_curses() == 0) {
                    minitscr();
                    init_curses = TRUE;
                }

                view();
                mrefresh();
                rcode = 0;

                if(init_curses) mendwin();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "mclear_immediately") == 0 || strcmp(cmd, "mfiler3_mclear_immediately") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                BOOL init_curses = FALSE;
                if(mis_curses() == 0) {
                    minitscr();
                    init_curses = TRUE;
                }

                mclear_immediately();
                rcode = 0;

                if(init_curses) mendwin();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "isearch") == 0 || strcmp(cmd, "mfiler3_isearch") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                gISearch = TRUE;
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "cmdline") == 0 || strcmp(cmd, "mfiler3_cmdline") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 1) {
                    cmdline_start("", 0);
                }
                else if(vector_size(argv) == 2) {
                    char* init_str = string_c_str(vector_item(argv, 1));
                    cmdline_start(init_str, -1);
                }
                else if(vector_size(argv) == 3) {
                    char* init_str = string_c_str(vector_item(argv, 1));
                    int cursor = atoi(string_c_str(vector_item(argv, 2)));
                    cmdline_start(init_str, cursor);
                }
                else if(vector_size(argv) == 4) {
                    char* init_str = string_c_str(vector_item(argv, 1));
                    int cursor = atoi(string_c_str(vector_item(argv, 2)));

                    string_obj* init_str2 = string_new("");
                    expand_macro(init_str, init_str2, FALSE);
                    cmdline_start(string_c_str(init_str2), cursor);
                }

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "get_mark") == 0 || strcmp(cmd, "mfiler3_get_mark") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3) {
                    int dir;

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        dir = arg1[0] - '0';
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();
                    }
                    else {
                        dir = adir();
                    }

                    int arg2 = atoi(string_c_str(vector_item(argv, 2)));

                    int n = filer_mark(dir, arg2);

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", n);
                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = n;
                }
                else if(vector_size(argv) == 2) {
                    int dir = adir();

                    int arg1 = atoi(string_c_str(vector_item(argv, 1)));

                    int n = filer_mark(dir, arg1);

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", n);
                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = n;
                }
                else {
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_toggle_mark") == 0 || strcmp(cmd, "mfiler3_set_toggle_mark") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3) {
                    int dir;

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        dir = arg1[0] - '0';
                    }
                    else if(strcmp(arg1, "-a") == 0) {
                        dir = adir();
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();
                    }

                    char* arg2 = string_c_str(vector_item(argv, 2));

                    /// 񂪐ǂ Ȋ֐Wł ///
                    BOOL isdigit = TRUE;
                    int j;
                    for(j=0; j<strlen(arg2); j++) {
                        if(arg2[j] < '0' || arg2[j] > '9') {
                            isdigit = FALSE;
                        }
                    }

                    int arg2_num;
                    if(isdigit) {
                        arg2_num = atoi(arg2);
                    }
                    else {
                        arg2_num = filer_file2(dir, arg2);
                    }

                    if(arg2_num >= 0) filer_toggle_mark(dir, arg2_num);

                    rcode = 0;
                }
                else if(vector_size(argv) == 2) {
                    int dir = adir();

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    /// 񂪐ǂ Ȋ֐Wł ///
                    BOOL isdigit = TRUE;
                    int j;
                    for(j=0; j<strlen(arg1); j++) {
                        if(arg1[j] < '0' || arg1[j] > '9') {
                            isdigit = FALSE;
                        }
                    }

                    int arg1_num;
                    if(isdigit) {
                        arg1_num = atoi(arg1);
                    }
                    else {
                        arg1_num = filer_file2(dir, arg1);
                    }

                    if(arg1_num > 0) filer_toggle_mark(dir, arg1_num);

                    rcode = 0;
                }
                else {
                    rcode = 1;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_mark") == 0 || strcmp(cmd, "mfiler3_set_mark") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 4) {
                    int dir;

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        dir = arg1[0] - '0';
                    }
                    else if(strcmp(arg1, "-a") == 0) {
                        dir = adir();
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();
                    }

                    char* arg2 = string_c_str(vector_item(argv, 2));
                    int arg3 = atoi(string_c_str(vector_item(argv, 3)));

                    /// 񂪐ǂ Ȋ֐Wł ///
                    BOOL isdigit = TRUE;
                    int j;
                    for(j=0; j<strlen(arg2); j++) {
                        if(arg2[j] < '0' || arg2[j] > '9') {
                            isdigit = FALSE;
                        }
                    }

                    int arg2_num;
                    if(isdigit) {
                        arg2_num = atoi(arg2);
                    }
                    else {
                        arg2_num = filer_file2(dir, arg2);
                    }

                    if(arg2_num > 0) filer_set_mark(dir, arg2_num, arg3);

                    rcode = 0;
                }
                else if(vector_size(argv) == 3) {
                    int dir = adir();

                    char* arg1 = string_c_str(vector_item(argv, 1));
                    int arg2 = atoi(string_c_str(vector_item(argv, 2)));

                    /// 񂪐ǂ Ȋ֐Wł ///
                    BOOL isdigit = TRUE;
                    int j;
                    for(j=0; j<strlen(arg1); j++) {
                        if(arg1[j] < '0' || arg1[j] > '9') {
                            isdigit = FALSE;
                        }
                    }

                    int arg1_num;
                    if(isdigit) {
                        arg1_num = atoi(arg1);
                    }
                    else {
                        arg1_num = filer_file2(dir, arg1);
                    }

                    if(arg1_num > 0) filer_set_mark(dir, arg1_num, arg2);

                    rcode = 0;
                }
                else {
                    rcode = 1;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "mark_clear") == 0 || strcmp(cmd, "mfiler3_mark_clear") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                sDir* dir;
                if(vector_size(argv) == 1) {
                    dir = filer_dir(adir());
                }
                else if(vector_size(argv) == 2) {
                    char* arg2 = string_c_str(vector_item(argv, 1));
                    int arg2i = atoi(arg2);

                    if(strcmp(arg2, "-a") == 0) {
                        dir = filer_dir(adir());
                    }
                    else if(strcmp(arg2, "-s") == 0) {
                        dir = filer_dir(sdir());
                    }
                    else {
                        dir = filer_dir(arg2i);
                    }
                }

                if(dir) {
                    int k;
                    for(k=0; k<vector_size(dir->mFiles); k++) {
                        sFile* f = vector_item(dir->mFiles, k);
                        f->mMark = FALSE;
                    }
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "mark_all_files") == 0 || strcmp(cmd, "mfiler3_mark_all_files") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                sDir* dir;
                if(vector_size(argv) == 1) {
                    dir = filer_dir(adir());
                }
                else if(vector_size(argv) == 2) {
                    char* arg2 = string_c_str(vector_item(argv, 1));
                    int arg2i = atoi(arg2);

                    if(strcmp(arg2, "-a") == 0) {
                        dir = filer_dir(adir());
                    }
                    else if(strcmp(arg2, "-s") == 0) {
                        dir = filer_dir(sdir());
                    }
                    else {
                        dir = filer_dir(arg2i);
                    }
                }

                if(dir) {
                    int k;
                    for(k=0; k<vector_size(dir->mFiles); k++) {
                        sFile* f = vector_item(dir->mFiles, k);
                        if(!S_ISDIR(f->mStat.st_mode)) {
                            f->mMark = !f->mMark;
                        }
                    }
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "mark_all_files_and_directory") == 0 || strcmp(cmd, "mfiler3_mark_all_files_and_directory") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                sDir* dir;
                if(vector_size(argv) == 1) {
                    dir = filer_dir(adir());
                }
                else if(vector_size(argv) == 2) {
                    char* arg2 = string_c_str(vector_item(argv, 1));
                    int arg2i = atoi(arg2);

                    if(strcmp(arg2, "-a") == 0) {
                        dir = filer_dir(adir());
                    }
                    else if(strcmp(arg2, "-s") == 0) {
                        dir = filer_dir(sdir());
                    }
                    else {
                        dir = filer_dir(arg2i);
                    }
                }

                if(dir) {
                    int k;
                    for(k=0; k<vector_size(dir->mFiles); k++) {
                        sFile* f = vector_item(dir->mFiles, k);
                        if(strcmp(f->mName, "..") != 0) {
                            f->mMark = !f->mMark;
                        }
                    }
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
/*
            else if(strcmp(cmd, "sisearch_cache_exist") == 0 || strcmp(cmd, "mfiler3_sisearch_cache_exist") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(sisearch_cache_exist()) {
                    rcode = 0;
                }
                else {
                    rcode = 1;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sisearch") == 0 || strcmp(cmd, "mfiler3_sisearch") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                gSISearch = TRUE;

                sisearch_start();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sisearch_getcache") == 0 || strcmp(cmd, "mfiler3_sisearch_getcache") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                sisearch_get_cache();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
*/
            else if(strcmp(cmd, "mask") == 0 || strcmp(cmd, "mfiler3_mask") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;

                if(vector_size(argv) == 1) {
                    sDir* dir = filer_dir(adir());
                    char buf[BUFSIZ];
                    sprintf(buf, "%s\n", dir->mMask);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }
                else if(vector_size(argv) == 2) {
                    int d = atoi(string_c_str(vector_item(argv, 1)));

                    sDir* dir = filer_dir(d);
                    char buf[BUFSIZ];
                    sprintf(buf, "%s\n", dir->mMask);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_mask") == 0 || strcmp(cmd, "mfiler3_set_mask") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 3) {
                    int dir;

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        dir = arg1[0] - '0';
                    }
                    else if(strcmp(arg1, "-a") == 0) {
                        dir = adir();
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();
                    }

                    sDir* dir2 = filer_dir(dir);
                    char* arg2 = string_c_str(vector_item(argv, 2));

                    strcpy(dir2->mMask, arg2);
/*
                    if(dir2->mVD) {
                        filer_cd(dir, dir2->mPath);
                    }
                    else {
*/
                        filer_reread(dir);
//                    }

                    rcode = 0;
                }
                else if(vector_size(argv) == 2) {
                    int dir = adir();

                    char* arg1 = string_c_str(vector_item(argv, 1));
                    sDir* dir2 = filer_dir(dir);
                    strcpy(dir2->mMask, arg1);
/*
                    if(dir2->mVD) {
                        filer_cd(dir, dir2->mPath);
                    }
                    else {
*/
                        filer_reread(dir);
//                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_dotdir_mask") == 0 || strcmp(cmd, "mfiler3_set_dotdir_mask") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 3) {
                    int dir;

                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        dir = arg1[0] - '0';
                    }
                    else if(strcmp(arg1, "-a") == 0) {
                        dir = adir();
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        dir = sdir();
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mDotDirMask = atoi(string_c_str(vector_item(argv, 2)));
                    filer_reread(dir);

                    rcode = 0;
                }
                else if(vector_size(argv) == 2) {
                    int dir = adir();

                    sDir* dir2 = filer_dir(dir);
                    dir2->mDotDirMask = atoi(string_c_str(vector_item(argv, 1)));
                    filer_reread(dir);

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "dotdir_mask") == 0 || strcmp(cmd, "mfiler3_dotdir_mask") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;

                if(vector_size(argv) == 1) {
                    sDir* dir = filer_dir(adir());
                    if(dir->mDotDirMask) {
                        if(output_fd == 1)
                            write(nextout, "1\n", 2);
                        else
                            write(output_fd, "1\n", 2);
                    }
                    else {
                        if(output_fd == 1)
                            write(nextout, "0\n", 2);
                        else
                            write(output_fd, "0\n", 2);
                    }

                    rcode = 0;
                }
                else if(vector_size(argv) == 2) {
                    int d = atoi(string_c_str(vector_item(argv, 1)));

                    sDir* dir = filer_dir(d);
                    if(dir->mDotDirMask) {
                        if(output_fd == 1)
                            write(nextout, "1\n", 2);
                        else
                            write(output_fd, "1\n", 2);
                    }
                    else {
                        if(output_fd == 1)
                            write(nextout, "0\n", 2);
                        else
                            write(output_fd, "0\n", 2);
                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "redraw") == 0 || strcmp(cmd, "mfiler3_redraw") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                clear();
                view();
                mrefresh();

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "reread") == 0 || strcmp(cmd, "mfiler3_reread") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* arg1 = string_c_str(vector_item(argv, 1));

                    if(strlen(arg1) == 1 && arg1[0] >= '0' && arg1[0] <= '9')
                    {
                        filer_reread(arg1[0] - '0');
                    }
                    else if(strcmp(arg1, "all") == 0) {
                        int j;
                        for(j=0; j<vector_size(gDirs); j++) {
                            filer_reread(j);
                        }
                    }
                    else if(strcmp(arg1, "-a") == 0) {
                        filer_reread(adir());
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        filer_reread(sdir());
                    }
                }
                else {
                    filer_reread(0);
                    filer_reread(1);
                }

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "index") == 0 || strcmp(cmd, "mfiler3_index") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);

                    if(r == 0) {
                        break;
                    }
                    buf[r] = 0;

                    string_push_back(str, buf);
                }

                char* str2 = string_c_str(str);

                int argv2 = 0;
                if(vector_size(argv) == 3) {
                    argv2 = atoi(string_c_str(vector_item(argv, 2)));

                    if(argv2 < 0) {
                        argv2 = strlen(str2) + argv2;
                    }
                }

                if(vector_size(argv) >= 2) {
                    char* p = strstr(str2 + argv2
                                        , string_c_str(vector_item(argv, 1)));

                    char str[BUFSIZ];
                    if(p) {
                        sprintf(str, "%d\n", p - str2);
                    }
                    else {
                        sprintf(str, "-1\n");
                    }

                    if(output_fd == 1)
                        write(nextout, str, strlen(str));
                    else
                        write(output_fd, str, strlen(str));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "rindex") == 0 || strcmp(cmd, "mfiler3_rindex") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);

                    if(r == 0) {
                        break;
                    }
                    buf[r] = 0;

                    string_push_back(str, buf);
                }

                char* str2 = string_c_str(str);

                int argv2 = strlen(str2);
                if(vector_size(argv) == 3) {
                    argv2 = atoi(string_c_str(vector_item(argv, 2)));

                    if(argv2 < 0) {
                        argv2 = strlen(str2) + argv2;
                    }
                }

                if(vector_size(argv) >= 2) {
                    char* arg1 = string_c_str(vector_item(argv, 1));

                    char* p;
                    int i;
                    for(i=argv2; i >= 0; i--) {
                        int match = 1;
                        int j;
                        for(j=0; j<strlen(arg1); j++) {
                            if(!(i+j < strlen(str2) && str2[i+j] == arg1[j])) {
                                match = 0;
                            }
                        }

                        if(match) {
                            p = str2 + i;
                            break;
                        }
                    }

                    char str[BUFSIZ];
                    if(p) {
                        sprintf(str, "%d\n", p - str2);
                    }
                    else {
                        sprintf(str, "-1\n");
                    }

                    if(output_fd == 1)
                        write(nextout, str, strlen(str));
                    else
                        write(output_fd, str, strlen(str));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "toggle") == 0 || strcmp(cmd, "mfiler3_toggle") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 1) {
                    char* arg1 = string_c_str(vector_item(argv, 1));

                    char str[BUFSIZ];
                    if(strcmp(arg1, "0") == 0) {
                        strcpy(str, "1\n");
                    }
                    else if(strcmp(arg1, "1") == 0) {
                        strcpy(str, "0\n");
                    }
                    else {
                        strcpy(str, "0\n");
                    }

                    if(output_fd == 1)
                        write(nextout, str, strlen(str));
                    else
                        write(output_fd, str, strlen(str));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "chomp") == 0 || strcmp(cmd, "mfiler3_chomp") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);
                    if(r < 0) {
                        perror("read");
                        return 1;
                    }
                    if(r == 0) {
                        break;
                    }
                    buf[r] = 0;

                    string_push_back(str, buf);
                }

                char* str2 = string_c_str(str);

                if(str2[strlen(str2)-1] == '\n') {
                    if(output_fd == 1)
                        write(nextout, str2, strlen(str2)-1);
                    else
                        write(output_fd, str2, strlen(str2)-1);
                }
                else {
                    if(output_fd == 1)
                        write(nextout, str2, strlen(str2));
                    else
                        write(output_fd, str2, strlen(str2));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_sort_kind") == 0 || strcmp(cmd, "mfiler3_set_sort_kind") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2 || vector_size(argv) == 3) {
                    int dir;
                    enum eSortKind kind;
                    if(vector_size(argv) == 3) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                        char* arg2 = string_c_str(vector_item(argv, 2));
                        int k;
                        for(k=0; k<kSortMax; k++) {
                            if(strcmp(arg2, kSortName[k]) == 0) {
                                kind = k;
                                break;
                            }
                        }
                    }
                    else if(vector_size(argv) == 2) {
                        dir = adir();
                        char* arg1 = string_c_str(vector_item(argv, 1));
                        int k;
                        for(k=0; k<kSortMax; k++) {
                            if(strcmp(arg1, kSortName[k]) == 0) {
                                kind = k;
                                break;
                            }
                        }
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mSortKind = kind;

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sort_kind") == 0 
                    || strcmp(cmd, "mfiler3_sort_kind") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int dir = atoi(string_c_str(vector_item(argv, 1)));

                    sDir* dir2 = filer_dir(dir);

                    char buf[BUFSIZ];
                    if(dir2->mSortKindBefore != -1)
                        sprintf(buf, "%s\n", kSortName[dir2->mSortKindBefore]);
                    else
                        sprintf(buf, "%s\n", kSortName[dir2->mSortKind]);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }
                else {
                    sDir* dir2 = filer_dir(adir());

                    char buf[BUFSIZ];
                    if(dir2->mSortKindBefore != -1)
                        sprintf(buf, "%s\n", kSortName[dir2->mSortKindBefore]);
                    else
                        sprintf(buf, "%s\n", kSortName[dir2->mSortKind]);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "toggle_sort_markup") == 0 || strcmp(cmd, "mfiler3_toggle_sort_markup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 1 || vector_size(argv) == 2) {
                    int dir;
                    if(vector_size(argv) == 1) {
                        dir = adir();
                    }
                    else if(vector_size(argv) == 2) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mSortKindMarkUp = !dir2->mSortKindMarkUp;

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "toggle_sort_dirup") == 0 || strcmp(cmd, "mfiler3_toggle_sort_dirup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 1 || vector_size(argv) == 2) {
                    int dir;
                    if(vector_size(argv) == 1) {
                        dir = adir();
                    }
                    else if(vector_size(argv) == 2) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mSortKindDirUp = !dir2->mSortKindDirUp;

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_sort_markup") == 0 || strcmp(cmd, "mfiler3_set_sort_markup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2 || vector_size(argv) == 3) {
                    int dir;
                    int value;
                    if(vector_size(argv) == 2) {
                        dir = adir();
                        value = atoi(string_c_str(vector_item(argv, 1)));
                    }
                    else if(vector_size(argv) == 3) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                        value = atoi(string_c_str(vector_item(argv, 2)));
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mSortKindMarkUp = value;

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_sort_dirup") == 0 || strcmp(cmd, "mfiler3_set_sort_dirup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2 || vector_size(argv) == 3) {
                    int dir;
                    int value;
                    if(vector_size(argv) == 2) {
                        dir = adir();
                        value = atoi(string_c_str(vector_item(argv, 1)));
                    }
                    else if(vector_size(argv) == 3) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                        value = atoi(string_c_str(vector_item(argv, 2)));
                    }

                    sDir* dir2 = filer_dir(dir);
                    dir2->mSortKindDirUp = value;

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sort_markup") == 0 || strcmp(cmd, "mfiler3_sort_markup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 1 || vector_size(argv) == 2) {
                    int dir;
                    if(vector_size(argv) == 1) {
                        dir = adir();
                    }
                    else if(vector_size(argv) == 2) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                    }

                    sDir* dir2 = filer_dir(dir);

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", dir2->mSortKindMarkUp);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sort_dirup") == 0 || strcmp(cmd, "mfiler3_sort_dirup") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 1 || vector_size(argv) == 2) {
                    int dir;
                    if(vector_size(argv) == 1) {
                        dir = adir();
                    }
                    else if(vector_size(argv) == 2) {
                        dir = atoi(string_c_str(vector_item(argv, 1)));
                    }

                    sDir* dir2 = filer_dir(dir);

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", dir2->mSortKindDirUp);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sort") == 0 || strcmp(cmd, "mfiler3_sort") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                int j;
                for(j=0; j<vector_size(gDirs); j++) {
                    filer_sort(vector_item(gDirs, j));
                }

                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "load") == 0 || strcmp(cmd, "mfiler3_load") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    int result = shell_load(
                        string_c_str(vector_item(argv, 1)), sub_shell);

                    if(result == 0) {
                        rcode = 0;
                    }
                    else {
                        rcode = 1;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "eval") == 0 || strcmp(cmd, "mfiler3_eval") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    string_obj* cmdline = string_new("");
                    int k;
                    for(k=1; k<vector_size(argv); k++) {
                        string_obj* str = vector_item(argv, k);

                        string_push_back(cmdline, string_c_str(str));
                        string_push_back(cmdline, " ");
                    }

                    int result = shell(string_c_str(cmdline)
                                        , "eval", -1, FALSE, sub_shell, -1);

                    if(result == 0) {
                        rcode = 0;
                    }
                    else {
                        rcode = 1;
                    }
                }
                *hitanykey = FALSE;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "vdfinish") == 0 || strcmp(cmd, "mfiler3_vdfinish") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                filer_vd_end(adir());

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "open") == 0 || strcmp(cmd, "mfiler3_open") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);
                
                rcode = 1;
                if(vector_size(argv) == 3) {
                    char* fd = string_c_str(vector_item(argv, 1));
                    char* fname = string_c_str(vector_item(argv, 2));

                    int fdn = open(fname, O_RDONLY) + 1;
                    if(fdn > 1) {
                        hash_put(gFDs, fd, (void*)fdn);
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "close") == 0 || strcmp(cmd, "mfiler3_close") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* fd = string_c_str(vector_item(argv, 1));

                    int fdn = hash_item(gFDs, fd);
                    close(fdn-1);
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "vd") == 0 || strcmp(cmd, "mfiler3_vd") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                filer_vd_start(adir());
                filer_vd_add(adir(), "..");

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);

                    if(r < 0) {
                        perror("read");
                        goto vd_end;
                    }
                    if(r == 0) {
                        break;
                    }

                    buf[r] = 0;
                    string_push_back(str, buf);
                }
                

                char* p = string_c_str(str);

                string_obj* str2 = string_new("");
                while(*p) {
                    if(*p == '\n') {
                        p++;
                        if(strcmp(string_c_str(str2), "") != 0) {
                            filer_vd_add(adir(), string_c_str(str2));
                        }
                        str2 = string_new("");
                    }
                    else {
                        string_push_back2(str2, *p++);
                    }
                }

                if(strcmp(string_c_str(str2), "") != 0) {
                    filer_vd_add(adir(), string_c_str(str2));
                }

vd_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode
                        , pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_archive_title") == 0 
                    || strcmp(cmd, "mfiler3_set_archive_title") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                filer_archive_title(adir(), string_c_str(vector_item(argv, 1)));

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "archive_title") == 0 
                    || strcmp(cmd, "mfiler3_archive_title") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                sDir* dir = filer_dir(adir());
                char buf[BUFSIZ];
                strcpy(buf, dir->mATitle);

                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "vd2") == 0 || strcmp(cmd, "mfiler3_vd2") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                filer_vd2_start(adir());
                filer_vd_add(adir(), "..");

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);

                    if(r < 0) {
                        perror("read");
                        goto vd2_end;
                    }
                    if(r == 0) {
                        break;
                    }

                    buf[r] = 0;
                    string_push_back(str, buf);
                }
                

                char* p = string_c_str(str);

                string_obj* str2 = string_new("");
                while(*p) {
                    if(*p == '\n') {
                        p++;
                        if(strcmp(string_c_str(str2), "") != 0) {
                            filer_vd_add2(adir(), string_c_str(str2));
                        }
                        str2 = string_new("");
                    }
                    else {
                        string_push_back2(str2, *p++);
                    }
                }

                if(strcmp(string_c_str(str2), "") != 0) {
                    filer_vd_add2(adir(), string_c_str(str2));
                }

vd2_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "read") == 0 || strcmp(cmd, "mfiler3_read") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                string_obj* str = string_new("");
                while(1) {
                    char buf[BUFSIZ];
                    int r;
                    if(input_fd == 0)
                        r = read(nextin, buf, BUFSIZ);
                    else
                        r = read(input_fd, buf, BUFSIZ);

                    if(r < 0) {
                        perror("read");
                        goto read_end;
                    }
                    if(r == 0) {
                        break;
                    }

                    buf[r] = 0;
                    string_push_back(str, buf);
                }

                vector_obj* input = vector_new(5);

                string_obj* str2 = string_new("");

                char* p = string_c_str(str);
                while(*p) {
                    if(*p == '\n') {
                        p++;
                        vector_add(input, str2);
                        str2 = string_new("");
                    }
                    else {
                        string_push_back2(str2, *p++);
                    }
                }

                vector_add(input, str2);

                if(vector_size(argv) >= 2) {
                    int j;
                    for(j=1; j<vector_size(argv); j++) {
                        string_obj* str = vector_item(input, j-1);
                        if(str) {
                            setenv(string_c_str((string_obj*)
                              vector_item(argv, j)), string_c_str(str), 1);
                        }
                    }
                }

read_end:
                if(string_length(str) == 0) {
                    rcode = 1;
                }
                else {
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "print") == 0 || strcmp(cmd, "mfiler3_print") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) >= 2) {
                    char buf[BUFSIZ];
                    sprintf(buf, "%s\n", string_c_str(vector_item(argv, 1)));

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "hnumber") == 0 || strcmp(cmd, "mfiler3_hnumber") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                int result = 0;

                if(vector_size(argv) == 2) {
                    char* search = string_c_str(vector_item(argv, 1));

                    char path[PATH_MAX];
                    sprintf(path, "%s/.mhistory3", gHomeDir);

                    if(access(path, R_OK) == 0) {
                        char line[kCmdLineMax];

                        FILE* f = fopen(path, "r+");
                        while(fgets(line, kCmdLineMax, f) != NULL) {
                            line[strlen(line)-1] = 0; // chomp
                            if(strstr(line, search)) {
                                result++;
                            }
                        }
                        fclose(f);
                    }
                }

               char buf[BUFSIZ];
               sprintf(buf, "%d", result);

               if(output_fd == 1)
                   write(nextout, buf, strlen(buf));
               else
                   write(output_fd, buf, strlen(buf));

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "hadd") == 0 || strcmp(cmd, "mfiler3_hadd") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* cmd = string_c_str(vector_item(argv, 1));
                    add_history(cmd);
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "set_related_prog") == 0 
                    || strcmp(cmd, "mfiler3_set_related_prog") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3) {
                    char* ext = string_c_str(vector_item(argv, 1));
                    char* prog = string_c_str(vector_item(argv, 2));

                    if(hash_item(gRelatedProg, ext)) {
                        int j;
                        for(j=0; j<vector_size(gRelatedProg2); j++) {
                            sRelatedProg* rp = vector_item(gRelatedProg2, j);
                            if(strcmp(string_c_str(rp->mExt), ext) == 0) {
                                rp->mProg = string_new(prog);
                                break;
                            }
                        }
                    }
                    else {
                        vector_add(gRelatedProg2, sRelatedProg_new(ext, prog));
                    }
                    hash_put(gRelatedProg, ext, string_new(prog));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "related_prog") == 0 || strcmp(cmd, "mfiler3_related_prog") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* ext = string_c_str(vector_item(argv, 1));
                    string_obj* prog = hash_item(gRelatedProg, ext); 

                    if(prog) {
                       char buf[BUFSIZ];
                       sprintf(buf, "%s\n", string_c_str(prog));

                       if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                       else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "related_prog_prog") == 0 || strcmp(cmd, "mfiler3_related_prog_prog") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int num = atoi(string_c_str(vector_item(argv, 1)));

                    sRelatedProg* rp = vector_item(gRelatedProg2, num);

                    if(rp) {
                       char buf[BUFSIZ];
                       sprintf(buf, "%s\n", string_c_str(rp->mProg));

                       if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                       else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "related_prog_ext") == 0 || strcmp(cmd, "mfiler3_related_prog_ext") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int num = atoi(string_c_str(vector_item(argv, 1)));

                    sRelatedProg* rp = vector_item(gRelatedProg2, num);

                    if(rp) {
                       char buf[BUFSIZ];
                       sprintf(buf, "%s\n", string_c_str(rp->mExt));

                       if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                       else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "related_prog_num") == 0 || strcmp(cmd, "mfiler3_related_prog_num") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment
                        , redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

               char buf[BUFSIZ];
               sprintf(buf, "%d\n", vector_size(gRelatedProg2));

               if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
               else
                    write(output_fd, buf, strlen(buf));
                
                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "new_dir") == 0 || strcmp(cmd, "mfiler3_new_dir") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    char* path = string_c_str(vector_item(argv, 1));
                    filer_new_dir(path);
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "fg") == 0 || strcmp(cmd, "mfiler3_fg") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    if(argv2[0] >= '1' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';
                        shell_forground_job(num-1);
                    }

                    rcode = 0;
                }
                else {
                    shell_forground_job(0);
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "bg") == 0 || strcmp(cmd, "mfiler3_bg") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    if(argv2[0] >= '1' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';
                        shell_background_job(num-1);
                    }

                    rcode = 0;
                }
                else {
                    shell_background_job(0);
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "new_dir") == 0 || strcmp(cmd, "mfiler3_new_dir") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    char* path = string_c_str(vector_item(argv, 1));
                    filer_new_dir(path);
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "del_dir") == 0 || strcmp(cmd, "mfiler3_del_dir") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    int dir = atoi(string_c_str(vector_item(argv, 1)));
                    filer_del_dir(dir);
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);

                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "dir_num") == 0 || strcmp(cmd, "mfiler3_dir_num") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", vector_size(gDirs));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "path") == 0 || strcmp(cmd, "mfiler3_path") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    if(strcmp(argv2, "-s") == 0) {
                        sDir* dir = filer_dir(sdir());
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", dir->mPath);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';

                        sDir* dir = filer_dir(num);
                        if(dir) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%s\n", dir->mPath);
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                        }
                    }
                }
                else {
                    sDir* dir = filer_dir(adir());

                    char buf[BUFSIZ];
                    sprintf(buf, "%s\n", dir->mPath);
                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "cursor") == 0 || strcmp(cmd, "mfiler3_cursor") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    if(strcmp(argv2, "-s") == 0) {
                        sDir* dir = filer_dir(sdir());

                        if(dir) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%d\n", dir->mCursor);
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                            rcode = 0;
                        }
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';

                        sDir* dir = filer_dir(num);

                        if(dir) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%d\n", dir->mCursor);
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                            rcode = 0;
                        }
                    }
                }
                else {
                    sDir* dir = filer_dir(adir());

                    if(dir) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%d\n", dir->mCursor);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                        rcode = 0;
                    }
                }

                /// I ///
                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "kanjicode") == 0 || strcmp(cmd, "mfiler3_kanjicode") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%s\n", gKanjiCodeString[gKanjiCode]);
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "adir") == 0 || strcmp(cmd, "mfiler3_adir") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", adir());
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = adir();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "sdir") == 0 || strcmp(cmd, "mfiler3_sdir") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", sdir());
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = sdir();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "job_name") == 0 || strcmp(cmd, "mfiler3_job_name") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int num = atoi(string_c_str(vector_item(argv, 1)));

                    sJob* job = vector_item(gJobs, num);

                    char buf[BUFSIZ];
                    sprintf(buf, "%s\n", string_c_str(job->mName));
                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "markfiles") == 0 || strcmp(cmd, "mfiler3_markfiles") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3 || vector_size(argv) == 4) {
                    char* var_name;
                    char* len_name;
                    int dir;

                    if(vector_size(argv) == 3) {
                        var_name = string_c_str(vector_item(argv, 1));
                        len_name = string_c_str(vector_item(argv, 2));

                        dir = adir();
                    }
                    else {
                        var_name = string_c_str(vector_item(argv, 2));
                        len_name = string_c_str(vector_item(argv, 3));

                        dir = atoi(string_c_str(vector_item(argv, 1)));
                    }

                    vector_obj* files = filer_mark_files(dir);

                    if(files) {
                        int j;
                        for(j=0; j<vector_size(files); j++) {
                            sFile* fname = vector_item(files, j);

                            char buf[BUFSIZ];
                            sprintf(buf, "%s%d", var_name, j);

                            setenv(buf, fname->mName, 1);
                        }

                        char buf[BUFSIZ];
                        sprintf(buf, "%d", vector_size(files));
                        setenv(len_name, buf, 1);
                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "job_num") == 0 || strcmp(cmd, "mfiler3_job_num") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", vector_size(gJobs));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_name") == 0 || strcmp(cmd, "mfiler3_file_name") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    char* argv3 = string_c_str(
                                    (string_obj*)vector_item(argv, 2));

                    if(strcmp(argv2, "-s") == 0) {
                        sFile* file = filer_file(sdir(), atoi(argv3));
                        if(file) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%s\n", file->mName);
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                        }
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';

                        sFile* file = filer_file(num, atoi(argv3));
                        if(file) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%s\n", file->mName);
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                        }
                    }
                }
                else if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));

                    sDir* dir = filer_dir(adir());

                    sFile* file = filer_file(adir(), atoi(argv2));
                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", file->mName);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_ext") == 0 || strcmp(cmd, "mfiler3_file_ext") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 3) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    char* argv3 = string_c_str(
                                    (string_obj*)vector_item(argv, 2));

                    if(strcmp(argv2, "-s") == 0) {
                        sFile* file = filer_file(sdir(), atoi(argv3));
                        if(file) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%s\n", extname(file->mName));
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                        }
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';

                        sFile* file = filer_file(num, atoi(argv3));
                        if(file) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%s\n", extname(file->mName));
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                        }
                    }
                }
                else if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));

                    sDir* dir = filer_dir(adir());

                    sFile* file = filer_file(adir(), atoi(argv2));
                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", extname(file->mName));
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_index") == 0 || strcmp(cmd, "mfiler3_file_index") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    char* argv1 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", filer_file2(adir(), argv1));

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                    rcode = 0;
                }
                else if(vector_size(argv) == 3) {
                    char* argv1 = string_c_str(
                                (string_obj*)vector_item(argv, 1));
                    char* argv2 = string_c_str(
                                (string_obj*)vector_item(argv, 2));

                    if(strcmp(argv1, "-s") == 0) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%d\n", filer_file2(sdir(), argv2));

                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                        rcode = 0;
                    }
                    else if(argv1[0] >= '0' && argv1[0] <= '9') {
                        int num = argv1[0] - '0';

                        char buf[BUFSIZ];
                        sprintf(buf, "%d\n", filer_file2(num, argv2));
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_user") == 0 || strcmp(cmd, "mfiler3_filer_user") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));

                    sFile* file = filer_file(adir(), argv1);

                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", file->mUser);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }

                    rcode = 0;
                }
                else if(vector_size(argv) == 3) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));
                    int argv2 = atoi(string_c_str(vector_item(argv, 2)));

                    sFile* file = filer_file(argv1, argv2);

                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", file->mUser);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_group") == 0 || strcmp(cmd, "mfiler3_filer_group") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));

                    sFile* file = filer_file(adir(), argv1);

                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", file->mGroup);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }

                    rcode = 0;
                }
                else if(vector_size(argv) == 3) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));
                    int argv2 = atoi(string_c_str(vector_item(argv, 2)));

                    sFile* file = filer_file(argv1, argv2);

                    if(file) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", file->mGroup);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_perm") == 0 || strcmp(cmd, "mfiler3_filer_permission") == 0) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));

                    sFile* file = filer_file(adir(), argv1);

                    if(file) {
                        int n = file->mLStat.st_mode & S_ALLPERM;

                        char buf[BUFSIZ];
                        sprintf(buf, "%o\n", n);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }

                    rcode = 0;
                }
                else if(vector_size(argv) == 3) {
                    int argv1 = atoi(string_c_str(vector_item(argv, 1)));
                    int argv2 = atoi(string_c_str(vector_item(argv, 2)));

                    sFile* file = filer_file(argv1, argv2);

                    if(file) {
                        int n = file->mLStat.st_mode & S_ALLPERM;

                        char buf[BUFSIZ];
                        sprintf(buf, "%o\n", n);
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));

                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "file_num") == 0 || strcmp(cmd, "mfiler3_file_num") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                rcode = 1;
                if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));

                    if(strcmp(argv2, "-s") == 0) {
                        sDir* dir = filer_dir(sdir());
                        if(dir) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%d\n", vector_size(dir->mFiles));
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                            rcode = 0;
                        }
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';

                        sDir* dir = filer_dir(num);
                        if(dir) {
                            char buf[BUFSIZ];
                            sprintf(buf, "%d\n", vector_size(dir->mFiles));
                            if(output_fd == 1)
                                write(nextout, buf, strlen(buf));
                            else
                                write(output_fd, buf, strlen(buf));
                            rcode = 0;
                        }
                    }
                }
                else {
                    sDir* dir = filer_dir(adir());

                    if(dir) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%d\n", vector_size(dir->mFiles));
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "row") == 0 || strcmp(cmd, "mfiler3_row") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", filer_row(adir()));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = filer_row(adir());

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "row_max") == 0 || strcmp(cmd, "mfiler3_row_max") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", filer_row_max(adir()));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "line") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", filer_line(adir()));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "line_max") == 0 || strcmp(cmd, "mfiler3_line_max") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                char buf[BUFSIZ];
                sprintf(buf, "%d\n", filer_line_max(adir()));
                if(output_fd == 1)
                    write(nextout, buf, strlen(buf));
                else
                    write(output_fd, buf, strlen(buf));
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "fcolor") == 0 || strcmp(cmd, "mfiler3_fcolor") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 5) {
                    char* regex = string_c_str(vector_item(argv, 1));

                    int red = atoi(string_c_str(vector_item(argv, 2)));
                    int green = atoi(string_c_str(vector_item(argv, 3)));
                    int blue = atoi(string_c_str(vector_item(argv, 4)));

                    add_fcolor(regex, red, green, blue);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "init256") == 0 || strcmp(cmd, "mfiler3_init256") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                minit256color();

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "final256") == 0 || strcmp(cmd, "mfiler3_final256") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                mfinal256color();

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if((strcmp(cmd, "focus") == 0 || strcmp(cmd, "mfiler3_focus") == 0) && !sub_shell) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);


                gFocus = TRUE;
                rcode = 0;

                if(gChangeTerminalTitle) {
                    printf("%c]2;[mfiler3] %s%c", 033, gTitleBar, 007);
                    fflush(stdout);
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if((strcmp(cmd, "unfocus") == 0 || strcmp(cmd, "mfiler3_unfocus") == 0 ) && !sub_shell) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);


                gFocus = FALSE;
                rcode = 0;

                if(gChangeTerminalTitle) {
                    printf("%c]2;mfiler3 %s%c", 033, gTitleBar, 007);
                    fflush(stdout);
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "activate") == 0 || strcmp(cmd, "mfiler3_activate") == 0 && !sub_shell) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    if(strcmp(argv2, "-s") == 0) {
                        filer_activate(sdir());
                    }
                    else if(argv2[0] >= '0' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';
                        filer_activate(num);
                    }

                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "length") == 0 || strcmp(cmd, "mfiler3_length") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* arg1 = string_c_str(vector_item(argv, 1));
                    int n = strlen(arg1);

                    char buf[BUFSIZ];
                    sprintf(buf, "%d\n", n);
                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
                
            }
            else if(strcmp(cmd, "msg") == 0 || strcmp(cmd, "mfiler3_msg") == 0 && !sub_shell) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                BOOL init_curses = FALSE;
                if(mis_curses() == 0) {
                    minitscr();
                    init_curses = TRUE;
                }

                if(vector_size(argv) == 2) {
                    char* arg1 = string_c_str(vector_item(argv, 1));
                    msg(arg1);
                    rcode = 0;
                }

                if(init_curses) mendwin();

                /// I ///
                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
                
            }
            else if(strcmp(cmd, "cursor_right") == 0 || strcmp(cmd, "mfiler3_cursor_right") == 0 && !sub_shell) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                int n = filer_row_max(adir()) -1;
                if(strcmp(getenv("OPTION_MOVE_PARENT"), "1") == 0
                    && filer_row(adir()) == n
                    && adir() == 1)
                {
                    filer_cd(adir(), "..");
                }
                else if(strcmp(getenv("VIEW_OPTION"), "all") == 0) {
                    filer_activate(1);
                }
                else if(filer_row(adir()) != n) {
                    sDir* dir = filer_dir(adir());
                    int cursor_num = dir->mCursor + filer_line_max(adir());
                    filer_cursor_move(adir(), cursor_num);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "cursor_left") == 0 || strcmp(cmd, "mfiler3_cursor_left") == 0 && !sub_shell) 
            {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(strcmp(getenv("OPTION_MOVE_PARENT"), "1") == 0
                    && filer_row(adir()) == 0
                    && adir() == 0)
                {
                    filer_cd(adir(), "..");
                }
                else if(strcmp(getenv("VIEW_OPTION"), "all") == 0) {
                    filer_activate(0);
                }
                else if(filer_row(adir()) != 0) {
                    sDir* dir = filer_dir(adir());
                    int cursor_num = dir->mCursor - filer_line_max(adir());
                    filer_cursor_move(adir(), cursor_num);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "cursor_move") == 0 || strcmp(cmd, "mfiler3_cursor_move") == 0 && !sub_shell) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 3) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    char* argv3 = string_c_str(
                                    (string_obj*)vector_item(argv, 2));

                    int dir_num;
                    if(strcmp(argv2, "-s") == 0) {
                        dir_num = sdir();
                    }
                    else {
                        dir_num = argv2[0] - '0';
                    }

                    int cursor_num;
                    if(argv3[0] == '+') {
                        char buf[BUFSIZ];
                        memcpy(buf, argv3+1, strlen(argv3));
                        sDir* dir = filer_dir(dir_num);
                        if(dir) {
                            cursor_num = dir->mCursor + atoi(buf);
                        }
                        else {
                            cursor_num = 0;
                        }
                    }
                    else if(argv3[0] == '-') {
                        char buf[BUFSIZ];
                        memcpy(buf, argv3+1, strlen(argv3));
                        sDir* dir = filer_dir(dir_num);
                        if(dir) {
                            cursor_num = dir->mCursor - atoi(buf);
                        }
                    }
                    else if(argv3[0] == '/') {
                        char buf[BUFSIZ];
                        memcpy(buf,argv3+1, strlen(argv3));
                        cursor_num = filer_file2(dir_num, buf);
                        if(cursor_num == -1) {
                            cursor_num = 0;
                        }
                    }
                    else {
                        cursor_num = atoi(argv3);
                    }

                    filer_cursor_move(dir_num, cursor_num);
                }
                else if(vector_size(argv) == 2) {
                    char* argv2 = string_c_str(
                                    (string_obj*)vector_item(argv, 1));
                    
                    int cursor_num;
                    if(argv2[0] == '+') {
                        char buf[BUFSIZ];
                        memcpy(buf, argv2+1, strlen(argv2));
                        sDir* dir = filer_dir(adir());
                        cursor_num = dir->mCursor + atoi(buf);
                    }
                    else if(argv2[0] == '-') {
                        char buf[BUFSIZ];
                        memcpy(buf, argv2+1, strlen(argv2));
                        sDir* dir = filer_dir(adir());
                        cursor_num = dir->mCursor - atoi(buf);
                    }
                    else if(argv2[0] == '/') {
                        char buf[BUFSIZ];
                        memcpy(buf,argv2+1, strlen(argv2));
                        cursor_num = filer_file2(adir(), buf);
                        if(cursor_num == -1) {
                            cursor_num = 0;
                        }
                    }
                    else {
                        cursor_num = atoi(argv2);
                    }

                    filer_cursor_move(adir(), cursor_num);
                }
                else {
                    filer_cursor_move(adir(), 0);
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// exit ///
            else if(strcmp(cmd, "exit") == 0 || strcmp(cmd, "mfiler3_exit") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(sub_shell) {
                    exit(0);
                }
                else {
                    gMainLoop = false;
                }
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// input box ///
            else if(strcmp(cmd, "input") == 0 || strcmp(cmd, "mfiler3_input") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 4) {
                    char* msg = string_c_str(vector_item(argv, 1));
                    char* default_input = string_c_str(vector_item(argv, 2));
                    int default_cursor = atoi(string_c_str(vector_item(argv, 3)));

                    char buf[BUFSIZ];
                    input_box(msg, buf, default_input, default_cursor);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }

            /// msg ///
            else if(strcmp(cmd, "msg") == 0 || strcmp(cmd, "mfiler3_msg") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    msg("%s", string_c_str(vector_item(argv, 1)));
                    rcode = 0;
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "ary_erase") == 0 || strcmp(cmd, "mfiler3_ary_erase") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 3) {
                    vector_obj* v = hash_item(gArrays
                                    , string_c_str(vector_item(argv, 1)));
                    if(v) {
                        int n = atoi(string_c_str(vector_item(argv, 2)));
                        vector_erase(v, n);
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "ary_insert") == 0 || strcmp(cmd, "mfiler3_ary_insert") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 4) {
                    vector_obj* v = hash_item(gArrays
                                    , string_c_str(vector_item(argv, 1)));
                    if(v) {
                        int n = atoi(string_c_str(vector_item(argv, 2)));
                        vector_insert(v, n
                                , string_new(string_c_str(vector_item(argv,3))));
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "ary_add") == 0 || strcmp(cmd, "mfiler3_ary_add") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 3) {
                    vector_obj* v = hash_item(gArrays
                                    , string_c_str(vector_item(argv, 1)));
                    if(v) {
                        vector_add(v, string_new(string_c_str(vector_item(argv,2))));
                        rcode = 0;
                    }
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "ary_new") == 0 || strcmp(cmd, "mfiler3_ary_new") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    vector_obj* v = vector_new(10);
                    hash_put(gArrays, string_c_str(vector_item(argv, 1)), v);
                }

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else if(strcmp(cmd, "ary_length") == 0 || strcmp(cmd, "mfiler3_ary_length") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    vector_obj* v = hash_item(gArrays
                                        , string_c_str(vector_item(argv, 1)));

                    if(v) {
                        char buf[BUFSIZ];
                        sprintf(buf, "%d\n", vector_size(v));
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));
                    }
                }

                /// I ///
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
                
            }
            /// choice ///
            else if(strcmp(cmd, "choice") == 0 || strcmp(cmd, "mfiler3_choice") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                BOOL init_curses = FALSE;
                if(mis_curses() == 0) {
                    minitscr();
                    init_curses = TRUE;
                }

                if(vector_size(argv) >= 3) {
                    char* msg = string_c_str(vector_item(argv, 1));
                    char** str = GC_malloc(sizeof(char*)*vector_size(argv));

                    int j;
                    for(j=2; j<vector_size(argv); j++) {
                        str[j-2] = string_c_str(vector_item(argv, j));
                    }

                    int n = select_str(msg, str, vector_size(argv) -2, -1);
                    char buf[BUFSIZ];
                    sprintf(buf, "%d", n);

                    if(output_fd == 1)
                        write(nextout, buf, strlen(buf));
                    else
                        write(output_fd, buf, strlen(buf));
                }

                if(init_curses) mendwin();

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }

            /// selector ///
            else if(strcmp(cmd, "selector") == 0 || strcmp(cmd, "mfiler3_selector") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2 || vector_size(argv) == 4) {
                    char* fname = string_c_str(vector_item(argv, 1));
                    int scrolltop = 0;
                    int cursor = 0;

                    if(vector_size(argv) == 4) {
                        scrolltop = atoi(string_c_str(vector_item(argv, 2)));
                        cursor = atoi(string_c_str(vector_item(argv, 3)));
                    }

                    string_obj* str = string_new("");
                    int f = open(fname, O_RDONLY);
                    if(f >= 0) {
                        while(1) {
                            char buf[BUFSIZ];
                            int size = read(f, buf, BUFSIZ-1);
                            if(size <= 0) {
                                break;
                            }

                            buf[size] = 0;

                            string_push_back(str, buf);
                        }

                        string_obj* result = string_new("");
                        selector(str, result, &scrolltop, &cursor);

                        char buf[BUFSIZ];
                        sprintf(buf, "%s\n", string_c_str(result));
                        if(output_fd == 1)
                            write(nextout, buf, strlen(buf));
                        else
                            write(output_fd, buf, strlen(buf));

                        sprintf(buf, "%d", scrolltop);
                        setenv("SELECTOR_SCROLLTOP", buf, 1);

                        sprintf(buf, "%d", cursor);
                        setenv("SELECTOR_CURSOR", buf, 1);
                    }
                }


selector_end:
                rcode = 0;

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }


            /// mcp ///
            else if(strcmp(cmd, "mcp") == 0 || strcmp(cmd, "mfiler3_mcp") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) >= 2) {
                    gCopyOverride = kNone;
                    gWriteProtected = kWPNone;

                    /// `FbN ///
                    char* distination = string_c_str(
                        vector_item(argv, vector_size(argv)-1));

                    /// ΏۂfBNg ///
                    struct stat dstat;
                    if(distination[strlen(distination)-1] == '/'
                        || stat(distination, &dstat) == 0 
                                && S_ISDIR(dstat.st_mode)) 
                    {
                        /// fBNgȂ쐬 ///
                        if(stat(distination, &dstat) < 0 
                            || !S_ISDIR(dstat.st_mode)) 
                        {
                            char* str[] = {
                                "yes", "no"
                            };

                            char buf[BUFSIZ];
                            sprintf(buf, "%s doesn't exist. create?", distination);

                            if(select_str(buf, str, 2, 1) == 0) {
                                sprintf(buf, "mkdir -p %s", distination);
                                system(buf);

                                if(stat(distination, &dstat) < 0 
                                    || !S_ISDIR(dstat.st_mode))
                                {
                                    msg("mcp: destination err(%s)", distination);
                                    goto mcp_end;
                                }
                            }
                            else {
                                msg("mcp: destination err(%s)", distination);
                                goto mcp_end;
                            }
                        }

                        /// go ///
                        const int mark_file_num = vector_size(argv) - 1;
                        gProgressMark = mark_file_num;

                        int j;
                        for(j=1; j<vector_size(argv)-1; j++) {
                            char* item = string_c_str(vector_item(argv, j));
                            char source[PATH_MAX];

                            sDir* dir = filer_dir(adir());

                            /// ΃pX ///
                            if(item[0] != '/') {
                                strcpy(source, dir->mPath);
                                strcat(source, item);
                            }
                            else {
                                strcpy(source, item);
                            }

                            char* fname = GC_strdup(basename(GC_strdup(source)));
                            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                                int num;
                                if((num = filer_file2(adir(), item)) < 0) 
                                {
                                    msg("%s doesn't exist", item);
                                    break;
                                }
                                else
                                {
                                    filer_cursor_move(adir(), num);

                                    view();
                                    draw_progress_box(mark_file_num);
                                    mrefresh();
                                    
                                    if(!file_copy(source, distination
                                                    , false, false)) 
                                    {
                                        break;
                                    }

                                    gProgressMark--;
                                    
                                    filer_set_mark(adir(), num, FALSE);
                                }
                            }
                        }
                    }
                    
                    mclear();
                    view();
                    mrefresh();

                    sDir* dir = filer_dir(0);
                    if(strcmp(distination, dir->mPath) == 0) {
                        filer_reread(0);
                    }

                    dir = filer_dir(1);
                    if(strcmp(distination, dir->mPath) == 0) {
                        filer_reread(1);
                    }
                }
mcp_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// mmv ///
            else if(strcmp(cmd, "mmv") == 0 || strcmp(cmd, "mfiler3_mmv") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                
                BOOL force = FALSE;
                int j=0;
                for(j=1; j<vector_size(argv); j++) {
                    char* item = string_c_str(vector_item(argv, j));

                    if(strcmp(item, "-f") == 0) {
                        force = TRUE;
                        vector_erase(argv, j);
                        break;
                    }
                }

                if(vector_size(argv) >= 2) {
                    if(force) {
                        gCopyOverride = kYesAll;
                    }
                    else {
                        gCopyOverride = kNone;
                    }

                    gWriteProtected = kWPNone;

                    /// `FbN ///
                    char* distination = string_c_str(
                        vector_item(argv, vector_size(argv)-1));

                    /// ΏۂfBNg ///
                    struct stat dstat;
                    if(distination[strlen(distination)-1] == '/'
                        || stat(distination, &dstat) == 0 
                                && S_ISDIR(dstat.st_mode)) 
                    {
                        /// fBNgȂ쐬 ///
                        if(stat(distination, &dstat) < 0 
                            || !S_ISDIR(dstat.st_mode)) 
                        {
                            char* str[] = {
                                "yes", "no"
                            };

                            char buf[BUFSIZ];
                            sprintf(buf, "%s doesn't exist. create?", distination);

                            if(select_str(buf, str, 2, 1) == 0) {
                                sprintf(buf, "mkdir -p %s", distination);
                                system(buf);

                                if(stat(distination, &dstat) < 0 
                                    || !S_ISDIR(dstat.st_mode))
                                {
                                    msg("mmv: destination err(%s)", distination);
                                    goto mmv_end;
                                }
                            }
                            else {
                                msg("mmv: destination err(%s)", distination);
                                goto mmv_end;
                            }
                        }

                        /// go ///
                        const int mark_file_num = vector_size(argv) - 1;
                        gProgressMark = mark_file_num;

                        int j;
                        for(j=1; j<vector_size(argv)-1; j++) {
                            char* item = string_c_str(vector_item(argv, j));
                            char source[PATH_MAX];

                            sDir* dir = filer_dir(adir());

                            if(item[0] != '/') {
                                strcpy(source, dir->mPath);
                                strcat(source, item);
                            }
                            else {
                                strcpy(source, item);
                            }

                            char* fname = GC_strdup(basename(GC_strdup(source)));
                            if(strcmp(fname, ".") != 0 && strcmp(fname, "..") != 0) {
                                int num;
                                if((num = filer_file2(adir(), item)) < 0) 
                                {
                                    msg("%s doesn't exist", item);
                                    break;
                                }
                                else
                                {
                                    filer_cursor_move(adir(), num);

                                    view();
                                    draw_progress_box(mark_file_num);
                                    mrefresh();
                                    
                                    if(!file_copy(source, distination
                                                    , true, false)) 
                                    {
                                        break;
                                    }

                                    gProgressMark--;
                                    
                                    filer_set_mark(adir(), num, FALSE);
                                }
                            }
                        }
                    }
                    
                    mclear();
                    view();
                    mrefresh();

                    filer_reread(0);
                    filer_reread(1);
                }
mmv_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// mrm ///
            else if(strcmp(cmd, "mrm") == 0 || strcmp(cmd, "mfiler3_mrm") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);
                
                if(vector_size(argv) >= 2) {
                    gCopyOverride = kNone;
                    gWriteProtected = kWPNone;

                    /// go ///
                    const int mark_file_num = vector_size(argv) - 1;
                    gProgressMark = mark_file_num;

                    int j;
                    for(j=1; j<vector_size(argv); j++) {
                        char* item = string_c_str(vector_item(argv, j));

                        if(strcmp(item, ".") != 0 && strcmp(item, "..") != 0) {
                            char source[PATH_MAX];

                            if(item[0] != '/') {
                                sDir* dir = filer_dir(adir());
                                strcpy(source, dir->mPath);
                                strcat(source, item);

                                int num;
                                if((num = filer_file2(adir(), item)) < 0) 
                                {
                                    msg("%s doesn't exist", item);
                                    break;
                                }
                                else
                                {
                                    filer_cursor_move(adir(), num);

                                    view();
                                    draw_progress_box(mark_file_num);
                                    mrefresh();
                                    
                                    if(!file_remove(source, false, true))
                                    {
                                        break;
                                    }

                                    gProgressMark--;
                                    
                                    filer_set_mark(adir(), num, FALSE);
                                }
                            }
                            else {
                                strcpy(source, item);
                                
                                if(access(source, R_OK) != 0) {
                                    msg("%s does't exist", source);
                                    break;
                                }
                                else {
                                    view();
                                    draw_progress_box(mark_file_num);
                                    mrefresh();
                                    
                                    if(!file_remove(source, false, true))
                                    {
                                        break;
                                    }

                                    gProgressMark--;
                                }
                            }
                        }
                    }
                    
                    mclear();
                    view();
                    mrefresh();

                    filer_reread(0);
                    filer_reread(1);
                }
mrm_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            /// let ///
            else if(strcmp(cmd, "let") == 0 || strcmp(cmd, "mfiler3_let") == 0) {
                int input_fd;
                int output_fd;
                
                inner_command_init(i, pipein, statment, redirections, sub_shell
                    , &output_fd, &input_fd, nextin, nextout);

                if(vector_size(argv) == 2) {
                    char* p = string_c_str(vector_item(argv, 1));
                    char var_name[BUFSIZ];
                    char* p2 = var_name;
                    while(*p != '=') {
                        *p2++ = *p++;
                        if(*p == 0) {
                            err_msg("need =", sub_shell);
                            goto let_end;
                        }
                    }
                    *p2 = 0;
                    p++;

                    int n = calculate(p, sub_shell);
                    char buf2[BUFSIZ];
                    sprintf(buf2, "%d", n);

                    setenv(var_name, buf2, 1);

                    rcode = n;
                }
let_end:

                inner_command_final(i, statment, pipein, &nextin, &nextout, &rcode, pipefds[0], &input_fd, &output_fd, flg_function);
                last_command_is_inner = TRUE;
            }
            else {
                last_command_is_inner = FALSE;

                /// R}h̃t@C֘At ///
                if(!in_fun) {
                    char* prog = string_c_str(vector_item(argv, 0));

                    int l;
                    for(l=1; l<vector_size(argv); l++) {
                        char* arg = string_c_str(vector_item(argv, l));
                        char* ext = extname(arg);

                        if(arg[0] != '-' && strcmp(ext, "") != 0) {
                            if(hash_item(gRelatedProg, ext)) {
                                int j;
                                for(j=0; j<vector_size(gRelatedProg2); j++) {
                                    sRelatedProg* rp = vector_item(gRelatedProg2, j);
                                    if(strcmp(string_c_str(rp->mExt), ext) == 0) {
                                        rp->mProg = string_new(prog);
                                        break;
                                    }
                                }
                            }
                            else {
                                vector_add(gRelatedProg2, sRelatedProg_new(ext, prog));
                            }
                            hash_put(gRelatedProg, ext, string_new(prog));
                        }
                    }
                }

                /// fork ///
                pid_t pid = fork();
                if(pid < 0) {
                    perror("fork");
                    exit(1);
                }

                /// qvZX̏ ///
                if(pid == 0) {
                    // VOi //
                    set_signal_subshell();

                    /// vZXO[v ///
                    if(job->mPGroup == -1) {
                        job->mPGroup = getpid();

                        /// Ǝ̃vZXO[vɂ ///
                        if(setpgid(0, job->mPGroup) < 0) {
                            perror("setpgid(child)");
                            exit(1);
                        }

                        /// Oɏo ///
                        if(!statment->background) {
                            if(tcsetpgrp(0, job->mPGroup) < 0) {
                                perror("tcsetpgrp(child)");
                                exit(1);
                            }
                        }

                        shared_memory->first_process = 1;
                    }
                    else {
                        while(shared_memory->first_process == 0) {
                        }

                        /// Ǝ̃vZXO[vɂ ///
                        if(setpgid(0, job->mPGroup) < 0) {
                            perror("setpgid2(child)");
                            exit(1);
                        }

                        /// [Oɏo ///
                        if(!statment->background) {
                            if(tcsetpgrp(0, job->mPGroup) < 0) {
                                perror("tcsetpgrp2(child)");
                                exit(1);
                            }
                        }
                    }

                    set_signal_clear();
/*
char buf[BUFSIZ];
strcpy(buf, "");
int l;
for(l=0; l<vector_size(argv); l++) {
    strcat(buf, string_c_str(vector_item(argv, l)));
}
*/

                    /// _CNg ///
                    int j;
                    for(j=0; j<vector_size(redirections); j++) {
                        sRedirect* redirect = (sRedirect*)
                                vector_item(redirections, j);
                        if(redirect->mType == kRedirectErrAndOutput) {
                            if(dup2(nextout, 2) < 0) {
                                perror("dup2 3-1");
                                exit(1);
                            }
                        }
                        else {
                            mode_t mode;
                            switch(redirect->mType) {
                                case kRedirectInput:
                                    mode = O_RDONLY;
                                    break;
                                
                                case kRedirectOverwrite:
                                    mode = O_RDWR | O_CREAT | O_TRUNC;
                                    break;
                                    
                                case kRedirectAppend:
                                    mode = O_RDWR | O_CREAT | O_APPEND;
                                    break;
                            }
                            
                            int openfd = open(redirect->mFName, mode, 0666);
                            if(openfd < 0) {
                                fprintf(stderr, "open %s is err", redirect->mFName);
                                exit(1);
                            }
                            
                            if(openfd != redirect->mFd) {
                                if(dup2(openfd, redirect->mFd) < 0) {
                                    perror("dup2 3");
                                    exit(1);
                                }
                                close(openfd);
                            }
                        }
                    }

                    /// pCv ///
                    if(nextin != 0) {
                        if(dup2(nextin, 0) < 0) {
                            perror("dup2 1");
                            exit(1);
                        }
                        close(nextin);
                    }
                    
                    if(nextout != 1) {
                        if(dup2(nextout, 1) < 0) {
                            perror("dup2 2");
                            exit(1);
                        }
                        if(!flg_function
                            || flg_function && nextout != pipein)
                        {
                            close(nextout);
                        }
                    }

                    /// char** ɕϊ ///
                    char** argv2 = (char**)malloc(sizeof(char*)*(vector_size(argv)+1));

                    for(i=0; i<vector_size(argv); i++) {
                        string_obj* item = (string_obj*)vector_item(argv, i);
                        argv2[i] = string_c_str(item);
                    }
                    argv2[i] = NULL;

                    /// exec ///
                    execvp(argv2[0], argv2);
                    fprintf(stderr, "exec('%s') error", argv2[0]);
                    exit(1);
                }
                /// evZX̏ ///
                else {
                    if(job->mPGroup == -1) {
                        job->mPGroup = pid;

                        // qƎvZXO[vɓ
                        if(setpgid(pid, job->mPGroup) < 0
                            && !errno == EACCES) 
                        {
                            perror("setpgid1(parent)");
                            exit(1);
                        }
                    }
                    else {
                        // qƎ̃vZXO[vɓ
                        if(setpgid(pid, job->mPGroup) < 0 
                            && !errno == EACCES) 
                        {
                            perror("setpgid2(parent)");
                            exit(1);
                        }
                    }

                    sJob_AddChildProgram(job, pid, argv, 0);

                    if(nextin != 0) {
                        close(nextin);
                    }
                    if(nextout != 1 && nextout != 0 &&
                        (!flg_function
                            || flg_function && nextout != pipein) )
                        close(nextout);
                    
                    nextin = pipefds[0];
                }
            }
        }
    }
run_command_end:

    /// L ///
    if(shmdt(shared_memory) == -1) {
        fprintf(stderr, "shmdt failed\n");
        exit(1);
    }

    if(shmctl(shared_memory_id, IPC_RMID, 0) == -1) {
        if(sub_shell) fprintf(stderr, "subshell\n");
        //perror("shmctl(IPC_RMID)");
    }

    vector_add(gJobs, job);

    /// tHAOhWȕ ///
    if(!statment->background || job->mRunningProgs == 0) {
        gForgroundJob = job;

        if(gForgroundJob->mRunningProgs == 0) {
            int i;
            for(i = 0; i<vector_size(gJobs); i++) {
                if(vector_item(gJobs, i) == gForgroundJob) {
                    vector_erase(gJobs, i);
                    break;
                }
            }
            gForgroundJob = NULL;

            if(last_command_is_inner == FALSE) {
                rcode = 0;
            }
        }
        else {
            if(vector_size(gForgroundJob->mChildPrograms) > 0) {
                if(change_title && gChangeTerminalTitle) {
                    printf("%c]2;mfiler3 %s%c", 033
                                , string_c_str(gForgroundJob->mName), 007);
                    fflush(stdout);
                }

                while(gForgroundJob 
                    && vector_size(gForgroundJob->mChildPrograms) > 0)
                {
                    sChildProgram* prog = (sChildProgram*)
                            vector_item(gForgroundJob->mChildPrograms, 0);
                    int status = 0;
                    pid_t pid = waitpid(prog->mPid, &status, WUNTRACED);
    
                    if(pid) {
                        /// VOi̔zɂIꍇ ///
                        if(WIFSIGNALED(status)) {
                            gForgroundJob->mRunningProgs--;
                            vector_erase(gForgroundJob->mChildPrograms, 0);

                            if(gForgroundJob->mRunningProgs == 0) {
                                int i;
                                for(i=0; i<vector_size(gJobs); i++) {
                                    if(vector_item(gJobs, i) == gForgroundJob) {
                                        vector_erase(gJobs, i);
                                        break;
                                    }
                                }
                                gForgroundJob = NULL;

                                if(!quick && !sub_shell) {
                                    filer_reread(0);
                                    filer_reread(1);
                                }

                                if(tcsetpgrp(0, getpid())) {
                                    perror("tcsetpgrp(mfiler3)");
                                    exit(1);
                                }

                                if(last_command_is_inner == FALSE) {
                                    rcode = WTERMSIG(status);
                                    char buf[256];
                                    sprintf(buf, "%d", rcode);
                                    setenv("?", buf, 1);
                                }
                            }

                            *break_ = TRUE;
                        }
                        /// Iꍇ ///
                        else if(WIFEXITED(status)) {
                            gForgroundJob->mRunningProgs--;
                            vector_erase(gForgroundJob->mChildPrograms, 0);

                            if(gForgroundJob->mRunningProgs == 0) {
                                int i;
                                for(i=0; i<vector_size(gJobs); i++) {
                                    if(vector_item(gJobs, i) == gForgroundJob) {
                                        vector_erase(gJobs, i);
                                        break;
                                    }
                                }
                                gForgroundJob = NULL;

                                if(!quick && !sub_shell) {
                                    filer_reread(0);
                                    filer_reread(1);
                                }

                                if(tcsetpgrp(0, getpid())) {
                                    perror("tcsetpgrp(mfiler3)");
                                    exit(1);
                                }

                                if(last_command_is_inner == FALSE) {
                                    rcode = WEXITSTATUS(status);
                                    char buf[256];
                                    sprintf(buf, "%d", rcode);
                                    setenv("?", buf, 1);
                                }
                            }
                        }
                        /// VOi̔zɂ~ꍇ ///
                        else if(WIFSTOPPED(status)) {
                            gForgroundJob = NULL;

                            if(tcsetpgrp(0, getpid())) {
                                perror("tcsetpgrp(mfiler3) WIFSTOPPED");
                                exit(1);
                            }
                        }
                    }
                }

                if(change_title && gChangeTerminalTitle) {
                    if(gFocus) {
                        printf("%c]2;[mfiler3] %s%c", 033, gTitleBar, 007);
                        fflush(stdout);
                    }
                    else {
                        printf("%c]2;mfiler3 %s%c", 033, gTitleBar, 007);
                        fflush(stdout);
                    }
                }
            }
        }
    }
    else {
        if(last_command_is_inner == FALSE) {
            rcode = 1;
        }
    }
    return rcode;
}

///////////////////////////////////////////////////////////////////////////////
// VF
///////////////////////////////////////////////////////////////////////////////
string_obj* shell3(char* cmd)
{
    int pipefds[2];

    if(pipe(pipefds) < 0) {
        perror("pipe");
        exit(1);
    }

    shell(cmd, NULL, pipefds[1], FALSE, FALSE, -1);
    string_obj* result = string_new("");

    char buf[BUFSIZ];
    while(1) {
        int size = read(pipefds[0], buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            fprintf(stderr, "expand command err(read)");
            close(pipefds[0]);
            close(pipefds[1]);
            return Qnil;
        }

        buf[size] = 0;

        string_push_back(result, buf);
    }
    close(pipefds[0]);
    close(pipefds[1]);

    return result;
}

int shell(char* cmdline, char* title, int pipein, int flg_function, BOOL sub_shell, int cursor_pos)
{
    string_obj* cmdline2 = string_new(cmdline);

    string_obj* cmdline3 = string_new("");
    BOOL hitanykey = TRUE;
    BOOL quick = FALSE;
    BOOL reset_marks = TRUE;
    BOOL append_history = TRUE;
    BOOL change_title = TRUE;
    BOOL screen_mode = FALSE;
    BOOL ruby_mode = FALSE;
    BOOL xterm = FALSE;
    if(!expand_special_macro(cmdline2, cmdline3
          , &hitanykey, &quick, &reset_marks, &append_history
          , &change_title
          , &screen_mode, &ruby_mode, &xterm)) 
    {
        err_msg("expand special macro err", sub_shell);
        return 1;
    }

    string_obj* title2 = string_new("");
    if(title) {
        expand_macro(title, title2, FALSE);
    }
    else {
        expand_macro(string_c_str(cmdline3), title2, FALSE);
    }

    /// qXgɉ ///
    if(append_history && !sub_shell) {
        add_history(cmdline);

        string_obj* str = string_new("");
        expand_macro(cmdline, str, sub_shell);
        if(strcmp(cmdline, string_c_str(str)) != 0) {
            add_history(string_c_str(str));
        }
    }

    /// xterm mode ///
    if(xterm) {
        char* xterm_type = getenv("XTERM_TYPE");

        string_obj* cmdline4 = string_new("");
        if(!expand_macro(string_c_str(cmdline3), cmdline4, sub_shell)) {
            err_msg("expand macro err", sub_shell);
            return 1;
        }

        /// normal xterm ///
        if(atoi(xterm_type) == 0) {
            char* argv[256];

            argv[0] = getenv("XTERM_PROG");
            argv[1] = getenv("XTERM_OPT_TITLE");
            argv[2] = string_c_str(title2);

            int arg_num = 0;
            int c = 0;
            char buf2[128][128];

            char* p = getenv("XTERM_OPT_EXTRA");

            while(*p == ' ') p++;

            if(*p != 0) {
                while(1) {
                    if(*p == ' ') {
                        buf2[arg_num][c] = 0;
                        c = 0;
                        arg_num++;

                        while(*p == ' ') p++;
                    }
                    else if(*p == 0) {
                        buf2[arg_num][c] = 0;
                        arg_num++;
                        break;
                    }
                    else {
                        buf2[arg_num][c++] = *p++;
                    }
                }
            }

            int i;
            for(i=0; i<arg_num; i++) {
                argv[3+i] = buf2[i];
            }

            argv[3+arg_num] = getenv("XTERM_OPT_EVAL");
            argv[4+arg_num] = "/bin/sh";
            argv[5+arg_num] = "-c";

            if(hitanykey && !quick) {
                string_insert(cmdline4, 0, "( ");
                char tmp[256];
                sprintf(tmp, "%s", " ); echo; echo 'HIT ENTER KEY'; read");
                //sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'; echo; echo 'HIT ENTER KEY'; read");
                
                string_push_back(cmdline4, tmp);
            }
            else {
                string_insert(cmdline4, 0, "( ");
                char tmp[256];
                sprintf(tmp, "%s", " );");
                //sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'");

                string_push_back(cmdline4, tmp);
            }

            argv[6+arg_num] = string_c_str(cmdline4);
            argv[7+arg_num] = NULL;

            pid_t pid = fork();
            if(pid == -1) {
                fprintf(stderr, "fork failed");
                exit(1);
            }

            if(pid == 0) {
                if(execvp(getenv("XTERM_PROG"), argv) < 0) {
                    fprintf(stderr, "execvp failed");
                    exit(0);
                }
            }
            
            //waitpid(pid, NULL, 0);

            if(reset_marks && !quick) {
                filer_reset_marks(adir());
            }
        }
        /// GNOME terminal ///
        else {
            char* argv[256];

            argv[0] = getenv("XTERM_PROG");
            argv[1] = getenv("XTERM_OPT_TITLE");
            argv[2] = string_c_str(title2);

            int arg_num = 0;
            int c = 0;
            char buf2[128][128];

            char* p = getenv("XTERM_OPT_EXTRA");

            while(*p == ' ') p++;

            if(*p != 0) {
                while(1) {
                    if(*p == ' ') {
                        buf2[arg_num][c] = 0;
                        c = 0;
                        arg_num++;

                        while(*p == ' ') p++;
                    }
                    else if(*p == 0) {
                        buf2[arg_num][c] = 0;
                        arg_num++;
                        break;
                    }
                    else {
                        buf2[arg_num][c++] = *p++;
                    }
                } } int i; for(i=0; i<arg_num; i++) { argv[3+i] = buf2[i];
            }

            argv[3+arg_num] = getenv("XTERM_OPT_EVAL");

            if(hitanykey && !quick) {
                string_insert(cmdline4, 0, "( ");
                char tmp[256];
                sprintf(tmp, "%s", " ); echo; echo 'HIT ENTER KEY'; read");
                //sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'; echo; echo 'HIT ENTER KEY'; read");
                
                string_push_back(cmdline4, tmp);
            }
            else {
                string_insert(cmdline4, 0, "( ");
                char tmp[256];
                sprintf(tmp, "%s", " );");
                //sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'");

                string_push_back(cmdline4, tmp);
            }

            string_obj* str = string_new("");
            string_push_back(str, "sh -c \"");
            string_push_back(str, string_c_str(cmdline4));
            string_push_back(str, "\"");

            argv[4+arg_num] = string_c_str(str);
            argv[5+arg_num] = NULL;

            pid_t pid = fork();
            if(pid == -1) {
                fprintf(stderr, "fork failed");
                exit(1);
            }

            if(pid == 0) {
                if(execvp(getenv("XTERM_PROG"), argv) < 0) {
                    fprintf(stderr, "execvp failed");
                    exit(0);
                }
            }

            //waitpid(pid, NULL, 0);

            if(reset_marks && !quick) {
                filer_reset_marks(adir());
            }
        }
    }
    /// ruby mode ///
    else if(ruby_mode) {
        if(!quick && !sub_shell) {
            mendwin();
            set_signal_sigint();

            mclear_immediately();
            mmove_immediately(0, 0);
            fflush(stdout);
        }

        int error;

        VALUE value;
        value = rb_eval_string_protect(string_c_str(cmdline3), &error);
        
        if(error) {
            if(quick) {
                mendwin();

                mclear_immediately();
                mmove_immediately(0, 0);
                fflush(stdout);
            }
            
            switch(error) {
            case TAG_RETURN:
                fprintf(stderr, "unexpected return\n");
                break;
                
            case TAG_NEXT:
                fprintf(stderr, "unexpected next\n");
                break;
                
            case TAG_BREAK:
                fprintf(stderr, "unexpected break\n");
                break;
                
            case TAG_REDO:
                fprintf(stderr, "unexpected redo\n");
                break;
                
            case TAG_RETRY:
                fprintf(stderr, "retry outside of rescue clause\n");
                break;
                
            case TAG_RAISE:
            case TAG_FATAL:
                fprintf(stderr, "%s: %s\n",
                    rb_class2name(CLASS_OF(ruby_errinfo)),
                    RSTRING(rb_obj_as_string(ruby_errinfo))->ptr);
                break;
            
            default:
                fprintf(stderr, "unknown longjmp status %d\n", error);
                break;
            }
            

            if(quick) {
                printf("\nHIT ANY KEY");
                fflush(stdout);

                minitscr();

                int meta;
                mgetch(&meta);

                mclear();

                mclear_immediately();
            }
        }
        else {
            if(!quick) {
                printf("=> ");
                rb_p(value);
            }
        }

        if(!quick) {
            if(hitanykey || error) {
                printf("\nHIT ANY KEY");
                fflush(stdout);
            }

            minitscr();

            if(hitanykey || error) {
                int meta;
                mgetch(&meta);
            }

            mclear();

            mclear_immediately();
        }
    }
    /// XN[[hs ///
    else if(screen_mode) {
        char* argv[7];

        argv[0] = "screen";
        argv[1] = "-t";
        argv[2] = string_c_str(title2);
        argv[3] = getenv("SHELL");
        argv[4] = "-c";
        argv[6] = NULL;

        string_obj* cmd2 = string_new("");
        if(!expand_macro(string_c_str(cmdline3), cmd2, sub_shell)) {
            err_msg("expand macro err", sub_shell);
            if(!quick && !sub_shell) {
                minitscr();
                set_signal_sigint_clear();
                mclear();

                mclear_immediately();
            }
            return 1;
        }

        if(hitanykey && !quick) {
            string_insert(cmd2, 0, "( ");
            char tmp[256];
            sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'; echo; echo 'HIT ENTER KEY'; read");

            string_push_back(cmd2, tmp);
        }
        else {
            string_insert(cmd2, 0, "( ");
            char tmp[256];
            sprintf(tmp, "%s", " ); mfiler3 -e '%Q%h reread'");

            string_push_back(cmd2, tmp);
        }

        argv[5] = string_c_str(cmd2);

        pid_t pid = fork();
        if(pid == -1) {
            fprintf(stderr, "fork failed");
            exit(1);
        }
        if(pid == 0) {
            execvp("screen", argv);
        }

        waitpid(pid, NULL, 0);

        if(reset_marks && !quick) {
            filer_reset_marks(adir());
        }

        return 0;
    }
    else {
        if(!quick && !sub_shell) {
            mendwin();
            set_signal_sigint();

            mclear_immediately();
            mmove_immediately(0, 0);
            fflush(stdout);
        }

        /// s ///
        int rcode = 0;
        char* pointer = string_c_str(cmdline3);
        BOOL terminated = TRUE;
        while(*pointer) {
            /// s𓾂 ///
            sStatment* statment = sStatment_new();
            string_obj* statment1 = string_new("");
            if(!get_one_line(&pointer, statment1, sub_shell)) {
                err_msg("get one line err", sub_shell);
                if(!quick && !sub_shell) {
                    minitscr();
                    set_signal_sigint_clear();
                    mclear();

                    mclear_immediately();
                }
                return 1;
            }
            
            /// ϐ̓WJ ///
            string_obj* statment2 = string_new("");
            if(!expand_env(statment1, statment2, sub_shell)) {
                err_msg("expand env err", sub_shell);
                if(!quick && !sub_shell) {
                    minitscr();
                    set_signal_sigint_clear();
                    mclear();

                    mclear_immediately();
                }
                return 1;
            }

            /// }N̓WJ ///
            string_obj* statment3 = string_new("");
            if(!expand_macro(string_c_str(statment2), statment3, sub_shell)) {
                err_msg("expand macro err", sub_shell);
                if(!quick && !sub_shell) {
                    minitscr();
                    set_signal_sigint_clear();
                    mclear();

                    mclear_immediately();
                }
                return 1;
            }

            /// p[X ///
            if(!parse(string_c_str(statment3), statment, sub_shell)) {
                err_msg("parser err", sub_shell);
                if(!quick && !sub_shell) {
                    minitscr();
                    set_signal_sigint_clear();
                    mclear();

                    mclear_immediately();
                }
                return 1;
            }

            /// R}hs ///
            int break2;
            int return2;
            if(!terminated) {
                if(statment->terminated == kTNormal) {
                    terminated = TRUE;
                }
            }
            else {
                rcode = run_command(&break2, &return2, statment, pipein, 
                                flg_function, string_c_str(title2)
                                , quick, &hitanykey, change_title
                                , FALSE, sub_shell);

                if(statment->terminated == kOrOr) {
                    if(rcode == 0) {
                        terminated = FALSE;
                    }
                }
                else if(statment->terminated == kAndAnd) {
                    if(rcode != 0) {
                        terminated = FALSE;
                    }
                }
            }
            if(break2) {
                break;
            }
            if(return2) {
                break;
            }
        }

        if(hitanykey && !sub_shell) {
            if(mis_curses() > 0) {
                printf("\nHIT ANY KEY");
                fflush(stdout);

                int meta;
                mgetch(&meta);
            }
            else {
                printf("\nHIT ANY KEY");
                fflush(stdout);

                minitscr();
                int meta;
                mgetch(&meta);
                mendwin();
            }
        }

        if(!sub_shell) {
            if(!quick) {
                minitscr();
                set_signal_sigint_clear();
                mclear();
            }

            if(reset_marks && !quick) {
                filer_reset_marks(adir());
            }
        }

        return rcode;
    }
}

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////
void shell_view()
{
    const int maxy = mgetmaxy();
    const int maxx = mgetmaxx();

    const int size = vector_size(gJobs);
    int i;
    for(i=0; i<size; i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);

        const int x = (maxx/size)*i;
        char buf[BUFSIZ];
        sprintf(buf, "[%d]%s", i+1, string_c_str(job->mName));
        char buf2[BUFSIZ];
        
        str_cut(buf, maxx/size, buf2, BUFSIZ);

        int fkey_space = atoi(getenv("FKEY_SPACE"));
        mmvprintw(maxy-3-fkey_space, x, "%s", buf2);
    }
}

///////////////////////////////////////////////////////////////////////////////
// Wu̐
///////////////////////////////////////////////////////////////////////////////
int shell_job_num()
{
    return vector_size(gJobs);
}

///////////////////////////////////////////////////////////////////////////////
// Wũ^CgԂ
///////////////////////////////////////////////////////////////////////////////
char* shell_job_title(int num)
{
    if(num>=0 && num < vector_size(gJobs)) {
        sJob* job = (sJob*)vector_item(gJobs, num);
        return string_c_str(job->mName);
    }
    else {
        return NULL;
    }
}

///////////////////////////////////////////////////////////////////////////////
// Wu
///////////////////////////////////////////////////////////////////////////////
void shell_kill_job(int num)
{
    if(num>=0 && num < vector_size(gJobs)) {
        sJob* job = (sJob*)vector_item(gJobs, num);

        int i;
        for(i=0; i<vector_size(job->mChildPrograms); i++) {
            sChildProgram* prog 
                = (sChildProgram*)vector_item(job->mChildPrograms, i);
            kill(prog->mPid, SIGKILL);
        }

        vector_erase(gJobs, num);
    }
}

///////////////////////////////////////////////////////////////////////////////
// WuOʂɏo
///////////////////////////////////////////////////////////////////////////////
void shell_forground_job(int num)
{
    if(num>=0 && num < vector_size(gJobs)) {
        sJob* job = (sJob*)vector_item(gJobs, num);
        if(job->mRunningProgs == 0) {   // R}h
            return;
        }

        BOOL flg_curses = FALSE;
        if(mis_curses()) {
            flg_curses = TRUE;
            mendwin();
        }

        struct termios tty;
        tcgetattr(STDIN_FILENO, &tty);

        mclear_immediately();
        mmove_immediately(0, 0);
        fflush(stdout);

        gForgroundJob = job;
        
        if(tcsetpgrp(0, gForgroundJob->mPGroup)) {
            perror("tcsetpgrp forground job");
            exit(1);
        }
        
        if(killpg(gForgroundJob->mPGroup, SIGCONT) < 0) {
            sChildProgram* prog = 
                (sChildProgram*)vector_item(job->mChildPrograms, 0);
            kill(prog->mPid, SIGCONT);
        }
        
        wait_forground_job(TRUE);
        
        tcsetattr(STDIN_FILENO, TCSANOW, &tty);

        if(flg_curses) {
            minitscr();
            set_signal_sigint_clear();
            mclear();
        }

        mclear_immediately();
    }
}

///////////////////////////////////////////////////////////////////////////////
// WuSIGCONT
///////////////////////////////////////////////////////////////////////////////
static void shell_background_job(int num)
{
    if(num>=0 && num < vector_size(gJobs)) {
        sJob* job = (sJob*)vector_item(gJobs, num);
        if(job->mRunningProgs == 0) {   // R}h
            return;
        }
        
        if(killpg(job->mPGroup, SIGCONT) < 0) {
            sChildProgram* prog = 
                (sChildProgram*)vector_item(job->mChildPrograms, 0);
            kill(prog->mPid, SIGCONT);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// SẴWukill
///////////////////////////////////////////////////////////////////////////////
void shell_kill_all_jobs()
{
    int i;
    for(i=0; i<vector_size(gJobs); i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);
        
        int j;
        for(j=0; j<vector_size(job->mChildPrograms); j++) {
            sChildProgram* prog = (sChildProgram*)vector_item(job->mChildPrograms, j);
            kill(prog->mPid, SIGKILL);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// tHAOhWȕI҂
///////////////////////////////////////////////////////////////////////////////
int wait_forground_job(BOOL quick)
{
    int return_code = 0;

    if(vector_size(gForgroundJob->mChildPrograms) > 0) {
        if(gChangeTerminalTitle) {
            printf("%c]2;mfiler3 %s%c", 033
                        , string_c_str(gForgroundJob->mName), 007);
            fflush(stdout);
        }

        while(gForgroundJob && vector_size(gForgroundJob->mChildPrograms) > 0) {
            sChildProgram* prog 
               = (sChildProgram*)vector_item(gForgroundJob->mChildPrograms, 0);
            int status = 0;
            pid_t pid = waitpid(prog->mPid, &status, WUNTRACED);
            
            if(pid) {
                /// Iꍇ ///
                if(WIFEXITED(status)) {
                    gForgroundJob->mRunningProgs--;
                    vector_erase(gForgroundJob->mChildPrograms, 0);

                    if(gForgroundJob->mRunningProgs == 0) {
                        int i;
                        for(i=0; i<vector_size(gJobs); i++) {
                            if(vector_item(gJobs, i) == gForgroundJob) {
                                vector_erase(gJobs, i);
                                break;
                            }
                        }
                        gForgroundJob = NULL;

                        if(!quick) {
                            filer_reread(0);
                            filer_reread(1);
                        }

                        if(tcsetpgrp(0, getpid())) {
                            perror("tcsetpgrp");
                            exit(1);
                        }

                        return_code = WEXITSTATUS(status);
                        char buf[256];
                        sprintf(buf, "%d", return_code);
                        setenv("?", buf, 1);
                    }
                }
                else if(WIFSIGNALED(status)) {
                    gForgroundJob->mRunningProgs--;
                    vector_erase(gForgroundJob->mChildPrograms, 0);

                    if(gForgroundJob->mRunningProgs == 0) {
                        int i;
                        for(i=0; i<vector_size(gJobs); i++) {
                            if(vector_item(gJobs, i) == gForgroundJob) {
                                vector_erase(gJobs, i);
                                break;
                            }
                        }
                        gForgroundJob = NULL;

                        if(!quick) {
                            filer_reread(0);
                            filer_reread(1);
                        }

                        if(tcsetpgrp(0, getpid())) {
                            perror("tcsetpgrp");
                            exit(1);
                        }

                        return_code = WTERMSIG(status);
                        char buf[256];
                        sprintf(buf, "%d", return_code);
                        setenv("?", buf, 1);
                    }
                }
                /// VOi̔zɂtHOhWu~ꍇ ///
                else if(WIFSTOPPED(status)) {
                    gForgroundJob = NULL;

                    if(tcsetpgrp(0, getpid())) {
                        perror("tcsetpgrp");
                        exit(1);
                    }
                }
            }
        }

        if(gChangeTerminalTitle) {
            if(gFocus) {
                printf("%c]2;[mfiler3] %s%c", 033, gTitleBar, 007);
                fflush(stdout);
            }
            else {
                printf("%c]2;mfiler3 %s%c", 033, gTitleBar, 007);
                fflush(stdout);
            }
        }
    }

    return return_code;
}

///////////////////////////////////////////////////////////////////////////////
// obNOEhWuIĂΌ㏈
///////////////////////////////////////////////////////////////////////////////
void shell_wait_backgroud_job()
{
    int i = 0;
while_start:
    for(i=0; i<vector_size(gJobs); i++) {
        sJob* job = (sJob*)vector_item(gJobs, i);
        int j;
        for(j=0; j<vector_size(job->mChildPrograms); j++) {
            sChildProgram* prg 
                = (sChildProgram*)vector_item(job->mChildPrograms, j);

            int status;
            pid_t pid = waitpid(prg->mPid, &status, WNOHANG);

            if(pid == prg->mPid || pid < 0 && errno == ECHILD) {
                vector_erase(job->mChildPrograms, j);

                job->mRunningProgs--;

                if(job->mRunningProgs == 0) {
                    vector_erase(gJobs, i);
   
                    filer_reread(0);
                    filer_reread(1);
                }

                goto while_start;
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// t@C̓ǂݍ
///////////////////////////////////////////////////////////////////////////////
int shell_load(char* fname, BOOL sub_shell)
{
    string_obj* str = string_new("");

    int f = open(fname, O_RDONLY);
    if(f < 0) {
        return -1;
    }

    char buf[BUFSIZ];
    while(1) {
        int size = read(f, buf, BUFSIZ-1);
        if(size == 0) {
            break;
        }
        if(size < 0) {
            close(f);
            return -1;
        }

        buf[size] = 0;

        string_push_back(str, buf);
    }
    close(f);

    shell(string_c_str(str), fname, -1, FALSE, sub_shell, -1);
}


