/******************************************************************************
 * mod_uploader / PlainConverter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: PlainConverter.h 516 2005-08-26 07:10:16Z svn $
 *****************************************************************************/

#ifndef PLAINCONVERTER_H
#define PLAINCONVERTER_H

#include "apr_pools.h"
#include "apr_file_info.h"

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include <cstdlib>

using namespace std;

class UploadItemReader;

/**
 * @brief åץɥƥ̾ΥեѴ륯饹
 */
class PlainConverter
{
public:
    PlainConverter(apr_pool_t *pool);
    void convert(const char *src_path, const char *plain_dir_path,
                 const char *code, bool is_quiet);
    void convert_dir(const char *upload_dir_path, const char *plain_dir_path,
                     const char *code, bool is_quiet);
    void convert_file(const char *upload_file_path, const char *plain_dir_path,
                      const char *code, bool is_quiet);

private:
    PlainConverter(const PlainConverter&);
    PlainConverter &operator=(const PlainConverter&);

    void convert_file(UploadItemReader &reader,
                      const char *upload_file_name, const char *plain_dir_path,
                      const char *code, bool is_quiet);
    const char *create_file_path(const char *plain_dir, const char *plain_name,
                                 const char *code);
    apr_filetype_e get_file_type(const char *path);

    apr_pool_t *pool_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
