 /******************************************************************************
 * mod_uploader / ThumbnailWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.h 570 2005-09-02 21:21:36Z svn $
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef MAKE_THUMBNAIL

#ifndef THUMBNAILWRITER_H
#define THUMBNAILWRITER_H

#include "UploadItemReader.h"

#include "apr_pools.h"

using namespace std;

namespace Magick {
    class Geometry;
}

/**
 * Υͥ륯饹
 */
class ThumbnailWriter
{
public:
    static const char FILE_SUFFIX[];

    ThumbnailWriter(apr_pool_t *pool,
                    const char *file_dir, const char *thumb_dir);
    void write(const char *file_path) const;

    static const char *create_thumb_path(apr_pool_t *pool,
                                         const char *thumb_dir,
                                         const char *file_path);

private:
    static const apr_size_t SIZE_LIMIT;
    static const apr_size_t WIDTH_LIMIT;
    static const apr_size_t HEIGHT_LIMIT;

    ThumbnailWriter(const ThumbnailWriter&);
    ThumbnailWriter &operator=(const ThumbnailWriter&);

    void *read(apr_pool_t *pool, const char *file_path, apr_size_t *size) const;
    void calc_size(Magick::Geometry &size) const;

    apr_pool_t *pool_;
    const char * const file_dir_;
    const char * const thumb_dir_;
};

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
