#!/bin/sh
#-------------------------------------------------------------------------------
# help,manΥ󥳡ǥ󥰤˴ؤ빹
#  Ƥϼ̤
#   1) help/ja-euc help/ja-sjis encodingѴƥԡ
#   1) help/ja-euc help/ja-utf8 encodingѴƥԡ
#   2) man/ja-euc  man/ja-sjis  encodingѴƥԡ
#   2) man/ja-euc  man/ja-utf8  encodingѴƥԡ
#   3) help/ja-euc help/default ˥ԡ
#   4) man/ja-euc  man/default ˥ԡ
#
#  դåɬפʥեΤߥԡ
#-------------------------------------------------------------------------------

function convHelp {
  if [ ! -e help/ja-sjis/$1 ] || [ help/ja-euc/$1 -nt help/ja-sjis/$1 ]; then
    echo 'nkf -Es <help/ja-euc/'$1 '>help/ja-sjis/'$1
    nkf -Es <help/ja-euc/$1 |
    gawk '{gsub(/\\[\x80-\xff]/,"\\\\&");print $0}' >help/ja-sjis/$1
  fi

  if [ ! -e help/ja-utf8/$1 ] || [ help/ja-euc/$1 -nt help/ja-utf8/$1 ]; then
    echo 'iconv -f euc-jp -t utf-8 <help/ja-euc/'$1 '>help/ja-utf8/'$1
    iconv -f euc-jp -t utf-8 <help/ja-euc/$1 >help/ja-utf8/$1
  fi

  if [ ! -e help/default/$1 ] || [ help/ja-euc/$1 -nt help/default/$1 ]; then
    echo "cp help/ja-euc/$1 help/default/$1"
    cp help/ja-euc/$1 help/default/$1
  fi
}

for fname in `ls help/ja-euc/*.h`; do
  f=${fname##*/}
  convHelp $f
done

function convMan {
  if [ ! -e man/ja-sjis/$1 ] || [ man/ja-euc/$1 -nt man/ja-sjis/$1 ]; then
    echo 'nkf -Es <man/ja-euc/'$1 '>man/ja-sjis/'$1
    nkf -Es <man/ja-euc/$1 |
    gawk '{gsub(/\\[\x80-\xff]/,"\\\\&");print $0}' >man/ja-sjis/$1
  fi

  if [ ! -e man/ja-utf8/$1 ] || [ man/ja-euc/$1 -nt man/ja-utf8/$1 ]; then
    echo 'iconv -f euc-jp -t utf-8 <man/ja-euc/'$1 '>man/ja-utf8/'$1
    iconv -f euc-jp -t utf-8 <man/ja-euc/$1 >man/ja-utf8/$1
  fi

  if [ ! -e man/default/$1 ] || [ man/ja-euc/$1 -nt man/default/$1 ]; then
    echo "cp man/ja-euc/$1 man/default/$1"
    cp man/ja-euc/$1 man/default/$1
  fi
}


for fname in `ls man/ja-euc/*.1`; do
  f=${fname##*/}
  convMan $f
done

encPATH=lib/include/musashi
nkf -Es <$encPATH/mssEncmsg.h |
gawk '{gsub(/\\[\x80-\xff]/,"\\\\&");print $0}' >$encPATH/mssEncmsg.h.ja-sjis
iconv -f euc-jp -t utf-8 <$encPATH/mssEncmsg.h >$encPATH/mssEncmsg.h.ja-utf8
cp $encPATH/mssEncmsg.h $encPATH/mssEncmsg.h.ja-euc
