/*--------------------------------------------------------------
  OCR base library: dictionary file I/O    dicfile
  (C) 2008,2009  Hideaki Goto  (see accompanying LICENSE file)
    Written by  H.Goto,  Feb. 2008
    Revised by  H.Goto,  May  2009
--------------------------------------------------------------*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>

#include	"utypes.h"
#include	"siplib.h"

#include	"ocrbase.h"


/*----------------------------------------------
  Load character vector dictionary
----------------------------------------------*/

int ocrbase_loaddic(RecBase *Rec, char *dicfile, int dim, int n_top){
	FILE	*fp;
	int	cid;
	struct stat	statinfo;
	int	n_cat;
	if ( stat(dicfile,&statinfo) ){
		return(-1);
	}
	n_cat = statinfo.st_size / sizeof(double) / dim;
	if ( n_cat <= 0 ){
		return(-1);
	}
	if ( Rec->alloc(n_cat, dim, n_top) ){
		return(-1);
	}
	if ( NULL == (fp = fopen(dicfile,"rb")) ){
		return(-1);
	}
	for ( cid=0 ; cid<n_cat ; cid++ ){
		if ( Rec->dic[cid].read_vector(fp) ){
			fclose(fp);
			return(-1);
		}
	}
	fclose(fp);
	return(n_cat);
}




