/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: externallinkbuffer.hxx,v $
 *
 *  $Revision: 1.1.2.2 $
 *
 *  last change: $Author: dr $ $Date: 2007/08/24 09:06:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_XLS_EXTERNALLINKBUFFER_HXX
#define OOX_XLS_EXTERNALLINKBUFFER_HXX

#include "oox/core/containerhelper.hxx"
#include "oox/xls/globaldatahelper.hxx"

#include <com/sun/star/table/CellAddress.hpp>
#include <map>
#include <list>

namespace oox { namespace core {
    class AttributeList;
} }

namespace oox {
namespace xls {

// ============================================================================

/** Stores a single external reference information. */
struct ExtRef
{
    ::rtl::OUString     maPath;
    ::rtl::OUString     maSheetName;

    explicit            ExtRef();
};

struct ExtRefCell
{
    ::com::sun::star::table::CellAddress    maCellAddress;
    ::rtl::OUString                         maFormulaString;
};

struct BiffLinkSheetRange
{
    sal_Int32           mnFirst;
    sal_Int32           mnLast;

    inline explicit     BiffLinkSheetRange() : mnFirst( -1 ), mnLast( -1 ) {}
    inline explicit     BiffLinkSheetRange( sal_Int32 nFirst, sal_Int32 nLast ) : mnFirst( nFirst ), mnLast( nLast ) {}

    inline void         set( sal_Int32 nFirst, sal_Int32 nLast ) { mnFirst = nFirst; mnLast = nLast; }

    inline bool         isDeleted() const { return (mnFirst < 0) || (mnLast < 0); }
    inline bool         is3dRange() const { return !isDeleted() && (mnFirst != mnLast); }
};

// ============================================================================

enum ExternalLinkType
{
    LINKTYPE_INTERNAL,      /// Link refers to own workbook.
    LINKTYPE_ANALYSIS,      /// Link refers to Analysis add-in.
    LINKTYPE_EXTERNAL,      /// Link refers to an external spreadsheet document.
    LINKTYPE_UNKNOWN        /// Unknown or unsupported link type.
};

// ============================================================================

class BiffExternalLinkBufferImpl;

class ExternalLinkBuffer : public GlobalDataHelper
{
public:
    explicit            ExternalLinkBuffer( const GlobalDataHelper& rGlobalData );

    void                setExternalLink( sal_Int32 nId, const ::rtl::OUString& aPath );

    /** Get an external link data by ID.  The ID is given in the Excel formula
        string as in '[1]Sheet1!A1'. */
    const ExtRef*       getExternalLinkById( sal_Int32 nId ) const;

    /** Check if a given Excel formula string is an external reference. */
    bool                isExtRef( const ::rtl::OUString& aCellFormula ) const;

    void                addToDestCellList( const ::com::sun::star::table::CellAddress& aAddr, const ::rtl::OUString& aFormula );

    /** Imports the EXTERNSHEET record from the passed stream. */
    void                importExternSheet( BiffInputStream& rStrm );
    /** Imports the SUPBOOK record from the passed stream. */
    void                importSupBook( BiffInputStream& rStrm );
    /** Imports the EXTERNNAME record from the passed stream. */
    void                importExternName( BiffInputStream& rStrm );

    void                finalizeImport();

    /** Returns the link type for the passed ref identifier. */
    ExternalLinkType    getLinkType( sal_Int32 nRefId ) const;
    /** Returns the sheet range for the specified reference (BIFF5). */
    BiffLinkSheetRange  getSheetRange( sal_Int32 nRefId, sal_Int16 nTabId1, sal_Int16 nTabId2 ) const;
    /** Returns the sheet range for the specified reference (BIFF8). */
    BiffLinkSheetRange  getSheetRange( sal_Int32 nRefId ) const;
    /** Returns the name of the external name with the passed name index. */
    ::rtl::OUString     getExternName( sal_Int32 nRefId, sal_uInt16 nNameId ) const;

private:
    void                setExtSheets();

    void                setExtRefCells();

    void                expandFormula( ::rtl::OUString& rFormula );

private:
    typedef ::std::map<sal_Int32, ExtRef>   ExtRefMap;
    typedef ::std::list<ExtRefCell>         ExtRefCellList;

    ExtRefMap           maExtRefs;
    ExtRefCellList      maDestCellList;

    ::std::auto_ptr< BiffExternalLinkBufferImpl > mxBiffImpl;
};

// ============================================================================

} // namespace xls
} // namespace oox

#endif

