(* Test the standard overloadings coming with the package. *)
open Camlp4.PreCast
open Test

let std_int var =
  [[Var.int "x"], Compare_val.int(), "to_int(of_int x)", <:expr@here< x >>;
   [Var.int32 "x"], Compare_val.int32(),
   "to_int32(of_int32 x)", <:expr@here< x >>;
   [Var.nativeint "x"], Compare_val.nativeint(),
   "to_nativeint(of_nativeint x)", <:expr@here< x >>;
   [Var.float "x"], Compare_val.float(),
   "float(truncate x)", <:expr@here< floor x >>;
   [], Compare_val.bool(), "max_int + min_int = -1", <:expr@here< true >>;
   [var "x"], Compare_val.bool(),
   "(x lsr 1) lsl 1 = x land (lnot 1)", <:expr@here< true >>;
  ]

(* Overload the expressions with the module [m]. *)
let std_int_for m var =
  let o (var, cmp, e0, e1) = (var, cmp, m ^ ".(" ^ e0 ^ ")", e1) in
  `Compare_val(List.map o (std_int var))

let standard =
  List.map (fun (m, var) -> concrete_syntax m "" (std_int_for m var))
    ["Int", (fun x -> Var.int x);
     "Int32", (fun x -> Var.int32 x);
     "Int64", (fun x -> Var.int64 x);
     "Nativeint", (fun x -> Var.nativeint x);
    ]

let optim =
  [concrete_syntax "Int optimizations" ""
     (`Compare_expr ["Int.(of_int x)", <:expr@here< x >>;
                     "Int.(to_int x)", <:expr@here< x >>]);
   concrete_syntax "Int32 optimizations" ""
     (`Compare_expr ["Int32.(of_int32 x)", <:expr@here< x >>;
                     "Int32.(to_int32 x)", <:expr@here< x >>]);
   concrete_syntax "Int64 optimizations" ""
     (`Compare_expr ["Int64.(of_int64 x)", <:expr@here< x >>;
                     "Int64.(to_int64 x)", <:expr@here< x >>]);
   concrete_syntax "Nativeint optimizations" ""
     (`Compare_expr ["Nativeint.(of_nativeint x)", <:expr@here< x >>;
                     "Nativeint.(to_nativeint x)", <:expr@here< x >>]);
  ]

let () =
  run (group "Standard overloadings" ~libs:["pa_do.cmo"]
          ~header:<:str_item@here< >> ~comp_no:10
          (standard @ optim))


(* Local Variables: *)
(* compile-command: "omake --no--progress test" *)
(* End: *)
