//%2006////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2000, 2001, 2002 BMC Software; Hewlett-Packard Development
// Company, L.P.; IBM Corp.; The Open Group; Tivoli Systems.
// Copyright (c) 2003 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation, The Open Group.
// Copyright (c) 2004 BMC Software; Hewlett-Packard Development Company, L.P.;
// IBM Corp.; EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2005 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; VERITAS Software Corporation; The Open Group.
// Copyright (c) 2006 Hewlett-Packard Development Company, L.P.; IBM Corp.;
// EMC Corporation; Symantec Corporation; The Open Group.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// THE ABOVE COPYRIGHT NOTICE AND THIS PERMISSION NOTICE SHALL BE INCLUDED IN
// ALL COPIES OR SUBSTANTIAL PORTIONS OF THE SOFTWARE. THE SOFTWARE IS PROVIDED
// "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//==============================================================================
//
//%/////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
//  This file contains the exception classes used in the configuration
//  classes.
////////////////////////////////////////////////////////////////////////////////

#ifndef Pegasus_ConfigExceptions_h
#define Pegasus_ConfigExceptions_h

#include <Pegasus/Common/Exception.h>
#include <Pegasus/Config/Linkage.h>
#include <Pegasus/Common/MessageLoader.h>

PEGASUS_NAMESPACE_BEGIN


/**
    MissingCommandLineOptionArgument Exception class
*/
class PEGASUS_CONFIG_LINKAGE MissingCommandLineOptionArgument : public Exception
{
public:
    MissingCommandLineOptionArgument(const String& optionName)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.MISSING_CMDLINE_OPTION",
              "Missing command line option argument: $0",
              optionName))
    {
    }
};

/**
    UnrecognizedCommandLineOption Exception class
*/
class PEGASUS_CONFIG_LINKAGE UnrecognizedCommandLineOption : public Exception
{
public:
    UnrecognizedCommandLineOption()
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.UNRECOGNIZED_CMDLINE_OPTION",
              "Unrecognized command line option. "))
    {
    }
};


/**
    InvalidPropertyValue Exception class
*/
class PEGASUS_CONFIG_LINKAGE InvalidPropertyValue : public Exception
{
public:
    InvalidPropertyValue(const String& name, const String& value)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.INVALID_PROPERTY_VALUE",
              "Invalid property value: $0=$1",
              name,
              value))
    {
    }
};


/**
    DuplicateOption Exception class
*/
class PEGASUS_CONFIG_LINKAGE DuplicateOption : public Exception
{
public:
    DuplicateOption(const String& name)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.DUPLICATE_OPTION",
              "Duplicate option: $0",
              name))
    {
    }
};


/**
    ConfigFileSyntaxError Exception class
*/
class PEGASUS_CONFIG_LINKAGE ConfigFileSyntaxError : public Exception
{
public:
    ConfigFileSyntaxError(const String& file, Uint32 line)
        : Exception(_formatMessage(file, line)) { }

    static String _formatMessage(const String& file, Uint32 line);
};


/**
    UnrecognizedConfigFileOption Exception class
*/
class PEGASUS_CONFIG_LINKAGE UnrecognizedConfigFileOption : public Exception
{
public:
    UnrecognizedConfigFileOption(const String& name)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.UNRECOGNIZED_CONFIG_FILE_OPTION",
              "Unrecognized config file option: $0",
              name))
    {
    }
};


/**
    MissingRequiredOptionValue Exception class
*/
class PEGASUS_CONFIG_LINKAGE MissingRequiredOptionValue : public Exception
{
public:
    MissingRequiredOptionValue(const String& name)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.MISSING_REQUIRED_OPTION",
              "Missing required option value: $0",
              name))
    {
    }
};


/**
    UnrecognizedConfigProperty Exception class
*/
class PEGASUS_CONFIG_LINKAGE UnrecognizedConfigProperty : public Exception
{
public:
    UnrecognizedConfigProperty(const String& name)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.UNRECOGNIZED_CONFIG_PROPERTY",
              "Unrecognized config property: $0",
              name))
    {
    }
};

/**
    NonDynamicConfigProperty Exception class
*/
class PEGASUS_CONFIG_LINKAGE NonDynamicConfigProperty : public Exception
{
public:
    NonDynamicConfigProperty(const String& name)
        : Exception(MessageLoaderParms(
              "Config.ConfigExceptions.NONDYNAMIC_CONFIG_PROPERTY",
              "NonDynamic config property: $0",
              name))
    {
    }
};

PEGASUS_NAMESPACE_END

#endif /* Pegasus_ConfigExceptions_h */
