#!/bin/sh

# 一時ファイルを削除
rm -f anthy_words.txt*
rm -f *.list*
rm -f *.utf8*
rm -f *.order
rm -f prime-dict-all*

# anthy基本辞書を結合
cat gcanna.ctd gijutu.ctd names-ut.ctd \
ekimei.ctd kaisha.ctd chimei.ctd > anthy_words.txt

# anthy基本辞書をprime形式に変換
ruby 01-utf8-contents-converter.rb anthy_words.txt
ruby 02-split-cannadic.rb anthy_words.txt.utf8
ruby 03-get-anthy-noun.rb anthy_words.txt.utf8.split
ruby 05-change-orders-anthy.rb anthy_words.txt.utf8.split.list
ruby 06-remove-duplicates-anthy.rb anthy_words.txt.utf8.split.list.order

# prime辞書をutf8に変更して項目の並びを変える
ruby 01-utf8-contents-converter.rb prime-dict
ruby 04-change-orders.rb prime-dict.utf8

# 郵便番号辞書をprime形式に変換
ruby 01-utf8-contents-converter.rb zipcode.t
ruby 13-convert-chimei.rb zipcode.t.utf8

# 全ての辞書を結合
cat *.order > prime-dict-all

# primeとanthyとで重複している項目を削除して
# prime辞書の並びで出力
ruby 10-sortdic.rb prime-dict-all
ruby 11-remove-duplicates.rb prime-dict-all

# 完成した辞書をeucに変換
ruby 12-euc-contents-converter.rb prime-dict-all.removed
mv prime-dict-all.removed.euc prime-dict.new

# 一時ファイルを削除
rm -f anthy_words.txt*
rm -f *.list*
rm -f *.utf8*
rm -f *.order
rm -f prime-dict-all*
