dnl
dnl These two checks for signal functions were originally part of the
dnl aclocal.m4 file distributed with bash 2.0.
dnl
dnl Check type of signal routines (posix, 4.2bsd, 4.1bsd or v7)
AC_DEFUN([Q_SIGNAL_CHECK],
[AC_REQUIRE([AC_TYPE_SIGNAL])
AC_MSG_CHECKING(for type of signal functions)
AC_CACHE_VAL(q_cv_signal_vintage,
[
  AC_TRY_LINK([#include <signal.h>],[
    sigset_t ss;
    struct sigaction sa;
    sigemptyset(&ss); sigsuspend(&ss);
    sigaction(SIGINT, &sa, (struct sigaction *) 0);
    sigprocmask(SIG_BLOCK, &ss, (sigset_t *) 0);
  ], q_cv_signal_vintage=posix,
  [
    AC_TRY_LINK([#include <signal.h>], [
	int mask = sigmask(SIGINT);
	sigsetmask(mask); sigblock(mask); sigpause(mask);
    ], q_cv_signal_vintage=4.2bsd,
    [
      AC_TRY_LINK([
	#include <signal.h>
	RETSIGTYPE foo() { }], [
		int mask = sigmask(SIGINT);
		sigset(SIGINT, foo); sigrelse(SIGINT);
		sighold(SIGINT); sigpause(SIGINT);
        ], q_cv_signal_vintage=svr3, q_cv_signal_vintage=v7
    )]
  )]
)
])
AC_MSG_RESULT($q_cv_signal_vintage)
if test "$q_cv_signal_vintage" = posix; then
AC_DEFINE(HAVE_POSIX_SIGNALS, 1, [Define if POSIX signal functions are available.])
elif test "$q_cv_signal_vintage" = "4.2bsd"; then
AC_DEFINE(HAVE_BSD_SIGNALS, 1, [Define if BSD signal functions are available.])
elif test "$q_cv_signal_vintage" = svr3; then
AC_DEFINE(HAVE_USG_SIGHOLD, 1, [Define if SVR3 signal functions are available.])
fi
])
dnl
AC_DEFUN([Q_REINSTALL_SIGHANDLERS],
[AC_REQUIRE([AC_TYPE_SIGNAL])
AC_REQUIRE([Q_SIGNAL_CHECK])
AC_MSG_CHECKING([if signal handlers must be reinstalled when invoked])
AC_CACHE_VAL(q_cv_must_reinstall_sighandlers,
[AC_TRY_RUN([
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
typedef RETSIGTYPE sigfunc();
int nsigint;
#ifdef HAVE_POSIX_SIGNALS
sigfunc *
set_signal_handler(sig, handler)
     int sig;
     sigfunc *handler;
{
  struct sigaction act, oact;
  act.sa_handler = handler;
  act.sa_flags = 0;
  sigemptyset (&act.sa_mask);
  sigemptyset (&oact.sa_mask);
  sigaction (sig, &act, &oact);
  return (oact.sa_handler);
}
#else
#define set_signal_handler(s, h) signal(s, h)
#endif
RETSIGTYPE
sigint(s)
    int s;
{
  nsigint++;
}
main()
{
  nsigint = 0;
  set_signal_handler(SIGINT, sigint);
  kill((int)getpid(), SIGINT);
  kill((int)getpid(), SIGINT);
  exit(nsigint != 2);
}
], q_cv_must_reinstall_sighandlers=no, q_cv_must_reinstall_sighandlers=yes,
if test "$q_cv_signal_vintage" = svr3; then
  q_cv_must_reinstall_sighandlers=yes
else
  q_cv_must_reinstall_sighandlers=no
fi)])
if test "$cross_compiling" = yes; then
  AC_MSG_RESULT([$q_cv_must_reinstall_sighandlers assumed for cross compilation])
else
  AC_MSG_RESULT($q_cv_must_reinstall_sighandlers)
fi
AC_DEFINE(MUST_REINSTALL_SIGHANDLERS, [], [Define if signal handlers must be reinstalled by handler.])
if test "$q_cv_must_reinstall_sighandlers" = yes; then
  AC_DEFINE(MUST_REINSTALL_SIGHANDLERS, 1)
fi
])

dnl This is like the AC_CHECK_LIB function, but does not cache results and
dnl takes arbitrary linker flags as the first argument

dnl Q_CHECK_LIB(LDFLAGS, FUNCTION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND
dnl             [, OTHER-LIBRARIES]]])
AC_DEFUN([Q_CHECK_LIB],
[AC_MSG_CHECKING([for $2 in $1])
ac_save_LIBS="$LIBS"
LIBS="$1 $5 $LIBS"
AC_TRY_LINK(dnl
ifelse([$2], [main], , dnl Avoid conflicting decl of main.
[/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $2();
]),
	    [$2()],
	    q_lib_check=yes, q_lib_check=no)
LIBS="$ac_save_LIBS"
dnl
if test $q_lib_check = "yes"; then
  AC_MSG_RESULT(yes)
ifelse([$3], , [LIBS="$1 $LIBS"], [$3
])
else
  AC_MSG_RESULT(no)
ifelse([$4], , , [$4
])dnl
fi
])
dnl
dnl Check for IPV6 support.
dnl This one was pilfered from the guile sources.
dnl
AC_DEFUN([Q_CHECK_IPV6],
[AC_MSG_CHECKING(for working IPv6 support)
AC_CACHE_VAL(q_cv_have_ipv6,
[AC_TRY_COMPILE([#include <netinet/in.h>],
[struct sockaddr_in6 a;  a.sin6_family = AF_INET6;],
q_cv_have_ipv6=yes, q_cv_have_ipv6=no)])
AC_MSG_RESULT($q_cv_have_ipv6)
if test $q_cv_have_ipv6 = yes; then
  AC_DEFINE(HAVE_IPV6, [], [Define if system supports IPv6.])
fi
])

dnl nl_langinfo/CODESET check from Bruno Haible.

AC_DEFUN([Q_LANGINFO_CODESET],
[
  AC_CACHE_CHECK([for nl_langinfo and CODESET], am_cv_langinfo_codeset,
    [AC_TRY_LINK([#include <langinfo.h>],
      [char* cs = nl_langinfo(CODESET);],
      am_cv_langinfo_codeset=yes,
      am_cv_langinfo_codeset=no)
    ])
  if test $am_cv_langinfo_codeset = yes; then
    AC_DEFINE(HAVE_LANGINFO_CODESET, 1,
      [Define if you have <langinfo.h> and nl_langinfo(CODESET).])
  fi
])
