
/* tix.q: example showing how to use Tix with Q-Tk 10-28-00 AG */

/* This script shows how to use Tix with Q-Tk. Tix is a Tk extension package
   which provides a lot of convenient extra widgets for building your Tk
   application; it is available from http://tix.mne.com.

   Using the `tix' function defined below, you can execute an arbitrary script
   containing both ordinary Tcl/Tk and the extended Tix commands. For
   instance, provided that the "widget" example script is located in the
   current directory (you can find this script in the demo subdirectory of the
   Tix distribution), you can run the script as follows:

   ==> tix "widget"

   The crucial Tcl command invoked by the tix function is `package require
   Tix' (see the definition of init_app) which loads the Tix package into the
   Tcl/Tk interpreter hosted by Q-Tk (provided that Tix has been installed
   properly on your system).

   The script also demonstrates how to define a `tk_error' function which
   handles Tk errors (here, we simply print an error message and halt
   evaluation), and how to redefine the Tcl `exit' command to call back into
   our main loop instead of exiting Q. */

include tk;

tix S      = init_app S || main_loop;

tk_error S = writes ("! Tk Error: "++S++"\n") || halt;

init_app S = // start a new interpreter
	     tk_quit ||
	     // load Tix and source the given script
	     tk ("package require Tix; source {"++S++"}") ||
	     // redefine exit to invoke the quit_cb callback below
	     tk "proc exit { {returnCode 0} } { q quit_cb $returnCode }";

// application main loop

main_loop  = tk_read || main_loop if tk_ready;
	   = () otherwise;

// callback invoked when the Tix script terminates using exit

quit_cb 0  = writes "Application exited normally.\n" || tk_quit;
quit_cb N  = writes ("Application exited with exit code "++str N++".\n") ||
	     tk_quit;
