
#line 3 "qclex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 48
#define YY_END_OF_BUFFER 49
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[358] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   49,   47,
       40,   43,   46,   38,   45,   46,   46,   31,   31,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   24,   22,   24,   24,   24,
       23,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   26,   26,   26,   26,
       25,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   37,   44,   41,   36,
       27,   29,    0,    0,   31,   46,   46,   46,    1,   46,
       46,   46,   46,   46,    7,   46,   46,   46,   46,   46,

       46,   46,   46,   46,   46,   46,   46,   42,   24,   24,
       24,    1,   24,   24,   24,   24,   24,    7,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       26,   26,   26,    1,   26,   26,   26,   26,   26,    7,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,    0,   41,   32,   36,    0,   36,   36,    0,
       35,   33,   46,    3,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   19,   46,   46,   42,
       42,   24,    3,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   19,   24,   24,   26,    3,

       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       26,   26,   19,   26,   26,    0,   37,    0,    0,   36,
       28,   30,    0,   46,    4,   46,    6,   46,   46,   46,
       46,   46,   46,   16,   17,   46,   46,   46,   42,   24,
        4,   24,    6,   24,   24,   24,   24,   24,   24,   16,
       17,   24,   24,   24,   26,    4,   26,    6,   26,   26,
       26,   26,   26,   26,   16,   17,   26,   26,   26,    0,
       36,   34,    2,   46,   46,   46,   46,   46,   46,   46,
       18,   46,   21,   42,    2,   24,   24,   24,   24,   24,
       24,   24,   18,   24,   21,    2,   26,   26,   26,   26,

       26,   26,   26,   18,   26,   21,    5,   10,   46,   46,
       46,   14,   46,   46,   42,    5,    8,   24,   24,   24,
       14,   24,   24,    5,   10,   26,   26,   26,   14,   26,
       26,   11,   46,   13,   15,   20,   42,    9,   24,   13,
       15,   20,   11,   26,   13,   15,   20,   46,   42,   39,
       24,   26,   12,   39,   12,   12,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    8,    8,    8,    9,
        9,   10,   11,    9,   12,   13,   14,   15,   16,   16,
       16,   16,   16,   16,   16,   17,   17,   18,   19,    8,
       20,    8,    8,    8,   21,   21,   21,   21,   22,   21,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   24,   23,   23,
        9,    8,    9,    8,   23,    8,   25,   26,   27,   28,

       29,   30,   23,   31,   32,   23,   23,   33,   34,   35,
       36,   37,   23,   38,   39,   40,   41,   42,   43,   44,
       45,   23,    9,    8,    9,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,

        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8
    } ;

static yyconst flex_int32_t yy_meta[46] =
    {   0,
        1,    1,    2,    1,    3,    1,    3,    3,    1,    3,
        3,    3,    3,    3,    4,    4,    4,    3,    1,    3,
        4,    4,    3,    3,    4,    4,    4,    4,    4,    4,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3
    } ;

static yyconst flex_int16_t yy_base[366] =
    {   0,
        0,  841,    0,  840,   45,  839,   90,  838,  844,  849,
      849,  849,  849,  849,  849,  121,  129,  131,  141,  825,
      171,  187,  106,  111,  128,  113,  134,  126,  149,  165,
      172,  171,  183,  110,  837,  849,  849,  197,  206,  823,
      849,  222,  238,  123,  157,  220,  180,  227,  184,  200,
      226,  229,  186,  244,  216,  835,  849,  255,  265,  821,
      849,  279,  295,  135,  215,  234,  242,  282,  255,  281,
      259,  279,  288,  300,  297,  833,  325,  849,    0,  333,
      343,  351,  359,    0,  366,  849,  798,  818,  796,  291,
      198,  795,  298,  141,  794,  292,  306,  304,  272,  262,

      322,  324,  347,  350,  352,  354,  348,  828,  849,  792,
      812,  790,  359,  366,  789,  360,  246,  788,  364,  330,
      313,  365,  376,  377,  378,  371,  381,  373,  375,  389,
      849,  787,  807,  785,  384,  391,  784,  385,  390,  783,
      394,  395,  396,  400,  410,  408,  409,  403,  413,  405,
      407,  421,  442,    0,  849,  446,  454,  461,  469,  464,
      472,  808,  781,  780,  463,  464,  417,  428,  461,  466,
      457,  468,  470,  469,  477,  481,  779,  433,  473,    0,
      805,  777,  776,  484,  485,  483,  479,  486,  492,  487,
      494,  501,  495,  503,  506,  775,  497,  500,  774,  773,

      512,  514,  510,  511,  513,  519,  515,  522,  529,  524,
      531,  533,  772,  525,  528,  558,  561,  568,  571,  574,
      849,  849,  797,  542,  770,  554,  769,  556,  530,  558,
      573,  567,  568,  768,  767,  571,  563,  574,  793,  569,
      765,  576,  764,  578,  579,  583,  580,  591,  592,  763,
      762,  595,  587,  598,  593,  761,  597,  760,  600,  601,
      605,  616,  613,  614,  759,  758,  617,  609,  620,  645,
      648,  849,  757,  619,  627,  629,  630,  631,  645,  649,
      756,  650,  755,  764,  753,  641,  638,  651,  642,  643,
      659,  662,  752,  666,  751,  750,  657,  654,  667,  660,

      668,  670,  675,  749,  677,  748,  747,  746,  681,  672,
      683,  745,  680,  682,  748,  743,  742,  688,  686,  694,
      741,  691,  693,  740,  739,  699,  697,  702,  738,  701,
      704,  737,  736,  733,  729,  725,  740,  712,  711,  709,
      708,  707,  705,  612,  590,  572,  416,  706,  365,    0,
      710,  713,  275,    0,  192,  170,  849,  750,  752,  754,
      758,  189,  762,  766,  770
    } ;

static yyconst flex_int16_t yy_def[366] =
    {   0,
      357,    1,    1,    1,  357,    5,  357,    7,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      358,  358,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,  357,  357,  357,  357,  357,  357,
      357,  359,  359,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,  357,  357,  357,  357,  357,
      357,  360,  360,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,  357,  357,  357,  361,  357,
      357,  357,  357,  362,  357,  357,   22,  357,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,

       22,   22,   22,   22,   22,   22,   22,  363,  357,   43,
      357,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
      357,   63,  357,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,  357,  361,  357,  357,  357,  357,  357,  357,
      357,  362,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,  363,
      363,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   63,   63,

       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,  357,  357,  357,  357,  357,
      357,  357,  357,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,  363,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,  357,
      357,  357,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,  363,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   63,   63,   63,   63,   63,

       63,   63,   63,   63,   63,   63,   22,   22,   22,   22,
       22,   22,   22,   22,  363,   43,   43,   43,   43,   43,
       43,   43,   43,   63,   63,   63,   63,   63,   63,   63,
       63,   22,   22,   22,   22,   22,  364,   43,   43,   43,
       43,   43,   63,   63,   63,   63,   63,   22,  364,  365,
       43,   63,   22,  365,   43,   63,    0,  357,  357,  357,
      357,  357,  357,  357,  357
    } ;

static yyconst flex_int16_t yy_nxt[895] =
    {   0,
       10,   11,   12,   11,   13,   14,   13,   13,   15,   13,
       13,   13,   16,   17,   18,   19,   19,   20,   15,   13,
       21,   21,   21,   21,   22,   21,   23,   24,   25,   26,
       21,   27,   21,   21,   21,   28,   29,   21,   30,   31,
       32,   33,   34,   21,   21,   10,   11,   12,   11,   36,
       37,   36,   36,   15,   36,   36,   36,   38,   39,   18,
       19,   19,   40,   41,   36,   42,   42,   42,   42,   43,
       42,   44,   45,   46,   47,   42,   48,   42,   42,   42,
       49,   50,   42,   51,   52,   53,   54,   55,   42,   42,
       10,   11,   12,   11,   57,   14,   57,   57,   15,   57,

       57,   57,   58,   59,   18,   19,   19,   60,   61,   57,
       62,   62,   62,   62,   63,   62,   64,   65,   66,   67,
       62,   68,   62,   62,   62,   69,   70,   62,   71,   72,
       73,   74,   75,   62,   62,   77,   77,   77,   78,   91,
      107,   90,   79,   80,   87,   81,   81,   82,   87,   87,
       94,   87,   83,   80,   84,   85,   85,   85,  113,   83,
       92,  110,   83,   95,   87,   98,   87,   96,   97,   83,
      135,   93,   87,  132,   84,   86,  167,   86,   86,   87,
       86,   86,   86,   86,   86,  114,   99,   87,   88,  100,
       86,   86,  162,   86,   86,  110,   86,   86,   86,   86,

       86,  101,  102,   87,   88,  104,   86,  105,  132,   87,
       87,   77,   77,   77,  106,   78,  103,  117,  110,   79,
      127,   87,  110,  121,  110,   89,  109,  164,  109,  109,
      110,  109,  109,  109,  109,  109,   87,  122,  110,  111,
      123,  109,  109,  136,  109,  109,  130,  109,  109,  109,
      109,  109,  115,  132,  110,  111,  118,  109,  110,  125,
      119,  120,  124,  116,  110,  110,  137,  110,  128,   77,
       77,   77,  132,  126,   78,  129,  112,  138,   79,  139,
      132,  186,  110,  131,  110,  131,  131,  172,  131,  131,
      131,  131,  131,  132,  143,  146,  133,  132,  131,  131,

       87,  131,  131,  171,  131,  131,  131,  131,  131,  147,
       87,  140,  133,   87,  131,  141,  142,  132,  144,  132,
      132,  145,  149,  148,  150,  163,  132,  152,  168,   87,
       87,  151,  169,  134,  170,  132,   87,  166,  132,   77,
       77,   77,   87,  189,   87,  155,  153,  156,  156,  156,
      173,  110,  174,  153,  157,  158,  188,   81,   81,   82,
       87,  157,   87,  159,   83,   82,   82,   82,  110,  160,
      160,   83,   83,  161,  161,  161,  179,  176,   80,   83,
       85,   85,   85,  175,  350,   87,   87,   83,   87,  177,
       87,  178,   87,  182,   83,  183,  190,  110,  110,  185,

      187,  191,  110,  110,  110,  192,  193,  194,  195,  110,
      196,  110,  197,  110,  110,  110,  110,  198,  199,  110,
      200,  205,  132,  132,  202,  203,  206,  110,  132,  132,
      204,  207,  132,  132,  132,  208,  209,  210,  132,  211,
      212,  132,  213,  132,  214,  132,  132,  132,  132,  215,
      227,  132,  216,  216,  132,   87,  217,  217,  217,  132,
      156,  156,  156,  228,  219,  219,   87,  218,  220,  220,
      220,   87,  237,  221,  218,  156,  156,  156,  161,  161,
      161,  222,  157,  156,  156,  156,  161,  161,  161,  157,
      157,  225,  226,  229,  230,   87,  233,  157,  231,   87,

      232,   87,   87,  234,   87,  235,   87,   87,   87,  236,
      238,   87,  241,  242,  244,   87,  243,  110,  245,   87,
      246,  110,  110,  110,  110,  110,  248,  249,  247,  250,
      110,  251,  110,  110,  252,  110,  253,  254,  110,  110,
      256,  110,  257,  258,  110,  260,  259,  261,  132,  132,
      132,  132,  132,  132,  263,  264,  262,  132,  265,  266,
      132,  267,  132,  132,  268,  269,  132,  132,   87,  132,
      276,  132,  217,  217,  217,  217,  217,  217,  270,  270,
       87,  273,  271,  271,  271,  220,  220,  220,  220,  220,
      220,  274,   87,  275,   87,  277,   87,  278,  279,  280,

      281,   87,  283,  282,  290,   87,   87,  110,  285,   87,
      132,   87,   87,  286,  110,  287,  110,  110,  110,  288,
      289,  110,  291,  292,  293,  110,  295,  294,  132,  110,
      110,  132,  296,  110,  297,  132,  110,  298,  132,  132,
      301,  299,  300,  132,  302,  303,  304,  132,  306,  305,
      352,  132,  132,  307,  132,  132,  309,   87,  132,  271,
      271,  271,  271,  271,  271,   87,  308,   87,   87,   87,
      311,  312,  310,  313,  314,  316,  110,  317,  318,  110,
      110,  110,  320,   87,  319,  321,  322,   87,   87,  110,
      323,  324,  132,  325,  326,  132,  329,  110,  132,  330,

      110,  331,  327,  333,  110,  132,  132,  328,  132,  332,
       87,  334,  335,  132,  336,  132,  338,  339,   87,   87,
       87,   87,  340,  341,  110,  342,  110,  343,  344,  110,
      345,  110,  110,  346,  353,  132,  347,  132,  355,  132,
      132,  356,  132,  132,   87,  110,  110,  110,  110,  351,
      110,  132,   87,   87,  110,  110,  132,  132,  154,  350,
      154,  154,  180,   87,  180,  180,  349,   87,  349,  349,
      354,   87,  354,  354,  348,   87,  132,  132,  132,  110,
      110,  110,  337,   87,   87,   87,  132,  132,  132,  110,
      110,  110,  315,   87,   87,   87,  132,  132,  132,  132,

      110,  110,  110,  110,  284,   87,   87,   87,   87,  272,
      132,  132,  255,  110,  110,  240,  239,   87,   87,  224,
      223,  132,  201,  132,  131,  132,  110,  184,  110,  109,
      110,  181,   87,  165,   87,   86,   87,  108,  131,  108,
      109,  108,   86,  357,   76,   56,   35,   35,    9,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357

    } ;

static yyconst flex_int16_t yy_chk[895] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,

        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,   16,   16,   16,   17,   24,
       34,   23,   17,   18,   23,   18,   18,   18,   34,   24,
       26,   26,   18,   19,   18,   19,   19,   19,   44,   18,
       25,   44,   19,   27,   28,   28,   25,   27,   27,   19,
       64,   25,   27,   64,   18,   21,   94,   21,   21,   94,
       21,   21,   21,   21,   21,   45,   29,   29,   21,   29,
       21,   22,  362,   22,   22,   45,   22,   22,   22,   22,

       22,   30,   31,   30,   22,   32,   22,   33,  356,   32,
       31,   38,   38,   38,   33,   39,   31,   47,   47,   39,
       53,   33,   49,   49,   53,   22,   42,   91,   42,   42,
      355,   42,   42,   42,   42,   42,   91,   50,   50,   42,
       50,   42,   43,   65,   43,   43,   55,   43,   43,   43,
       43,   43,   46,   65,   55,   43,   48,   43,   46,   52,
       48,   48,   51,   46,   51,   48,   66,   52,   54,   58,
       58,   58,   66,   52,   59,   54,   43,   66,   59,   67,
       67,  117,   54,   62,  117,   62,   62,  100,   62,   62,
       62,   62,   62,   69,   69,   71,   62,   71,   62,   63,

      100,   63,   63,   99,   63,   63,   63,   63,   63,   72,
       99,   68,   63,  353,   63,   68,   68,   72,   70,   70,
       68,   70,   73,   72,   74,   90,   73,   75,   96,   90,
       96,   74,   97,   63,   98,   75,   93,   93,   74,   77,
       77,   77,   98,  121,   97,   80,   77,   80,   80,   80,
      101,  121,  102,   77,   80,   81,  120,   81,   81,   81,
      101,   80,  102,   82,   81,   82,   82,   82,  120,   83,
       83,   81,   82,   83,   83,   83,  107,  104,   85,   82,
       85,   85,   85,  103,  349,  103,  107,   85,  104,  105,
      105,  106,  106,  113,   85,  114,  122,  113,  116,  116,

      119,  123,  119,  122,  114,  124,  125,  126,  127,  126,
      128,  128,  129,  129,  123,  124,  125,  130,  135,  127,
      136,  142,  135,  138,  138,  139,  143,  130,  139,  136,
      141,  144,  141,  142,  143,  145,  146,  147,  144,  148,
      149,  148,  150,  150,  151,  151,  146,  147,  145,  152,
      167,  149,  153,  153,  347,  167,  153,  153,  153,  152,
      156,  156,  156,  168,  157,  157,  168,  156,  157,  157,
      157,  178,  178,  158,  156,  158,  158,  158,  160,  160,
      160,  159,  158,  159,  159,  159,  161,  161,  161,  158,
      159,  165,  166,  169,  170,  171,  173,  159,  171,  169,

      172,  165,  166,  174,  170,  175,  172,  174,  173,  176,
      179,  179,  184,  185,  187,  175,  186,  187,  188,  176,
      189,  186,  184,  185,  188,  190,  191,  192,  190,  193,
      189,  194,  191,  193,  195,  197,  197,  198,  198,  192,
      201,  194,  202,  203,  195,  205,  204,  206,  203,  204,
      201,  205,  202,  207,  208,  209,  207,  206,  210,  211,
      208,  212,  210,  214,  214,  215,  215,  209,  229,  211,
      229,  212,  216,  216,  216,  217,  217,  217,  218,  218,
      224,  224,  218,  218,  218,  219,  219,  219,  220,  220,
      220,  226,  226,  228,  228,  230,  230,  231,  232,  233,

      236,  237,  238,  237,  247,  232,  233,  240,  240,  236,
      346,  231,  238,  242,  242,  244,  244,  245,  247,  245,
      246,  246,  248,  249,  252,  253,  254,  253,  345,  248,
      249,  255,  255,  252,  257,  257,  254,  259,  259,  260,
      262,  260,  261,  261,  263,  264,  267,  268,  269,  268,
      344,  263,  264,  274,  262,  267,  276,  274,  269,  270,
      270,  270,  271,  271,  271,  275,  275,  276,  277,  278,
      278,  279,  277,  280,  282,  286,  287,  287,  288,  286,
      289,  290,  290,  279,  289,  291,  292,  280,  282,  288,
      294,  297,  298,  298,  299,  297,  302,  291,  300,  303,

      292,  305,  300,  310,  294,  299,  301,  301,  302,  309,
      310,  311,  313,  303,  314,  305,  318,  319,  313,  309,
      314,  311,  320,  322,  319,  323,  318,  326,  327,  322,
      328,  323,  320,  330,  348,  327,  331,  326,  351,  330,
      328,  352,  331,  343,  348,  342,  341,  340,  351,  339,
      338,  352,  358,  358,  359,  359,  360,  360,  361,  337,
      361,  361,  363,  336,  363,  363,  364,  335,  364,  364,
      365,  334,  365,  365,  333,  332,  329,  325,  324,  321,
      317,  316,  315,  312,  308,  307,  306,  304,  296,  295,
      293,  285,  284,  283,  281,  273,  266,  265,  258,  256,

      251,  250,  243,  241,  239,  235,  234,  227,  225,  223,
      213,  200,  199,  196,  183,  182,  181,  177,  164,  163,
      162,  140,  137,  134,  133,  132,  118,  115,  112,  111,
      110,  108,   95,   92,   89,   88,   87,   76,   60,   56,
       40,   35,   20,    9,    8,    6,    4,    2,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  357

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "qclex.l"
#line 3 "qclex.l"

/* qclex.l: lexical analyzer for the Q language */

/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* make sure we have flex */

#ifndef FLEX_SCANNER
#error "Sorry, this program requires flex."
#endif

#include "qcdefs.h"
#include "qc.h"

#undef yywrap
int yylineno;           /* the current line */

char *source = NULL;  	/* the source file name */

int context; /* identifier context, 1 = type identifier */

static char s1[MAXSTRLEN], s2[MAXSTRLEN];
int incmode;

static int wrapped = 0;

static int abufsz = 0, bufp = 0;
static char *buf = NULL;

static int checkid(int tok);
static comment(), string();
static void bigint();
static utf8_id(), utf8_id_or_sym(), utf8_qualid(), utf8_skip();

static char *strdupchk(char *s)
{
  if (!s || !(s = strdup(s)))
    fatal(qcmsg[MEM_OVF]);
  else
    return s;
}

/* prevent buffer overflows */

static ofchk(char *s)
{
  if (strlen(s) >= MAXSTRLEN)
    fatal(qcmsg[MEM_OVF]);
}

#ifdef HAVE_UNICODE

static inline char *
u8strind(char *s, size_t i)
{
  unsigned p = 0, q = 0;
 start:
  for (; *s && i > 0; s++) {
    unsigned char uc = (unsigned char)*s;
    if (q == 0) {
      if (((signed char)uc) < 0) {
	switch (uc & 0xf0) {
	case 0xc0: case 0xd0:
	  q = 1;
	  break;
	case 0xe0:
	  q = 2;
	  break;
	case 0xf0:
	  if ((uc & 0x8) == 0)
	    q = 3;
	  break;
	}
      }
      p = 0; if (q == 0) i--;
    } else if ((uc & 0xc0) == 0x80) {
      /* continuation byte */
      if (--q == 0) {
	p = 0; i--;
      } else
	p++;
    } else {
      /* malformed char */
      i--; s -= p+1; p = q = 0;
    }
  }
  if (q > 0) {
    /* unterminated char */
    i--; s -= p; p = q = 0;
    goto start;
  }
  return s;
}

#ifdef HAVE_ICONV

#define CHUNKSZ 128

static iconv_t ic = (iconv_t)-2;

static char *toutf8(char *s)
{
  static char *mybuf = NULL;
  static size_t mybufsz = 0;

  size_t l = strlen(s);
  if (ic == (iconv_t)-2) {
    char *codeset = default_codeset?
      default_codeset:default_encoding();
    if (codeset && strcmp(codeset, "UTF-8"))
      ic = iconv_open("UTF-8", codeset);
    else
      ic = (iconv_t)-1;
  }
  if (mybufsz < l+1) {
    char *mybuf1 = realloc(mybuf, l+1);
    if (!mybuf1) return NULL;
    mybuf = mybuf1;
    mybufsz = l+1;
  }
  if (ic == (iconv_t)-1)
    return strcpy(mybuf, s);
  else {
    char *inbuf = s, *outbuf = mybuf;
    size_t inbytes = l, outbytes = mybufsz-1;

    while (iconv(ic, &inbuf, &inbytes, &outbuf, &outbytes) ==
	   (size_t)-1)
      if (errno == E2BIG) {
	/* try to enlarge the output buffer */
	size_t k = outbuf-mybuf;
	char *mybuf1 = realloc(mybuf, mybufsz+CHUNKSZ);
	if (!mybuf1) return NULL;
	mybuf = mybuf1;
	mybufsz += CHUNKSZ;
	outbuf = mybuf+k;
	outbytes += CHUNKSZ;
      } else {
	/* conversion error */
	return strcpy(mybuf, s);
      }
    /* terminate the output string */
    *outbuf = 0;
    return mybuf;
  }
}

#endif

#endif

static char *getbuf(FILE *fp)
{
  static char *mybuf = NULL;
  static size_t mybufsz = 0;

  char *t, *r;
  int l;

  if (!mybuf) {
    mybuf = malloc(MAXSTRLEN);
    if (!mybuf) return NULL;
    mybufsz = MAXSTRLEN;
  }

  *mybuf = 0; t = mybuf;
  while (fp && !feof(fp) && (r = fgets(t, MAXSTRLEN, fp)) && *t &&
	 t[(l = strlen(t))-1] != '\n') {
    /* try to enlarge the buffer: */
    int k = t-mybuf+l;
    char *mybuf1;
    if (mybuf1 = (char*)realloc(mybuf, mybufsz+MAXSTRLEN)) {
      mybuf = mybuf1;
      t = mybuf+k;
      mybufsz += MAXSTRLEN;
    } else
      return NULL;
  }
  return mybuf;
}

static char *mybuf = NULL, *mybufptr = NULL;

static inline int myinput(char *buf, int max_size)
{
 read:
  if (mybufptr && *mybufptr) {
    int l = strlen(mybufptr);
    if (l > max_size) l = max_size;
    memcpy(buf, mybufptr, l);
    mybufptr += l;
    return l;
  }
  if (mybuf) free(mybuf);
  mybuf = getbuf(yyin);
  if (!mybuf) fatal("memory overflow");
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
  mybuf = toutf8(mybuf);
  if (!mybuf) fatal("memory overflow");
#endif
  mybuf = strdup(mybuf);
  if (!mybuf) fatal("memory overflow");
  mybufptr = mybuf;
  if (!*mybuf) return YY_NULL;
  goto read;
}

/* redefined input macro: */

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size)\
	{\
	result = myinput(buf, max_size);\
	}

#line 992 "qclex.c"

#define INITIAL 0
#define src 1
#define isrc 2
#define inamesrc 3

/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 249 "qclex.l"


#line 1150 "qclex.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 358 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 849 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(src):
case YY_STATE_EOF(isrc):
case YY_STATE_EOF(inamesrc):
#line 251 "qclex.l"
{ if (wrapped) yyterminate(); else return(EOFTOK); }
	YY_BREAK
case 1:
YY_RULE_SETUP
#line 252 "qclex.l"
return(AS);
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 253 "qclex.l"
return(CONST);
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 254 "qclex.l"
return(DEF);
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 255 "qclex.l"
return(ELSE);
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 256 "qclex.l"
return(EXTERN);
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 257 "qclex.l"
{ BEGIN isrc; return(FROM); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 258 "qclex.l"
return(IF);
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 259 "qclex.l"
{ BEGIN inamesrc; return(IMPORT); }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 260 "qclex.l"
{ BEGIN inamesrc; return(INCLUDE); }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 261 "qclex.l"
{ BEGIN isrc; return(IMPORT); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 262 "qclex.l"
{ BEGIN isrc; return(INCLUDE); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 263 "qclex.l"
return(OTHERWISE);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 264 "qclex.l"
return(PRIVATE);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 265 "qclex.l"
return(PUBLIC);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 266 "qclex.l"
return(SPECIAL);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 267 "qclex.l"
return(THEN);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 268 "qclex.l"
return(TYPE);
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 269 "qclex.l"
return(UNDEF);
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 270 "qclex.l"
return(VAR);
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 271 "qclex.l"
return(VIRTUAL);
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 272 "qclex.l"
return(WHERE);
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 273 "qclex.l"
{
			char *buf1;
			int i, l;
			string();
			l = strlen(buf);
			buf1 = (char*)malloc((strlen(buf)+1)*sizeof(char));
			if (!buf1)
			  fatal(qcmsg[MEM_OVF]);
			if (!scanstr(buf1, buf))
			  for (i = strlen(buf); i < l-1; i += strlen(buf+i+1)+1) {
			    char msg[MAXSTRLEN];
#ifdef HAVE_UNICODE
			    char *s = buf+i+1, *t = u8strind(s, 1), c[5];
			    c[0] = '\\'; strncpy(c+1, s, t-s); c[t-s+1] = 0;
#else
			    char c[3];
			    c[0] = '\\'; c[1] = buf[i+1]; c[2] = 0;
#endif
			    sprintf(msg, qcmsg[INVALID_ESCAPE], utf8_to_sys(c));
			    yyerror(msg);
			  }
			yylval.sval = buf1;
			return(STR1);
			}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 297 "qclex.l"
{ BEGIN src; return ';'; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 298 "qclex.l"
{ int ret;
			  yyless(0);
			  ret = utf8_id();
			  if (ret) {
			    yylval.sval = strdupchk(buf); return(ID1);
			  } else {
			    if (!*buf) utf8_skip();
			    return ERRTOK;
			  }
			}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 308 "qclex.l"
{ BEGIN src; return ';'; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 309 "qclex.l"
{ int ret;
			  yyless(0);
			  context = 1;
			  ret = utf8_id_or_sym();
			  context = 0;
			  if (ret) {
			    yylval.sval = strdupchk(buf); return(ID1);
			  } else {
			    if (!*buf) utf8_skip();
			    return ERRTOK;
			  }
			}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 321 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 28:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 322 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 323 "qclex.l"
{ return(ERRTOK); }
	YY_BREAK
case 30:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 324 "qclex.l"
{ return(ERRTOK); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 325 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 32:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 326 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 327 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 34:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 328 "qclex.l"
{ bigint(yylval.zval); return(INT); }
	YY_BREAK
case 35:
#line 330 "qclex.l"
case 36:
#line 331 "qclex.l"
case 37:
YY_RULE_SETUP
#line 331 "qclex.l"
{ yylval.fval = my_strtod(yytext, NULL); return(FLOAT); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 332 "qclex.l"
{
			char *buf1;
			int i, l;
			string();
			l = strlen(buf);
			buf1 = (char*)malloc((l+1)*sizeof(char));
			if (!buf1)
			  fatal(qcmsg[MEM_OVF]);
			if (!scanstr(buf1, buf))
			  for (i = strlen(buf); i < l-1; i += strlen(buf+i+1)+1) {
			    char msg[MAXSTRLEN];
#ifdef HAVE_UNICODE
			    char *s = buf+i+1, *t = u8strind(s, 1), c[5];
			    c[0] = '\\'; strncpy(c+1, s, t-s); c[t-s+1] = 0;
#else
			    char c[3];
			    c[0] = '\\'; c[1] = buf[i+1]; c[2] = 0;
#endif
			    sprintf(msg, qcmsg[INVALID_ESCAPE], utf8_to_sys(c));
			    yyerror(msg);
			  }
			yylval.ival = putstr(buf1);
			free(buf1);
			return(STR);
			}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 357 "qclex.l"
{
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
			  char *codeset = strchr(yytext, '=');
			  if (codeset) {
			    ++codeset;
			    if (ic != (iconv_t)-1 && ic != (iconv_t)-2)
			      iconv_close(ic);
			    if (strcmp(codeset, "UTF-8")) {
			      ic = iconv_open("UTF-8", codeset);
			      if (ic == (iconv_t)-1) {
				char msg[MAXSTRLEN];
				sprintf(msg, "unknown encoding `%s'", codeset);
				yyerror(msg);
			      }
			    } else
			      ic = (iconv_t)-1;
			  }
#endif
			}
	YY_BREAK
case 40:
#line 377 "qclex.l"
case 41:
#line 378 "qclex.l"
case 42:
YY_RULE_SETUP
#line 378 "qclex.l"
;
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 379 "qclex.l"
yylineno++;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 380 "qclex.l"
comment();
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 381 "qclex.l"
return(yytext[0]);
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 382 "qclex.l"
{ int ret;
			  yyless(0);
			  ret = utf8_qualid();
			  if (ret) {
			    int idtok = (ret&8)?((ret&2)?QUID:QLID):((ret&2)?UID:LID);
			    ofchk(buf); yylval.sval = strcpy(s1, buf);
			    return checkid(idtok);
			  } else {
			    if (!*buf) utf8_skip();
			    return ERRTOK;
			  }
			}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 394 "qclex.l"
return(yytext[0]);
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 396 "qclex.l"
ECHO;
	YY_BREAK
#line 1578 "qclex.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 8);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 358 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 8;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 358 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 357);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * str )
{
    
	return yy_scan_bytes(str,strlen(str) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * bytes, int  len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 396 "qclex.l"



static int      in_comment = 0;
static int      argc;
static char   **argv, **argv0 = NULL, **asv, **asv0 = NULL, *mainfile;

static int op_tok[] = { OP0, OP1, OP2, OP3, OP4, OP5, OP6, OP7, OP8, OP9 };

typedef struct {
  char *name;
  int tok;
} keyword;

static keyword kwtable[] = {
  {"as",	AS},
  {"const",	CONST},
  {"def",	DEF},
  {"else",	ELSE},
  {"extern",	EXTERN},
  {"from",	FROM},
  {"if",	IF},
  {"import",	IMPORT},
  {"include",	INCLUDE},
  {"otherwise",	OTHERWISE},
  {"private",	PRIVATE},
  {"public",	PUBLIC},
  {"special",	SPECIAL},
  {"then",	THEN},
  {"type",	TYPE},
  {"undef",	UNDEF},
  {"var",	VAR},
  {"virtual",	VIRTUAL},
  {"where",	WHERE},
  {"..",	DOTDOT},
  {":",		':'},
  {"|",		'|'},
  {"=",		'='},
  {"==",	EQUIV},
  {"-",		'-'},
  {"\\",	'\\'},
  {".",		'.'},
  {"@",		'@'},
  {"~",		'~'},
};

static int compkw(const void *k1, const void *k2)
{
  keyword *kw1 = (keyword*) k1;
  keyword *kw2 = (keyword*) k2;
  return strcmp(kw1->name, kw2->name);
}

static void initkws(void)
{
  qsort(kwtable, sizeof(kwtable)/sizeof(keyword), sizeof(keyword), compkw);
}

static int kwtok(char *name)
{
  keyword key, *res;
  key.name = name;
  res = bsearch(&key, kwtable, sizeof(kwtable)/sizeof(keyword),
		sizeof(keyword), compkw);
  if (res)
    return res->tok;
  else
    return NONE;
}

static int checkid(int tok)
{
  int tok1 = kwtok(yylval.sval);
  if (tok1 != NONE) {
    if (tok1 == IMPORT || tok1 == INCLUDE || tok1 == FROM)
      BEGIN isrc;
    return tok1;
  }
  if (!context) {
    char s[MAXSTRLEN];
    int fno;
    strcpy(s, yylval.sval);
    fno = getfun(s);
    if (fno != NONE && symtb[fno].prec != NONE) {
      yylval.ival = fno;
      return op_tok[symtb[fno].prec];
    }
  }
  return tok;
}

static int checksym(const char *sym)
{
  if (context)
    return 1;
  else {
    char s[MAXSTRLEN];
    strcpy(s, sym);
    return kwtok(s) != NONE || getfun(s) != NONE;
  }
}

static comment()
{
  register int    c;

  in_comment = 1;
  while ((c = input()) && c != EOF) {
    if (c == '*') {
      if ((c = input()) == '/')
	break;
      else
	unput(c);
    } else if (c == '\n')
      yylineno++;
  }
  if (!c || c == EOF) {
    yyerror(qcmsg[OPEN_COMMENT]);
    fatal("unrecoverable syntax error");
  }
  in_comment = 0;
}

static initbuf()
{
  bufp = 0;
}

static addbuf(char c)
{
  if (bufp >= abufsz)
    if (!(buf = (char*)arealloc(buf, abufsz, 100, sizeof(char))))
      fatal(qcmsg[MEM_OVF]);
    else
      abufsz += 100;
  buf[bufp++] = c;
}

static lookahead(const char *s)
{
  register long c;
  const char *t = s;
  int ret;
  while (*t && (c = input()) == *t)
    t++;
  ret = !*t;
  if (*t) {
    if (c != EOF) unput(c);
  }
  while (t > s)
    unput(*--t);
  return ret;
}

#define DELIM "\"()[]{},;_"

#ifdef HAVE_UNICODE

#define ERRC (-99)

static inline long
u8getc(void)
{
  size_t n;
  unsigned p = 0, q = 0;
  unsigned long c = 0;
  int ch;
  for (n = 0; n == 0 && (ch = input()) != EOF; ) {
    unsigned char uc = (unsigned char)ch;
    if (q == 0) {
      if (((signed char)uc) < 0) {
	switch (uc & 0xf0) {
	case 0xc0: case 0xd0:
	  q = 1;
	  c = uc & 0x1f;
	  break;
	case 0xe0:
	  q = 2;
	  c = uc & 0xf;
	  break;
	case 0xf0:
	  if ((uc & 0x8) == 0) {
	    q = 3;
	    c = uc & 0x7;
	  } else
	    c = uc;
	  break;
	default:
	  c = uc;
	  break;
	}
      } else
	c = uc;
      p = 0; if (q == 0) n++;
    } else if ((uc & 0xc0) == 0x80) {
      /* continuation byte */
      c = c << 6 | (uc & 0x3f);
      if (--q == 0)
	n++;
      else
	p++;
    } else {
      /* malformed char */
      return ERRC;
    }
  }
  if (n == 1)
    return c;
  else
    return EOF;
}

static inline char *
u8encode(char *t, unsigned long c)
{
  unsigned char *uc = (unsigned char*)t;
  if (c < 0x80) {
    uc[1] = 0;
    uc[0] = c;
  } else if (c < 0x800) {
    uc[2] = 0;
    uc[1] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[0] = 0xc0 | c;
  } else if (c < 0x10000) {
    uc[3] = 0;
    uc[2] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[1] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[0] = 0xe0 | c;
  } else {
    uc[4] = 0;
    uc[3] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[2] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[1] = 0x80 | c&0x3f;
    c = c >> 6;
    uc[0] = 0xf0 | c;
  }
  return t;
}

static inline void
u8ungetc(long c)
{
  if (c && c != EOF) {
    int i;
    char s[5];
    u8encode(s, (unsigned long)c);
    for (i = strlen(s)-1; i >= 0; --i)
      unput(s[i]);
  }
}

static inline void
u8addbuf(long c)
{
  if (c != EOF) {
    char s[5], *t;
    u8encode(s, (unsigned long)c);
    for (t = s; *t; t++)
      addbuf(*t);
  }
}

static utf8_ident()
{
  register long c;
  int save_bufp = bufp, ret = 1;
  while ((c = u8getc()) && c != EOF) {
    if (c == ERRC) {
      addbuf('\0');
      return 0;
    }
    if (bufp == save_bufp)
      if (u_isalpha(c) || c == '_') {
	if (u_isupper(c))
	  ret |= 2; /* indicates a capitalized identifier */
	u8addbuf(c);
      } else
	break;
    else if (u_isalnum(c) || c == '_')
      u8addbuf(c);
    else
      break;
  }
  if (c && c != EOF)
    u8ungetc(c);
  addbuf('\0');
  if (strcmp(buf, "_") == 0) ret |= 2;
  return (*buf)?ret:0;
}

static utf8_ident_or_sym()
{
  register long c;
  int save_bufp = bufp, ret = 1, k = bufp, lastk = bufp;
  while ((c = u8getc()) && c != EOF) {
    if (c == ERRC) {
      addbuf('\0');
      return 0;
    }
    if (bufp == save_bufp)
      if (u_isalpha(c) || c == '_') {
	if (u_isupper(c))
	  ret |= 2; /* indicates a capitalized identifier */
	u8addbuf(c);
      } else if (u_ispunct(c) && (c >= 128 || !strchr(DELIM, c))) {
	u8addbuf(c); addbuf('\0');
	if (checksym(buf)) k = strlen(buf);
	bufp--;
	ret |= 4; /* indicates a symbol */
      } else
	break;
    else if (ret & 4) {
      if (u_ispunct(c) && (c >= 128 || !strchr(DELIM, c))) {
	int l = bufp-1;
	u8addbuf(c); addbuf('\0');
	if (strcmp(buf+l, "::") == 0 ||
	    strcmp(buf+l, "//") == 0 || strcmp(buf+l, "/*") == 0) {
	  if (k > l) k = lastk;
	  bufp--;
	  goto out;
	}
	if (checksym(buf)) {
	  lastk = k;
	  k = strlen(buf);
	}
	bufp--;
      } else
	break;
    } else if (u_isalnum(c) || c == '_')
      u8addbuf(c);
    else
      break;
  }
  if (c && c != EOF)
    u8ungetc(c);
 out:
  if (ret & 4) {
    while (bufp > k)
      unput(buf[--bufp]);
  }
  addbuf('\0');
  if (strcmp(buf, "_") == 0) ret |= 2;
#if 0
  printf("got symbol '%s' (flags: %d)\n", buf, ret);
#endif
  return (*buf)?ret:0;
}

static utf8_skip()
{
  long c;
  while ((c = input()) && c != EOF && (((unsigned char)c)&0xc0) == 0xc0) ;
  if (c == EOF)
    fatal("unrecoverable syntax error");
  else {
    yytext[0] = c;
    yytext[1] = 0;
  }
}

#else

static utf8_ident()
{
  register long c;
  int save_bufp = bufp, ret = 1;
  while ((c = input()) && c != EOF) {
    if (bufp == save_bufp)
      if (isalpha(c) || c == '_') {
	if (isupper(c))
	  ret |= 2; /* indicates a capitalized identifier */
	addbuf(c);
      } else
	break;
    else if (isalnum(c) || c == '_')
      addbuf(c);
    else
      break;
  }
  if (c && c != EOF)
    unput(c);
  addbuf('\0');
  if (strcmp(buf, "_") == 0) ret |= 2;
  return (*buf)?ret:0;
}

static utf8_ident_or_sym()
{
  register long c;
  int save_bufp = bufp, ret = 1, k = bufp, lastk = bufp;
  while ((c = input()) && c != EOF) {
    if (bufp == save_bufp)
      if (isalpha(c) || c == '_') {
	if (isupper(c))
	  ret |= 2; /* indicates a capitalized identifier */
	addbuf(c);
      } else if (ispunct(c) && (c >= 128 || !strchr(DELIM, c))) {
	addbuf(c); addbuf('\0');
	if (checksym(buf)) k = strlen(buf);
	bufp--;
	ret |= 4; /* indicates a symbol */
      } else
	break;
    else if (ret & 4) {
      if (ispunct(c) && (c >= 128 || !strchr(DELIM, c))) {
	int l = bufp-1;
	addbuf(c); addbuf('\0');
	if (strcmp(buf+l, "::") == 0 ||
	    strcmp(buf+l, "//") == 0 || strcmp(buf+l, "/*") == 0) {
	  if (k > l) k = lastk;
	  bufp--;
	  goto out;
	}
	if (checksym(buf)) {
	  lastk = k;
	  k = strlen(buf);
	}
	bufp--;
      } else
	break;
    } else if (isalnum(c) || c == '_')
      addbuf(c);
    else
      break;
  }
  if (c && c != EOF)
    unput(c);
 out:
  if (ret & 4) {
    while (bufp > k)
      unput(buf[--bufp]);
  }
  addbuf('\0');
  if (strcmp(buf, "_") == 0) ret |= 2;
#if 0
  printf("got symbol '%s' (flags: %d)\n", buf, ret);
#endif
  return (*buf)?ret:0;
}

static utf8_skip()
{
  int c = input();
  if (c == EOF)
    fatal("unrecoverable syntax error");
  else {
    yytext[0] = c;
    yytext[1] = 0;
  }
}

#endif

static utf8_id()
{
  initbuf();
  return utf8_ident();
}

static utf8_id_or_sym()
{
  initbuf();
  return utf8_ident_or_sym();
}

static utf8_qualid()
{
  register long c;
  int ret, ret2;
  initbuf();
  ret = utf8_ident_or_sym();
  if (ret && (ret & 4))
    return ret;
  else if (lookahead("::")) {
    bufp--;
    addbuf(input()); addbuf(input());
    ret2 = utf8_ident_or_sym();
    if (ret2)
      return ret2 | 8; /* indicates a qualified id */
    else {
      unput(':'); unput(':');
      bufp--; bufp--;
      buf[bufp] = 0;
      return ret;
    }
  } else
    return ret;
}

static string()
{
  register int    c;

  in_comment = 1;
  initbuf();
  while ((c = input()) && c != EOF) {
    if (c == '"')
      break;
    else if (c == '\\') {
      if ((c = input()) == '\n') {
	yylineno++;
      } else {
	addbuf('\\');
	addbuf(c);
      }
    } else if (c == '\n')
      break;
    else
      addbuf(c);
  }
  addbuf('\0');
  if (c != '"') {
    yyerror(qcmsg[OPEN_STRING]);
    fatal("unrecoverable syntax error");
  }
  in_comment = 0;
}

static char *
skipz(char *s)
{
  while (*s == '0') s++;
  return s;
}

static void*
my_mpz_realloc(m, new_size)
     mpz_ptr m;
     mp_size_t new_size;
{
  mpz_t m1;
  memcpy(m1, m, sizeof(mpz_t));
  if (_mpz_realloc(m, new_size))
    return m->_mp_d;
  else {
    if (m1->_mp_d) mpz_clear(m1);
    return NULL;
  }
}

static void bigint(z)
     mpz_t z;
{
  int sz;
  if (strncmp(yytext, "0x", 2) == 0 ||
      strncmp(yytext, "0X", 2) == 0)
    sz = 4*strlen(skipz(yytext+2));
  else if (*yytext == '0')
    sz = 3*strlen(skipz(yytext+1));
  else
    sz = log(10)/log(2)*strlen(skipz(yytext))+1;
  sz = sz/(CHAR_BIT*sizeof(mp_limb_t)) + 2;
  mpz_init(z); 
  if (z->_mp_d && my_mpz_realloc(z, sz)) {
    int sz1;
    mpz_set_str(z, yytext, 0);
    sz1 = mpz_size(z);
    if (sz1 < sz && !my_mpz_realloc(z, sz1))
      fatal(qcmsg[MEM_OVF]);
  } else
    fatal(qcmsg[MEM_OVF]);
}

char *_realname[MAXFILES];
int _modtb[MAXFILES], _fnametb[MAXFILES];
int _modtbsz;

typedef struct {
  char *s, *as;
} id_alias_t;

static struct FileStack {
  YY_BUFFER_STATE state;
  FILE *yyin;
  int prio, modno, yylineno, incl;
  char *source;
  int argc;
  char **argv, **argv0;
  char **asv, **asv0;
  int namec;
  id_alias_t *namev;
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
  iconv_t ic;
#endif
  char *mybuf, *mybufptr;
} fst[MAXFILES], *fsp;

static
getmodno(s)
     char *s;
/* look up module name s in module table, return corresponding module
   number (NONE if not in table) */
{
  int i;
  for (i = 0; i < _modtbsz; i++)
    if (strcmp(s, strsp+_modtb[i]) == 0)
      return i;
  return NONE;
}

static
getmodno_by_fname(s)
     char *s;
/* look up module by file name */
{
  int i;
  for (i = 0; i < _modtbsz; i++)
    if (strcmp(s, strsp+_fnametb[i]) == 0)
      return i;
  return NONE;
}

static
stacked(modno)
     int modno;
/* check whether module is on include stack */
{
  struct FileStack *fsp1;
  for (fsp1 = fst; fsp1 < fsp; fsp1++)
    if (fsp1->modno == modno)
      return 1;
  return 0;
}

static
addmod(modname, realname, fname, s)
     char *modname, *realname, *fname, *s;
/* add module to module table */
{
  if (_modtbsz >= MAXFILES)
    fatal(qcmsg[TOO_MANY_FILES]);
  else {
    _modtb[_modtbsz] = putstr(modname);
    _fnametb[_modtbsz] = putstr(fname);
    _realname[_modtbsz] = strdup(realname);
    if (!_realname[_modtbsz]) fatal("memory overflow");
    modno = _modtbsz++;
    if (s == mainfile) mainno = modno;
    if (mainno > 0) putimp(0, 1);
  }
}

#define HAVE_FILE (-2)

static
opensrc(s, as, save)
     char           *s, *as;
     int save;
{
  char aname[MAXSTRLEN], fname[MAXSTRLEN], fname2[MAXSTRLEN],
    modname[MAXSTRLEN];
  int mno, have_stdin;

  if (!s || !*s) return NONE;

  /* handle stdin */

  have_stdin = mainno < 0 && strcmp(s, "-") == 0 && !as;

  if (have_stdin) {
    strcpy(fname, "<<stdin>>");
    strcpy(aname, fname);
    strcpy(modname, fname);
    as = modname;
    goto open_file;
  }

  /* parse file name and determine module id: */

  basename(modname, sys_to_utf8(s), '.');
  if (!as) as = modname;
  absname(aname, searchlib(fname, s));
  if (!chkfile(aname)) {
    strcat(strcpy(fname2, s), ".q");
    absname(aname, searchlib(fname, fname2));
  }

  /* check whether module has already been loaded: */

  if ((mno = getmodno(as)) != NONE) {
    if (s == mainfile) mainno = mno;
    /* file already loaded, check for name conflicts and cyclic inclusions */
    if (strcmp(aname, strsp+_fnametb[mno]) != 0) {
      char msg[MAXSTRLEN];
      sprintf(msg, qcmsg[AMBIG_REF], as);
      yyerror(msg);
    } else if (stacked(mno))
      yyerror(qcmsg[CYCLIC_REF]);
    return mno;
  } else if ((mno = getmodno_by_fname(aname)) != NONE) {
    /* module has already been loaded under a different alias; we handle this
       case by manufacturing aliases for all symbols of the module */
    int _modno = modno, sz = symtbsz, i;
    addmod(as, modname, aname, s);
    for (i = BUILTIN; i < sz; i++)
      if (symtb[i].modno == mno) {
	short flags = symtb[i].flags & ~EXT;
	if (flags & TSYM)
	  astype(i, 0, flags);
	else if (flags & VSYM)
	  asfvar(i, 0, flags);
	else
	  asfun(i, 0, symtb[i].argc, symtb[i].argv, flags, symtb[i].prec);
      }
    mno = modno;
    modno = _modno;
    return mno;
  }

  /* open new file: */

 open_file:
  if (save) saveimps();

  if ((yyin = have_stdin?stdin:fopen(aname, "r")) == NULL) {
    source = s;
    fatal(qcmsg[FILE_NOT_FOUND]);
  }
  if (fsp > fst)
    yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));

  /* enter into module table and initialize settings: */

  addmod(as, modname, aname, s);
  prio = 0;
  source = strdupchk(fname);
  yylineno = 1;
  BEGIN src;
  if (vflag)
    printf("%s:\n", have_stdin?fname:s);
  return HAVE_FILE;

}

static
pushfile(incl)
     int incl;
{
  if (fsp - fst >= MAXFILES)
    fatal(qcmsg[TOO_MANY_FILES]);
  else {
    fsp->state = YY_CURRENT_BUFFER;
    fsp->yyin = yyin;
    fsp->yylineno = yylineno;
    fsp->prio = prio;
    fsp->modno = modno;
    fsp->source = source;
    fsp->incl = incl;
    fsp->argc = argc;
    fsp->argv = argv;
    fsp->argv0 = argv0;
    fsp->asv = asv;
    fsp->asv0 = asv0;
    fsp->namec = 0;
    fsp->namev = NULL;
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
    fsp->ic = ic;
    ic = (iconv_t)-2;
#endif
    fsp->mybuf = mybuf;
    fsp->mybufptr = mybufptr;
    mybuf = mybufptr = NULL;
    fsp++;
  }
}

static popfile()
{
  fsp--;
  yy_delete_buffer(YY_CURRENT_BUFFER);
  yy_switch_to_buffer(fsp->state);
  yyin = fsp->yyin;
  yylineno = fsp->yylineno;
  prio = fsp->prio;
  modno = fsp->modno;
  source = fsp->source;
  argc = fsp->argc;
  argv = fsp->argv;
  argv0 = fsp->argv0;
  asv = fsp->asv;
  asv0 = fsp->asv0;
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
  if (ic != (iconv_t)-1 && ic != (iconv_t)-2)
    iconv_close(ic);
  ic = fsp->ic;
#endif
  if (mybuf) free(mybuf);
  mybuf = fsp->mybuf;
  mybufptr = fsp->mybufptr;
}

static popfile0()
{
  fsp--;
  yyin = fsp->yyin;
  yylineno = fsp->yylineno;
  prio = fsp->prio;
  modno = fsp->modno;
  source = fsp->source;
  argc = fsp->argc;
  argv = fsp->argv;
  argv0 = fsp->argv0;
  asv = fsp->asv;
  asv0 = fsp->asv0;
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
  if (ic != (iconv_t)-1 && ic != (iconv_t)-2)
    iconv_close(ic);
  ic = fsp->ic;
#endif
  if (mybuf) free(mybuf);
  mybuf = fsp->mybuf;
  mybufptr = fsp->mybufptr;
}

#define MAXNAMES MAXFILES

static id_alias_t impq[MAXFILES], impname[MAXNAMES];

static int impqsz = 0, impnamesz = 0;

add_import(s, as)
     char *s, *as;
{
  if (impqsz >= MAXFILES)
    fatal(qcmsg[TOO_MANY_FILES]);
  impq[impqsz].s = utf8_to_sys_dup(s);
  if (s) free(s);
  if (!impq[impqsz].s) fatal("memory overflow");
  impq[impqsz].as = as;
  impqsz++;
}

add_import_name(s, as)
     char *s, *as;
{
  if (impnamesz >= MAXNAMES)
    fatal(qcmsg[MEM_OVF]);
  impname[impnamesz].s = s;
  impname[impnamesz].as = as;
  impnamesz++;
}

clear_imports()
{
  impqsz = impnamesz = 0;
}

static void
sym_import(int incl, int mno, int namec, id_alias_t *namev)
{
  /* make aliases for imported symbols */
  char *modname = strsp+_modtb[mno];
  int i, l = strlen(modname);
  if (namec > 0 && namev[0].s) {
    for (i = 0; i < namec; i++)
      if (namev[i].s) {
	int sym = getsym(mno, namev[i].s);
	char *as = namev[i].as?namev[i].as:namev[i].s;
	if (sym != NONE) {
	  short flags = symtb[sym].flags & ~EXT;
	  if (!incl) flags |= PRIV;
	  if (flags & TSYM) {
	    int as_sym = mkxtype(as);
	    if (as_sym != NONE) astype(sym, as_sym, flags);
	  } else if (flags & VSYM) {
	    int as_sym = mkxfvar(as);
	    if (as_sym != NONE) asfvar(sym, as_sym, flags);
	  } else {
	    int as_sym = mkxfun(as);
	    if (as_sym != NONE)
	      asfun(sym, as_sym, symtb[sym].argc, symtb[sym].argv, flags,
		    symtb[sym].prec);
	  }
	} else {
	  /* error: undeclared symbol */
	  char msg[MAXSTRLEN];
	  sprintf(msg, qcmsg[MISS_DCL], utf8_to_sys(namev[i].s),
		  utf8_to_sys(modname));
	  yyerror(msg);
	}
	free(namev[i].s);
	if (namev[i].as) free(namev[i].as);
      }
  } else {
    /* just import everything */
    int sz = symtbsz;
    for (i = BUILTIN; i < sz; i++)
      if (symtb[i].modno == mno && !(symtb[i].flags&PRIV)) {
	short flags = symtb[i].flags & ~EXT;
	if (flags & TSYM)
	  astype(i, 0, flags);
	else if (flags & VSYM)
	  asfvar(i, 0, flags);
	else
	  asfun(i, 0, symtb[i].argc, symtb[i].argv, flags, symtb[i].prec);
      }
  }
}

static
doimport(incl)
     int incl;
{
  int i, mno;
  if (impqsz == 0) return;
  pushfile(incl);
  argc = impqsz;
  argv0 = argv = aalloc(argc, sizeof(char*));
  asv0 = asv = aalloc(argc, sizeof(char*));
  if (!argv || !asv) fatal(qcmsg[MEM_OVF]);
  for (i = 0; i < argc; i++) {
    argv[i] = impq[i].s;
    asv[i] = impq[i].as;
  }
  impqsz = 0;
  if (impnamesz > 0) {
    fsp[-1].namec = impnamesz;
    fsp[-1].namev = aalloc(impnamesz, sizeof(id_alias_t));
    if (!fsp[-1].namev) fatal(qcmsg[MEM_OVF]);
    memcpy(fsp[-1].namev, impname, impnamesz*sizeof(id_alias_t));
    impnamesz = 0;
  }
  while (argc--)
    if ((mno = opensrc(*argv++, *asv++, 1)) == HAVE_FILE) {
      if (argv[-1]) free(argv[-1]); if (asv[-1]) free(asv[-1]);
      return;
    } else {
      if (argv[-1]) free(argv[-1]); if (asv[-1]) free(asv[-1]);
      fsp--;
      modno = fsp->modno;
      yylineno = fsp->yylineno;
      if (mno != NONE)
	if (fsp->namev) {
	  sym_import(incl, mno, fsp->namec, fsp->namev);
	  free(fsp->namev); fsp->namev = NULL;
	} else if (incl)
	  putinc(mno, 0);
	else
	  putimp(mno, 0);
      fsp++;
    }
  if (argv0) free(argv0);
  if (asv0) free(asv0);
  popfile0();
}

import()
{
  doimport(0);
}

include()
{
  doimport(1);
}

static int have_main = 0;

yywrap()
{
  return 1;
}

wrapover()
{
  int have_file = 0;
  if (wrapped) return 1;
  if (wflag == 1) unresolved_forwards();
  saveimps();
  if (yyin != stdin) fclose(yyin); yyin = NULL;
  if (in_comment)
    return (wrapped = 1);
  else if (fsp > fst) {
    int mno = modno;
    fsp--;
    modno = fsp->modno;
    yylineno = fsp->yylineno;
    if (source) free(source);
    source = fsp->source;
    restoreimps();
    if (fsp->namev) {
      sym_import(fsp->incl, mno, fsp->namec, fsp->namev);
      free(fsp->namev); fsp->namev = NULL;
    } else if (fsp->incl)
      putinc(mno, 0);
    else
      putimp(mno, 0);
    fsp++;
    while(argc--)
      if ((have_file = (mno = opensrc(*argv++, *asv++, 1)) == HAVE_FILE)) {
	if (argv[-1]) free(argv[-1]); if (asv[-1]) free(asv[-1]);
	break;
      } else {
	if (argv[-1]) free(argv[-1]); if (asv[-1]) free(asv[-1]);
	fsp--;
	if (mno != NONE)
	  if (fsp->namev) {
	    sym_import(fsp->incl, mno, fsp->namec, fsp->namev);
	    free(fsp->namev); fsp->namev = NULL;
	  } else if (fsp->incl)
	    putinc(mno, 0);
	  else
	    putimp(mno, 0);
	fsp++;
      }
    if (!have_file) {
      if (argv0) free(argv0); if (asv0) free(asv0);
      popfile();
    }
    return 1;
  } else {
    static int mno, save = 0;
    if (have_main) {
      mno = modno;
      modno = mainno;
      restoreimps();
      putimp(mno, 0);
      save = 1;
    } else if (mainno != NONE) {
      have_main = 1;
      modno = mainno;
      restoreimps();
    } else if (mainfile && !*mainfile) {
      /* create a dummy main module to hold the global imports */
      mno = modno;
      addmod("", "", "", mainfile);
      have_main = 1;
      restoreimps();
      if (mno > 0) putimp(mno, 0);
      save = 1;
    }
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
    if (ic != (iconv_t)-1 && ic != (iconv_t)-2)
      iconv_close(ic);
    ic = (iconv_t)-2;
#endif
    while(argc-- && !(have_file = (mno=opensrc(*argv++, NULL, save))
		      == HAVE_FILE)) {
      putimp(mno, 0);
      save = 1;
    }
    if (!have_file && save) saveimps();
    wrapped = !have_file;
    return 1;
  }
}

initlex(_argc, _argv)
     int             _argc;
     char          **_argv;
{
  argc = _argc;
  argv = _argv;
  mainfile = (argc < 1)?NULL:*argv;
  initkws();
  while (argc && !**argv) argc--, argv++;
  if (prelude || argc >= 1) {
    fsp = fst;
    BEGIN src;
    if (prelude)
      opensrc(prelude, NULL, 0);
    else {
      if (mainfile && !*mainfile) {
	/* create a dummy main module to hold the global imports */
	addmod("", "", "", mainfile);
	saveimps();
	have_main = 1;
      }
      argc--;
      opensrc(*argv++, NULL, 0);
    }
    return 1;
  } else
    return 0;
}

srcstate()
{
  BEGIN src;
}

