/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include <qlineedit.h>

#include "editlabelimpl.h"

/* 
 *  Constructs a EditLabel which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
EditLabel::EditLabel( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : EditLabelBase( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
EditLabel::~EditLabel()
{
    // no need to delete child widgets, Qt does it all for us
}

int EditLabel::exec()
{
	editLabel->setText(m_strLabel);
	editLabel->setFocus();
	return EditLabelBase::exec();
}

void EditLabel::accept()
{
	//qDebug("EditLabel::accept\n");
	m_strLabel = editLabel->text();
	EditLabelBase::accept();
}

void EditLabel::setText(const QString & text)
{
	m_strLabel=text;
}

QString EditLabel::text ()
{
	return m_strLabel;
}
