/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSchʥ饹
****************************************************************************/
#ifndef XBSCHCOMPONENT_H
#define XBSCHCOMPONENT_H

#include "xbsch.h"
#include "xbschobj.h"
#include "complib.h"



//    (0) 0      (1) 90     (2) 180    (3) 270
//                                
//    ԡ     ̡     ¡     ҡ     
//  ̢Ң ¢Ԣ Ң̢ Ԣ¢
//    ¡     ҡ     ԡ     ̡     
//                                
//
//    (4) M0     (5) M90    (6) M180   (7) M270
//                                
//    ԡ     ̡     ¡     ҡ     
//  Ң̢ Ԣ¢ ̢Ң ¢Ԣ
//    ¡     ҡ     ԡ     ̡     
//                                


class SXBSchComponent:public SXBSchObj
{
public:
	enum BSCHCOMP_DIR{
		COMPONENT_DIR_0		=0,
		COMPONENT_DIR_90	=1,
		COMPONENT_DIR_180	=2,
		COMPONENT_DIR_270	=3,
		COMPONENT_DIR_M0	=4,
		COMPONENT_DIR_M90	=5,
		COMPONENT_DIR_M180	=6,
		COMPONENT_DIR_M270	=7
	};

	enum BSCHCOMP_TEXTPOS{
		COMPONENT_DEFAULT_REFNUM_X	=2,
		COMPONENT_DEFAULT_REFNUM_Y	=10,
		COMPONENT_DEFAULT_NAME_X	=2,
		COMPONENT_DEFAULT_NAME_Y	=20
	};

	enum BSCHCOMP_PINLTRB{
		COMPONENT_HASLPIN	=1,
		COMPONENT_HASTPIN	=2,
		COMPONENT_HASRPIN	=4,
		COMPONENT_HASBPIN	=8,
	};

	//󥹥ȥ饯
	SXBSchComponent();
	//ǥȥ饯
	virtual ~SXBSchComponent();
	SXBSchComponent(const SXBSchComponent&);				//ԡ󥹥ȥ饯
	SXBSchComponent& operator=(const SXBSchComponent&);	//黻
	bool readEmbLibCe3(SReadCE3&, SCompInfo*,string& );
	bool writeEmbLibCe3(SWriteCE3& wce3);

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

    //IDμ
	unsigned id(){return ID_COMPONENT;}
protected:
	string	m_name;			//̾
	SPoint	m_name_pos;		//̾θΥեå
	bool	m_name_drawSizeIsValid;
	SSize	m_name_drawSize;
	bool	m_name_horiz;
	string	m_refnum;		//ֹ
	SPoint	m_refnum_pos;	//ֹθΥեå
	bool	m_refnum_drawSizeIsValid;
	SSize	m_refnum_drawSize;
	bool	m_refnum_horiz;
	int		m_block;		//֥åֹ
	int		m_dir;			//
	int		m_pinltrb;		//LTRB10ԥĹԥ¸ߤƤ뤫ɤΥե饰
	SCompIndex* m_compInfoIndex;		//ʤξؤΥݥ
//	SCompIndex* m_embeddedCompInfoIndex;	//ʤξؤΥݥ
	bool	m_useEmbeddedLib;
	string	m_orgname;		//Ĺɡ饤֥꤫ɤ»ͤʤĤɬ
	string	m_note;

protected:
	void	mirrorDir();		//m_dirѿ򺸱ȿž
	void	rotateDir();		//m_dirѿ򱦲ž
	void	resetRefnumPos();	//ֹΰ֤ǥեȤΰ֤ѹ
	void	resetNamePos();		//̾ΰ֤ǥեȤΰ֤ѹ
//	void	setPinLtrb();		//LTRB˥ԥ¸ߤƤ뤫ɤΥե饰



public:
	void	setPinLtrb();		//LTRB˥ԥ¸ߤƤ뤫ɤΥե饰
	
	SXBSchObj* duplicate();	//ʣԤ
	//ɸ  m_p2ؤ̵ˤƤ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}

	void move(int offsetx,int offsety);	//֤ư
	void mirrorH(int x); //XɸꤷƺȿžԤ
	virtual void mirrorH(); //ȿžԤ
	void rotate(const SPoint& p); //XY濴ɸꤷơžԤ
	void rotate();	//žԤ
	int qSelectWeight(const SPoint& p);				//ꤷ٤֤
	unsigned testSelection(const SRect& rc);		//ϰϤꤷԤ
	unsigned testSelectionForDrag(const SRect& rc); //ϰϤ򤷤ƥɥåԤ
	bool qRedraw(const SRect&){return true;}		//褬ɬפɤ֤ qRedraw()Ͼ롣
	
	SRect area();	//ͭϰϤ֤
	SRect bodyArea();	//ͭϰϤ֤

	SRect rotateRect();
	SSize size() const;
	SRect nameArea() const;
	SRect refnumArea() const;

	void setNameDrawSize(const SSize& size);	//襵
	void setRefnumDrawSize(const SSize& size);	//襵

public:
	void setName(const char* psz);
	const char* name() const {return m_name.c_str();}
	void setNameHorizontal(bool bHoriz);	//2005/04/09
	bool nameHorizontal() const {return m_name_horiz;}//2005/04/09

	void setNote(const char* psz);
	const char* note() const {return m_note.c_str();}
	void setNamePos(const SPoint& p){m_name_pos = p;}
	void moveNamePos(int offsetx,int offsety);
	SPoint namePos(){return m_name_pos;}

	void setRefnum(const char* psz);
	const char* refnum() const {return m_refnum.c_str();}
	void setRefnumHorizontal(bool bHoriz);//2005/04/09
	bool refnumHorizontal() const {return m_refnum_horiz;}//2005/04/09
	void setRefnumPos(const SPoint& p){m_refnum_pos = p;}
	void moveRefnumPos(int offsetx,int offsety);
	SPoint refnumPos(){return m_refnum_pos;}

	void setOrgName(const char* psz);
	const char* orgname() const {return m_orgname.c_str();}
	const SCompIndex* compInfoIndex() const {return m_compInfoIndex;}
	void setCompInfoIndex(const SCompIndex* pIndex);
	
	const SPin*  pinLoc(int nIndex,int& nLtrb,SPoint& ptLoc) const; //ԥκäΰ־
	const SPin*  pinEnd(int nIndex,int& nLtrb,SPoint& ptEnd) const; //ԥüΰ־
	SPoint pinPosition(int)	const;//nܤΥԥüΰ֤롣pinEnd()Υ桼ƥ饤

	int pinCount() const; //ԥο


	void setBlock(int n);
	int block(){return m_block;}

	void setDir(int n);
	int dir(){return m_dir;}
	
	bool canAttribute(){return true;}	//ȥӥ塼Ȥѹǽʾtrue֤
};

#endif
