/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEventException.h"

#include <wtf/GetPtr.h>

#include "EventException.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEventException)

/* Hash table */

static const HashTableValue JSEventExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsEventExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsEventExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsEventExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsEventExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSEventExceptionTableValues, 0 };
#else
    { 10, 7, JSEventExceptionTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSEventExceptionConstructorTableValues[2] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEventExceptionConstructorTableValues, 0 };
#else
    { 2, 1, JSEventExceptionConstructorTableValues, 0 };
#endif

class JSEventExceptionConstructor : public DOMObject {
public:
    JSEventExceptionConstructor(ExecState* exec)
        : DOMObject(JSEventExceptionConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSEventExceptionPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSEventExceptionConstructor::s_info = { "EventExceptionConstructor", 0, &JSEventExceptionConstructorTable, 0 };

bool JSEventExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventExceptionConstructor, DOMObject>(exec, &JSEventExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSEventExceptionPrototypeTableValues[3] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsEventExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSEventExceptionPrototypeTableValues, 0 };
#else
    { 5, 3, JSEventExceptionPrototypeTableValues, 0 };
#endif

const ClassInfo JSEventExceptionPrototype::s_info = { "EventExceptionPrototype", 0, &JSEventExceptionPrototypeTable, 0 };

JSObject* JSEventExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEventException>(exec, globalObject);
}

bool JSEventExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSEventExceptionPrototype, JSObject>(exec, &JSEventExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSEventException::s_info = { "EventException", 0, &JSEventExceptionTable, 0 };

JSEventException::JSEventException(PassRefPtr<Structure> structure, PassRefPtr<EventException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSEventException::~JSEventException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSEventException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSEventExceptionPrototype(JSEventExceptionPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSEventException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventException, Base>(exec, &JSEventExceptionTable, this, propertyName, slot);
}

JSValuePtr jsEventExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventException* imp = static_cast<EventException*>(static_cast<JSEventException*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->code());
}

JSValuePtr jsEventExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventException* imp = static_cast<EventException*>(static_cast<JSEventException*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsEventExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventException* imp = static_cast<EventException*>(static_cast<JSEventException*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->message());
}

JSValuePtr jsEventExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSEventException*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSEventException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSEventExceptionConstructor>(exec);
}

JSValuePtr jsEventExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEventException::s_info))
        return throwError(exec, TypeError);
    JSEventException* castedThisObj = static_cast<JSEventException*>(asObject(thisValue));
    EventException* imp = static_cast<EventException*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValuePtr jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, EventException* object)
{
    return getDOMObjectWrapper<JSEventException>(exec, object);
}
EventException* toEventException(JSC::JSValuePtr value)
{
    return value->isObject(&JSEventException::s_info) ? static_cast<JSEventException*>(asObject(value))->impl() : 0;
}

}
