/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLQuoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLQuoteElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLQuoteElement)

/* Hash table */

static const HashTableValue JSHTMLQuoteElementTableValues[3] =
{
    { "cite", DontDelete, (intptr_t)jsHTMLQuoteElementCite, (intptr_t)setJSHTMLQuoteElementCite },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLQuoteElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSHTMLQuoteElementTableValues, 0 };
#else
    { 5, 3, JSHTMLQuoteElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLQuoteElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLQuoteElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLQuoteElementConstructorTableValues, 0 };
#endif

class JSHTMLQuoteElementConstructor : public DOMObject {
public:
    JSHTMLQuoteElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLQuoteElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLQuoteElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLQuoteElementConstructor::s_info = { "HTMLQuoteElementConstructor", 0, &JSHTMLQuoteElementConstructorTable, 0 };

bool JSHTMLQuoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElementConstructor, DOMObject>(exec, &JSHTMLQuoteElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLQuoteElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLQuoteElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLQuoteElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLQuoteElementPrototype::s_info = { "HTMLQuoteElementPrototype", 0, &JSHTMLQuoteElementPrototypeTable, 0 };

JSObject* JSHTMLQuoteElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLQuoteElement>(exec, globalObject);
}

const ClassInfo JSHTMLQuoteElement::s_info = { "HTMLQuoteElement", &JSHTMLElement::s_info, &JSHTMLQuoteElementTable, 0 };

JSHTMLQuoteElement::JSHTMLQuoteElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLQuoteElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLQuoteElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLQuoteElementPrototype(JSHTMLQuoteElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLQuoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElement, Base>(exec, &JSHTMLQuoteElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLQuoteElementCite(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(static_cast<JSHTMLQuoteElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->cite());
}

JSValuePtr jsHTMLQuoteElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLQuoteElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLQuoteElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLQuoteElement, Base>(exec, propertyName, value, &JSHTMLQuoteElementTable, this, slot);
}

void setJSHTMLQuoteElementCite(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(static_cast<JSHTMLQuoteElement*>(thisObject)->impl());
    imp->setCite(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLQuoteElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLQuoteElementConstructor>(exec);
}


}
