/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        QDate now=QDate::currentDate();

        {
                //Test import SKGImportExportManager::CSV skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);

                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_CSV", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/skrooge_partial.csv");
                        SKGTESTERROR("imp1.setCodec", imp1.setCodec(""), true);
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                }
                SKGAccountObject account;
                SKGTESTERROR("ACCOUNT.getObjectByName", SKGNamedObject::getObjectByName(&document1, "v_account", "Courant steph", account), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-935");
        }

        {
                //Test import QIF 1
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account.setNumber("12345P"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGUnitValueObject unit_euro_val1;
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                }

                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_CSV", err);
                        //Date;Libell�;Libell� compl�mentaire;Montant;Sens;Num�ro de ch�que
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/coopanet.csv");
                        QStringList map;
                        map << "date" << "comment" << "" << "amount" << "sign" << "number";
                        SKGTESTERROR("imp1.setCSVMapping", imp1.setCSVMapping(&map), true);
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account), true);
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                }
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-680.28");
        }

        {
                //Test import bankperfect
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account1;
                SKGAccountObject account2;
                SKGUnitObject unit_euro(&document1);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account1), true);
                        SKGTESTERROR("ACCOUNT:setName",account1.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account1.setNumber("12345P"), true);
                        SKGTESTERROR("ACCOUNT:save",account1.save(), true);

                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account2), true);
                        SKGTESTERROR("ACCOUNT:setName",account2.setName("PEL"), true);
                        SKGTESTERROR("ACCOUNT:save",account2.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGUnitValueObject unit_euro_val1;
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                }

                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_BP_CSV", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/bankperfect.csv");
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account1), true);
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                }

                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_BP_CSV", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/bankperfect2.csv");
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account2), true);
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);

                        int NbOperationsMerged=0;
                        SKGTESTERROR("imp1.findAndGroupTransfers", imp1.findAndGroupTransfers(NbOperationsMerged), true);
                        SKGTEST("imp1:NbOperationsMerged", NbOperationsMerged, 6);

                        SKGTESTERROR("imp1.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                }
                document1.dump(DUMPOPERATION|DUMPUNIT|DUMPACCOUNT);
                SKGTESTERROR("ACCOUNT.load", account1.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account1.getCurrentAmount()), "2624.068438");

                SKGTESTERROR("ACCOUNT.load", account2.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account2.getCurrentAmount()), "1500");

                SKGImportExportManager exp1(&document1, SKGImportExportManager::CSV, getTestPath("OUT")+"/skgtestimportcsv/bankperfect.csv");
                SKGTESTERROR("SKGImportExportManager::CSV.exportFile", exp1.exportFile(), true);

                {
                        SKGStringListList oTable;
                        SKGTESTERROR("SKGImportExportManager::CSV.exportFile", document1.getConsolidatedView("v_operation_display", "d_DATEMONTH", "t_CATEGORY", "f_CURRENTAMOUNT", "SUM", "",oTable), true);
                        QStringList dump=SKGServices::tableToDump(oTable, SKGServices::DUMP_TEXT);
                        int nbl=dump.count();
                        for (int i=0; i<nbl; ++i) {
                                SKGTRACE << dump[i] << endl;
                        }
                }
                {
                        SKGStringListList oTable;
                        SKGTESTERROR("SKGImportExportManager::CSV.exportFile", document1.getConsolidatedView("v_operation_display", "", "t_CATEGORY", "f_CURRENTAMOUNT", "SUM", "",oTable), true);
                        QStringList dump=SKGServices::tableToDump(oTable, SKGServices::DUMP_TEXT);
                        int nbl=dump.count();
                        for (int i=0; i<nbl; ++i) {
                                SKGTRACE << dump[i] << endl;
                        }
                }
                {
                        SKGStringListList oTable;
                        SKGTESTERROR("SKGImportExportManager::CSV.exportFile", document1.getConsolidatedView("v_operation_display", "d_DATEMONTH", "", "f_CURRENTAMOUNT", "SUM", "",oTable), true);
                        QStringList dump=SKGServices::tableToDump(oTable, SKGServices::DUMP_TEXT);
                        int nbl=dump.count();
                        for (int i=0; i<nbl; ++i) {
                                SKGTRACE << dump[i] << endl;
                        }
                }

        }

        {
                //Test import skrooge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_SKROOGE_CSV", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("OUT")+"/skgtestimportcsv/bankperfect.csv");
                        SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
                        SKGTEST("imp1:getCSVMapping", SKGServices::stringsToCsv(imp1.getCSVMapping()),
                                "\"date\";\"account\";\"number\";\"mode\";\"payee\";\"comment\";\"quantity\";\"unit\";\"amount\";\"sign\";\"category\";\"status\";\"bookmarked\"");
                }

                SKGImportExportManager exp1(&document1, SKGImportExportManager::CSV, getTestPath("OUT")+"/skgtestimportcsv/bankperfect2.csv");
                SKGTESTERROR("SKGImportExportManager::CSV.exportFile", exp1.exportFile(), true);
        }

        {
                //Test import skrooge+optimization
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_OPTIM", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/bankperfect.csv");
                        SKGTESTERROR("OPTIM.importFile", imp1.importFile(), true);
                        SKGTESTERROR("OPTIM.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                }

                SKGTESTERROR("OPTIM.undoRedoTransaction", document1.undoRedoTransaction(SKGDocument::UNDOLASTSAVE), true);
        }

        {
                //Test import skrooge in double to check merge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/remi_1.txt");
                        SKGTESTERROR("OPTIM.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION);
                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/remi_1.txt");
                        SKGTESTERROR("OPTIM.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION);
                }

                SKGAccountObject account(&document1);
                SKGTESTERROR("ACCOUNT.load", account.setName("remi_1"), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-767.26");
        }
        {
                //Test import 2638120
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/XXXXXXMxxxXXXXXXX.csv");
                        SKGTEST("BP:getCSVHeaderIndex", imp1.getCSVHeaderIndex(), 7);
                        SKGTESTERROR("BP.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION);
                }

                SKGAccountObject account(&document1);
                SKGTESTERROR("ACCOUNT.load", account.setName("XXXXXXMxxxXXXXXXX"), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "8114.26");
        }
        {
                //Test import 206894
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/206894.csv");
                        SKGTESTERROR("BP.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION);
                }

                SKGAccountObject account(&document1);
                SKGTESTERROR("ACCOUNT.load", account.setName("206894"), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "2986.39");
        }

        {
                //Test import with tabulation
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::CSV, getTestPath("IN")+"/skgtestimportcsv/mutual fund.csv");
                        SKGTESTERROR("BP.importFile", imp1.importFile(), true);
                        document1.dump(DUMPOPERATION);
                }


                SKGAccountObject account(&document1);
                SKGTESTERROR("ACCOUNT.load", account.setName("Janus Twenty Fund"), true);
                SKGTESTERROR("ACCOUNT.load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "24.51428572");
        }

        //End test
        SKGENDTEST();
}
