/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        QDate now=QDate::currentDate();

        {
                //Test import QIF 1
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:setNumber",bank.setNumber("0003"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account.setNumber("12345P"), true);
                        SKGTESTERROR("ACCOUNT:setAgencyNumber",account.setAgencyNumber("98765"), true);
                        SKGTESTERROR("ACCOUNT:setAgencyNumber",account.setAgencyAddress("10 rue Dupon, 31000 TOULOUSE"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGUnitValueObject unit_euro_val1;
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_BP_QIF", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/ref.qif");
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account), true);
                        SKGTESTERROR("QIF.setDefaultUnit", imp1.setDefaultUnit(&unit_euro), true);
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                SKGTESTERROR("ACCOUNT:load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-935");

                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_BP_QIF", err);
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, "");
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);

                        SKGImportExportManager exp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/ref.qif");
                        SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
                }

                SKGTESTERROR("ACCOUNT:load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-935");
        }

        {
                //Test import QIF 2
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant Guillaume"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account.setNumber("98765A"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGUnitValueObject unit_euro_val1;
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_BP_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/E0269787.qif");
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account), true);
                        SKGTESTERROR("QIF.setDefaultUnit", imp1.setDefaultUnit(&unit_euro), true);
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);


                        SKGImportExportManager exp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787.qif");
                        SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
                }

                SKGTESTERROR("ACCOUNT:load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-1684.58");

                //Check import with account retrieved from file
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                {
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);

                        SKGImportExportManager exp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787_bis.qif");
                        SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
                }

                //Check multi import
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                {
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/ref.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);	//Double import
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);
                }

                //Check import with account retrieved from files
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                {
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/ref.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGImportExportManager imp2(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787.qif");
                        SKGTESTERROR("QIF.importFile", imp2.importFile(), true);
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);

                        SKGImportExportManager exp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787_ref.qif");
                        SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
                }

                //Check import qif multi accounts
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                {
                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/E0269787_ref.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);
                        QStringList oResult;
                        SKGTESTERROR("ACCOUNT:getDistinctValues", SKGServices::getDistinctValues(&document1, "account", "t_name", oResult), true);
                        SKGTEST("ACCOUNT:oResult.size", oResult.size(), 2);

                }
        }

        {
                //Test import QIF 2
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGUnitObject unit_euro(&document1);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("ING"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("ING"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account.setNumber("ING"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGUnitValueObject unit_euro_val1;
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_ING_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/ing.qif");
                        SKGTESTERROR("QIF.setDefaultAccount", imp1.setDefaultAccount(&account), true);
                        SKGTESTERROR("QIF.setDefaultUnit", imp1.setDefaultUnit(&unit_euro), true);
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                        SKGTESTERROR("QIF.cleanBankImport", imp1.cleanBankImport(), true);
                        SKGTESTERROR("QIF.cleanBankPerfectImport", imp1.cleanBankPerfectImport(), true);
                        int out=0;
                        SKGTESTERROR("QIF.findAndGroupTransfers", imp1.findAndGroupTransfers(out), true);


                        SKGImportExportManager exp1(&document1, SKGImportExportManager::QIF, getTestPath("OUT")+"/skgtestimportqif/ing.qif");
                        SKGTESTERROR("QIF.exportFile", exp1.exportFile(), true);
                }
        }

        {
                //Test import QIF MOTO
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_ING_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/moto.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("moto"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "26198.77");

                }
        }

        {
                //Test import QIF MOTO with euro and franc
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_INIT", err);

                        {
                                SKGUnitObject unit(&document1);
                                SKGTESTERROR("EURO.setName",unit.setName("E"), true);
                                SKGTESTERROR("EURO.setType",unit.setType(SKGUnitObject::PRIMARY), true);
                                SKGTESTERROR("EURO.setSymbol",unit.setSymbol("E"), true);
                                SKGTESTERROR("EURO.importFile",unit.save(), true);

                                //Creation of the value
                                SKGUnitValueObject value;
                                SKGTESTERROR("EURO.addUnitValue",unit.addUnitValue(value), true);
                                SKGTESTERROR("EURO.setDate",value.setDate(QDate(2002,1,1)), true);
                                SKGTESTERROR("EURO.setQuantity",value.setQuantity(1), true);
                                SKGTESTERROR("EURO.save",value.save(), true);
                        }

                        {
                                SKGUnitObject unit(&document1);
                                SKGTESTERROR("FRANC.setName",unit.setName("F"), true);
                                SKGTESTERROR("FRANC.setType",unit.setType(SKGUnitObject::PRIMARY), true);
                                SKGTESTERROR("FRANC.setSymbol",unit.setSymbol("F"), true);
                                SKGTESTERROR("FRANC.importFile",unit.save(), true);

                                //Creation of the value
                                SKGUnitValueObject value;
                                SKGTESTERROR("FRANC.addUnitValue",unit.addUnitValue(value), true);
                                SKGTESTERROR("FRANC.setDate",value.setDate(QDate(1959,1,1)), true);
                                SKGTESTERROR("FRANC.setQuantity",value.setQuantity(1.0/6.55957), true);
                                SKGTESTERROR("FRANC.save",value.save(), true);
                        }

                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_ING_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/moto.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);

                        document1.dump(DUMPALL);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("moto"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "5009.99543");

                }
        }

        {
                //Test import QIF KMM
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_KMM_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/kmm-without-category.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("kmm-without-category"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-52.36");
                }
        }

        {
                //Test import QIF KMM with category
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_KMM_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/kmm-with-category.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("kmm-with-category"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-52.36");
                }
        }

        {
                //Test import QIF REMI in double to check merge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_REMI_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/remi_2.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_REMI_QIF", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/remi_2.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }
                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("remi_2"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-1208.63");
                }
        }

        {
                //Test import QIF REMI in double to check merge
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT_DOUBLE", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/double.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }
                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("double"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-243");
                }
        }

        {
                //Test import bug GNUCash 350286
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/350286.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("350286"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "1057.37");
                }
        }

        {
                //Test import bug GNUCash 393596
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/393596.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("393596"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "12.34");
                }
        }

        {
                //Test import bug GNUCash 503166
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/503166.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("My Investments"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "20");
                }
        }

        {
                //Test import bug GNUCash 392707
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/392707.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("392707"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "1219.06");
                }
        }

        {
                //Test import bug GNUCash 373584
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/373584.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("My Investments"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "1000000");
                }
        }

        {
                //Test import bug 199818
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/199818.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("199818"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-345.64");
                }
        }

        {
                //Test import bug 201316
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/201316.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGStringListList listTmp;
                        SKGTESTERROR("QIF.executeSelectSqliteOrder", SKGServices::executeSelectSqliteOrder (&document1,
                                        "SELECT TOTAL(f_CURRENTAMOUNT),t_status FROM v_operation_display GROUP BY t_status ORDER BY t_status", listTmp ), true);
                        SKGTEST("QIF:listTmp.count", listTmp.count(), 4);
                        if (listTmp.count()==4) {
                                SKGTEST("QIF:listTmp.at(1).at(0)", listTmp.at(1).at(0), "-10.0");
                                SKGTEST("QIF:listTmp.at(2).at(0)", listTmp.at(2).at(0), "-100.0");
                                SKGTEST("QIF:listTmp.at(3).at(0)", listTmp.at(3).at(0), "-1000.0");
                        }
                }
        }

        {
                //Test import bug 201451
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "IMPORT", err);

                        SKGImportExportManager imp1(&document1, SKGImportExportManager::QIF, getTestPath("IN")+"/skgtestimportqif/201451.qif");
                        SKGTESTERROR("QIF.importFile", imp1.importFile(), true);
                }

                {
                        SKGAccountObject account(&document1);
                        SKGTESTERROR("QIF.setName", account.setName("201451"), true);
                        SKGTESTERROR("QIF.load", account.load(), true);
                        SKGTEST("QIF:getValue", SKGServices::doubleToString(account.getCurrentAmount()), "-123.45");
                }
        }
        //End test
        SKGENDTEST();
}
