/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSEARCHPLUGINWIDGET_H
#define SKGSEARCHPLUGINWIDGET_H
/** @file
* A skrooge plugin to search and process operations
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgsearchpluginwidget_base.h"
#include "skgtabwidget.h"

class SKGObjectModel;

/**
 * A skrooge plugin to search and process operations
 */
class SKGSearchPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGSearchPluginWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGSearchPluginWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttribute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

private slots:
        void dataModified(const QString& iTableName, int iIdTransaction);
        void onAddRule();
        void onModifyRule();
        void onApply();
        void onSelectionChanged();
        void onActionTypeChanged();
        void onTop();
        void onUp();
        void onDown();
        void onBottom();
        void onDoubleClick();
        void onEditorModified();
        void onBtnModeClicked();
        void cleanEditor();

private:
        Q_DISABLE_COPY(SKGSearchPluginWidget);

        int getCurrentMode();
        void setCurrentMode(int iMode);
        QString getXMLActionDefinition();

        SKGObjectModel* objectModel;
        int mode;

        Ui::skgsearchplugin_base ui;
};

#endif // SKGSEARCHPLUGINWIDGET_H
