class StartPage < ControlPage

  def initialize(parent = nil)
    super(parent)

    @tip_label = Qt::Label.new do
      set_word_wrap true
      set_minimum_height 75

      @tips = [ 'You can switch to fullscreen mode by double-clicking the webcam preview.',

                'If you experience flicker or other video display related problems, you may try ' +
                'to switch <i>Accelerated Video Rendering</i> option in <i>Settings</i>.',

                "If your webcam was detected but there is no image from it, " +
                'try to change <i>Webcam Resolution</i> in <i>Settings</i>.',

                "If <i>Flash Effect</i> is not smooth you can try to:<br>" +
                "1. Enable Desktop Effects.<br>" + "2. Update your video driver.<br>" +
                "3. Simply disable it in <i>Settings</i>."
               ]

      @tip = rand(@tips.size)
      set_text('<div align="justify">' + @tips[@tip])

      install_event_filter self

      def eventFilter(obj, event)
        if event.type == Qt::Event::MouseButtonPress
          @tip += 1
          @tip = 0 if @tip == @tips.size
          set_text('<div align="justify">' + @tips[@tip])
          true
        else false end
      end
    end

    tip_info = Qt::Label.new(center(small_font("Click to see next tip.")))

    add_group('Tip of the day', :tip_small) do |g|
      g.add_widget @tip_label
      g.add_widget tip_info
    end

    about_text= 'About' + ' ' + $webkam_app.name + ' ' + $webkam_app.version

    cprt_text = 'Copyright (C) 2008 Bartosz Wadolowski'
    copyright = Qt::Label.new(small_font(center(cprt_text)))

    ws_text = 'Visit ' + link($webkam_app.website, 'project website') + ' for more information.'
    website = Qt::Label.new(center(ws_text)) do
                set_word_wrap true
                set_open_external_links true
              end

    lcse_text = 'This program is distributed under the terms of the ' +
                link('http://www.gnu.org/copyleft/gpl.html', ' GPLv3.')
    license = Qt::Label.new(small_font(center(lcse_text))) do
                set_word_wrap true
                set_open_external_links true
              end

    add_group(about_text, :webkam_small, false) do |g|
      g.add_widget copyright
      g.add_widget license
      g.add_spacing 5
      g.add_widget website
    end

    add_stretch
  end

end

