#include <unistd.h>
#include <stdio.h>
#include <assert.h>

#ifdef WINDOWS
# include <winsock.h>
#else
# include <sys/socket.h>
# include <netdb.h>
# include <netinet/in.h>
#ifndef __BEOS__
# include <arpa/inet.h>
#endif
#endif /* WINDOWS */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/* #include "bswap.h" */

#include "url.h"                                                                                
#include <inttypes.h>

/* MBUF_SIZE may be small, but not tiny; it should be at
   least large enough for mms_send_command() to work -
   note that mms_send_command() sends user supplied
   strings like the URL path */
#define MBUF_SIZE (1024 * 16)

/* Progress updates. should be similar to rbuf buffer size.
   unfortunately, rbuf buffer size has no #define */
#define MPROGRESS_SIZE 4096
#define MSTREAM_SIZE 256

typedef struct {
  uint8_t buf[MBUF_SIZE];
  int     num_bytes;
} command_t;

struct mms_stat
{
  /* URL */
  struct url *u;		/* Filled in by the original wget code */
  char url[1024];		/* URL string */
  char *local_fn;		/* The local filename */
  char *local_fn0;		/* Silly copy of original local_fn pointer */

  /* Sigs */
  char guid[35];
  unsigned char sig[4];

  /* Connections in and out */
  int  sock;			/* Socket connected MMS host */
  FILE *fh;			/* Local file handle */

  /* Buffers */
  uint8_t head_buf[MBUF_SIZE];	/* ASF header */
  uint8_t mpkt_buf[MBUF_SIZE];	/* ASF media packet (or part) - Note that
				   a media packet may be > MBUF_SIZE */

  /* Byte counts and times */
  long head_len;		/* Header packet (head_buf) size */
  long mpad_len;		/* Padded media packet size */
  long mpad_total;		/* Total size of all padded media packets */

  long mpkt_len;		/* Size of the current media packet -
				   As stated above, this may be > MBUF_SIZE,
				   but should always be <= mpad_len */
  long mpkt_to_get;		/* Bytes still to read */
  long mpkt_to_pad;		/* Padding bytes still to write */

  long asf_dl;			/* Downloaded so far */
  long asf_dltime;		/* Time taken to download so far */
  long asf_total;		/* Total bytes expected to download */

  /* Former mms_client-0.0.3 globals */
  int seq_num;
  int num_stream_ids;
  int stream_ids[MSTREAM_SIZE];

  /* Status of MMS session */
  uerr_t status; 		/* Error code (MMSOK, MMSERR, etc) */
};
