#include <string.h>
#include <windows.h>
#include <stdint.h>
#include <stdio.h>
#include <ddk/imm.h>
#include <limits.h>
#include "cannaapi.h"
#include "ut.h"
#include "apisup.h"

Array Clients;
Array Context;
Array ReplyBuf;
unsigned SerialNumber; //ƥȤֹ̤

HWND NewWin();

void reset_client_data(ClientData_t* cdt,int fd,const char* user);
CannaContext_t* reset_context(CannaContext_t* c,int fd,HWND wh,unsigned xwin);
void cd_constructor(void* p);
void cx_constructor(void* p);
int eq_wnd(const void *val,const void *elem);
int eq_fd(const void *val,const void *elem);


//wh=Х륳ƥȤ˻Ȥhwnd
void InitClientData(HWND wh)
{
    ArNewPs(&Clients,sizeof(ClientData_t),cd_constructor,8);
    ArNewPs(&Context,sizeof(CannaContext_t),cx_constructor,8);
    OpenContext(0,wh,NULL);
    ArNew(&ReplyBuf,1,NULL);
}

//ʣʤ˳ǧƤ
int16_t OpenConnection(int fd,const char* user)
{
    int16_t cxn;
    ClientData_t* cdt = ArFindElemIf(&Clients,0,eq_fd,0); //õ
    reset_client_data(cdt,fd,user);
    OpenContext(fd,NewWin(),&cxn);
    return cxn;
}

//եǥץfdΥ饤Ⱦ
bool CloseConnection(int fd)
{
    /*??? gcc4.3.3ˤʤä,ͥȴؿƴؿѿ򻲾Ȥ褦ˤʤä(close_cxƤfd򻲾Ȥ饻եˤʤ)
     */
    int close_cx(CannaContext_t* cx,int fd){
	if(cx->Connection==fd && cx->Win!=NULL)
	    CloseContext(cx);
	return 1;
    }

    ClientData_t* cdt;
    bool st=false;
    if((cdt = FindClient(fd)) != NULL){
	cdt->Connection = 0;
	free(cdt->User);
	free(cdt->App);
	free(cdt->Group);
	ArForEach(&Context,(AR_FOREACH)close_cx,(void*)fd);
	st=true;
    }else
	LOG("already closed fd %d\n",fd);
    return st;
}

ClientData_t* FindClient(int fd)
{
    int n = ArFindIf(&Clients,0,eq_fd,(void*)fd);
    return n>=0 ? ArElem(&Clients,n) : NULL;
}

int16_t context_number(const CannaContext_t* cx)
{
    return cx - (const CannaContext_t*)(Context.adr);
}

CannaContext_t* OpenContext(int fd,HWND wh,int16_t *cxn)
{
    CannaContext_t* cx = ArFindElemIf(&Context,0,eq_wnd,NULL);
    reset_context(cx,fd,wh,0);
    cx->SerialNum = SerialNumber++;
    if(cxn != NULL)
	*cxn = context_number(cx);
    return cx;
}

//ơɥɽƤХɥĤ
void CheckCloseStWin(CannaContext_t* cx)
{
    if(cx->Flags & OPEN_STATUS_WINDOW){
	//ΥƥȤϥơɥɽƤ
	cx->Flags &= ~OPEN_STATUS_WINDOW;
	if(--WimeData.StWinHolders <= 0){
	    SendMessage(cx->Win,WM_IME_NOTIFY,IMN_CLOSESTATUSWINDOW,0);
	    LOG("hide status window\n");
	    if(WimeData.StWinHolders < 0){ //ǰΤåƤ
		MSG("BUG? multiply hide status window\n");
		WimeData.StWinHolders = 0;
	    }
	}
    }else
	LOG("already hide status window\n");
}

void CloseContext(CannaContext_t* cx)
{
    if(cx != NULL){
#ifndef SETCONTEXT_FAIL
	//ImmCreateContextImeSelect褹ޤ̵ˤ
	if(!ImmDestroyContext(ImmAssociateContext(cx->Win,NULL)))
	    LOG("fail ImmDestroyContext\n");
#endif
	DestroyWindow(cx->Win);
	cx->Win = NULL;
	ArDelete(&cx->CandInfo);
	ArDelete(&cx->FixedStr);
	ArDelete(&cx->FixedYomi);
	ArDelete(&cx->Dics);
	ArDelete(&cx->DicMode);
	CheckCloseStWin(cx);
	LOG("close context %hd\n",context_number(cx));
    }
}

//fdγǧ⤹뤫
CannaContext_t* ValidContext(int cxn,const char* msgtag)
{
    CannaContext_t* cx = ArElem(&Context,cxn);
    if(cxn<0 || cxn>=Context.use || cx->Win==NULL){
	LOG("%s:invalid context %hd\n",msgtag,cxn);
	cx = NULL;
    }
    return cx;
}

CannaContext_t* FindContext(HWND wh,int16_t* cxn)
{
    *cxn = ArFindIf(&Context,0,eq_wnd,wh);
    return *cxn!=-1 ? ArElem(&Context,*cxn) : NULL;
}

void reset_client_data(ClientData_t* cdt,int fd,const char* user)
{
    cdt->Connection = fd;
    cdt->User = user==NULL ? NULL : strdup(user);
    cdt->App = cdt->Group = NULL;
}

CannaContext_t* reset_context(CannaContext_t* cx,int fd,HWND wh,unsigned xwin)
{
    cx->Win = wh;
    cx->Connection = fd;
    ArClear(&cx->CandInfo);
    cx->FixedNum = 0;
    cx->Flags = 0;
    ArClear(&cx->FixedStr);
    ArClear(&cx->FixedYomi);
    ArClear(&cx->Dics);
    ArClear(&cx->DicMode);
    cx->XWin = xwin;
    return cx;
}

CannaContext_t* ResetContext(CannaContext_t* cx)
{
    return reset_context(cx,cx->Connection,cx->Win,cx->XWin);
}

void cd_constructor(void* p)
{
    reset_client_data((ClientData_t*)p,0,NULL);
}

void candinfo_c(void* p)
{
    memset(p,0,sizeof(CandListPageInfo));
}

void cx_constructor(void* p)
{
    CannaContext_t* cx = (CannaContext_t*)p;
    memset(cx,0,sizeof(*cx));
    ArNewPs(&(cx->CandInfo),sizeof(CandListPageInfo),candinfo_c,16);
    cx->SerialNum = SerialNumber++;
    ArNew(&cx->FixedStr,2,NULL);
    ArNew(&cx->FixedYomi,2,NULL);
    ArNew(&cx->Dics,1,NULL);
    ArNew(&cx->DicMode,4,NULL);
}

int eq_wnd(const void *val,const void *elem)
{
    return val==((CannaContext_t*)elem)->Win;
}

int eq_fd(const void *val,const void *elem)
{
    return (int)val == ((const ClientData_t*)elem)->Connection;
}

#ifdef SETCONTEXT_FAIL
void SetCurrentImc(HIMC imc,BOOL on)
{
    static HIMC Current = NULL;

    if(on){
	if(Current!=NULL && Current!=imc){
	    ImmNotifyIME(Current,NI_COMPOSITIONSTR,CPS_CANCEL,0);
	    ImmSetOpenStatus(Current,FALSE);
	}
	ImmSetOpenStatus(Current=imc,TRUE);
    }else{
	ImmSetOpenStatus(Current,FALSE);
	Current = NULL;
    }    
}
#endif

////////////////////////////////////////////////////////////////////////

uint16_t Req2(CanHeader* ch)
{
    return Swap2(((Req2_t*)ch)->p1);
}

void Req3(CanHeader* ch,int16_t *p1,uint16_t *p2)
{
    *p1 = Swap2(((Req3_t*)ch)->p1);
    *p2 = Swap2(((Req3_t*)ch)->p2);
}

//cannawcharʸޥХʸˤ
//p5free뤳
char* Req4(Req4_t* q,int16_t* p1,uint16_t* p2,uint16_t* p3,uint16_t* p4)
{
    Req9((CanHeader*)q,p1,(int16_t*)p2,(int16_t*)p3,(int16_t*)p4);
    return ToMb(q->p5);
}

void Req5(CanHeader* h,int16_t *p1,uint16_t *p2,int32_t* p3)
{
    Req10((Req10_t*)h,p1,(int16_t*)p2,p3);
}

void Req6(CanHeader* h,int16_t *p1,int16_t *p2,uint16_t *p3)
{
    Req9(h,p1,p2,(int16_t*)p3,NULL);
}

void Req7(CanHeader* h,int16_t* p1,int16_t* p2,int16_t* p3)
{
    Req9(h,p1,p2,p3,NULL);
}

void Req8(CanHeader* h,int16_t* p1,int16_t* p2,int16_t* p3,uint16_t* p4)
{
    Req9(h,p1,p2,p3,(int16_t*)p4);
}

void Req9(CanHeader* q,int16_t* p1,int16_t* p2,int16_t* p3,int16_t* p4)
{
    int16_t *p[]={p1,p2,p3,p4};
    int n;
    for(n=0; n<4; ++n)
	if(p[n] != NULL)
	    *p[n] = Swap2(((Req9_t*)q)->p[n]);
}

void *Req10(Req10_t* q,int16_t *p1,int16_t *p2,int32_t *p3)
{
    *p1 = Swap2(q->p1);
    *p2 = Swap2(q->p2);
    *p3 = Swap4(q->p3);
    int sz=(q->h.Length-(sizeof(Req10_t)-sizeof(CanHeader)))/2;
    while(--sz >= 0)
	Swap2p(q->p4+sz,1);
    return q->p4;
}

//p3ϥХȤ촹򤻤ˤΤޤ
uint16_t* Req11r(CanHeader* ch,int16_t* p1,int16_t* p2)
{
    Req3(ch,p1,(uint16_t*)p2);
    return ((Req11_t*)ch)->p3;
}

//p3ϣХʸǤȤƣХʸѴ
//p3free뤳
char* Req11(CanHeader* ch,int16_t* p1,int16_t* p2)
{
    uint16_t *p3 = Req11r(ch,p1,p2);
    return ToMb(p3);
}

//cannawcharʸޥХʸˤ
//p2free뤳
char* Req12(Req12_t* q,int16_t* p1,char** p2)
{
    char *p3 = (char*)(WcChr(q->p2,0)+1);
    *p1 = Swap2(q->p1);
    *p2 = ToMb(q->p2);
    return p3;
}

//p3free뤳
char* Req13(Req13_t* q,int16_t* p1,char** p3,uint16_t* p4,uint16_t* p5,uint16_t* p6)
{
    uint16_t *wp;
    *p1 = Swap2(q->p1);
    *p3 = strchr(q->p2,0)+1;
    wp = WcChr((uint16_t*)*p3,0)+1;
    *p4 = *(wp++);
    *p5 = *(wp++);
    *p6 = *(wp++);
    *p3 = ToMb((uint16_t*)*p3);
    return q->p2;
}

//cannawcharʸޥХʸˤ
//p3free뤳
char* Req14(CanHeader *h,int32_t *p1,int16_t *p2)
{
    Req15(h,p1,p2);
    return ToMb(((Req14_t*)h)->p3);
}

char* Req15(CanHeader* h,int32_t *p1,int16_t *p2)
{
    *p1 = Swap4(((Req15_t*)h)->p1);
    *p2 = Swap2(((Req15_t*)h)->p2);
    return h->Length>sizeof(Req15_t)-sizeof(CanHeader) ? ((Req15_t*)h)->p3 : NULL;
}

//ޥ˥奢Ǥϥ18ȥ֤äƤListDirectory(1-7)˻ȤȤˤ
uint16_t Req16(Req16_t* q,int16_t* p1,char** p2)
{
    *p1 = Swap2(q->p1);
    *p2 = q->p2;
    return Swap2c(strchr(*p2,0)+1);
}

uint16_t Req18(Req18_t* q,int16_t* p1,char** p2,char** p3)
{
    *p1 = Swap2(q->p1);
    *p2 = q->p2;
    *p3 = strchr(*p2,0)+1;
    return Swap2c(strchr(*p3,0)+1);
}

char* Req19(CanHeader* h,int32_t* p1,int16_t* p2,char** p3)
{
    *p3 = Req15(h,p1,p2);
    return strchr(*p3,0)+1;
}

char* Req21(CanHeader* h,int32_t* p1,int16_t* p2,char** p3,char** p4)
{
    *p4 = Req19(h,p1,p2,p3);
    return strchr(*p4,0)+1;
}

//----------------------------------------------------

bool send_reply(Array* r,uint8_t mj,uint8_t mn)
{
    CanHeader *h = ArAdr(r);
    h->Major = mj;
    h->Minor = mn;
    h->Length = Swap2(ArUsing(r)-sizeof(CanHeader));
    return ImWrite(h,ArUsing(r));
}
    
bool Reply2(uint8_t mj,uint8_t mn,char st)
{
    Rply2_t *r = ArAlloc(&ReplyBuf,sizeof(Rply2_t));
    r->p1 = st;
    return send_reply(&ReplyBuf,mj,mn);
}

//len=dataʸ(̥ʸޤ)
bool Reply3(uint8_t mj,uint8_t mn,char st,const uint16_t* data,int len)
{
    Rply3_t *r = ArAlloc(&ReplyBuf,sizeof(Rply3_t)+len*2);
    r->p1 = st;
    memcpy(r->p2,data,len*2);
    return send_reply(&ReplyBuf,mj,mn);
}
    
bool Reply4(uint8_t mj,uint8_t mn,char p1,const int32_t* data,int num)
{
    Rply4_t *r = ArAlloc(&ReplyBuf,sizeof(Rply4_t)+num*4);
    r->p1 = p1;
    for(int n=0; n<num; ++n)
	r->p2[n] = Swap4(*(data++));
    return send_reply(&ReplyBuf,mj,mn);
}

bool Reply5(uint8_t mj,uint8_t mn,int16_t st)
{
    Rply5_t *r = ArAlloc(&ReplyBuf,sizeof(Rply5_t));
    r->p1 = Swap2(st);
    return send_reply(&ReplyBuf,mj,mn);
}

/* str==NULLΤȤlen=0
*/
bool Reply6(uint8_t mj,uint8_t mn,uint16_t i,const char* str,int len)
{
    if(str==NULL)
	len = 0;
    Rply6_t *r = ArAlloc(&ReplyBuf,sizeof(Rply6_t)+len);
    r->p1 = Swap2(i);
    memcpy(r->p2,str,len);
    return send_reply(&ReplyBuf,mj,mn);
}

bool Reply6s(uint8_t mj,uint8_t mn,uint16_t i,const char* str)
{
    return Reply6(mj,mn,i,str,str!=NULL?strlen(str)+1:0);
}

//len=̥ޤʸ
bool Reply7(uint8_t mj,uint8_t mn,uint16_t i,uint16_t *str,int len)
{
    if(str == NULL)
	len = 0;
    len *= 2;
    Rply7_t *r = ArAlloc(&ReplyBuf,sizeof(Rply7_t)+len);
    r->p1 = Swap2(i);
    memcpy(r->p2,str,len);
    return send_reply(&ReplyBuf,mj,mn);
}

//!!! -mno-cygwinʤ
void* MEMPCPY(void* d,const void* s,int n)
{
    return (char*)memcpy(d,s,n)+n;
}

//p4sizep4ΥХȿ
bool Reply10(uint8_t mj,uint8_t mn,char p1,const char* p2,const char* p3,const int32_t* p4,int p4size)
{
    char *p;
    int p2size = p2!=NULL ? strlen(p2)+1 : 0;
    int p3size = p3!=NULL ? strlen(p3)+1 : 0;
    int bufsize = sizeof(Rply10_t) + p2size + p3size + p4size;
    Rply10_t *r = ArAlloc(&ReplyBuf,bufsize);
    r->p1 = p1;
    p = MEMPCPY(r->p2,p2,p2size);
    p = MEMPCPY(p,p3,p3size);

    for(; p4size>0; p+=sizeof(*p4),++p4,p4size-=sizeof(*p4)){
	*(int32_t*)p = Swap4(*p4);
    }

    return send_reply(&ReplyBuf,mj,mn);
}

bool ReplyN(uint8_t mj,uint8_t mn,const void* p,unsigned size)
{
    if(p==NULL){
	size=0;
    }
    ArAlloc(&ReplyBuf,sizeof(CanHeader)+size);
    memcpy((CanHeader*)ArAdr(&ReplyBuf)+1,p,size);
    return send_reply(&ReplyBuf,mj,mn);
}

////////////////////////////////////////////////////////////////////////

void dbg_attr(const char* tag,char* a,int len)
{
    char sel,cnv;
    char *buf=malloc(4*len+1),*bp=buf;

    for(int n=0; n<len; ++n){
	sel=cnv='-';
	switch(*(a++)){
	case ATTR_INPUT://̤,̤Ѵ
	    break;
	case ATTR_TARGET_CONVERTED://,Ѵ
	    sel='s'; cnv='c';
	    break;
	case ATTR_CONVERTED:	//̤,Ѵ
	    cnv='c';
	    break;
	case ATTR_TARGET_NOTCONVERTED:	//,̤Ѵ
	    sel='s';
	    break;
	case ATTR_INPUT_ERROR:	//̵
	    sel=cnv='x';
	    break;
	case ATTR_FIXEDCONVERTED:
	    cnv='f';
	    break;
	default:	//°
	    sel=cnv='?';
	}
	*(bp++) = '[';
	*(bp++) = sel;
	*(bp++) = cnv;
	*(bp++) = ']';
    }
    *bp = 0;
    MSG("\t%s-attr:size %d:%s\n",tag,len,buf);
    free(buf);
}

void dbg_str(const char* tag,COMPOSITIONSTRING* cs,int stroffset,
	     int cloffset,int cllen,
	     int atoffset,int atlen,
	     void (*cpy_u16)(uint16_t* dst,const uint16_t* src,int len))
{
    uint16_t* str = (uint16_t*)((char*)cs+stroffset);
    uint32_t* cl = (uint32_t*)((char*)cs+cloffset);
    cllen /= 4;
    uint16_t u16[cl[cllen-1]+1];
    char ej[sizeof(u16)];
    Array lb;
    int len;

    ArNew(&lb,1,NULL);
    MSG("\t%s-clause:size %d:%s\n",tag,cllen,ArAdr(Dump4(" %d",cl,cllen,&lb)));
    if(atoffset!=0)
	dbg_attr(tag,(char*)cs+atoffset,atlen);
    for(int n=0; n<cllen-1; ++n){
	len = cl[n+1]-cl[n];
	cpy_u16(u16,str+cl[n],len);
	ArPrint(&lb,"[%s]",U16ToEj(ej,u16,len));
    }
    MSG("\t%s-str=%s\n",tag,ArAdr(&lb));
    ArDelete(&lb);
}

void dbg_str_cpy_comp(uint16_t* dst,const uint16_t* src,int len)
{
    memcpy(dst,src,len*2);
}

void dbg_str_cpy_read(uint16_t* dst,const uint16_t* src,int len)
{
    SjHan2UniZen(dst,(char*)src,2,0x40,0,len);
}

void DbgComp(HIMC imc,const char *tag)
{
    INPUTCONTEXT *ic = (INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs = (COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);

    MSG("%s:COMPOSITIONSTRING debug\n",tag);
    dbg_str("comp",cs,cs->dwCompStrOffset,cs->dwCompClauseOffset,cs->dwCompClauseLen,cs->dwCompAttrOffset,cs->dwCompAttrLen,dbg_str_cpy_comp);
    dbg_str("read",cs,cs->dwCompReadStrOffset,cs->dwCompReadClauseOffset,cs->dwCompReadClauseLen,cs->dwCompReadAttrOffset,cs->dwCompReadAttrLen,dbg_str_cpy_read);
    dbg_str("result",cs,cs->dwResultStrOffset,cs->dwResultClauseOffset,cs->dwResultClauseLen,0,0,dbg_str_cpy_comp);
    dbg_str("result-read",cs,cs->dwResultReadStrOffset,cs->dwResultReadClauseOffset,cs->dwResultReadClauseLen,0,0,dbg_str_cpy_read);
    MSG("\tcursor pos=%d  delta start=%d\n",cs->dwCursorPos,cs->dwDeltaStart);

    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
}

/*
  ߤʸƱ=-1
  =0
  =1
*/
int change_attr(int target,char *attr,const int32_t *cls,int clslen)
{
    char a,*bp;
    int n,cur;
    
    //ߤʸ򸫤Ĥ
    for(cur=0; cur<clslen-1; ++cur)
	if(a=attr[cls[cur]],
	   (a==ATTR_TARGET_CONVERTED||a==ATTR_TARGET_NOTCONVERTED))
	    break;
    LOG("target change %d --> %d\n",cur,target);
    if(cur == clslen-1){
	LOG("ʸ᤬ʤ\n");
	return 0; //ʸ᤬ʤ
    }
    if(cur == target)
	return -1; //ߤʸƱ

    //򤵤Ƥʬ̤ˤ
    for(n=cls[cur+1]-cls[cur],bp=attr+cls[cur]; n>0; --n,++bp)
	switch(*bp){
	case ATTR_TARGET_CONVERTED:
	    *bp = ATTR_CONVERTED;
	    break;
	case ATTR_TARGET_NOTCONVERTED:
	    *bp = ATTR_INPUT;
	}

    //ʸ򤹤
    for(n=cls[target+1]-cls[target],bp=attr+cls[target]; n>0; --n,++bp)
	switch(*bp){
	case ATTR_CONVERTED:
	    *bp = ATTR_TARGET_CONVERTED;
	    break;
	case ATTR_INPUT:
	    *bp = ATTR_TARGET_NOTCONVERTED;
	}
    return 1;
}

/*
  ʸѹ
  tn=ʸֹ(0)
*/
ChangeTargetStatus ChangeTargetClause(HIMC imc,int tn,const CannaContext_t* cx)
{
    int alen,readalen,r0,r1,clslen,readclslen;
    int32_t *cls,*readcls;
    INPUTCONTEXT *ic=(INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs=(COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);

    if(tn < cx->FixedNum)
	return ChangeTargetFixed; //ʸϤɤ褦ʤ
    tn -= cx->FixedNum;

    /*
      readclsʤɤImmGetCompositionString()ǤȤäƤ٤
      wine1.0rc1ǤfixmeˤʤäƤΤǡľܹ¤Τ򸫤뤳Ȥˤ
    */
    char attr[alen=cs->dwCompAttrLen],readattr[readalen=cs->dwCompReadAttrLen];
    memcpy(attr,(char*)cs+cs->dwCompAttrOffset,alen);
    memcpy(readattr,(char*)cs+cs->dwCompReadAttrOffset,readalen);

    clslen = cs->dwCompClauseLen/4;
    cls = (int32_t*)((char*)cs+cs->dwCompClauseOffset);
    readclslen = cs->dwCompReadClauseLen/4;
    readcls = (int32_t*)((char*)cs+cs->dwCompReadClauseOffset);

    //LOG("befer change\n");DbgComp(imc,__FUNCTION__);
    if((r0 = change_attr(tn,attr,cls,clslen)))
       r1 = change_attr(tn,readattr,readcls,readclslen);
    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);

    /*
      wineImmSetCompositionString()ǤAWˤݥǡ̵wcharˤΤǡcharɬפʥޥɤλW褵
       compreadξꤷʤȼԤ
    */
    if(r0<0)
	LOG("clause %d is current cl.\n",cx->FixedNum+tn);
    if(r0>0 && r1>0){
	if(!(r0 = ImmSetCompositionStringW(imc,SCS_CHANGEATTR,attr,alen,readattr,readalen)))
	    MSG("fail ImmSetCompositionStringW\n");
#if 0
	else{
	    //??? ImmNotifyIMEɬפ
	    r0 = ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
	    if(r0){
		VERBOSE(MSG("after change\n"); DbgComp(imc,__FUNCTION__));
	    }else
		MSG("fail ImmNotifyIME\n");
	}
#endif
    }
    return (r0!=0 ? ChangeTargetSuccess:ChangeTargetFail);
}

//ʸcxΥФ¸롣(ǡ¸)
void SaveFixedClause(HIMC imc,CannaContext_t* cx)
{
    int32_t *cl,*rcl;
    uint16_t *uni,*yo;
    INPUTCONTEXT *ic=(INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs=(COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);

    cl = (int32_t*)((char*)cs+cs->dwResultClauseOffset);
    uni = (uint16_t*)((char*)cs+cs->dwResultStrOffset);
    rcl = (int32_t*)((char*)cs+cs->dwResultReadClauseOffset);
    yo = (uint16_t*)((char*)cs+cs->dwResultReadStrOffset);
    for(int n=0; n<(int)(cs->dwResultClauseLen)/4-1; ++n){
	wstr_add_nwcs(&cx->FixedStr,uni+cl[n],cl[n+1]-cl[n]);
	wstr_add_wc(&cx->FixedStr,0);

	wstr_add_nwcs(&cx->FixedYomi,yo+rcl[n],rcl[n+1]-rcl[n]);
	wstr_add_wc(&cx->FixedYomi,0);

	++ cx->FixedNum;
    }
    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
}

/*
  ʸֹnѴʸcejˤ
  ejΥ֥å=2
  ejϥꥢ롣̥ʸɲäʤ
  atnullǤʤ°֤
*/
Array* ClauseStr(HIMC imc,int n,Array *ej,char* at,const CannaContext_t* cx)
{
    INPUTCONTEXT *ic=(INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs=(COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
    uint16_t *uni;
    char a;
    int len;

    if(n < cx->FixedNum){
	//nϸʸؤƤ
	uni = StrListNthWc(cx->FixedStr.adr,cx->FixedNum,n);
	len = WcLen(uni);
	a = ATTR_FIXEDCONVERTED; //??? ֤󤳤ΤȤ
    }else{
	n -= cx->FixedNum; //ʸ᤬Фʸޤƹͤ
	int32_t* cl = (int32_t*)((char*)cs+cs->dwCompClauseOffset);
	uni = (uint16_t*)((char*)cs+cs->dwCompStrOffset) + cl[n];
	len = cl[n+1]-cl[n];
	a = *((char*)cs+cs->dwCompAttrOffset+cl[n]);
    }

    if(ej != NULL){
	U16ToCej(ArAlloc(ej,len+1),uni,len);
	ArDec(ej);	
	//Array x,y;ArNew(&x,1,NULL);ArNew(&y,1,NULL);Dump1(" %02x",uni,len*2,&x);Dump1(" %02x",ArAdr(ej),ArUsingBytes(ej),&y);printf("u:%s --> e:%s\n",ArAdr(&x),ArAdr(&y));
    }
    if(at != NULL)
	*at = a;

    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
    return ej;
}

//ʸ֤
int ClauseLen(HIMC imc,const CannaContext_t* cx)
{
    INPUTCONTEXT* ic=(INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING* cs=(COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
    int len=0;
    if(cs->dwCompClauseLen > 0)
	len += cs->dwCompClauseLen/4-1;//ʸ(-1)
    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
    return cx->FixedNum + len;
}

/*
  n1ʸᤫn2ʸޤǤɤʸeucjp֤
  e->blocksize == 2
  eϥꥢ롣
  e˥̥ʸϤĤuseˤϥȤʤ
*/
Array* GetInputClause(HIMC imc,int n1,int n2,const CannaContext_t* cx,Array* e)
{
    INPUTCONTEXT *ic = (INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs = (COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
    Array src;

    ArNew(&src,2,NULL);
    while(n1 < min(cx->FixedNum,n2+1)){
	wstr_add_wcs(&src,StrListNthWc(cx->FixedYomi.adr,cx->FixedNum,n1++));
    }
    if(n2 >= cx->FixedNum){
	n1 -= cx->FixedNum;
	n2 -= cx->FixedNum;
	if(n1 <= n2){
	    int32_t* rcl = (int32_t*)((char*)cs+cs->dwCompReadClauseOffset);
	    uint16_t* han = (uint16_t*)((char*)cs+cs->dwCompReadStrOffset)+rcl[n1];
	    wstr_add_nwcs(&src,han,rcl[n2+1]-rcl[n1]);
	}
    }
    wstr_add_wc(&src,0); //̥ʸɲäƤ
    SjHan2UniZen(ArAdr(&src),ArAdr(&src),2,0x40,1,INT_MAX);
    ArAlloc(e,WcLen(ArAdr(&src))+1);
    ArDec(e); //̥ʸϥȤʤ
    U16ToEj(ArAdr(e),ArAdr(&src),ArUsing(e));
    *(uint16_t*)ArElem(e,ArUsing(e)) = 0; //U16ToEjΥ̥ʸ8bitʤΤ16bitΥ̥ʸ֤

    ArDelete(&src);
    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
    return e;
}

/*
  ɤʸΤʸ֤
*/
int InputLen(HIMC imc,CannaContext_t* cx)
{
    INPUTCONTEXT *ic = (INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs = (COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
    int32_t* rcl = (int32_t*)((char*)cs+cs->dwCompReadClauseOffset);
    int hanlen = rcl[cs->dwCompReadClauseLen/4-1];
    uint16_t uzen[hanlen+1];
    int len=0;

    for(int n=0; n<cx->FixedNum; ++n)
	len += WcLen(StrListNthWc(cx->FixedYomi.adr,cx->FixedNum,n));
    SjHan2UniZen(uzen,(char*)cs+cs->dwCompReadStrOffset,2,0x40,1,hanlen);
    len += WcLen(uzen);

    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
    return len;
}

/*
  °ʸֹ֤
  ʸ̵뤹
*/
int GetAttrCl(HIMC imc,char at,const CannaContext_t* cx)
{
    INPUTCONTEXT *ic = (INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs = (COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);
    int num;
    int cllen = cs->dwCompClauseLen/4-1;
    int32_t* cl = (int32_t*)((char*)cs+cs->dwCompClauseOffset);
    char* attr = (char*)cs+cs->dwCompAttrOffset;

    for(num=0; num<cllen; ++num){
	if(attr[cl[num]] == at)
	    break;
    }
    
    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);

    return num<cllen ? cx->FixedNum+num : -1;
}

#if 0
int WcToMb(const uint16_t* w,int wlen,char* m,int mlen)
{
    int sz = WideCharToMultiByte(CP_ACP,0,(LPCWSTR)w,wlen,m,mlen,NULL,NULL);
    m[sz] = 0;
    return sz;
}
#endif

/*
  (clpos_b<=ʸֹ<clpos_e)ޤǤCOMPOSITIONSTRINGscsɲä
  ʸֹimcǤο͡ cx->FixedNumϹθƤʤΤǤ餫Ƥȡ
  ʸˤϺǸǡʸˤդuseˤϥȤʤ
  ResultStrʸ֤Ȥˤ롣

  ClauseStr(),GetInputClause()ȽʣƤ...
 */
void StoreComp(Array scs[],HIMC imc,int clpos_b,int clpos_e,int en)
{
    int32_t *cl,*rcl;
    int strlen,rdlen,n;

    INPUTCONTEXT *ic = (INPUTCONTEXT*)ImmLockIMC(imc);
    COMPOSITIONSTRING *cs = (COMPOSITIONSTRING*)ImmLockIMCC(ic->hCompStr);

    if(clpos_e < 0)
	clpos_e = cs->dwCompClauseLen/4-1;
    cl = (int32_t*)((char*)cs+cs->dwCompClauseOffset);
    strlen = cl[clpos_e]-cl[clpos_b];
    rcl = (int32_t*)((char*)cs+cs->dwCompReadClauseOffset);
    rdlen = rcl[clpos_e]-rcl[clpos_b];

    int ncl = clpos_e-clpos_b+1; //ʸ+1
    int32_t cl_s[ncl],cl_r[ncl];
    for(n=0; n<ncl; ++n){
	cl_s[n] = cl[clpos_b+n]-cl[clpos_b];
	cl_r[n] = rcl[clpos_b+n]-rcl[clpos_b];
    }
    if(en & EN_STRCL){
	ArAddN(scs+CS_STRCL,cl_s,ncl);
	-- scs[CS_STRCL].use;
    }
    if(en & EN_READCL){
	ArAddN(scs+CS_READCL,cl_r,ncl);
	-- scs[CS_READCL].use;
    }

    if(en & EN_STR)
	ArAddN(scs+CS_STR,(uint16_t*)((char*)cs+cs->dwCompStrOffset) + cl[clpos_b],strlen);
    if(en & EN_READ)
	ArAddN(scs+CS_READ,(uint16_t*)((char*)cs+cs->dwCompReadStrOffset) + rcl[clpos_b],rdlen);

    if(en & EN_STRATTR)
	ArAddN(scs+CS_STRATTR,(char*)cs+cs->dwCompAttrOffset + cl[clpos_b],strlen);
    if(en & EN_READATTR)
	ArAddN(scs+CS_READATTR,(char*)cs+cs->dwCompReadAttrOffset + rcl[clpos_b],rdlen);

    //ResultStrʸ֤Ȥˤ롣
    if(en & EN_RESULT)
	ArAddN(scs+CS_RESULT,(char*)cs+cs->dwResultStrOffset,cs->dwResultStrLen);

    ImmUnlockIMCC(ic->hCompStr);
    ImmUnlockIMC(imc);
}

/*
  scsƤimc˥åȤ
  ʸ᤬ĤʤȼԤ롣StoreCompʸ򤷤Ƥȡ
*/
bool LoadComp(Array scs[],HIMC imc)
{
    if(scs[CS_STR].use == 0){
	return ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CANCEL,0);
    }

    int n=0,actmax=3;
    int act[][3]={{SCS_SETSTR,CS_STR,CS_READ},
		  {SCS_CHANGECLAUSE,CS_STRCL,CS_READCL},
		  {SCS_CHANGEATTR,CS_STRATTR,CS_READATTR},
    };
    Array *css,*csr;
    /* ??? °ʸꤹ롣
       ʸꤹȼưŪƬʸ᤬ʸˤʤ褦
       °ꤹȤߤξ֤ƱImmSetCompositionStringWfail
       ֤(atokΤȤ)
       ʤΤǡscsƬʸ°ʸλϲ⤷ʤȤˤ롣
    */

    //ʸκǸʸɲä
    ArAdd(scs+CS_STRCL,&scs[CS_STR].use);
    ArAdd(scs+CS_READCL,&scs[CS_READ].use);

    char a = *(char*)(scs[CS_STRATTR].adr);
    if(a==ATTR_TARGET_CONVERTED || a==ATTR_TARGET_NOTCONVERTED)
	--actmax; //°ꤷʤ

    do{
	css = scs + act[n][1];
	csr = scs + act[n][2];
    }while(ImmSetCompositionStringW(imc,act[n][0],ArAdr(css),ArUsingBytes(css),ArAdr(csr),ArUsingBytes(csr)) && ++n<actmax);

    return n==actmax && ImmNotifyIME(imc,NI_COMPOSITIONSTR,CPS_CONVERT,0);
}

void CompNew(Array scs[])
{
    int bs[CS_MAX]={[CS_STR]=2,[CS_STRCL]=4,[CS_STRATTR]=1,[CS_READ]=2,[CS_READCL]=4,[CS_READATTR]=1,[CS_RESULT]=2};

    for(int n=0; n<CS_MAX; ++n)
	ArNew(scs+n,bs[n],NULL);
}

void CompDelete(Array scs[])
{
    for(int n=0; n<CS_MAX; ++n)
	ArDelete(scs+n);
}

/*
  ʸ°
*/
char GetAttr(HIMC imc,int cl,const CannaContext_t* cx)
{
    char a;
    ClauseStr(imc,cl,NULL,&a,cx);
    return a;
}
