#ifndef WIME_CANNAAPI_H
#define WIME_CANNAAPI_H

#define CANNA_NEW_WCHAR_AWARE
#ifdef __WINNT__
  #include <windows.h>
#else
  typedef void* HWND;
  typedef void* HIMC;
#endif
#include <stdint.h>
#include <canna/RK.h>
#include "wimeio.h"
#include "array.h"

#define WIME_CANNA_MAJOR 3
#define WIME_CANNA_MINOR 6
#define RETURN_VERSION_ERROR_STAT -2

#include "pkt.h"
#define CANNAHEADERSIZE sizeof(CanHeader)

typedef struct{
    HWND Win;
    int Conv;		//Ѵʸֹ롣ʳξ֤λ-1
    int FerMode;	//RkBgnBunΥ⡼
    RkStat RkSt;	//!!! äƤɬפʤ
    Array CandInfo;	//ʸѴꥹȤΥڡ
    int Connection;	//̿Υեǥץ
    unsigned SerialNum; //ֹ̤档 memo'libcannaȤʻ'򻲾 !!!ä
    unsigned Flags;
    unsigned XWin;	//KeyPress٥ȤXΥɥ

    Array Dics;		//̾Υꥹ(char*)
    Array DicMode;	//Υ⡼(int32)

    int FixedNum;	//ưѴ⡼ɤǾ˳ꤵ줿ʸο
    Array FixedStr;	//˳ꤵ줿ʸηʸΥꥹ(int16_t,le)
    Array FixedYomi;	//ʸɤ߲̾Υꥹ(int16_t,le)
} CannaContext_t;

//CannaContext_t.Flags
#define OPEN_STATUS_WINDOW	1	//ơɥɽƤ
#define PROC_NOTIFY_MSG		2	//WM_IME_NOTIFYDefWindowProcˤ錄(ơɥȤ)
#define PROC_COMP_MSG		4	//WM_IME_COMPOSITIONDefWindowProcˤ錄(ѴɥȤ)

//CandInfo
#define CANDLISTMAX 4
typedef struct{
    int Size[CANDLISTMAX];	//ƥڡθ
    int Seq;			//䥦ɥФʤȤθ
} CandListPageInfo;

typedef struct{
    int Connection; //̿Υեǥץ
    char *User;
    char *App;
    char *Group;
} ClientData_t;
    
//ʻ쥳
typedef struct{
    char *Ccode;	//ʤΥɡƬ'#'ϤĤʤɽ
    int Wcode;		//STYLEBUF.dwStyle
} HinshiCor;

//եΥǡ,¾
struct GlobalData_t{
    HinshiCor* HinshiTab;	//ʻ쥳
    int StWinHolders;		//ơɥɽƤ륳ƥȤο
};

extern struct GlobalData_t WimeData;

typedef bool (*WMCANNAPROTO)(CanHeader*,int);

bool wm_canna_init(CanHeader *ch,int fd);
bool wm_dup_context(CanHeader *ch,int fd);
bool wm_mount_dic(CanHeader *ch,int fd);
bool wm_begin_conv(CanHeader *ch,int fd);
bool wm_create_context(CanHeader *ch,int fd);
bool wm_get_candi_list(CanHeader *ch,int fd);
bool wm_set_app_name(CanHeader *ch,int fd);
bool wm_notice_group(CanHeader *ch,int fd);
bool wm_get_status(CanHeader *ch,int fd);
bool wm_end_conv(CanHeader *ch,int fd);
bool wm_unmount_dic(CanHeader *ch,int fd);
bool wm_canna_finalize(CanHeader *ch,int fd);
bool wm_close_context(CanHeader *ch,int fd);
bool wm_get_dic_list(CanHeader *ch,int fd);
bool wm_resize_pause(CanHeader *ch,int fd);
bool wm_define_word(CanHeader *ch,int fd);
bool wm_get_dir_list(CanHeader *ch,int fd);
bool wm_remount_dic(CanHeader *ch,int fd);
bool wm_mount_dic_list(CanHeader *ch,int fd);
bool wm_query_dic(CanHeader *ch,int fd);
bool wm_delete_word(CanHeader *ch,int fd);
bool wm_get_yomi(CanHeader *ch,int fd);
bool wm_subst_yomi(CanHeader *ch,int fd);
bool wm_store_yomi(CanHeader *ch,int fd);
bool wm_store_range(CanHeader *ch,int fd);
bool wm_get_last_yomi(CanHeader *ch,int fd);
bool wm_flush_yomi(CanHeader *ch,int fd);
bool wm_remove_yomi(CanHeader *ch,int fd);
bool wm_get_simple_kanji(CanHeader *ch,int fd);
bool wm_get_hinshi(CanHeader *ch,int fd);
bool wm_get_lex(CanHeader *ch,int fd);
bool wm_set_locale(CanHeader *ch,int fd);
bool wm_auto_conv(CanHeader *ch,int fd);
bool wm_query_ext(CanHeader *ch,int fd);
bool wm_kill_server(CanHeader *ch,int fd);

bool wm_get_server_info(CanHeader *ch,int fd);
bool wm_get_acl(CanHeader *ch,int fd);
bool wm_create_dic(CanHeader *ch,int fd);
bool wm_delete_dic(CanHeader *ch,int fd);
bool wm_rename_dic(CanHeader *ch,int fd);
bool wm_get_word_text_dic(CanHeader *ch,int fd);
bool wm_list_dic(CanHeader *ch,int fd);
bool wm_sync(CanHeader *ch,int fd);
bool wm_chmod_dic(CanHeader *ch,int fd);
bool wm_copy_dic(CanHeader *ch,int fd);

bool wm_wime_dialog(CanHeader* ch,int fd);
bool wm_wime_set_comp_win(CanHeader* ch,int fd);
bool wm_wime_get_comp_win(CanHeader* ch,int fd);
bool wm_wime_send_key(CanHeader* ch,int fd);
bool wm_wime_enable_ime(CanHeader* ch,int fd);
bool wm_wime_move_shadow_win(CanHeader* ch,int fd);
bool wm_wime_set_comp_font(CanHeader* ch,int fd);
bool wm_wime_show_status_window(CanHeader* ch,int fd);
bool wm_wime_get_comp_str(CanHeader* ch,int fd);
bool wm_wime_set_cand_win(CanHeader* ch,int fd);
bool wm_wime_reg_x_window(CanHeader* ch,int fd);
bool wm_wime_get_result_str(CanHeader* ch,int fd);
bool wm_wime_set_result_str(CanHeader* ch,int fd);

#endif
