#define _GNU_SOURCE
#include <stdio.h>
#include <getopt.h>
#include <windows.h>
#include <imm.h>
#include <process.h>
#include <stdint.h>
#include <errno.h>
#include <signal.h>
#include "cannaapi.h"
#include "wimeio.h"
#include "wimeapi.h"
#include "ut.h"
#include "apisup.h"

enum {
    WM_SET_COMP_STR = WM_APP,
    WM_CANNA_PACKET,	/* minor=0 */
    WM_CANNA_PACKET_EX = WM_CANNA_PACKET+256, /* minor=1 */
    WM_CANNA_PACKET_END = WM_CANNA_PACKET_EX+256
};

struct GlobalData_t WimeData;
WMCANNAPROTO* WmCannaTab[2];
unsigned CanFunMax[2];
char ClassName[]="ImeBridge";
FILE* LogFile; //꤬ʤstdoutˤ
char* LogFileName;

#define WIME_VERSION "3.1.3"

HWND NewWin();
unsigned __stdcall recv_xim(void *h);
LRESULT CALLBACK wnd_proc(HWND wh,UINT msg,WPARAM wp,LPARAM lp);
int cmdline_opt(int ac,char *av[]);
void init_cb(void);
void open_logfile(const char* fn,const char* mode);
void reg_class(void);
void ime_info(void);

int main(int ac,char *av[])
{
    HWND h;
    MSG msg;
    HANDLE th;
    int socket_num;

    Verbose = 1;
    LogFile = stdout;
    init_cb();
    socket_num = cmdline_opt(ac,av);
    setbuf(stdout,NULL);
    reg_class();
    h = NewWin();
    if(ImInit(socket_num) != 0)
	return 1;

    wime_connect();
    ImReadSetting(&WimeData);
    th = (HANDLE)_beginthreadex(NULL,0,recv_xim,h,0,NULL);
    wime_shm_init(LOGMARK);

    VERBOSE(ime_info());
    while(GetMessage(&msg, NULL, 0, 0) >0) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }

    wime_shm_fin();
    wime_disconnect();
    CloseHandle(th);
    LOG("EXIT\n");
    return 0;
}

void reg_class(void)
{
    WNDCLASS wc;

    memset(&wc,0,sizeof(wc));
    wc.lpfnWndProc = wnd_proc;
    wc.lpszClassName = ClassName;
    if(!RegisterClass(&wc)){
	ERR("fail RegisterClass '%s'\n",ClassName);
	exit(1);
    }
}

void ime_info(void)
{
    typedef struct{
	int bit;
	const char *desc;
    } pair;
#define def_pair(x) {x,#x}

    HKL kl;
    unsigned sz;
    pair igp_prop[] = {def_pair(IME_PROP_AT_CARET),
		       def_pair(IME_PROP_SPECIAL_UI),
		       def_pair(IME_PROP_CANDLIST_START_FROM_1),
		       def_pair(IME_PROP_UNICODE),
		       def_pair(IME_PROP_COMPLETE_ON_UNSELECT),
		       //def_pair(IME_PROP_ACCEPT_WIDE_VKEY),
    };
    pair igp_ui[] = {def_pair(UI_CAP_2700),
		   def_pair(UI_CAP_ROT90),
		   def_pair(UI_CAP_ROTANY)};
    pair igp_comp[] = {def_pair(SCS_CAP_COMPSTR),
		     def_pair(SCS_CAP_MAKEREAD),
		     def_pair(SCS_CAP_SETRECONVERTSTRING)};
    pair igp_sel[] = {def_pair(SELECT_CAP_CONVERSION),
		    def_pair(SELECT_CAP_SENTENCE)};
    pair igp_ver[] = {def_pair(IMEVER_0310),
		    def_pair(IMEVER_0400)};
    pair igp_conv[] = {def_pair(IME_CMODE_NATIVE),
		       def_pair(IME_CMODE_KATAKANA),
		       def_pair(IME_CMODE_LANGUAGE),
		       def_pair(IME_CMODE_FULLSHAPE),
		       def_pair(IME_CMODE_ROMAN),
		       def_pair(IME_CMODE_CHARCODE),
		       def_pair(IME_CMODE_HANJACONVERT),
		       def_pair(IME_CMODE_SOFTKBD),
		       def_pair(IME_CMODE_NOCONVERSION),
		       def_pair(IME_CMODE_EUDC),
		       def_pair(IME_CMODE_SYMBOL),
		       def_pair(IME_CMODE_FIXED),
    };
    pair igp_sen[] = {def_pair(IME_SMODE_NONE),
		      def_pair(IME_SMODE_PLAURALCLAUSE),
		      def_pair(IME_SMODE_SINGLECONVERT),
		      def_pair(IME_SMODE_AUTOMATIC),
		      def_pair(IME_SMODE_PHRASEPREDICT),
		      def_pair(IME_SMODE_CONVERSATION),
    };
    Array buf;
#undef def_pair

    Array* bit_name(int val,pair* p,int ni,Array* buf){
	const char *sep = "";
	*(char*)ArAlloc(buf,1) = 0;
	while(--ni >= 0){
	    if(val & p->bit){
		ArExpand(buf,strlen(p->desc)+1);
		strcat(strcat(ArAdr(buf),sep),p->desc);
		sep = "|";
	    }
	    val &= ~p->bit;
	    ++p;
	}
	if(val != 0){
	    char b[128];
	    sprintf(b,"%s0x%x",sep,val);
	    ArExpand(buf,strlen(b));
	    strcat(ArAdr(buf),b);
	}
	return buf;
    }

    kl = GetKeyboardLayout(0);

    sz = ImmGetIMEFileName(kl,NULL,0);
    char ime_fn[sz+1];
    ime_fn[0]=0;
    ImmGetIMEFileName(kl,ime_fn,sz);

    sz = ImmGetDescription(kl,NULL,0);
    char desc[sz+1];
    desc[0]=0;
    ImmGetDescription(kl,desc,sz);

    MSG("kb layout    0x%x\n",kl);
    MSG("ime filename '%s'\n",ime_fn);
    MSG("description  '%s'\n",desc);

    ArNew(&buf,1,NULL);
    MSG("property\n");
    MSG("\tconersion     %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_CONVERSION),igp_conv,ITEMS(igp_conv),&buf)));
    MSG("\time-version   %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_GETIMEVERSION),igp_ver,ITEMS(igp_ver),&buf)));
    MSG("\tproperty      %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_PROPERTY),igp_prop,ITEMS(igp_prop),&buf)));
    MSG("\tselect        %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_SELECT),igp_sel,ITEMS(igp_sel),&buf)));
    MSG("\tsentence      %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_SENTENCE),igp_sen,ITEMS(igp_sen),&buf)));
    MSG("\tset-comp-str  %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_SETCOMPSTR),igp_comp,ITEMS(igp_comp),&buf)));
    MSG("\tui            %s\n",ArAdr(bit_name(ImmGetProperty(kl,IGP_UI),igp_ui,ITEMS(igp_ui),&buf)));
    ArDelete(&buf);
}

bool AtInit(WMCANNAPROTO* tab[]);

//ime̤ν
bool ime_sp(const char* ime)
{
    typedef bool (*init_func_t)(WMCANNAPROTO* tab[]);
    struct{
	char* name;
	init_func_t init;
    } tab[]={
	{"atok",AtInit},
	{NULL,NULL}
    };
    int n;
    
    for(n=0; tab[n].name!=NULL && strcmp(tab[n].name,ime)!=0; ++n)
	;
    return tab[n].name!=NULL && tab[n].init(WmCannaTab);
}

//!!! Ʊä
void log_req(const Req15_t* r)
{
    /*
      ׵:type15
	p1=ޡʸ
	p2=Ȥʤ
	p3=ʸ
      :type2
    */
    bool st=true;
    for(int n=0; n<2 && !(st=(fprintf(LogFile,"[%c]%s",Swap4(r->p1),r->p3)>=0)); ++n)
	open_logfile(LogFileName,"a");
    Reply2(WIME_LOG&0xff,WIME_LOG>>8,st);
}

void LogW(const char* fmt,...)
{
    va_list vl;
    va_start(vl,fmt);
    vfprintf(LogFile,fmt,vl);
    va_end(vl);
}
    
/*
  ʤΥѥåȤ
*/
unsigned __stdcall recv_xim(void *h)
{
    Array chbuf;
    int rsz,fd;
    UINT msg;
    CanHeader *ch;

    ArNew(&chbuf,1,NULL);
    ArAlloc(&chbuf,CANNAHEADERSIZE);
    InitClientData(h);

    while((fd = ImSelect()) > 0){
	ch = chbuf.adr;
	rsz = ImRead(ch,CANNAHEADERSIZE);
	if(rsz <= 0){ //
	    LOG("disconnect fd %d\n",fd);
	    ImDisconnect();
	    CloseConnection(fd);
	    continue;
	}
	if(ch->Major > 0){
	    ch->Length = Swap2(ch->Length);
	    ch = ArAlloc(&chbuf,ch->Length);
	    ImRead(ch+1,ch->Length);
	}
	if( ((((unsigned)(ch->Minor))<<8)|ch->Major) == WIME_LOG ){
	    log_req((Req15_t*)ch);
	    continue;
	}
	//LOG("canna packet:major=0x%x minor=0x%x len=%d\n",ch->Major,ch->Minor,ch->Length);
	msg = WM_CANNA_PACKET+ch->Minor*256+ch->Major;
	SendMessage(h,msg,(WPARAM)ch,(LPARAM)fd);
    }
    ArDelete(&chbuf);
    LOG("EXIT\n");
    return 0;
}

/*
  imeѤΥߡɥ
 */
HWND NewWin(void)
{
    HWND h;

    h = CreateWindow(ClassName,"",WS_POPUP,0,0,0,0,NULL,NULL,NULL,NULL);
#ifndef SETCONTEXT_FAIL
    /*
      ImmCreateContext()ȤѴɥʤɤɽʤʤ(wine1.1.13)
      ImmCreateContext()ǤĤäimcImeSelect()ϤƤ롣
      ǥեȤǤϥåɤˣĤimcǳƥɥimcͭ뤿̤ʤ
      ŪimcĤꡢ̤imcȤ硢imc򥢥ƥ֤ˤʤʤ
      ImeSelect()ƤǤΤImmCreateContext()ImmDestroyContext()
      ImmCreateContext()ƤǤޤȸ᤹ȤǤʤ
      ʤ饭ܡɥե褿ȤˤΥɥimc򥢥ƥ֤ˤʤФʤ餺δؿImmSetActiveContext()ǤϤʤȻפwine1.1.13ǤϼƤʤ
      ʬδ֤뤴Ȥ˥ƥȤĤΤϤơХ륳ƥȤȤʤФʤʤ
    */
    HIMC imc = ImmCreateContext();
    ImmSetOpenStatus(imc,TRUE);
    ImmAssociateContext(h,imc);
#endif

    LOG("window handle %p, ime wnd %p\n",h,ImmGetDefaultIMEWnd(h));
    return h;
}

//ɥץΥХåؿơ֥
void init_cb(void)
{
    static WMCANNAPROTO wm_canna_tab0[]={
	wm_canna_init,		/*00*/		NULL,			/*01*/
	wm_canna_finalize,	/*02*/		wm_create_context,	/*03*/
	wm_dup_context,		/*04*/		wm_close_context,	/*05*/
	wm_get_dic_list,	/*06*/		wm_get_dir_list,	/*07*/
	wm_mount_dic,		/*08*/		wm_unmount_dic,		/*09*/
	wm_remount_dic,		/*0a*/		wm_mount_dic_list,	/*0b*/
	wm_query_dic,		/*0c*/		wm_define_word,		/*0d*/
	wm_delete_word,		/*0e*/		wm_begin_conv,		/*0f*/
	wm_end_conv,		/*10*/		wm_get_candi_list,	/*11*/
	wm_get_yomi,		/*12*/		wm_subst_yomi,		/*13*/
	wm_store_yomi,		/*14*/		wm_store_range,		/*15*/
	wm_get_last_yomi,	/*16*/		wm_flush_yomi,		/*17*/
	wm_remove_yomi,		/*18*/		wm_get_simple_kanji,	/*19*/
	wm_resize_pause,	/*1a*/		wm_get_hinshi,		/*1b*/
	wm_get_lex,		/*1c*/		wm_get_status,		/*1d*/
	wm_set_locale,		/*1e*/		wm_auto_conv,		/*1f*/
	wm_query_ext,		/*20*/		wm_set_app_name,	/*21*/
	wm_notice_group,	/*22*/		NULL,			/*23*/
	wm_kill_server		/*24*/
    };
    static WMCANNAPROTO wm_canna_tab1[]={
	NULL,			/*00*/		wm_get_server_info,	/*01*/
	wm_get_acl,		/*02*/		wm_create_dic,		/*03*/
	wm_delete_dic,		/*04*/		wm_rename_dic,		/*05*/
	wm_get_word_text_dic,	/*06*/		wm_list_dic,		/*07*/
	wm_sync,		/*08*/		wm_chmod_dic,		/*09*/
	wm_copy_dic,		/*0a*/

	//ɲ	pkt.hΥץȥֹ,cannaapi.cquery_ext()ѹ뤳
	wm_wime_dialog,
	wm_wime_set_comp_win,
	wm_wime_get_comp_win,
	wm_wime_send_key,
	wm_wime_enable_ime,
	wm_wime_move_shadow_win,
	wm_wime_set_comp_font,
	wm_wime_show_status_window,
	wm_wime_get_comp_str,
	wm_wime_set_cand_win,
	wm_wime_reg_x_window,
	wm_wime_get_result_str,
	wm_wime_set_result_str,
    };

    CanFunMax[0] = sizeof(wm_canna_tab0)/sizeof(wm_canna_tab0[0]);
    CanFunMax[1] = sizeof(wm_canna_tab1)/sizeof(wm_canna_tab1[0]);

    WmCannaTab[0] = wm_canna_tab0;
    WmCannaTab[1] = wm_canna_tab1;

}

int aux_input(HWND h)
{
    HIMC imc;
    CannaContext_t *cx;
    int16_t cxn;

    imc = ImmGetContext(h);
    cx = FindContext(h,&cxn);
    VERBOSE(MSG("context %hd, xid 0x%x\n",cxn,cx->XWin); DbgComp(imc,__func__));

    if(cx->XWin != 0) //ǰΤåƤ
	ImAuxInput(cx->XWin);
    ImmReleaseContext(h,imc);
    return 0;
}

//#define DEBUG
const char* dbg_wm_comp_msg(unsigned lp);
const char* dbg_wm_notify_msg(unsigned wp);
const char* msg_name(unsigned n);
void dbg_filter_msg(int bit,HWND wh,UINT msg,WPARAM wp,LPARAM lp);
void dbg_ime_msg(HWND wh,UINT msg,WPARAM wp,LPARAM lp);
#ifdef DEBUG
#define DBG_IME_MSG(a,b,c,d) dbg_ime_msg(a,b,c,d)
#define DBG_FILTER_MSG(a,b,c,d,e) dbg_filter_msg(a,b,c,d,e)
#else
#define DBG_IME_MSG(a,b,c,d)
#define DBG_FILTER_MSG(a,b,c,d,e)
#endif

//ɥץ
LRESULT CALLBACK wnd_proc(HWND wh,UINT msg,WPARAM wp,LPARAM lp)
{
    LRESULT r;
    CannaContext_t *cx;
    int16_t cxn;
    unsigned major,minor;
    WMCANNAPROTO func = NULL;

    DBG_IME_MSG(wh,msg,wp,lp);

    switch(msg){
    case WM_IME_COMPOSITION: //10f
	cx = FindContext(wh,&cxn);
	if(cx!=NULL && lp==(GCS_RESULTSTR|GCS_RESULTCLAUSE))
	    //ɤߤʤǷʸѥåȥġʤɤ
	    r = aux_input(wh);
	else if(cx!=NULL && (cx->Flags & PROC_COMP_MSG)!=0)
	    r = DefWindowProc(wh,msg,wp,lp);
        else
	    r = 0;
	break;
	DBG_FILTER_MSG(PROC_COMP_MSG,wh,msg,wp,lp);
    case WM_IME_NOTIFY: //282
	cx = FindContext(wh,&cxn);
	if(cx!=NULL && (cx->Flags & PROC_NOTIFY_MSG)!=0)
	    r = DefWindowProc(wh,msg,wp,lp);
	else
	    r = 0;
	DBG_FILTER_MSG(PROC_NOTIFY_MSG,wh,msg,wp,lp);
	break;
    case WM_CANNA_PACKET ... WM_CANNA_PACKET_END-1:
	minor = (msg-WM_CANNA_PACKET)/256;
	major = msg-(WM_CANNA_PACKET+minor*256);
	if(minor<2 && major<CanFunMax[minor])
	    func = WmCannaTab[minor][major];
	if(func != NULL)
	    r = (LRESULT)func((CanHeader*)wp,(int)lp);
	else{
	    MSG("*** ILLEGAL CANNA PROTOCOL:minor=0x%x major=0x%x\n",minor,major);
	    r = (LRESULT)true;
	}
    default:
	r = DefWindowProc(wh,msg,wp,lp);
    }
    return r;
}

void usage(int exit_code)
{
    printf("wime [options] [logfile]\n"
	   "  -s ime	specify ime\n"
	   "  -p num	socket number\n"
	   "  -v,-v-	verbose (on,off)\n"
	   "  --version	print version\n"
	   "  -h,--help	this message\n"

	);
    exit(exit_code);
}

void print_version(void)
{
    printf("%s\n",WIME_VERSION);
}

/*
  fn򥪡ץ󤷤LogFile˥åȤ
*/
void open_logfile(const char* fn,const char* mode)
{
    if(LogFile != stdout){
	fclose(LogFile);
	LogFile = stdout;
    }
    if(fn!=NULL && *fn!=0){
	if(strcmp(fn,"-")==0)
	    LogFile = stdout;
	else if((LogFile = fopen(fn,mode)) == NULL){
	    ERR("cannot open log file '%s'\n",fn);
	    LogFile = stdout;
	}
    }
}

//åȤΥץֹ֤
int cmdline_opt(int ac,char *av[])
{
    struct option longopt[]={
	{"help",	no_argument,NULL,'h'},
	{"version",	no_argument,NULL,'vsn'},
	{NULL,0,NULL,0}
    };
    int c,socket_num=0;
    
    while((c = getopt_long(ac,av,"hp:s:v::",longopt,NULL)) != -1){
	switch(c){
	case 'h':
	    usage(0);
	case 'p':
	    socket_num = atoi(optarg);
	    break;
	case 's':
	    if(!ime_sp(optarg)){
		ERR("not available ime '%s'\n",optarg);
		exit(1);
	    }
	    break;
	case 'v':
	    if(optarg==NULL)
		Verbose = 1;
	    else if(strcmp(optarg,"-")==0)
		Verbose = 0;
	    else
		usage(1);
	    break;
	case 'vsn':
	    print_version();
	    exit(0);
	default:
	    usage(1);
	}
    }
    open_logfile(LogFileName = av[optind],"w");
	
    return socket_num;
}

/*
  ꤷåid餽ֹ档ʤä-1
*/
int MsgLoopN(int n,...)
{
    va_list vl;
    UINT m0,ms[n];
    WPARAM w0,ws[n];
    MSG msg;
    int i;

    va_start(vl,n);
    for(i=0; i<n; ++i){
	ms[i] = va_arg(vl,UINT);
	ws[i] = va_arg(vl,WPARAM);
    }
    va_end(vl);

    i = -1;
    while(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)){
	m0 = msg.message;
	w0 = msg.wParam;
	if(GetMessage(&msg,NULL,0,0) > 0){
	    TranslateMessage(&msg);
	    DispatchMessage(&msg);
	    for(i=n; --i>=0;)
		if(m0==ms[i] && w0==ws[i])
		    goto exit_p;
	}
    }
exit_p:
    return i;
}

#ifdef DEBUG
void dbg_ime_msg(HWND wh,UINT msg,WPARAM wp,LPARAM lp)
{
    HIMC imc=ImmGetContext(wh);
    switch(msg){
    case WM_IME_STARTCOMPOSITION ... WM_IME_KEYLAST:
    case WM_IME_SETCONTEXT ... WM_IME_KEYUP:
	dbg_filter_msg(-1,wh,msg,wp,lp);
	DbgComp(imc,__func__);
	break;
    }
    ImmReleaseContext(wh,imc);
}

void dbg_filter_msg(int bit,HWND wh,UINT msg,WPARAM wp,LPARAM lp)
{
    char *s;
    int16_t cxn;
    CannaContext_t *cx = FindContext(wh,&cxn);
    if(cx!=NULL && (cx->Flags & bit)!=0)
	s = "pass to system";
    else
	s = "filtering";
    MSG("window %x context %hd:ime message:%s %s %x %x\n",(unsigned)wh,cxn,s,msg_name(msg),(unsigned)wp,(unsigned)lp);
    switch(msg){
    case WM_IME_NOTIFY:
	MSG("\twp=%s\n",dbg_wm_notify_msg(wp));
	break;
    case WM_IME_COMPOSITION:
	MSG("\tlp=%s\n",dbg_wm_comp_msg(lp));
    }
}

#define CASE_STR(x) case x:s=#x;break

const char* dbg_wm_notify_msg(unsigned wp)
{
    const char *s;
    switch(wp){
	CASE_STR(IMN_CLOSESTATUSWINDOW);
	CASE_STR(IMN_OPENSTATUSWINDOW);
	CASE_STR(IMN_CHANGECANDIDATE);
	CASE_STR(IMN_CLOSECANDIDATE);
	CASE_STR(IMN_OPENCANDIDATE);
	CASE_STR(IMN_SETCONVERSIONMODE);
	CASE_STR(IMN_SETSENTENCEMODE);
	CASE_STR(IMN_SETOPENSTATUS);
	CASE_STR(IMN_SETCANDIDATEPOS);
	CASE_STR(IMN_SETCOMPOSITIONFONT);
	CASE_STR(IMN_SETCOMPOSITIONWINDOW);
	CASE_STR(IMN_SETSTATUSWINDOWPOS);
	CASE_STR(IMN_GUIDELINE);
	CASE_STR(IMN_PRIVATE);
    default: s="unknown";
    }
    return s;
}

const char* dbg_wm_comp_msg(unsigned lp)
{
#define PAIR(x) {x,#x}
    struct{
	int mask;
	const char* str;
    } bits[]={
	PAIR(GCS_COMPREADSTR),
	PAIR(GCS_COMPREADATTR),
	PAIR(GCS_COMPREADCLAUSE),
	PAIR(GCS_COMPSTR),
	PAIR(GCS_COMPATTR),
	PAIR(GCS_COMPCLAUSE),
	PAIR(GCS_CURSORPOS),
	PAIR(GCS_DELTASTART),
	PAIR(GCS_RESULTREADSTR),
	PAIR(GCS_RESULTREADCLAUSE),
	PAIR(GCS_RESULTSTR),
	PAIR(GCS_RESULTCLAUSE)
    };
#undef PAIR
    static char buf[256];
    const char *sep="";
    buf[0]=0;
    for(unsigned n=0; n<ITEMS(bits); ++n){
	if((lp & bits[n].mask)){
	    strcat(strcat(buf,sep),bits[n].str);
	    lp &= ~bits[n].mask;
	    sep="|";
	}
    }
    if(lp!=0){
	strcat(strcat(buf,sep),"0x");
	sprintf(buf+strlen(buf),"%x",lp);
	strcat(buf,")");
    }
    return buf;
}

const char* msg_name(unsigned n)
{
    const char *s;
    switch(n){
	CASE_STR(WM_IME_SETCONTEXT);
	CASE_STR(WM_IME_COMPOSITION);
	CASE_STR(WM_IME_NOTIFY);
	CASE_STR(WM_IME_STARTCOMPOSITION);
	CASE_STR(WM_IME_ENDCOMPOSITION);
	CASE_STR(WM_IME_CONTROL);
	CASE_STR(WM_IME_COMPOSITIONFULL);
	CASE_STR(WM_IME_SELECT);
	CASE_STR(WM_IME_CHAR);
	CASE_STR(WM_IME_REQUEST);
	CASE_STR(WM_IME_KEYDOWN);
	CASE_STR(WM_IME_KEYUP);
    default: s="???";
    }
    return s;
}
#endif
