#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "array.h"

#define DEFAULT_WSPAGESIZE 128

Array* ArNew(Array* ws,int bs,void (*ct)(void*))
{
    ws->adr = NULL;
    ws->blocksize = bs;
    ws->use = ws->reserve = 0;
    ws->pagesize = DEFAULT_WSPAGESIZE;
    ws->constructor = ct;
    return ws;
}

Array* ArNewPs(Array* ws,int bs,void (*ct)(void*),int pagesize)
{
    ArNew(ws,bs,ct)->pagesize = pagesize;
    return ws;
}

Array* ArDelete(Array* ws)
{
    if(!ws->adr)
	free(ws->adr);
    return ArNew(ws,ws->blocksize,ws->constructor);
}

Array* ArClear(Array* ws)
{
    ws->use = 0;
    return ws;
}

/*
  nĳݤ롣
  ݤǡuseѹʤ
  ɲóݤconstructorƤФ롣
*/
Array* ArReserve(Array* ws,int count)
{
    if(count > ws->reserve){
	ws->adr = realloc(ws->adr,(ws->reserve=(count/ws->pagesize+1)*ws->pagesize)*ws->blocksize);
    }
    if(ws->constructor != NULL){
	int n;
	char *p;
	for(n=ws->use,p=ArElem(ws,n); n<ws->reserve; ++n,p+=ws->blocksize)
	    ws->constructor(p);
    }
    return ws;
}

//nĳݤ
//Ƭ֤
void* ArAlloc(Array* a,int n)
{
    ArReserve(a,n);
    a->use = n;
    return a->adr;
}

//nɲûѤ
//ʬƬ֤
void* ArExpand(Array* ws,int n)
{
    void *p;
    ArReserve(ws,ws->use+n);
    p = ArElem(ws,ws->use);
    ws->use += n;
    return p;
}

void* ArElem(const Array* ws,int n)
{
    return (char*)(ws->adr)+n*ws->blocksize;
}

//Ƥ*pǤΥǥå֤
//n=ϥǥå
int ArFind(const Array* ws,int n,const void* p)
{
    char* src;

    for(src=ArElem(ws,n); n<ws->use; src+=ws->blocksize,++n){
	if(memcmp(src,p,ws->blocksize) == 0)
	    break;
    }
    return n<ws->use ? n : -1;
}

Array* ArRemove(Array* ws,int pos)
{
    if(pos >= 0){
	char *ad = ArElem(ws,pos);
	memcpy(ad,ad+ws->blocksize,(ws->use-pos-1)*ws->blocksize);
	-- ws->use;
    }
    return ws;
}

//eq(val,ǥɥ쥹)ˤʤǤֹ֤
//ĤʤȤ-1֤
int ArFindIf(const Array* a,int start,int (*eq)(const void*,const void*),const void* val)
{
    int st=-1;
    for(char *ep=a->adr; start<a->use; ++start,ep+=a->blocksize)
	if(eq(val,ep)){
	    st = start;
	    break;
	}
    return st;
}

//eq(val,ǥɥ쥹)ˤʤǤΥɥ쥹֤
//ĤʤȤArExpandƤӽФ
void* ArFindElemIf(Array* a,int start,int (*eq)(const void*,const void*),const void* val)
{
    int n = ArFindIf(a,start,eq,val);
    return n<0 ? ArExpand(a,1) : ArElem(a,n);
}

/*
  func֤齪λ롣λȤֹ֤
*/
int ArForEach(Array* a,AR_FOREACH func,void* arg)
{
    int n;
    char* p = a->adr;
    for(n=0; n<a->use; ++n,p+=a->blocksize)
	if(!func(p,arg))
	    break;
    return n;
}

//nʸɲ
Array* ArAddN(Array* a,const void *p,int n)
{
    memcpy(ArExpand(a,n),p,n*a->blocksize);
    return a;
}

Array* ArAdd(Array* a,const void *p)
{
    return ArAddN(a,p,1);
}

Array* ArAdd1(Array* ws,char c)
{
    *(char*)ArExpand(ws,1) = c;
    return ws;
}

Array* ArAddAr(Array* a,const Array* b)
{
    memcpy(ArExpand(a,b->use),b->adr,b->use);
    return a;
}

//dst֤
Array* ArCopy(Array* dst,const Array* src)
{
    dst->reserve = (dst->reserve*dst->blocksize)/src->blocksize;
    dst->blocksize = src->blocksize;
    dst->pagesize = src->pagesize;
    dst->constructor = src->constructor;
    dst->use = 0;
    memcpy(ArAlloc(dst,src->use),src->adr,src->use*src->blocksize);
    return dst;
}

Array* ArInsert(Array* a,int pos,int count,const void* p)
{
    ArExpand(a,count);
    memmove(ArElem(a,pos+count),ArElem(a,pos),(a->use-pos)*a->blocksize);
    memcpy(ArElem(a,pos),p,count*a->blocksize);
    return a;
}

//pֹ֤
int ArIndex(Array* a,const void* p)
{
    return ((char*)p - (char*)a->adr)/a->blocksize;
}

//use򣱸餹
Array* ArDec(Array* a)
{
    if(-- a->use < 0)
	a->use = 0;
    return a;
}

/*
  aprintf롣
  aϥꥢ줺aκǸɲýϤ롣
  aΥ֥åϣˤ뤳ȡ
  useʸˤʤ롣̥ʸդ롣
*/
Array* ArPrintV(Array* a,const char* fmt,va_list vl)
{
    int w,fz;
    va_list ovl;

    va_copy(ovl,vl);
    fz = a->reserve - a->use; //Ƥ礭
    if((w = vsnprintf(ArElem(a,a->use),fz,fmt,vl)) >= fz){
	w -= fz; //­ʤ礭
	w = (w & (-128)) + (((w & 0x7f)!=0)<<7); //128ХȤڤ夲
	ArReserve(a,a->reserve+w);
	w = vsnprintf(ArElem(a,a->use),fz+w,fmt,ovl);
    }
    a->use += w;
    va_end(ovl);
    return a;
}
Array* ArPrint(Array* a,const char* fmt,...)
{
    va_list vl;

    va_start(vl,fmt);
    a = ArPrintV(a,fmt,vl);
    va_end(vl);
    return a;
}
