/*
  wimeΤlinux¦Ȥ̿
*/

#include <sys/select.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <libgen.h>
#include <stdlib.h>
#include <unistd.h>
#include <regex.h>
#include <X11/Xlib.h>
#include "array.h"
#include "wimeio.h"
#include "cannaapi.h"
#include "wimeapi.h"

static char DefaultSocketPath[] = "/tmp/.iroha_unix/IROHA";
char SocketPath[sizeof(DefaultSocketPath)+64];
Array CannaFds;
int ActiveFd;

/*
#ifndef SUN_LEN
#define SUN_LEN(n) (sizeof(n)-sizeof((n)->sun_path)+strlen((n)->sun_path))
#endif
*/

int mkdirp(const char *p)
{
    char *pp;
    int r=0;

    if(p[0]=='/' && p[1]==0)
	return 1;

    pp = strdup(p);
    if(mkdirp(dirname(pp))){
	r = (mkdir(p,0777)==0);
	if(r)
	    chmod(p,0777);
	else
	    if(errno==EEXIST)
		r=1;
    }
    free(pp);
    return r;
}

//ʸ̥ʸĤʤ
int GetLine(FILE* stream,Array* ws)
{
    int c;
    while(c=fgetc(stream),c!=EOF && c!='\n'){
	ArAdd(ws,&c);
    }
    return c!=EOF;
}

HinshiCor* ReadHinshiDef(char *fn)
{
    FILE *fp;
    Array ht,lb;
    char delim[]=" \t",*tok;
    HinshiCor hc,*tab;
    int linenum=0,bytesize;
    regex_t reg;

    ArNew(&ht,sizeof(HinshiCor),NULL);
    ArNew(&lb,1,NULL);
    if((fp = fopen(fn,"r")) == NULL){
	printf("can't open '%s'\n",fn);
	tab = NULL;
    }else{
	while(GetLine(fp,&lb)){
	    ArAdd1(&lb,0);
	    ++linenum;
	    if(lb.use==1 || *(char*)lb.adr=='#')
		continue; //Ԥȹ
	    hc.Wcode = strtoul(lb.adr,&tok,0);
	    if(lb.adr == tok){
		//ͰʳΤΤ񤫤Ƥ
		printf("%s:%d:hinshi file format error\n",fn,linenum);
		continue;
	    }
	    strtok(tok,delim); //ʻ̵̾
	    while((tok=strtok(NULL,delim)) != NULL){
		//ɽΥå
		if(regcomp(&reg,tok,REG_EXTENDED) == 0){
		    hc.Ccode = strdup(tok);
		    ArAdd(&ht,&hc);
		    regfree(&reg);
		}else{
		    printf("%s:%d:regex error\n",fn,linenum);
		}
	    }
	    ArClear(&lb);
	}
	fclose(fp);

	//λޡ
	hc.Ccode = NULL;
	ArAdd(&ht,&hc);

	bytesize = ht.use * ht.blocksize;
	tab = memcpy(malloc(bytesize),ht.adr,bytesize);
    }

    ArDelete(&ht);
    ArDelete(&lb);
    return tab;
}

//եɤ߹
void ImReadSetting(void* _gd)
{
    struct GlobalData_t* gd = (struct GlobalData_t*)_gd;
    char *home,*hinshifile;
    char hinshipath[]="/.wime/hinshi";

    home = getenv("HOME");
    hinshifile = malloc(strlen(home)+sizeof(hinshipath)+1);
    sprintf(hinshifile,"%s%s",home,hinshipath);
    gd->HinshiTab = ReadHinshiDef(hinshifile);
    free(hinshifile);
}

/*
  ХѿSocketPath˥åȤΥѥ򥻥åȤ
  SocketPath֤
*/
const char* MakeSocketPath(int socket_num)
{
    char buf[6]; //16bitʤ65535

    strcpy(SocketPath,DefaultSocketPath);
    if(socket_num > 0){
	sprintf(buf,":%u",socket_num&0xffff);
	strcat(SocketPath,buf);
    }
    return SocketPath;
}

//errno֤롣顼ʤУ
//socket_num=pץο
int ImInit(unsigned socket_num)
{
    struct sockaddr_un sock_name;
    char *sock_path_cp;
    int cannasocket;

    errno=0;

    MakeSocketPath(socket_num);
    mkdirp(dirname(sock_path_cp = strdup(SocketPath)));
    free(sock_path_cp);

    if((cannasocket = socket(AF_UNIX,SOCK_STREAM,0)) == -1){
	perror(__FUNCTION__);
	return errno;
    }

    sock_name.sun_family = AF_UNIX;
    strcpy(sock_name.sun_path,SocketPath);
    if(bind(cannasocket,(struct sockaddr*)&sock_name,SUN_LEN(&sock_name)) != 0){
	perror(__FUNCTION__);
	close(cannasocket);
	return errno;
    }
    chmod(SocketPath,0777);

    if(listen(cannasocket,SOMAXCONN) < 0){
	perror(__FUNCTION__);
	close(cannasocket);
    }

    ArNew(&CannaFds,sizeof(int),NULL);
    ArAdd(&CannaFds,&cannasocket);
    return 0;
}

//äեǥץ֤
int ImSelect(void)
{
    int n,fd,maxfd,cont_loop;
    fd_set rs;

    if(CannaFds.use == 0) //ʤ齪λ
	return 0;

    do{
	FD_ZERO(&rs);
	maxfd = cont_loop = 0;
	for(n=0; n<ArUsing(&CannaFds); ++n){
	    fd = *(int*)ArElem(&CannaFds,n);
	    FD_SET(fd,&rs);
	    if(fd > maxfd)
		maxfd = fd;
	}
	if(select(maxfd+1,&rs,NULL,NULL,NULL) <= 0){
	    perror(__FUNCTION__);
	    return 0;
	}
	fd = *(int*)ArElem(&CannaFds,0); //Ƭ=åȢ³׵
	if(FD_ISSET(fd,&rs)){
	    if((fd = accept(fd,NULL,NULL)) < 0){
		perror(__FUNCTION__);
		return 0;
	    }
	    ArAdd(&CannaFds,&fd);
	    cont_loop = 1;
	}
    }while(cont_loop);

    ActiveFd = 0;
    for(n=0; n<ArUsing(&CannaFds); ++n){
	fd = *(int*)ArElem(&CannaFds,n);
	if(FD_ISSET(fd,&rs)){
	    ActiveFd = fd; //ΤäfdActiveFd
	    break;
	}
    }
    return ActiveFd;
}

int ImRead(void *buf,int len)
{
    return (int)read(ActiveFd,buf,len);
}

//len񤭹ޤ줿1֤
bool ImWrite(const void *buf,int len)
{
    return write(ActiveFd,buf,len)==(ssize_t)len;
}

int ImDisconnect(void)
{
    close(ActiveFd);
    ArRemove(&CannaFds,ArFind(&CannaFds,0,&ActiveFd));
    return ActiveFd;
}

int ImCloseAll(void)
{
    for(int n=0; n<CannaFds.use; ++n){
	close(*(int*)ArElem(&CannaFds,n));
    }
    ArDelete(&CannaFds);
    unlink(SocketPath);
    return 1;
}

Display *Disp;
void ImAuxInput(unsigned xw)
{
    XKeyPressedEvent ev;

    if(Disp == NULL){
	Disp = XOpenDisplay(NULL);
    }

    ev.type = KeyPress;
    ev.display = Disp;
    ev.root = XDefaultRootWindow(Disp);
    ev.window = xw;
    ev.subwindow = None;
    ev.time = CurrentTime;
    //ev.x = ev.y = 1; //ev.x_root = ev.y_root = 1;
    ev.same_screen = true;
    ev.state = AUX_INPUT_MOD;
    ev.keycode = 8;
    XSetInputFocus(Disp,xw,RevertToNone,CurrentTime); //ximǤɬ
    XSendEvent(Disp,xw,true,KeyPressMask,(XEvent*)&ev);
    XFlush(Disp);
}

__attribute__((destructor))
void close_disp()
{
    if(Disp != NULL)
	XCloseDisplay(Disp);
}
