#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>
#include "wimeapi.h"
#include "array.h"

const char VERSION[]="1.0.2";

void usage()
{
    printf("wimectrl [option]\n"
	   "  -k	kill wime\n"
	   "  -p <num>	socket path number\n"
	   "  -s	IME setting(default)\n"
	   "  -r	register word\n"
	   "  -d	user dictionary\n"
	   "  -v	version\n"
	   "  -h	this message\n"
/*
	   "  -t <wime context>\n"
	   "		send text to context\n"
	   "  -W	follow options use wime(default)\n"
	   "  -X	follow options use wimexim\n"
	   "  -G	follow options use wimegim\n"
*/
	);
}

int main(int ac,char *av[])
{
    bool st;
    int c;
    int mode=1; //>0:⡼+1,0=λ,-1=kill-server
    int socket_num=0;
    int cxn=0;

    while((c = getopt(ac,av,"ksrdvhp:t:")) != -1){
	switch(c){
	case 's':
	    mode = 1;
	    break;
	case 'r':
	    mode = 2;
	    break;
	case 'd':
	    mode = 3;
	    break;
	case 'v':
	    printf("%s\n",VERSION);
	    st = true;
	    mode = 0;
	    break;
	case 'k':
	    mode = -1;
	    break;
	case 'p':
	    socket_num = atoi(optarg);
	    break;
	case 't':
	    cxn = strtol(optarg,NULL,0);
	    mode = 0;
	    break;
	default:
	    usage();
	    st = (c=='h');
	    mode = 0;
	}
    }
    WimeInitialize(socket_num,LOGMARK);
    if(mode != 0){
	st = mode>0 ? WimeOpenIMEDialog(mode-1) : WimeKillServer();
    }else if(cxn != 0){
	Array str;
	char buf[16];
	unsigned sz;

	ArNew(&str,1,NULL);
	*(char*)ArExpand(&str,1)=0;
	do{
	    sz = strlen(fgets(buf,sizeof(buf),stdin));
	    ArExpand(&str,sz);
	    strcat(ArAdr(&str),buf);
	}while(sz == sizeof(buf)-1);
	st = WimeSetResultStr(-cxn,ArAdr(&str));
    }
    WimeFinalize();
    return st ? 0 : 1;
}
