/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.text.Collator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.IndexMark;
import writer2latex.office.ListCounter;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TocReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xhtml.AlphabeticalEntry;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.IndexData;
import writer2latex.xhtml.ParStyleConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TocEntry;
import writer2latex.xhtml.XhtmlStyleMap;

public class TextConverter
extends ConverterHelper {
    int nSplit = 0;
    private int nDontSplitLevel = 0;
    protected Stack sections = new Stack();
    Element[] currentHeading = new Element[7];
    private ListCounter outlineNumbering;
    private Hashtable listCounters = new Hashtable();
    private String sCurrentListLabel = null;
    private int nFloatMode;
    private Vector indexes = new Vector();
    Vector index = new Vector();
    private int nIndexIndex = -1;
    private int nAlphabeticalIndex = -1;
    private Vector tocEntries = new Vector();
    private int nTocFileIndex = -1;
    private Element currentChapter = null;
    private int nTocIndex = -1;
    private String sFntCitBodyStyle = null;
    private String sFntCitStyle = null;
    private String sEntCitBodyStyle = null;
    private String sEntCitStyle = null;
    private LinkedList footnotes = new LinkedList();
    private LinkedList endnotes = new LinkedList();
    private Node asapNode = null;
    private boolean bInToc = false;

    public TextConverter(OfficeReader ofr, Config config, Converter converter) {
        super(ofr, config, converter);
        this.nSplit = config.getXhtmlSplitLevel();
        this.nFloatMode = ofr.isText() && config.xhtmlFloatObjects() ? 1 : 2;
        this.outlineNumbering = new ListCounter(ofr.getOutlineStyle());
        PropertySet notes = ofr.getFootnotesConfiguration();
        if (notes != null) {
            this.sFntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sFntCitStyle = notes.getProperty("text:citation-style-name");
        }
        if ((notes = ofr.getEndnotesConfiguration()) != null) {
            this.sEntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sEntCitStyle = notes.getProperty("text:citation-style-name");
        }
    }

    public void convertTextContent(Element onode) {
        Element form;
        Element hnode = this.converter.nextOutFile();
        if (this.nSplit == 0 && (form = this.getDrawCv().createForm()) != null) {
            hnode.appendChild(form);
            hnode = form;
        }
        this.traverseBlockText(onode, hnode);
        int nIndexCount = this.indexes.size();
        int i = 0;
        while (i < nIndexCount) {
            this.generateToc((IndexData)this.indexes.get(i));
            ++i;
        }
    }

    protected int getTocIndex() {
        return this.nTocFileIndex;
    }

    protected int getAlphabeticalIndex() {
        return this.nAlphabeticalIndex;
    }

    public Node traverseBlockText(Node onode, Node hnode) {
        return this.traverseBlockText(onode, 0, null, hnode);
    }

    private Node traverseBlockText(Node onode, int nLevel, String styleName, Node hnode) {
        if (!onode.hasChildNodes()) {
            return hnode;
        }
        boolean bAfterHeading = false;
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (!nodeName.equals("text:section")) {
                    ++this.nDontSplitLevel;
                }
                if (OfficeReader.isDrawElement(child)) {
                    this.getDrawCv().handleDrawElement((Element)child, (Element)hnode, null, this.nFloatMode);
                } else if (nodeName.equals("text:p")) {
                    XhtmlStyleMap xpar = this.config.getXParStyleMap();
                    String sDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(child, "text:style-name"));
                    if (sDisplayName != null && xpar.contains(sDisplayName)) {
                        Node curHnode = hnode;
                        String sBlockElement = xpar.getBlockElement(sDisplayName);
                        String sBlockCss = xpar.getBlockCss(sDisplayName);
                        if (xpar.getBlockElement(sDisplayName).length() > 0) {
                            Element block = this.converter.createElement(xpar.getBlockElement(sDisplayName));
                            if (!"(none)".equals(xpar.getBlockCss(sDisplayName))) {
                                block.setAttribute("class", xpar.getBlockCss(sDisplayName));
                            }
                            hnode.appendChild(block);
                            curHnode = block;
                        }
                        boolean bMoreParagraphs = true;
                        do {
                            String sCurDisplayName;
                            String cnodeName;
                            this.handleParagraph(child, curHnode);
                            bMoreParagraphs = false;
                            if (++i >= nLen || !(cnodeName = (child = nList.item(i)).getNodeName()).equals("text:p") || (sCurDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(child, "text:style-name"))) == null || !xpar.contains(sCurDisplayName) || !sBlockElement.equals(xpar.getBlockElement(sCurDisplayName)) || !sBlockCss.equals(xpar.getBlockCss(sCurDisplayName))) continue;
                            bMoreParagraphs = true;
                        } while (bMoreParagraphs);
                        --i;
                    } else {
                        this.handleParagraph(child, hnode);
                    }
                } else if (nodeName.equals("text:h")) {
                    int nOutlineLevel = this.ofr.isOpenDocument() ? Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 1) : Misc.getPosInteger(Misc.getAttribute(child, "text:level"), 1);
                    Node rememberNode = hnode;
                    hnode = this.maybeSplit(hnode, nOutlineLevel, bAfterHeading);
                    this.handleHeading(child, hnode, rememberNode != hnode);
                } else if (nodeName.equals("text:list")) {
                    this.handleList(child, nLevel + 1, styleName, hnode);
                } else if (nodeName.equals("text:unordered-list")) {
                    this.handleList(child, nLevel + 1, styleName, hnode);
                } else if (nodeName.equals("text:ordered-list")) {
                    this.handleList(child, nLevel + 1, styleName, hnode);
                } else if (nodeName.equals("table:table")) {
                    this.getTableCv().handleTable(child, hnode);
                } else if (nodeName.equals("table:sub-table")) {
                    this.getTableCv().handleTable(child, hnode);
                } else if (nodeName.equals("text:section")) {
                    hnode = this.handleSection(child, hnode);
                } else if (nodeName.equals("text:table-of-content")) {
                    if (!this.ofr.getTocReader((Element)child).isByChapter()) {
                        hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    }
                    this.handleTOC(child, hnode);
                } else if (nodeName.equals("text:illustration-index")) {
                    this.handleLOF(child, hnode);
                } else if (nodeName.equals("text:table-index")) {
                    this.handleLOT(child, hnode);
                } else if (nodeName.equals("text:object-index")) {
                    this.handleObjectIndex(child, hnode);
                } else if (nodeName.equals("text:user-index")) {
                    this.handleUserIndex(child, hnode);
                } else if (nodeName.equals("text:alphabetical-index")) {
                    hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    this.handleAlphabeticalIndex(child, hnode);
                } else if (nodeName.equals("text:bibliography")) {
                    hnode = this.maybeSplit(hnode, 1, bAfterHeading);
                    this.handleBibliography(child, hnode);
                } else if (nodeName.equals("text:sequence-decls")) {
                    // empty if block
                }
                if (!nodeName.equals("text:section")) {
                    --this.nDontSplitLevel;
                }
                bAfterHeading = nodeName.equals("text:h");
            }
            ++i;
        }
        return hnode;
    }

    private Node maybeSplit(Node node, int nLevel, boolean bAfterHeading) {
        if (bAfterHeading || this.nDontSplitLevel > 1) {
            return node;
        }
        if (this.nSplit >= nLevel && this.converter.outFileHasContent()) {
            return this.converter.nextOutFile();
        }
        return node;
    }

    private Node handleSection(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        this.converter.addTarget(div, sName + "%7Cregion");
        StyleInfo sectionInfo = new StyleInfo();
        this.getSectionSc().applyStyle(sStyleName, sectionInfo);
        this.applyStyle(sectionInfo, div);
        this.sections.push(onode);
        Node newhnode = this.traverseBlockText(onode, div);
        this.sections.pop();
        return newhnode.getParentNode();
    }

    private void handleHeading(Node onode, Node hnode, boolean bAfterSplit) {
        int nLevel;
        int n = nLevel = this.ofr.isOpenDocument() ? Misc.getPosInteger(Misc.getAttribute(onode, "text:outline-level"), 1) : Misc.getPosInteger(Misc.getAttribute(onode, "text:level"), 1);
        if (nLevel <= 6) {
            if (nLevel == 1) {
                this.currentChapter = (Element)onode;
            }
            if (bAfterSplit && this.nSplit > 0) {
                int i = 0;
                while (i < nLevel) {
                    if (this.currentHeading[i] != null) {
                        hnode.appendChild(this.converter.importNode(this.currentHeading[i], true));
                    }
                    ++i;
                }
            }
            Element heading = this.converter.createElement("h" + nLevel);
            this.traverseFloats(onode, hnode, heading);
            hnode.appendChild(heading);
            String sStyleName = Misc.getAttribute(onode, "text:style-name");
            StyleWithProperties style = this.ofr.getParStyle(sStyleName);
            if (style != null) {
                StyleInfo headInfo = new StyleInfo();
                this.getParSc();
                ParStyleConverter.applyDirection(style, headInfo);
                this.getParSc().applyStyle(headInfo, heading);
            }
            this.getParSc().setHeadingStyle(nLevel, sStyleName);
            this.prependAsapNode(heading);
            Element span = this.converter.createElement("span");
            span.setAttribute("class", "SectionNumber");
            heading.appendChild(span);
            span.appendChild(this.converter.createTextNode(this.outlineNumbering.step(nLevel).getLabel()));
            if (!this.bInToc) {
                this.converter.addTarget(heading, "toc" + ++this.nTocIndex);
                TocEntry entry = new TocEntry();
                entry.onode = (Element)onode;
                entry.sLabel = this.outlineNumbering.getLabel();
                this.tocEntries.add(entry);
            }
            this.traverseInlineText(onode, heading);
            this.currentHeading[nLevel] = heading;
            int i = nLevel + 1;
            while (i <= 6) {
                this.currentHeading[i] = null;
                ++i;
            }
        } else {
            this.handleParagraph(onode, hnode);
        }
    }

    private void handleParagraph(Node onode, Node hnode) {
        Element par;
        if (this.config.ignoreEmptyParagraphs()) {
            if (OfficeReader.isWhitespaceContent(onode)) {
                return;
            }
        }
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        if (this.ofr.isSpreadsheet()) {
            par = (Element)hnode;
        } else {
            Element temp = this.converter.createElement("temp");
            par = this.createParagraph(temp, sStyleName);
            this.prependAsapNode(par);
            this.traverseFloats(onode, hnode, par);
            hnode.appendChild(temp.getFirstChild());
        }
        if (this.ofr.isIndexSourceStyle(this.getParSc().getRealParStyleName(sStyleName))) {
            this.converter.addTarget(par, "toc" + ++this.nTocIndex);
            TocEntry entry = new TocEntry();
            entry.onode = (Element)onode;
            entry.sLabel = this.sCurrentListLabel;
            this.tocEntries.add(entry);
        }
        this.sCurrentListLabel = null;
        if (onode.hasChildNodes()) {
            par = this.createTextBackground(par, sStyleName);
            this.traverseInlineText(onode, par);
        }
    }

    private void prependAsapNode(Node node) {
        if (this.asapNode != null) {
            if (this.asapNode.getOwnerDocument() != node.getOwnerDocument()) {
                this.asapNode = this.converter.importNode(this.asapNode, true);
            }
            node.appendChild(this.asapNode);
            this.asapNode = null;
        }
    }

    private boolean hasItems(Node onode) {
        Node child = onode.getFirstChild();
        while (child != null) {
            if (Misc.isElement(child, "text:list-item") || Misc.isElement(child, "text:list-header")) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private void handleOL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ol");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleUL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ul");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleList(Node onode, int nLevel, String sStyleName, Node hnode) {
        ListStyle style;
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        if ((style = this.ofr.getListStyle(sStyleName)) != null && style.isNumber(nLevel)) {
            this.handleOL(onode, nLevel, sStyleName, hnode);
        } else {
            this.handleUL(onode, nLevel, sStyleName, hnode);
        }
    }

    private void traverseList(Node onode, int nLevel, String styleName, Element hnode) {
        ListCounter counter = null;
        if (styleName != null) {
            if (this.listCounters.containsKey(styleName)) {
                counter = (ListCounter)this.listCounters.get(styleName);
            } else {
                ListStyle style = this.ofr.getListStyle(styleName);
                if (style != null) {
                    counter = new ListCounter(style);
                    this.listCounters.put(styleName, counter);
                }
            }
        }
        if (counter != null) {
            boolean bContinueNumbering = "true".equals(Misc.getAttribute(onode, "text:continue-numbering"));
            if (bContinueNumbering) {
                if (this.config.xhtmlUseListHack()) {
                    hnode.setAttribute("start", Integer.toString(counter.getValue(nLevel) + 1));
                }
            } else if (counter != null) {
                counter.restart(nLevel);
            }
        }
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:list-item")) {
                        boolean bIsImmediateNestedList = false;
                        Element child1 = Misc.getFirstChildElement(child);
                        if (child1.getTagName().equals("text:ordered-list") || child1.getTagName().equals("text:unordered-list") || child1.getTagName().equals("text:list")) {
                            bIsImmediateNestedList = true;
                        }
                        if (this.config.xhtmlUseListHack() && bIsImmediateNestedList) {
                            this.traverseListItem(child, nLevel, styleName, hnode);
                        } else {
                            this.sCurrentListLabel = counter.step(nLevel).getLabel();
                            Element item = this.converter.createElement("li");
                            StyleInfo info = new StyleInfo();
                            this.getPresentationSc().applyOutlineStyle(nLevel, info);
                            this.applyStyle(info, item);
                            hnode.appendChild(item);
                            if (this.config.xhtmlUseListHack()) {
                                boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                                int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                                if (bRestart) {
                                    item.setAttribute("value", Integer.toString(nStartValue));
                                    if (counter != null) {
                                        this.sCurrentListLabel = counter.restart(nLevel, nStartValue).getLabel();
                                    }
                                }
                            }
                            this.traverseListItem(child, nLevel, styleName, item);
                        }
                    }
                    if (nodeName.equals("text:list-header")) {
                        Element item = this.converter.createElement("li");
                        hnode.appendChild(item);
                        item.setAttribute("style", "list-style-type:none");
                        this.traverseListItem(child, nLevel, styleName, item);
                    }
                }
                ++i;
            }
        }
    }

    private void traverseListItem(Node onode, int nLevel, String styleName, Node hnode) {
        if (this.config.xhtmlFormatting() != 4 && onode.hasChildNodes()) {
            NodeList list = onode.getChildNodes();
            int nLen = list.getLength();
            int nParCount = 0;
            boolean bNoPTag = true;
            int i = 0;
            while (i < nLen) {
                if (list.item(i).getNodeType() == 1) {
                    if (list.item(i).getNodeName().equals("text:p")) {
                        ++nParCount;
                        if (bNoPTag) {
                            String sDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(list.item(0), "text:style-name"));
                            if (this.config.getXParStyleMap().contains(sDisplayName)) {
                                bNoPTag = false;
                            }
                        }
                    } else {
                        bNoPTag = false;
                    }
                }
                ++i;
            }
            if (bNoPTag && nParCount <= 1) {
                int i2 = 0;
                while (i2 < nLen) {
                    Node child = list.item(i2);
                    if (child.getNodeType() == 1) {
                        String nodeName = child.getNodeName();
                        if (nodeName.equals("text:p")) {
                            this.traverseInlineText(child, hnode);
                        }
                        if (nodeName.equals("text:list")) {
                            this.handleList(child, nLevel + 1, styleName, hnode);
                        }
                        if (nodeName.equals("text:ordered-list")) {
                            this.handleOL(child, nLevel + 1, styleName, hnode);
                        }
                        if (nodeName.equals("text:unordered-list")) {
                            this.handleUL(child, nLevel + 1, styleName, hnode);
                        }
                    }
                    ++i2;
                }
                return;
            }
        }
        this.traverseBlockText(onode, nLevel, styleName, hnode);
    }

    private void handleTOC(Node onode, Node hnode) {
        if (!this.ofr.getTocReader((Element)onode).isByChapter()) {
            this.nTocFileIndex = this.converter.getOutFileIndex();
        }
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        IndexData data = new IndexData();
        data.nOutFileIndex = this.converter.getOutFileIndex();
        data.onode = (Element)onode;
        data.chapter = this.currentChapter;
        data.hnode = div;
        this.indexes.add(data);
    }

    private void generateToc(IndexData data) {
        TocEntry entry;
        int i;
        Element title;
        Element onode = data.onode;
        Element chapter = data.chapter;
        Element div = data.hnode;
        int nSaveOutFileIndex = this.converter.getOutFileIndex();
        this.converter.changeOutFile(data.nOutFileIndex);
        this.bInToc = true;
        TocReader tocReader = this.ofr.getTocReader(onode);
        StyleInfo sectionInfo = new StyleInfo();
        this.getSectionSc().applyStyle(tocReader.getStyleName(), sectionInfo);
        this.applyStyle(sectionInfo, div);
        if (tocReader.getName() != null) {
            this.converter.addTarget(div, tocReader.getName());
        }
        if ((title = tocReader.getIndexTitleTemplate()) != null) {
            String sStyleName = Misc.getAttribute(title, "text:style-name");
            Element p = this.createParagraph(div, sStyleName);
            this.traversePCDATA(title, p);
        }
        String[] sEntryStyleName = new String[11];
        int i2 = 1;
        while (i2 <= 10) {
            Element entryTemplate = tocReader.getTocEntryTemplate(i2);
            if (entryTemplate != null) {
                sEntryStyleName[i2] = Misc.getAttribute(entryTemplate, "text:style-name");
            }
            ++i2;
        }
        int nStart = 0;
        int nLen = this.tocEntries.size();
        if (tocReader.isByChapter() && chapter != null) {
            i = 0;
            while (i < nLen) {
                entry = (TocEntry)this.tocEntries.get(i);
                if (entry.onode == chapter) {
                    nStart = i;
                    break;
                }
                ++i;
            }
        }
        i = nStart;
        while (i < nLen) {
            Element a;
            Element p;
            Element a2;
            entry = (TocEntry)this.tocEntries.get(i);
            String sNodeName = entry.onode.getTagName();
            if ("text:h".equals(sNodeName)) {
                int nLevel;
                int n = nLevel = this.ofr.isOpenDocument() ? Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1) : Misc.getPosInteger(entry.onode.getAttribute("text:level"), 1);
                if (nLevel == 1 && tocReader.isByChapter() && entry.onode != chapter) break;
                if (tocReader.useOutlineLevel() && nLevel <= tocReader.getOutlineLevel()) {
                    Element p2 = this.createParagraph(div, sEntryStyleName[nLevel]);
                    if (entry.sLabel != null) {
                        Element span = this.converter.createElement("span");
                        p2.appendChild(span);
                        span.setAttribute("class", "SectionNumber");
                        span.appendChild(this.converter.createTextNode(entry.sLabel));
                    }
                    a2 = this.converter.createLink("toc" + i);
                    p2.appendChild(a2);
                    this.traverseInlineText(entry.onode, a2);
                } else {
                    String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                    nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                    if (tocReader.useIndexSourceStyles() && 1 <= nLevel && nLevel <= tocReader.getOutlineLevel()) {
                        p = this.createParagraph(div, sEntryStyleName[nLevel]);
                        if (entry.sLabel != null) {
                            p.appendChild(this.converter.createTextNode(entry.sLabel));
                        }
                        a = this.converter.createLink("toc" + i);
                        p.appendChild(a);
                        this.traverseInlineText(entry.onode, a);
                    }
                }
            } else if ("text:p".equals(sNodeName)) {
                String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                int nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                if (tocReader.useIndexSourceStyles() && 1 <= nLevel && nLevel <= tocReader.getOutlineLevel()) {
                    p = this.createParagraph(div, sEntryStyleName[nLevel]);
                    if (entry.sLabel != null) {
                        p.appendChild(this.converter.createTextNode(entry.sLabel));
                    }
                    a = this.converter.createLink("toc" + i);
                    p.appendChild(a);
                    this.traverseInlineText(entry.onode, a);
                }
            } else if ("text:toc-mark".equals(sNodeName)) {
                int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
                if (tocReader.useIndexMarks() && nLevel <= tocReader.getOutlineLevel()) {
                    Element p3 = this.createParagraph(div, sEntryStyleName[nLevel]);
                    a2 = this.converter.createLink("toc" + i);
                    p3.appendChild(a2);
                    a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
                }
            } else if ("text:toc-mark-start".equals(sNodeName)) {
                int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
                if (tocReader.useIndexMarks() && nLevel <= tocReader.getOutlineLevel()) {
                    Element p4 = this.createParagraph(div, sEntryStyleName[nLevel]);
                    a2 = this.converter.createLink("toc" + i);
                    p4.appendChild(a2);
                    a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
                }
            }
            ++i;
        }
        this.bInToc = false;
        this.converter.changeOutFile(nSaveOutFileIndex);
    }

    private void handleLOF(Node onode, Node hnode) {
    }

    private void handleLOT(Node onode, Node hnode) {
    }

    private void handleObjectIndex(Node onode, Node hnode) {
    }

    private void handleUserIndex(Node onode, Node hnode) {
    }

    private void handleAlphabeticalIndex(Node onode, Node hnode) {
        this.nAlphabeticalIndex = this.converter.getOutFileIndex();
        Element source = Misc.getChildByTagName(onode, "text:alphabetical-index-source");
        if (source != null) {
            Collator collator;
            String sLanguage;
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "alphabeticalindex");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(source, "text:index-title-template");
            if (title != null) {
                String sStyleName = Misc.getAttribute((Node)title, "text:style-name");
                Element p = this.createParagraph(div, sStyleName);
                this.traversePCDATA(title, p);
            }
            String sEntryStyleName = null;
            if (source.hasChildNodes()) {
                NodeList nl = source.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    int nLevel;
                    Node child = nl.item(i);
                    if (child.getNodeType() == 1 && child.getNodeName().equals("text:alphabetical-index-entry-template") && (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 1)) == 1) {
                        sEntryStyleName = Misc.getAttribute(child, "text:style-name");
                    }
                    ++i;
                }
            }
            if ((sLanguage = Misc.getAttribute((Node)source, "fo:language")) == null) {
                collator = Collator.getInstance();
            } else {
                String sCountry = Misc.getAttribute((Node)source, "fo:country");
                if (sCountry == null) {
                    sCountry = "";
                }
                collator = Collator.getInstance(new Locale(sLanguage, sCountry));
            }
            int i = 0;
            while (i <= this.nIndexIndex) {
                int j = i + 1;
                while (j <= this.nIndexIndex) {
                    AlphabeticalEntry entryi = (AlphabeticalEntry)this.index.get(i);
                    AlphabeticalEntry entryj = (AlphabeticalEntry)this.index.get(j);
                    if (collator.compare(entryi.sWord, entryj.sWord) > 0) {
                        this.index.set(i, entryj);
                        this.index.set(j, entryi);
                    }
                    ++j;
                }
                ++i;
            }
            Element table = this.converter.createElement("table");
            table.setAttribute("style", "width:100%");
            div.appendChild(table);
            Element tr = this.converter.createElement("tr");
            table.appendChild(tr);
            Element[] td = new Element[4];
            int i2 = 0;
            while (i2 < 4) {
                td[i2] = this.converter.createElement("td");
                td[i2].setAttribute("style", "vertical-align:top");
                tr.appendChild(td[i2]);
                ++i2;
            }
            int nColEntries = this.nIndexIndex / 4 + 1;
            int nColIndex = -1;
            int i3 = 0;
            while (i3 <= this.nIndexIndex) {
                if (i3 % nColEntries == 0) {
                    ++nColIndex;
                }
                AlphabeticalEntry entry = (AlphabeticalEntry)this.index.get(i3);
                Element p = this.createParagraph(td[nColIndex], sEntryStyleName);
                Element a = this.converter.createLink("idx" + entry.nIndex);
                p.appendChild(a);
                a.appendChild(this.converter.createTextNode(entry.sWord));
                ++i3;
            }
        }
    }

    private void handleBibliography(Node onode, Node hnode) {
        Element body = Misc.getChildByTagName(onode, "text:index-body");
        if (body != null) {
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "bibliography");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(body, "text:index-title");
            if (title != null) {
                this.traverseBlockText(title, div);
            }
            this.traverseBlockText(body, div);
        }
    }

    private void traverseFloats(Node onode, Node hnodeBlock, Node hnodeInline) {
        Node child = onode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element elm = (Element)child;
                String sTag = elm.getTagName();
                if (OfficeReader.isDrawElement(elm)) {
                    elm = this.getDrawCv().getRealDrawElement(elm);
                    if (elm != null) {
                        String sAnchor = elm.getAttribute("text:anchor-type");
                        if (!"as-char".equals(sAnchor)) {
                            this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, this.nFloatMode);
                        } else if ("draw:text-box".equals(sTag)) {
                            this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, 0);
                        }
                    }
                } else if (OfficeReader.isTextElement(elm)) {
                    if (!OfficeReader.isNoteElement(elm)) {
                        this.traverseFloats(elm, hnodeBlock, hnodeInline);
                    }
                }
            }
            child = child.getNextSibling();
        }
    }

    private void traverseInlineText(Node onode, Node hnode) {
        String styleName = Misc.getAttribute(onode, "text:style-name");
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int nLen = nList.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = child.getNodeValue();
                        if (s.length() <= 0) break;
                        hnode.appendChild(this.converter.createTextNode(s));
                        break;
                    }
                    case 1: {
                        String sName = child.getNodeName();
                        if (OfficeReader.isDrawElement(child)) {
                            String sAnchor;
                            Element elm = this.getDrawCv().getRealDrawElement((Element)child);
                            if (elm == null || !"as-char".equals(sAnchor = elm.getAttribute("text:anchor-type"))) break;
                            this.getDrawCv().handleDrawElement(elm, null, (Element)hnode, 0);
                            break;
                        }
                        if (child.getNodeName().equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                hnode.appendChild(this.converter.createTextNode(" "));
                                break;
                            }
                            int count = Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1);
                            while (count > 0) {
                                hnode.appendChild(this.converter.createTextNode("\u00a0"));
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop")) {
                            this.handleTabStop(child, hnode);
                            break;
                        }
                        if (sName.equals("text:tab")) {
                            this.handleTabStop(child, hnode);
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (this.config.ignoreHardLineBreaks()) break;
                            hnode.appendChild(this.converter.createElement("br"));
                            break;
                        }
                        if (sName.equals("text:span")) {
                            this.handleSpan(child, hnode);
                            break;
                        }
                        if (sName.equals("text:a")) {
                            this.handleAnchor(child, hnode);
                            break;
                        }
                        if (sName.equals("text:footnote")) {
                            this.handleFootnote(child, hnode);
                            break;
                        }
                        if (sName.equals("text:endnote")) {
                            this.handleEndnote(child, hnode);
                            break;
                        }
                        if (sName.equals("text:note")) {
                            if ("endnote".equals(Misc.getAttribute(child, "text:note-class"))) {
                                this.handleEndnote(child, hnode);
                                break;
                            }
                            this.handleFootnote(child, hnode);
                            break;
                        }
                        if (sName.equals("text:sequence")) {
                            this.handleSequence(child, hnode);
                            break;
                        }
                        if (sName.equals("text:page-number")) {
                            this.handlePageNumber(child, hnode);
                            break;
                        }
                        if (sName.equals("text:page-count")) {
                            this.handlePageCount(child, hnode);
                            break;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.handleSequenceRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:note-ref")) {
                            this.handleNoteRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.handleReferenceMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.handleReferenceMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.handleReferenceRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.handleBookmark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.handleBookmark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.handleBookmarkRef(child, hnode);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.handleAlphabeticalIndexMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.handleAlphabeticalIndexMarkStart(child, hnode);
                            break;
                        }
                        if (sName.equals("text:toc-mark")) {
                            this.handleTocMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:toc-mark-start")) {
                            this.handleTocMark(child, hnode);
                            break;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.handleBibliographyMark(child, hnode);
                            break;
                        }
                        if (sName.equals("office:annotation")) {
                            this.converter.handleOfficeAnnotation(child, hnode);
                            break;
                        }
                        if (!sName.startsWith("text:")) break;
                        this.traverseInlineText(child, hnode);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void handleTabStop(Node onode, Node hnode) {
        if (this.config.getXhtmlTabstopStyle().length() > 0) {
            Element span = this.converter.createElement("span");
            hnode.appendChild(span);
            span.setAttribute("class", this.config.getXhtmlTabstopStyle());
            span.appendChild(this.converter.createTextNode(" "));
        } else {
            hnode.appendChild(this.converter.createTextNode(" "));
        }
    }

    private void handleSpan(Node onode, Node hnode) {
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element span = this.createInline((Element)hnode, sStyleName);
        this.traverseInlineText(onode, span);
    }

    private void traversePCDATA(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nl = onode.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    hnode.appendChild(this.converter.createTextNode(nl.item(i).getNodeValue()));
                }
                ++i;
            }
        }
    }

    protected void handleAnchor(Node onode, Node hnode) {
        Element anchor = this.converter.createLink((Element)onode);
        hnode.appendChild(anchor);
        this.traverseInlineText(onode, anchor);
    }

    private void handleFootnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sFntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:footnote-citation");
        if (citation == null) {
            citation = Misc.getChildByTagName(onode, "text:note-citation");
        }
        this.traversePCDATA(citation, link);
        this.footnotes.add(onode);
    }

    public void insertFootnotes(Node hnode) {
        int n = this.footnotes.size();
        int i = 0;
        while (i < n) {
            Element body;
            Node footnote = (Node)this.footnotes.get(i);
            String sId = Misc.getAttribute(footnote, "text:id");
            Element citation = Misc.getChildByTagName(footnote, "text:footnote-citation");
            if (citation == null) {
                citation = Misc.getChildByTagName(footnote, "text:note-citation");
            }
            if ((body = Misc.getChildByTagName(footnote, "text:footnote-body")) == null) {
                body = Misc.getChildByTagName(footnote, "text:note-body");
            }
            this.traverseNoteBody(sId, this.sFntCitStyle, citation, body, hnode);
            ++i;
        }
        this.footnotes.clear();
    }

    private void handleEndnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sEntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:endnote-citation");
        if (citation == null) {
            citation = Misc.getChildByTagName(onode, "text:note-citation");
        }
        this.traversePCDATA(citation, link);
        this.endnotes.add(onode);
    }

    public void insertEndnotes(Node hnode) {
        int n = this.endnotes.size();
        if (this.nSplit > 0 && n > 0) {
            hnode = this.converter.nextOutFile();
        }
        int i = 0;
        while (i < n) {
            Element body;
            Node endnote = (Node)this.endnotes.get(i);
            String sId = Misc.getAttribute(endnote, "text:id");
            Element citation = Misc.getChildByTagName(endnote, "text:endnote-citation");
            if (citation == null) {
                citation = Misc.getChildByTagName(endnote, "text:note-citation");
            }
            if ((body = Misc.getChildByTagName(endnote, "text:endnote-body")) == null) {
                body = Misc.getChildByTagName(endnote, "text:note-body");
            }
            this.traverseNoteBody(sId, this.sEntCitStyle, citation, body, hnode);
            ++i;
        }
    }

    private void traverseNoteBody(String sId, String sCitStyle, Node citation, Node onode, Node hnode) {
        Element link = this.converter.createLink("body" + sId);
        this.converter.addTarget(link, sId);
        StyleInfo linkInfo = new StyleInfo();
        this.getTextSc().applyStyle(sCitStyle, linkInfo);
        this.applyStyle(linkInfo, link);
        this.traversePCDATA(citation, link);
        Element span = this.converter.createElement("span");
        span.appendChild(link);
        span.appendChild(this.converter.createTextNode(" "));
        this.asapNode = span;
        this.traverseBlockText(onode, hnode);
    }

    private void handlePageNumber(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page number)"));
    }

    private void handlePageCount(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page count)"));
    }

    private void handleSequence(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:ref-name");
        if (sName != null && !this.bInToc) {
            Element anchor = this.converter.createTarget("seq" + sName);
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        } else {
            this.traversePCDATA(onode, hnode);
        }
    }

    private void createReference(Node onode, Node hnode, String sPrefix) {
        String sFormat = Misc.getAttribute(onode, "text:reference-format");
        String sName = Misc.getAttribute(onode, "text:ref-name");
        Element anchor = this.converter.createLink(sPrefix + sName);
        hnode.appendChild(anchor);
        if ("page".equals(sFormat)) {
            anchor.appendChild(this.converter.createTextNode("1"));
        } else {
            this.traversePCDATA(onode, anchor);
        }
    }

    private void handleSequenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "seq");
    }

    private void handleNoteRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "");
    }

    private void handleReferenceMark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget("ref" + sName));
        }
    }

    private void handleReferenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "ref");
    }

    private void handleBookmark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget(sName));
            hnode.appendChild(this.converter.createTarget("bkm" + sName));
        }
    }

    private void handleBookmarkRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "bkm");
    }

    private void handleAlphabeticalIndexMark(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = Misc.getAttribute(onode, "text:string-value");
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleAlphabeticalIndexMarkStart(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = IndexMark.getIndexValue(onode);
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleTocMark(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTarget("toc" + ++this.nTocIndex));
        TocEntry entry = new TocEntry();
        entry.onode = (Element)onode;
        this.tocEntries.add(entry);
    }

    private void handleBibliographyMark(Node onode, Node hnode) {
        if (this.bInToc) {
            this.traversePCDATA(onode, hnode);
        } else {
            Element anchor = this.converter.createLink("bibliography");
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        }
    }

    private Element applyAttributes(Element node, StyleWithProperties style) {
        if (this.config.xhtmlFormatting() == 4 || this.config.xhtmlFormatting() == 6) {
            return node;
        }
        if (style == null) {
            return node;
        }
        if (!style.isAutomatic()) {
            return node;
        }
        node = this.applyAttribute(node, "bold", this.getTextSc().isBold(style));
        node = this.applyAttribute(node, "italics", this.getTextSc().isItalics(style));
        node = this.applyAttribute(node, "fixed", this.getTextSc().isFixed(style));
        node = this.applyAttribute(node, "superscript", this.getTextSc().isSuperscript(style));
        node = this.applyAttribute(node, "subscript", this.getTextSc().isSubscript(style));
        return node;
    }

    private Element applyAttribute(Element node, String sAttr, boolean bApply) {
        if (!bApply) {
            return node;
        }
        XhtmlStyleMap xattr = this.config.getXAttrStyleMap();
        if (!xattr.contains(sAttr)) {
            return node;
        }
        Element attr = this.converter.createElement(xattr.getElement(sAttr));
        if (!"(none)".equals(xattr.getCss(sAttr))) {
            attr.setAttribute("class", xattr.getCss(sAttr));
        }
        node.appendChild(attr);
        return attr;
    }

    private Element createParagraph(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getParSc().applyStyle(sStyleName, info);
        Element par = this.converter.createElement(info.sTagName);
        node.appendChild(par);
        this.applyStyle(info, par);
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            return this.applyAttributes(par, style);
        }
        return par;
    }

    private Element createTextBackground(Element node, String sStyleName) {
        if (this.config.xhtmlFormatting() == 0 || this.config.xhtmlFormatting() == 7) {
            return node;
        }
        String sBack = this.getParSc().getTextBackground(sStyleName);
        if (sBack.length() > 0) {
            Element span = this.converter.createElement("span");
            span.setAttribute("style", sBack);
            node.appendChild(span);
            return span;
        }
        return node;
    }

    private Element createInline(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getTextSc().applyStyle(sStyleName, info);
        Element newNode = node;
        if (info.hasAttributes() || !"span".equals(info.sTagName)) {
            newNode = this.converter.createElement(info.sTagName);
            node.appendChild(newNode);
            this.applyStyle(info, newNode);
        }
        return this.applyAttributes(newNode, this.ofr.getTextStyle(sStyleName));
    }
}

