/************************************************************************
 *
 *  ConverterResult.java
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright: 2002-2006 by Henrik Just
 *
 *  All Rights Reserved.
 * 
 *  Version 0.4.1e (2006-11-12)
 *
 */
 
package writer2latex.api;

import java.util.Enumeration;

/** <p>A <code>ConverterResult</code> represent a document, which is the result
 *  of a conversion performed by a <code>Converter</code>implementation.</p>
 */
public interface ConverterResult {
    
    /** <p>Get the master document</p>
     *  @return <code>OutputFile</code> the master document
     */
    public OutputFile getMasterDocument();

    /** <p>Gets an <code>Enumeration</code> to access all files in the
     *  <code>ConverterResult</code>. This <em>includes</em> the master document.
     *  @return  an <code>Enumeration</code> of all files
     */
    public Enumeration getDocumentEnumeration();

}

