.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH DIAMONDTOUCH __drivermansuffix__ __vendorversion__
.SH NAME
diamond \- X driver for the MERL DiamondTouch
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" devname \*q
.B  "  Driver \*qdiamondtouch\*q"
.BI "  Option \*qDevice\*q              \*q" devpath \*q
.BI "  Option \*qNumDevices\*q          \*q" 1 \*q
.BI "  Option \*qRowThreshold\*q        \*q" 60 \*q
.BI "  Option \*qColThreshold\*q        \*q" 60 \*q
.BI "  Option \*qSearchFunction\*q      \*q" function \*q
.BI "  Option \*qDeliverBlobs\*q        \*q" True \*q
.BI "  Option \*qMoveThreshold\*q       \*q" 30 \*q
.BI "  Option \*qNoiseLimit\*q          \*q" 5 \*q
.BI "  Option \*qUserNumber\*q          \*q" 0 \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B diamondtouch
is an __xservername__ input driver for the MERL DiamondTouch devices.  
.PP
The 
.B diamondtouch
driver is a pointer emulation for the touchpoints detected on the device. It
can be used as the core pointer. 
.fi
If multiple input devices are configured for the same device path, they will
be assigned to the different users on this device. 
By default, the driver will send blob events to the X server and let the
server emulate a pointer event. Blob events can be switched off and pointer
emulation has to happen in the driver.

.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.

.PP
.SH OPTIONS
.PP
The following driver 
.B Options
control what devices are accepted:

.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specifies the device node through which the device can be accessed. 
Default is /dev/DiamondTouch. Multiple X devices using the same 
device path will be assigned to the different users on the physical device.
.fi
Note that a DiamondTouch device has a maximum number of users. Once this
maximum is reached, additional X device will fail to initialize.

.TP 7
.BI "Option \*qName\*q \*q" string \*q
Specifies the device name for the device you wish to use.
.fi
It probably helps if you assign some meaningful name to the device, so an X
client has some way of knowing what the device actually is. Think "DT User 1"
or the like.
.fi

.TP 7
.BI "Option \*qNumDevices\*q \*q" string \*q
Specifies how many recursive devices to create.
.fi
If multiple devices should be created from one physical device, this option
causes the driver to recursively create additional devices. For example, if
NumDevices is 4, this driver creates four devices without the need to have
four separate sections in the xorg.conf. 
Default is 1.
.fi

.TP 7
.BI "Option \*qRowThreshold\*q \*q" integer \*q
Specifies the lower threshold to accept a signal from the device. Any rows
with a singal strength lower than the threshold will be ignored. Default is
60.

.TP 7
.BI "Option \*qColThreshold\*q \*q" integer \*q
Specifies the lower threshold to accept a signal from the device. Any columns
with a singal strength lower than the threshold will be ignored. Default is
60.

.TP 7
.BI "Option \*qSearchFunction\*q \*q" string \*q
Specifies the search function to be used for finding a hotspot. This setting
is only used if blob events are disabled. Supported functions are:
.fi
.B SignalPeak 
takes the highest value for rows/columns each and uses them as a hotspot.
Default setting.
.fi
.B BBCenter
calculates the bounding box around all touches from the same user and uses the
center of the bounding box as hotspot.

.TP 7
.BI "Option \*qUserNumber\*q \*q" integer \*q
Specifies the user number on the device (essentially the pad the user has to
touch). Valid options are 0 to the maximum number of users of the device.
Default setting is to take the next available user number.
.fi
If the same user is added twice, the server will not create a new device. An
error message is printed to the log.  
.fi
If a 
.B UserNumber
is supplied that is greater than the number of users supported by the device,
the server will not create a new device. An error message is printed to the
log.

.PP
.SH BUGS
Only works for a single screen.
.fi
The mapping from device coordinates to screen coordinates is crude and can
result in jumpy cursors.
.fi 
The signal strenght is not reported to the client.
.fi
NumDevices does not forward options (e.g. RowThreshold) to the recursively
created devices.

.PP
.SH DEPRECATED OPTIONS
.PP
The following driver 
.B Options
are deprecated in the current version. They require a now-orphaned branch of
the X server.

.TP 7
.BI "Option \*qDeliverBlobs\*q \*q" boolean \*q
Specify if blob events should be generated by this device.
Default is TRUE.

.TP 7
.BI "Option \*qMoveThreshold\*q \*q" integer \*q
Threshold in pixels when to consider a blob a continuation blob. If the edges
of a blob are within this threshold to the position a previous blob, it is
considered a continuation of the blob.
This value does not apply if there is only one blob detected.
Default is 30.

.TP 7
.BI "Option \*qNoiseLimit\*q \*q" integer \*q
Minimum amount of pixels a blob has to move before it sends a new event. 
If either bounding box or hotspot moves more than the 
.B NoiseLimit
value, then a new event is set. If the bitmap data changes, a new event is set
regardless of the 
.B NoiseLimit
setting.
Default is 5.

.PP
.SH AUTHORS
Peter Hutterer
.fi
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__).
