/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "comment.h"
#include "debug.h"

struct comment *new_comment(char *value)
{
	_DEBUG(("new_comment"));
	struct comment *new = malloc(sizeof(struct comment));
	if ((new->value = strdup(value)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	return new;
}

void print_comment(struct comment *c)
{
	_DEBUG(("print_comment"));
	write_comment(c, stdout);
}


void write_comment(struct comment *c, FILE *file)
{
	_DEBUG(("write_comment"));
	fprintf(file, "%s\n", c->value);
}

void free_comment(struct comment *c)
{
	_DEBUG(("free_comment"));
	free(c->value);
	free(c);
}
