/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libxfcegui4/libxfcegui4.h>
#include <libintl.h>
#include <string.h>
#include <stdlib.h>
#include <config.h>

#include "open_dialog.h"
#include "parser_interface.h"
#include "node.h"
#include "treeview.h"
#include "xfbib.h"
#include "window.h"
#include "debug.h"
#include "open.h"

void show_open_dialog(struct xfbib *xfbib)
{
	_DEBUG(("show_open_dialog"));
	GtkWidget *open;

	open = gtk_file_chooser_dialog_new(_("Open"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN,
			GTK_RESPONSE_ACCEPT, NULL);

	GtkFileFilter *filter;
	filter = gtk_file_filter_new();
		gtk_file_filter_set_name(filter, _("BibTeX files"));
		gtk_file_filter_add_pattern(filter, N_("*.bib"));
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(open), filter);

	/* BibTeX files should have the .bib prefix so "All files" probably can be deleted */
	filter = gtk_file_filter_new();
		gtk_file_filter_set_name(filter, _("All files"));
		gtk_file_filter_add_pattern(filter, N_("*"));
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(open), filter);
	/* ____ */

	if(gtk_dialog_run(GTK_DIALOG(open)) == GTK_RESPONSE_ACCEPT) {
		free_list(xfbib->list);
		xfbib->list = NULL;
		open_file(gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(open)), xfbib);
	}
	gtk_widget_destroy(open);
}
