/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "preamble.h"
#include "debug.h"

struct preamble *new_preamble(char *value)
{
	_DEBUG(("new_preamble"));
	struct preamble *new = malloc(sizeof(struct preamble));
	if ((new->value = strdup(value)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	return new;
}

void print_preamble(struct preamble *p)
{
	_DEBUG(("print_preamble"));
	write_preamble(p, stdout);
}


void write_preamble(struct preamble *p, FILE *file)
{
	_DEBUG(("write_preamble"));
	fprintf(file, "@preamble{\"%s\"}\n\n", p->value);
}

void free_preamble(struct preamble *p)
{
	_DEBUG(("free_preamble"));
	free(p->value);
	free(p);
}
