/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libintl.h>

#include "window.h"
#include "entry.h"
#include "debug.h"
#include "xfbib.h"
#include "parser_interface.h"
#include "treeview.h"
#include "open.h"

int main(int argc, char **argv)
{
	_DEBUG(("main"));
	
	setlocale( LC_MESSAGES, "");
	bindtextdomain( PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);

	struct xfbib xfbib;
	
	gtk_window_set_default_icon_name("xfbib");
	
	gtk_init(&argc, &argv);

	xfbib.list = NULL;
	xfbib.filename = NULL;

	xfbib.window.window = create_window(&xfbib);
	
	if (argc > 1) {
		_DEBUG(("Argv: %s", argv[1]));
		open_file(argv[1], &xfbib);
	}
	
	gtk_widget_show_all(xfbib.window.window);
	
	gtk_main();

	return EXIT_SUCCESS;
}
