/*
 *   libmetatag - A media file tag-reader library
 *   Copyright (C) 2003, 2004  Pipian
 *   Copyright (C) 2007 Brett Parker <iDunno@sommitrealweird.co.uk>
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef METATAGS_H
#define METATAGS_H 1

#ifdef MAKE_BMP
#include <bmp/vfs.h>
#endif

/*
 * Simple struct to hold metadata
 */
typedef struct {
	char	*artist,
			*title,
			*album,
			*year,
			*track,
			*genre;
} metatag_t;

void get_tag_data(metatag_t *, char *, int);
metatag_t *metatag_new(void);
void metatag_delete(metatag_t *);
void metatag_set_artist(metatag_t *, char *);
void metatag_set_title(metatag_t *, char *);
void metatag_set_album(metatag_t *, char *);
void metatag_set_year(metatag_t *, char *);
void metatag_set_track(metatag_t *, char *);
void metatag_set_genre(metatag_t *, char *);
void metatag_free(metatag_t *);
#endif
