/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using Gtk;
using Gdk;
using Glade;

public class yTToolWin {

	// Language selection Widgets
	[Widget] Gtk.Window		toolWindow;
	[Widget] Gtk.Window		parentWindow;
	[Widget] Gtk.Button		cmdOk;
	[Widget] Gtk.Button		cmdCancel;
	[Widget] Gtk.Image		imgLogo;
	[Widget] Gtk.RadioButton		radioProvider1;
	[Widget] Gtk.SpinButton			spinLarge;
	[Widget] Gtk.CheckButton		chkStartIco;
	[Widget] Gtk.CheckButton		chkAllDesk;
	[Widget] Gtk.Notebook notebook1;
	//private yTService		currentService;
	private yTUserProfile	currentProfile;
	private yTProvider		currentProvider;
	private int				selectedProvider;
	private int 			keyNumber;
	private int        showForm;
	public	bool			startInSystray;
	public	bool			showInAllWorkspace;

	
	public yTToolWin(Gtk.Window owner,yTUserProfile usp, yTService cs,yTProvider cp, int formview){
		showForm = formview;
		Glade.XML gxml = new Glade.XML (null, "yt.glade", "toolWindow", null);
		gxml.Autoconnect (this);
		parentWindow = owner;
		currentProfile = usp;
		//currentService = cs;
		currentProvider = cp;
		startInSystray = currentProfile.startMode;
		showInAllWorkspace = currentProfile.allWorkspace;
		keyNumber = currentProfile.largeKey;
		setupGui();
		radioProvider1.Active = true;
		selectedProvider = 1;
		// setupStartupMode();
		chkStartIco.Visible = false; // (G2.16)
		setupSpinValue();
		setupVisibility();
	}	
	
	/* (G2.16)
	private void setupStartupMode(){
		if(startInSystray==true) 
			chkStartIco.Active = true;
		else
			chkStartIco.Active = false;
	}
	*/
	
	private void setupSpinValue(){
		spinLarge.Value = keyNumber;
	}
	
	private void setupVisibility(){
		if(showInAllWorkspace==true) 
			chkAllDesk.Active = true;
		else
			chkAllDesk.Active = false;
	}
	


	private void setupGui(){
		toolWindow.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		toolWindow.TransientFor = parentWindow;
		toolWindow.SetPosition(Gtk.WindowPosition.CenterOnParent);
		toolWindow.Modal = true;
		toolWindow.ShowAll();
		cmdOk.Clicked+=buttonHandler;
		cmdCancel.Clicked+=buttonHandler;
		radioProvider1.Clicked+=radioHandler;
		chkStartIco.Toggled+=checkHandler;
		chkAllDesk.Toggled+=checkHandler;
		imgLogo.FromPixbuf = new Gdk.Pixbuf(null,"yTLogo.png");
		if(showForm==1)
			notebook1.CurrentPage = 2;
		else 
			notebook1.CurrentPage = 1;
	}	

	
	private void  checkHandler(object o, EventArgs args){
		CheckButton b = (CheckButton) o;
		if(b==chkStartIco){
			startInSystray = chkStartIco.Active;
		}
		else if(b==chkAllDesk){
			showInAllWorkspace = chkAllDesk.Active;
		}
	}
	
	private void  radioHandler(object o, EventArgs args){
		selectedProvider=1;
	}	
	
	private void  buttonHandler(object o, EventArgs args){
		Button b = (Button) o;
		if(b==cmdOk) {
			currentProvider.changeProvider(selectedProvider);
			currentProfile.ProviderID = selectedProvider;
			currentProfile.startMode = startInSystray;
			currentProfile.allWorkspace = showInAllWorkspace;
			currentProfile.largeKey = Convert.ToInt16(spinLarge.Value);
		}
		toolWindow.Destroy();
	}	
	
	
}